/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.Albert;

import sun.awt.Albert.MAreaGeometry;
import sun.awt.Albert.TCAGEvenOdd;
import sun.awt.Albert.TCAGNode;
import sun.awt.Albert.TCAGUnary;
import sun.awt.Albert.TCAGWindNum;
import sun.awt.Albert.TGLoop;
import sun.awt.Albert.TGPoint;
import sun.awt.Albert.TGRect;
import sun.awt.Albert.TGrafExtractor;
import sun.awt.Albert.TGrafMatrix;

public class TLoopGeometry
extends MAreaGeometry {
    public TGLoop fLoop;
    private TGRect fBounds;
    private static final int kLargeLoop = 16;

    public TLoopGeometry() {
        this.fBounds = null;
    }

    public TLoopGeometry(TGLoop tGLoop) {
        this.fLoop = (TGLoop)tGLoop.clone();
        this.fBounds = null;
        this.updateTimeStamp();
    }

    public TLoopGeometry(TLoopGeometry tLoopGeometry) {
        super(tLoopGeometry);
        this.fLoop = null;
        this.fBounds = null;
        if (tLoopGeometry.fLoop != null) {
            this.fLoop = (TGLoop)tLoopGeometry.fLoop.clone();
        }
        if (tLoopGeometry.fBounds != null) {
            this.fBounds = (TGRect)tLoopGeometry.fBounds.clone();
        }
    }

    public Object clone() {
        return new TLoopGeometry(this);
    }

    public MAreaGeometry cloneAndTransform(TGrafMatrix tGrafMatrix) {
        if (this.fLoop.getNumberOfPoints() > 16) {
            return super.cloneAndTransform(tGrafMatrix);
        }
        TLoopGeometry tLoopGeometry = new TLoopGeometry(this);
        tLoopGeometry.fLoop.transformBy(tGrafMatrix);
        tLoopGeometry.fBounds = null;
        tLoopGeometry.updateTimeStamp();
        return tLoopGeometry;
    }

    public boolean contains(TGPoint tGPoint) {
        return this.fLoop.contains(tGPoint);
    }

    public boolean contains(TGRect tGRect) {
        return this.fLoop.contains(tGRect);
    }

    public final TLoopGeometry copyFrom(TLoopGeometry tLoopGeometry) {
        if (this != tLoopGeometry) {
            super.copyFrom(tLoopGeometry);
            this.fLoop = tLoopGeometry.fLoop;
            this.fBounds = tLoopGeometry.fBounds;
        }
        return this;
    }

    public boolean equals(MAreaGeometry mAreaGeometry) {
        if (this.getClass().equals(mAreaGeometry.getClass())) {
            return super.equals(mAreaGeometry) && this.fLoop.equals(((TLoopGeometry)mAreaGeometry).fLoop);
        }
        return false;
    }

    public void extract(TGrafExtractor tGrafExtractor, TCAGNode tCAGNode, TGrafMatrix tGrafMatrix) {
        boolean bl = this.fLoop.getEOFill();
        TCAGUnary tCAGUnary = bl ? new TCAGEvenOdd(tCAGNode) : new TCAGWindNum(tCAGNode);
        tGrafExtractor.adoptCAGNode(tCAGUnary);
        tGrafExtractor.extractLoop(this.fLoop, tCAGUnary, tGrafMatrix);
    }

    public TGRect getBounds() {
        if (this.fBounds == null) {
            this.fBounds = this.fLoop.getBounds();
        }
        return this.fBounds;
    }

    public boolean intersects(TGRect tGRect) {
        if (this.fLoop.getNumberOfPoints() > 0) {
            if (tGRect.contains(this.fLoop.getPoint(0).divW())) {
                return true;
            }
            if (this.fLoop.contains(tGRect.getTopLeft())) {
                return true;
            }
            if (this.fLoop.intersects(tGRect)) {
                return true;
            }
        }
        return false;
    }

    public boolean isEmpty() {
        return this.fLoop.getOrder() == 0 || this.fLoop.getNumberOfPoints() < 3;
    }

    public boolean isPolygonal() {
        return this.fLoop.getOrder() == 2 && this.fLoop.getNumberOfPoints() >= 3;
    }
}

