/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.Albert;

import sun.awt.Albert.MAreaGeometry;
import sun.awt.Albert.TCAGIntersect;
import sun.awt.Albert.TCAGNode;
import sun.awt.Albert.TGPoint;
import sun.awt.Albert.TGRect;
import sun.awt.Albert.TGrafExtractor;
import sun.awt.Albert.TGrafMatrix;

class TIntersectGeometry
extends MAreaGeometry {
    private MAreaGeometry fLeft;
    private MAreaGeometry fRight;
    private TGRect fBounds;

    public TIntersectGeometry() {
        this.fBounds = null;
    }

    public TIntersectGeometry(MAreaGeometry mAreaGeometry, MAreaGeometry mAreaGeometry2) {
        this.fLeft = mAreaGeometry;
        this.fRight = mAreaGeometry2;
        this.fBounds = null;
        this.updateTimeStamp();
    }

    public TIntersectGeometry(TIntersectGeometry tIntersectGeometry) {
        super(tIntersectGeometry);
        this.fLeft = null;
        this.fRight = null;
        this.fBounds = null;
        if (tIntersectGeometry.fLeft != null) {
            this.fLeft = (MAreaGeometry)tIntersectGeometry.fLeft.clone();
        }
        if (tIntersectGeometry.fRight != null) {
            this.fRight = (MAreaGeometry)tIntersectGeometry.fRight.clone();
        }
        if (tIntersectGeometry.fBounds != null) {
            this.fBounds = (TGRect)tIntersectGeometry.fBounds.clone();
        }
    }

    public Object clone() {
        return new TIntersectGeometry(this);
    }

    public MAreaGeometry cloneAndIntersect(MAreaGeometry mAreaGeometry) {
        TIntersectGeometry tIntersectGeometry = new TIntersectGeometry(this);
        tIntersectGeometry.fLeft = MAreaGeometry.intersect(tIntersectGeometry.fLeft, mAreaGeometry);
        tIntersectGeometry.fBounds = null;
        tIntersectGeometry.updateTimeStamp();
        return tIntersectGeometry;
    }

    public boolean contains(TGPoint tGPoint) {
        return this.getBounds().contains(tGPoint) && this.fLeft.contains(tGPoint) && this.fRight.contains(tGPoint);
    }

    public boolean contains(TGRect tGRect) {
        return this.fLeft.contains(tGRect) && this.fRight.contains(tGRect);
    }

    public final TIntersectGeometry copyFrom(TIntersectGeometry tIntersectGeometry) {
        if (this != tIntersectGeometry) {
            super.copyFrom(tIntersectGeometry);
            this.fLeft = tIntersectGeometry.fLeft;
            this.fRight = tIntersectGeometry.fRight;
            this.fBounds = tIntersectGeometry.fBounds;
        }
        return this;
    }

    public boolean equals(MAreaGeometry mAreaGeometry) {
        if (this.getClass().equals(mAreaGeometry.getClass())) {
            TIntersectGeometry tIntersectGeometry = (TIntersectGeometry)mAreaGeometry;
            return super.equals(mAreaGeometry) || this.fLeft == tIntersectGeometry.fLeft && this.fRight == tIntersectGeometry.fRight;
        }
        return false;
    }

    public void extract(TGrafExtractor tGrafExtractor, TCAGNode tCAGNode, TGrafMatrix tGrafMatrix) {
        TCAGIntersect tCAGIntersect = new TCAGIntersect(tCAGNode);
        tGrafExtractor.adoptCAGNode(tCAGIntersect);
        this.fLeft.extract(tGrafExtractor, tCAGIntersect, tGrafMatrix);
        this.fRight.extract(tGrafExtractor, tCAGIntersect.getRightLink(), tGrafMatrix);
    }

    public TGRect getBounds() {
        if (this.fBounds == null) {
            this.fBounds = new TGRect(this.fLeft.getBounds());
            this.fBounds.intersectWith(this.fRight.getBounds());
        }
        return this.fBounds;
    }

    public boolean intersects(TGRect tGRect) {
        return this.fLeft.intersects(tGRect) && this.fRight.intersects(tGRect);
    }

    public boolean isEmpty() {
        return this.getBounds().isEmpty() || this.fLeft.isEmpty() && this.fRight.isEmpty();
    }

    public boolean isPolygonal() {
        return this.fLeft.isPolygonal() && this.fRight.isPolygonal();
    }

    public boolean isSingular() {
        return false;
    }
}

