/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.Albert;

import sun.awt.Albert.TCAGNode;
import sun.awt.Albert.TCAGRoot;
import sun.awt.Albert.TCAGUnary;
import sun.awt.Albert.TGEllipse;
import sun.awt.Albert.TGLoop;
import sun.awt.Albert.TGPolygon;
import sun.awt.Albert.TGRect;
import sun.awt.Albert.TGrafMatrix;

abstract class TGrafExtractor {
    private static final TGrafMatrix fkIdentity = new TGrafMatrix();
    private TCAGNode[] fCAGNodes = null;
    private int fNumCAGNodes = 0;
    private int fNumAllocatedCAGNodes = 0;
    private static final int kCAGNodeIncrement = 16;

    protected TGrafExtractor() {
    }

    protected TGrafExtractor(TGrafExtractor tGrafExtractor) {
        this();
    }

    public final void adoptCAGNode(TCAGNode tCAGNode) {
        if (this.fNumCAGNodes == this.fNumAllocatedCAGNodes) {
            int n = this.fNumAllocatedCAGNodes;
            this.fNumAllocatedCAGNodes += 16;
            TCAGNode[] tCAGNodeArray = new TCAGNode[this.fNumAllocatedCAGNodes];
            if (this.fCAGNodes != null && n > 0) {
                System.arraycopy(this.fCAGNodes, 0, tCAGNodeArray, 0, n);
            }
            this.fCAGNodes = tCAGNodeArray;
        }
        this.fCAGNodes[this.fNumCAGNodes] = tCAGNode;
        ++this.fNumCAGNodes;
    }

    protected TGrafExtractor copyFrom(TGrafExtractor tGrafExtractor) {
        this.deleteCAGNodes();
        return this;
    }

    protected final void deleteCAGNodes() {
        int n = 0;
        while (n < this.fNumCAGNodes) {
            this.fCAGNodes[n] = null;
            ++n;
        }
        this.fNumCAGNodes = 0;
    }

    public void extractEllipse(TGEllipse tGEllipse, TCAGUnary tCAGUnary) {
        this.extractEllipse(tGEllipse, tCAGUnary, fkIdentity);
    }

    public abstract void extractEllipse(TGEllipse var1, TCAGUnary var2, TGrafMatrix var3);

    public void extractLoop(TGLoop tGLoop, TCAGUnary tCAGUnary) {
        this.extractLoop(tGLoop, tCAGUnary, fkIdentity);
    }

    public abstract void extractLoop(TGLoop var1, TCAGUnary var2, TGrafMatrix var3);

    public void extractPolygon(TGPolygon tGPolygon, TCAGUnary tCAGUnary) {
        this.extractPolygon(tGPolygon, tCAGUnary, fkIdentity);
    }

    public abstract void extractPolygon(TGPolygon var1, TCAGUnary var2, TGrafMatrix var3);

    public void extractRect(TGRect tGRect, TCAGUnary tCAGUnary) {
        this.extractRect(tGRect, tCAGUnary, fkIdentity);
    }

    public abstract void extractRect(TGRect var1, TCAGUnary var2, TGrafMatrix var3);

    public abstract void render(TCAGRoot var1);
}

