/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.Albert;

import sun.awt.Albert.TGPoint;
import sun.awt.Albert.TGRect;
import sun.awt.Albert.TRawArray;

class TGPointArray
extends TRawArray {
    private TGPoint[] fValues = null;

    public TGPointArray() {
        this(0);
    }

    public TGPointArray(int n) {
        super(n);
        if (this.fArraySize > 0) {
            this.allocateArray(this.fArraySize);
            this.newAllocation(0, this.fArraySize);
        }
    }

    public TGPointArray(TGPointArray tGPointArray) {
        if (tGPointArray.fNumberOfValues > 0) {
            this.allocateArray(tGPointArray.fArraySize);
            this.cloneFromArray(0, tGPointArray.fNumberOfValues, tGPointArray.fValues);
            int n = tGPointArray.fArraySize - tGPointArray.fNumberOfValues;
            if (n > 0) {
                this.newAllocation(tGPointArray.fNumberOfValues, n);
            }
        }
        super.copyFrom(tGPointArray);
    }

    void allocateArray(int n) {
        this.fValues = null;
        if (n > 0) {
            this.fValues = new TGPoint[n];
        }
    }

    public void append(TGPoint tGPoint) {
        this.resize(this.fNumberOfValues + 1);
        this.fValues[this.fNumberOfValues - 1].copyFrom(tGPoint);
    }

    private void cloneFromArray(int n, int n2, TGPoint[] tGPointArray) {
        int n3 = n + n2;
        int n4 = n;
        while (n4 < n3) {
            this.fValues[n4] = (TGPoint)tGPointArray[n4].clone();
            ++n4;
        }
    }

    public final TGPointArray copyFrom(TGPointArray tGPointArray) {
        if (this.fArraySize != tGPointArray.fArraySize) {
            TGPoint[] tGPointArray2 = this.fValues;
            this.allocateArray(tGPointArray.fArraySize);
            if (this.fArraySize > tGPointArray.fArraySize) {
                this.fArraySize = tGPointArray.fArraySize;
            } else {
                this.newAllocation(this.fArraySize, tGPointArray.fArraySize - this.fArraySize);
            }
            if (this.fArraySize > 0) {
                System.arraycopy(tGPointArray2, 0, this.fValues, 0, this.fArraySize);
            }
        }
        int n = 0;
        while (n < tGPointArray.fNumberOfValues) {
            this.fValues[n].copyFrom(tGPointArray.fValues[n]);
            ++n;
        }
        super.copyFrom(tGPointArray);
        return this;
    }

    public final boolean equals(TGPointArray tGPointArray) {
        if (tGPointArray == this) {
            return true;
        }
        if (super.equals(tGPointArray)) {
            return false;
        }
        int n = 0;
        while (n < this.fNumberOfValues) {
            if (!this.fValues[n].equals(tGPointArray.fValues[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public TGPoint[] getArray() {
        return this.fValues;
    }

    public TGRect getBounds() {
        int n = this.getNumberOfValues();
        if (n == 0) {
            return new TGRect(0.0, 0.0, 0.0, 0.0);
        }
        TGRect tGRect = new TGRect();
        TGPoint[] tGPointArray = this.getArray();
        tGRect.setToPoint(tGPointArray[0]);
        int n2 = 1;
        while (n2 < n) {
            tGRect.extendTo(tGPointArray[n2]);
            ++n2;
        }
        return tGRect;
    }

    public int getNumberOfPoints() {
        return this.getNumberOfValues();
    }

    public TGPoint getPoint(int n) {
        return this.getValue(n);
    }

    public TGPoint getValue(int n) {
        if (n < 0 || n >= this.fNumberOfValues) {
            throw new IndexOutOfBoundsException("RawArray.value(index)");
        }
        return this.fValues[n];
    }

    void newAllocation(int n, int n2) {
        int n3 = n + n2;
        int n4 = n;
        while (n4 < n3) {
            this.fValues[n4] = new TGPoint();
            ++n4;
        }
    }

    void reallocateArray(int n) {
        TGPoint[] tGPointArray = this.fValues;
        this.allocateArray(n);
        if (n > 0) {
            System.arraycopy(tGPointArray, 0, this.fValues, 0, this.fArraySize > n ? n : this.fArraySize);
        }
    }

    public void setPoint(int n, double d, double d2) {
        TGPoint tGPoint = this.getValue(n);
        tGPoint.x = d;
        tGPoint.y = d2;
    }

    public void setPoint(int n, TGPoint tGPoint) {
        this.setValue(n, tGPoint);
    }

    public void setValue(int n, TGPoint tGPoint) {
        if (n < 0 || n >= this.fNumberOfValues) {
            throw new IndexOutOfBoundsException("RawArray.setValue(index, ...)");
        }
        this.fValues[n].copyFrom(tGPoint);
    }

    public void swap(TGPointArray tGPointArray) {
        super.swap(tGPointArray);
        TGPoint[] tGPointArray2 = this.fValues;
        this.fValues = tGPointArray.fValues;
        tGPointArray.fValues = tGPointArray2;
    }
}

