/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.Albert;

import sun.awt.Albert.TGPoint;
import sun.awt.Albert.TGRect;

public class TGEllipse
implements Cloneable {
    private TGRect fRectangle;

    public TGEllipse(TGEllipse tGEllipse) {
        this.fRectangle = new TGRect(tGEllipse.fRectangle);
    }

    public TGEllipse(TGRect tGRect) {
        this.fRectangle = (TGRect)tGRect.clone();
    }

    public boolean contains(TGPoint tGPoint) {
        TGPoint tGPoint2 = this.getSize();
        if (tGPoint2.x == 0.0 || tGPoint2.y == 0.0) {
            return false;
        }
        TGPoint tGPoint3 = this.getCenter();
        tGPoint2.divideBy(2.0);
        TGPoint tGPoint4 = (TGPoint)tGPoint.clone();
        tGPoint4.subtractBy(tGPoint3);
        tGPoint4.divideBy(tGPoint2);
        tGPoint4.multiplyBy(tGPoint4);
        return tGPoint4.x + tGPoint4.y < 1.0;
    }

    public TGEllipse copyFrom(TGEllipse tGEllipse) {
        this.fRectangle.copyFrom(tGEllipse.fRectangle);
        return this;
    }

    public boolean equals(TGEllipse tGEllipse) {
        return this.fRectangle.equals(tGEllipse.fRectangle);
    }

    public TGRect getBounds() {
        return (TGRect)this.fRectangle.clone();
    }

    public TGPoint getCenter() {
        return this.fRectangle.getCenter();
    }

    public TGPoint getSize() {
        return this.fRectangle.getSize();
    }

    public boolean intersects(TGRect tGRect) {
        if (!this.fRectangle.intersects(tGRect)) {
            return false;
        }
        if (this.contains(tGRect.getTopLeft()) || this.contains(tGRect.getTopRight()) || this.contains(tGRect.getBottomLeft()) || this.contains(tGRect.getBottomRight())) {
            return true;
        }
        TGPoint tGPoint = this.getCenter();
        double d = (tGRect.x - tGPoint.x) * (tGRect.getMaxX() - tGPoint.x);
        double d2 = (tGRect.y - tGPoint.y) * (tGRect.getMaxY() - tGPoint.y);
        return d <= 0.0 || d2 <= 0.0;
    }
}

