/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.Albert;

import sun.awt.Albert.TBaseCurve;
import sun.awt.Albert.TConicInfo;
import sun.awt.Albert.TGEllipse;
import sun.awt.Albert.TGParametricArray;
import sun.awt.Albert.TGPoint;
import sun.awt.Albert.TGRPoint;
import sun.awt.Albert.TGRPointArray;
import sun.awt.Albert.TGrafMatrix;
import sun.awt.Albert.prStatic;

public class TGCurve
extends TBaseCurve {
    protected TConicInfo fConicInfo;

    public TGCurve() {
        this.fConicInfo = null;
    }

    public TGCurve(int n, int n2) {
        super(n, n2);
        this.fConicInfo = null;
    }

    public TGCurve(int n, TGRPointArray tGRPointArray, TGParametricArray tGParametricArray) {
        super(n, tGRPointArray, tGParametricArray);
        this.fConicInfo = null;
    }

    public TGCurve(TGCurve tGCurve) {
        super(tGCurve);
        if (tGCurve.fConicInfo != null) {
            if (this.fConicInfo != null) {
                this.fConicInfo.copyFrom(tGCurve.fConicInfo);
            } else {
                this.fConicInfo = new TConicInfo(tGCurve.fConicInfo);
            }
        }
    }

    TGCurve(TGEllipse tGEllipse, double d, double d2) {
        super(3, 3);
        if (d == d2) {
            TGPoint tGPoint = new TGPoint();
            tGPoint.setPolarCoordinates(d);
            tGPoint.multiplyBy(tGEllipse.getSize());
            tGPoint.multiplyBy(0.5);
            tGPoint.addBy(tGEllipse.getCenter());
            int n = 0;
            while (n < 3) {
                this.fPoints.setPoint(n, tGPoint);
                ++n;
            }
            this.setKnotScheme(2);
            this.fConicInfo = null;
        } else if (prStatic.Remainder(d, 360.0) == prStatic.Remainder(d2, 360.0)) {
            this.makeEllipticCurve(tGEllipse);
            if (d2 < d) {
                this.reverseDirection();
            }
        } else {
            TGRPointArray tGRPointArray = new TGRPointArray(12);
            int n = prStatic.ArcAngleAnglePts(tGEllipse, d, d2, 0, tGRPointArray);
            this.makeArc(n, tGRPointArray);
            this.fConicInfo = new TConicInfo(1, tGEllipse.getBounds(), false);
        }
    }

    public TGCurve(TGPoint tGPoint, TGPoint tGPoint2) {
        super(2, 2);
        this.setPoint(0, new TGRPoint(tGPoint));
        this.setPoint(1, new TGRPoint(tGPoint2));
        this.fConicInfo = null;
    }

    public TGCurve(TGPoint tGPoint, TGPoint tGPoint2, TGPoint tGPoint3) {
        super(tGPoint, tGPoint2, tGPoint3);
        this.fConicInfo = null;
    }

    public TGCurve(TGPoint tGPoint, TGPoint tGPoint2, TGPoint tGPoint3, TGPoint tGPoint4) {
        super(tGPoint, tGPoint2, tGPoint3, tGPoint4);
        this.fConicInfo = null;
    }

    public Object clone() {
        return new TGCurve(this);
    }

    public void concatenate(TBaseCurve tBaseCurve) {
        this.concatenate(tBaseCurve, true);
    }

    public void concatenate(TBaseCurve tBaseCurve, boolean bl) {
        super.concatenate(tBaseCurve, bl);
        this.fConicInfo = null;
    }

    public TGCurve copyFrom(TGCurve tGCurve) {
        super.copyFrom(tGCurve);
        if (tGCurve.fConicInfo != null) {
            if (this.fConicInfo != null) {
                this.fConicInfo.copyFrom(tGCurve.fConicInfo);
            } else {
                this.fConicInfo = new TConicInfo(tGCurve.fConicInfo);
            }
        }
        return this;
    }

    public boolean equals(TGCurve tGCurve) {
        return super.equals(tGCurve) && this.fConicInfo.equals(tGCurve.fConicInfo);
    }

    public TGPoint evaluate(double d) {
        return super.evaluate(d);
    }

    public TGRPoint evaluateW(double d) {
        return super.evaluateW(d);
    }

    protected void incrementOrder() {
        super.incrementOrder();
        this.fConicInfo = null;
    }

    protected void makeArc(int n, TGRPointArray tGRPointArray) {
        if ((n - 1) % 2 != 0) {
            throw new IllegalArgumentException("makeArc didn't get valid Bezier curve");
        }
        this.fOrder = 3;
        this.fNumPoints = n;
        tGRPointArray.resize(n);
        this.fPoints.swap(tGRPointArray);
        this.fKnots.resize(n + this.fOrder);
        this.setKnotScheme(2);
    }

    protected void makeEllipticCurve(TGEllipse tGEllipse) {
        double d = Math.sqrt(2.0) / 2.0;
        this.fPoints.setPoint(0, 1.0, 0.0, 1.0);
        this.fPoints.setPoint(1, d, d, d);
        this.fPoints.setPoint(2, 0.0, 1.0, 1.0);
        this.fPoints.setPoint(3, -d, d, d);
        this.fPoints.setPoint(4, -1.0, 0.0, 1.0);
        this.fPoints.setPoint(5, -d, -d, d);
        this.fPoints.setPoint(6, 0.0, -1.0, 1.0);
        this.fPoints.setPoint(7, d, -d, d);
        this.fPoints.setPoint(8, 1.0, 0.0, 1.0);
        TGPoint tGPoint = tGEllipse.getSize().divideBy(2.0);
        TGPoint tGPoint2 = tGEllipse.getCenter();
        TGRPoint[] tGRPointArray = this.fPoints.getArray();
        int n = 0;
        while (n < this.fNumPoints) {
            tGRPointArray[n].fX = tGRPointArray[n].fX * tGPoint.x + tGRPointArray[n].fW * tGPoint2.x;
            tGRPointArray[n].fY = tGRPointArray[n].fY * tGPoint.y + tGRPointArray[n].fW * tGPoint2.y;
            ++n;
        }
        this.fOrder = 3;
        this.setKnotScheme(2);
        this.fConicInfo = new TConicInfo(2, tGEllipse.getBounds(), false);
    }

    public void prAppendCurve(TBaseCurve tBaseCurve, boolean bl) {
        super.prAppendCurve(tBaseCurve, bl);
        this.fConicInfo = null;
    }

    public void refine(TGParametricArray tGParametricArray) {
        super.refine(tGParametricArray);
        this.fConicInfo = null;
    }

    public void setKnotScheme(int n) {
        super.setKnotScheme(n);
        this.fConicInfo = null;
    }

    public void setPoint(int n, TGRPoint tGRPoint) {
        super.setPoint(n, tGRPoint);
        this.fConicInfo = null;
    }

    public String toString() {
        String string = new String();
        String string2 = new String();
        int n = this.fNumPoints;
        int n2 = 0;
        while (n2 < n) {
            string = String.valueOf(string) + this.fPoints.getPoint(n2) + "\n";
            ++n2;
        }
        n += this.fOrder;
        int n3 = 0;
        while (n3 < n) {
            string2 = String.valueOf(string2) + this.fKnots.getValue(n3) + "\n";
            ++n3;
        }
        return "{\norder = " + this.fOrder + "\n" + "num points = " + this.fNumPoints + "\n" + "points: " + "\n" + string + "knots: " + "\n" + string2 + "\n}\n";
    }

    public void transformBy(TGrafMatrix tGrafMatrix) {
        tGrafMatrix.transformPoints(this.fPoints);
    }
}

