/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.Albert;

import sun.awt.Albert.TGParametricArray;
import sun.awt.Albert.TGPoint;
import sun.awt.Albert.TGRPoint;
import sun.awt.Albert.TGRPointArray;
import sun.awt.Albert.prStatic;

class TBaseCurve
implements Cloneable {
    public static final int kPinned = 0;
    public static final int kFloating = 1;
    public static final int kBezier = 2;
    public static final int kBreak = 0;
    public static final int kKink = 1;
    public static final int kJerk = 2;
    protected int fNumPoints;
    protected int fOrder;
    protected TGRPointArray fPoints;
    protected TGParametricArray fKnots;

    public TBaseCurve() {
        this.fPoints = new TGRPointArray(0);
        this.fKnots = new TGParametricArray(0);
        this.fOrder = 0;
        this.fNumPoints = 0;
    }

    public TBaseCurve(int n, int n2) {
        this.fPoints = new TGRPointArray(n2);
        this.fKnots = new TGParametricArray(n + n2);
        this.fOrder = n;
        this.fNumPoints = n2;
        this.setKnotScheme(0);
    }

    public TBaseCurve(int n, TGRPointArray tGRPointArray, TGParametricArray tGParametricArray) {
        if (n < 2) {
            throw new IndexOutOfBoundsException("curve order below range");
        }
        int n2 = tGRPointArray.getNumberOfPoints();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("curve number of points above range");
        }
        if (tGParametricArray.getNumberOfValues() != n + n2) {
            throw new IllegalArgumentException("curve number of knots is inconsistant");
        }
        this.fPoints = new TGRPointArray(tGRPointArray);
        this.fKnots = new TGParametricArray(tGParametricArray);
        this.fOrder = n;
        this.fNumPoints = n2;
    }

    public TBaseCurve(TBaseCurve tBaseCurve) {
        this.fPoints = new TGRPointArray(tBaseCurve.fPoints);
        this.fKnots = new TGParametricArray(tBaseCurve.fKnots);
        this.fOrder = tBaseCurve.fOrder;
        this.fNumPoints = tBaseCurve.fNumPoints;
    }

    public TBaseCurve(TGPoint tGPoint, TGPoint tGPoint2, TGPoint tGPoint3) {
        this(3, 3);
        this.fPoints.setPoint(0, tGPoint);
        this.fPoints.setPoint(1, tGPoint2);
        this.fPoints.setPoint(2, tGPoint3);
    }

    public TBaseCurve(TGPoint tGPoint, TGPoint tGPoint2, TGPoint tGPoint3, TGPoint tGPoint4) {
        this(4, 4);
        this.fPoints.setPoint(0, tGPoint);
        this.fPoints.setPoint(1, tGPoint2);
        this.fPoints.setPoint(2, tGPoint3);
        this.fPoints.setPoint(3, tGPoint4);
    }

    public Object clone() {
        return new TBaseCurve(this);
    }

    public void concatenate(TBaseCurve tBaseCurve) {
        this.concatenate(tBaseCurve, true);
    }

    public void concatenate(TBaseCurve tBaseCurve, boolean bl) {
        if (this.fOrder == 0) {
            this.copyFrom(tBaseCurve);
            return;
        }
        TBaseCurve tBaseCurve2 = new TBaseCurve(tBaseCurve);
        if (!tBaseCurve2.isPinned()) {
            tBaseCurve2.refineToPinned();
        }
        this.prAppendCurve(tBaseCurve2, bl);
    }

    public TBaseCurve copyFrom(TBaseCurve tBaseCurve) {
        if (tBaseCurve != this) {
            this.fOrder = tBaseCurve.fOrder;
            this.fNumPoints = tBaseCurve.fNumPoints;
            this.fKnots.copyFrom(tBaseCurve.fKnots);
            this.fPoints.copyFrom(tBaseCurve.fPoints);
        }
        return this;
    }

    public boolean equals(TBaseCurve tBaseCurve) {
        if (this.fOrder == 0) {
            return this.fOrder == tBaseCurve.fOrder;
        }
        return this.fNumPoints == tBaseCurve.fNumPoints && this.fOrder == tBaseCurve.fOrder && this.fPoints.equals(tBaseCurve.fPoints) && this.fKnots.equals(tBaseCurve.fKnots);
    }

    public TGPoint evaluate(double d) {
        return this.evaluateW(d).divW();
    }

    protected TGPoint evaluate(double d, int n) {
        TGRPoint tGRPoint = new TGRPoint();
        prStatic.NurbEval(this.fPoints.getArray(), n, d, this.fKnots.getArray(), this.fOrder, true, tGRPoint);
        return tGRPoint.divW();
    }

    public TGRPoint evaluateW(double d) {
        TGRPoint tGRPoint = new TGRPoint();
        double[] dArray = this.fKnots.getArray();
        prStatic.NurbEval(this.fPoints.getArray(), prStatic.FindInterval(d, dArray, this.fNumPoints, this.fOrder), d, dArray, this.fOrder, true, tGRPoint);
        return tGRPoint;
    }

    public double getKnot(int n) {
        return this.fKnots.getValue(n);
    }

    public double getMaxParameter() {
        return this.fKnots.getValue(this.fNumPoints);
    }

    public double getMinParameter() {
        return this.fKnots.getValue(this.fOrder - 1);
    }

    public int getNextDiscontinuity(int n) {
        return this.getNextDiscontinuity(n, 0);
    }

    public int getNextDiscontinuity(int n, int n2) {
        return prStatic.GetNextDiscon(n, n2, this.fOrder, this.fNumPoints, this.fKnots.getArray());
    }

    public int getNumberOfKnots() {
        return this.fOrder + this.fNumPoints;
    }

    public int getNumberOfPoints() {
        return this.fNumPoints;
    }

    public int getOrder() {
        return this.fOrder;
    }

    public TGRPoint getPoint(int n) {
        return new TGRPoint(this.fPoints.getValue(n));
    }

    public void getPoints(TGRPointArray tGRPointArray) {
        tGRPointArray.copyFrom(this.fPoints);
    }

    public void getSectionOfCurve(double d, double d2, TBaseCurve tBaseCurve) {
        if (this.fOrder == 0) {
            throw new IllegalArgumentException("curve not initialized");
        }
        boolean bl = false;
        if (d == d2) {
            tBaseCurve.copyFrom(new TBaseCurve());
            return;
        }
        if (d2 < d) {
            double d3 = d;
            d = d2;
            d2 = d3;
            bl = true;
        }
        if (d < this.getMinParameter()) {
            d = this.getMinParameter();
        }
        if (d2 > this.getMaxParameter()) {
            d2 = this.getMaxParameter();
        }
        if (d == this.getMinParameter() && d2 == this.getMaxParameter()) {
            tBaseCurve.copyFrom(this);
            return;
        }
        TBaseCurve tBaseCurve2 = new TBaseCurve(this);
        int n = this.fOrder + this.fNumPoints;
        TGParametricArray tGParametricArray = new TGParametricArray(n + 2 * this.fOrder);
        double[] dArray = tGParametricArray.getArray();
        double[] dArray2 = tBaseCurve2.fKnots.getArray();
        int n2 = 0;
        int n3 = 0;
        while (dArray2[n2] < d) {
            dArray[n3] = dArray2[n2];
            ++n2;
            ++n3;
        }
        int n4 = n3;
        int n5 = 0;
        while (dArray2[n2] == d) {
            dArray[n3] = dArray2[n2];
            ++n5;
            ++n2;
            ++n3;
        }
        while (n5 < this.fOrder) {
            dArray[n3] = d;
            ++n5;
            ++n3;
        }
        while (dArray2[n2] < d2) {
            dArray[n3] = dArray2[n2];
            ++n2;
            ++n3;
        }
        n5 = 0;
        while (n2 < dArray2.length && dArray2[n2] == d2) {
            dArray[n3] = dArray2[n2];
            ++n5;
            ++n2;
            ++n3;
        }
        while (n5 < this.fOrder) {
            dArray[n3] = d2;
            ++n5;
            ++n3;
        }
        int n6 = n3;
        while (n2 < n) {
            dArray[n3] = dArray2[n2];
            ++n2;
            ++n3;
        }
        tGParametricArray.resize(n3);
        tBaseCurve2.refine(tGParametricArray);
        int n7 = n6 - n4;
        tGParametricArray.resize(n7);
        System.arraycopy(dArray2, n4, tGParametricArray.getArray(), 0, n7);
        int n8 = n7 - this.fOrder;
        TGRPointArray tGRPointArray = tBaseCurve2.fPoints;
        if (n4 > 0) {
            TGRPoint[] tGRPointArray2 = tGRPointArray.getArray();
            System.arraycopy(tGRPointArray2, n4, tGRPointArray2, 0, n8);
        }
        tGRPointArray.resize(n8);
        tBaseCurve.fNumPoints = n8;
        tBaseCurve.fPoints = tGRPointArray;
        tBaseCurve.fKnots = tGParametricArray;
        tBaseCurve.fOrder = this.fOrder;
        if (bl) {
            tBaseCurve.reverseDirection();
        }
    }

    protected void incrementOrder() {
        int n = this.fOrder;
        int[] nArray = new int[2 * this.fNumPoints + n + 1];
        TGParametricArray tGParametricArray = new TGParametricArray(2 * this.fNumPoints + n + 2);
        int n2 = 0;
        while (n2 < 2 * this.fNumPoints + n + 1) {
            nArray[n2] = 0;
            ++n2;
        }
        int n3 = 0;
        n2 = 0;
        double[] dArray = tGParametricArray.getArray();
        double[] dArray2 = this.fKnots.getArray();
        double d = dArray2[0];
        int n4 = 0;
        while (n4 < this.fNumPoints + n) {
            if (d != dArray2[n4]) {
                n3 = 1;
                dArray[n2] = dArray[n2 - 1];
                ++n2;
            } else if (++n3 == n && n2 > n) {
                nArray[n2 - n] = n4 - n;
            }
            dArray[n2] = dArray2[n4];
            ++n2;
            d = dArray2[n4];
            ++n4;
        }
        dArray[n2] = dArray[n2 - 1];
        tGParametricArray.resize(n2 + 1);
        TGRPointArray tGRPointArray = new TGRPointArray(n2 - n);
        TGRPoint[] tGRPointArray2 = new TGRPointArray(n + 2).getArray();
        TGRPoint[] tGRPointArray3 = new TGRPointArray(n + 2).getArray();
        TGRPoint[] tGRPointArray4 = this.fPoints.getArray();
        tGRPointArray.setPoint(0, tGRPointArray4[0]);
        tGRPointArray.setPoint(n2 - n - 1, tGRPointArray4[this.fNumPoints - 1]);
        int n5 = this.fNumPoints = n2 - n;
        n2 = 1;
        while (n2 < n5 - 1) {
            if (nArray[n2] != 0) {
                tGRPointArray.setValue(n2, tGRPointArray4[nArray[n2]]);
                ++n2;
            }
            int n6 = 0;
            while (!(dArray[n2 + 1] < dArray2[n6 + 1])) {
                ++n6;
            }
            ++n6;
            n4 = 0;
            while (n4 < n) {
                TGRPoint.SetToZero(tGRPointArray2[n4]);
                TGRPoint.SetToZero(tGRPointArray3[n4]);
                ++n4;
            }
            int n7 = Math.min(n - 1, n5 + n - n6 - 1);
            n4 = Math.max(0, n - n6);
            while (n4 <= n7) {
                tGRPointArray2[n4].copyFrom(tGRPointArray4[n4 + n6 - n]);
                tGRPointArray3[n4].copyFrom(tGRPointArray2[n4]);
                ++n4;
            }
            int n8 = n - 1;
            while (n8 >= 1) {
                double d2 = dArray[n2 + n8];
                double d3 = dArray[n2 + n8 + 1];
                n7 = Math.max(n - n8, n - n6);
                n4 = Math.min(n - 1, n5 + 2 * n - n8 - n6 - 1);
                while (n4 >= n7) {
                    double d4 = dArray2[n6 + n4 - n];
                    double d5 = dArray2[n6 + n4 + n8 - n];
                    double d6 = d5 - d4;
                    tGRPointArray2[n4] = TGRPoint.multiply(d3 - d4, tGRPointArray2[n4]).addBy(TGRPoint.multiply(d5 - d3, tGRPointArray2[n4 - 1])).divideBy(d6);
                    tGRPointArray3[n4] = TGRPoint.multiply(d2 - d4, tGRPointArray3[n4]).addBy(TGRPoint.multiply(d5 - d2, tGRPointArray3[n4 - 1])).divideBy(d6).addBy(tGRPointArray2[n4]);
                    --n4;
                }
                --n8;
            }
            tGRPointArray.setValue(n2, TGRPoint.divide(tGRPointArray3[n - 1], n));
            ++n2;
        }
        ++this.fOrder;
        this.fPoints.swap(tGRPointArray);
        this.fKnots.swap(tGParametricArray);
    }

    public boolean isBezier() {
        return prStatic.IsBezierKnots(this.fOrder, this.fNumPoints, this.fKnots);
    }

    public boolean isEmpty() {
        return this.fOrder == 0;
    }

    public boolean isPinned() {
        return prStatic.IsPinnedKnots(this.fOrder, this.fNumPoints, this.fKnots);
    }

    public void prAppendCurve(TBaseCurve tBaseCurve, boolean bl) {
        int n;
        if (!this.isPinned()) {
            this.refineToPinned();
        }
        if ((n = tBaseCurve.getOrder()) > this.fOrder) {
            this.raiseOrder(n);
        } else if (this.fOrder > n) {
            tBaseCurve.raiseOrder(this.fOrder);
        }
        TGRPoint[] tGRPointArray = this.fPoints.getArray();
        TGRPoint[] tGRPointArray2 = tBaseCurve.fPoints.getArray();
        TGRPoint tGRPoint = new TGRPoint(tGRPointArray[this.fNumPoints - 1]);
        TGRPoint tGRPoint2 = new TGRPoint(tGRPointArray2[0]);
        int n2 = tBaseCurve.getNumberOfPoints();
        int n3 = bl && tGRPoint.equals(tGRPoint2) ? 1 : 0;
        this.fPoints.resize(this.fNumPoints + n2 - n3);
        tGRPointArray = this.fPoints.getArray();
        double[] dArray = this.fKnots.getArray();
        TGParametricArray tGParametricArray = new TGParametricArray(this.fNumPoints + this.fOrder + n2 - n3);
        System.arraycopy(dArray, 0, tGParametricArray.getArray(), 0, this.fNumPoints + this.fOrder);
        this.fKnots = tGParametricArray;
        dArray = this.fKnots.getArray();
        double[] dArray2 = tBaseCurve.fKnots.getArray();
        double d = dArray[this.fOrder + this.fNumPoints - 1] - dArray2[0];
        int n4 = this.fOrder + this.fNumPoints - n3;
        int n5 = this.fOrder;
        int n6 = 0;
        while (n6 < n2) {
            dArray[n4] = dArray2[n5] + d;
            ++n6;
            ++n5;
            ++n4;
        }
        n4 = this.fNumPoints;
        n5 = n3;
        n6 = 0;
        while (n6 < n2 - n3) {
            tGRPointArray[n4].copyFrom(tGRPointArray2[n5]);
            ++n6;
            ++n5;
            ++n4;
        }
        this.fNumPoints += n2 - n3;
    }

    public void raiseOrder(int n) {
        if (this.fOrder == 0) {
            throw new IllegalArgumentException("curve not initialized");
        }
        if (n > this.fOrder) {
            int n2 = this.fOrder;
            while (n2 < n) {
                this.incrementOrder();
                ++n2;
            }
        }
    }

    public void refine(TGParametricArray tGParametricArray) {
        int n = tGParametricArray.getNumberOfValues();
        double[] dArray = this.fKnots.getArray();
        double[] dArray2 = tGParametricArray.getArray();
        TGRPointArray tGRPointArray = new TGRPointArray(n - this.fOrder);
        double[][] dArray3 = prStatic.ComputeAlphaMatrix(dArray, dArray2, this.fNumPoints, n, this.fOrder);
        TGRPoint[] tGRPointArray2 = tGRPointArray.getArray();
        TGRPoint[] tGRPointArray3 = this.fPoints.getArray();
        int n2 = 0;
        while (n2 < n - this.fOrder) {
            TGRPoint tGRPoint = tGRPointArray2[n2];
            int n3 = this.fNumPoints - 1 + this.fOrder;
            while (dArray2[n2] < dArray[n3] && n3 > 0) {
                --n3;
            }
            int n4 = n3 - this.fOrder + 1;
            if (n4 < 0) {
                n4 = 0;
            }
            TGRPoint.SetToZero(tGRPoint);
            int n5 = n4;
            while (n5 <= n3) {
                TGRPoint tGRPoint2 = tGRPointArray3[n5];
                tGRPoint.addBy(TGRPoint.multiply(tGRPoint2, dArray3[n5 - n4][n2]));
                ++n5;
            }
            ++n2;
        }
        this.fNumPoints = n - this.fOrder;
        this.fKnots.resize(this.fOrder + this.fNumPoints);
        dArray = this.fKnots.getArray();
        System.arraycopy(dArray2, 0, dArray, 0, this.fOrder + this.fNumPoints);
        this.fPoints.swap(tGRPointArray);
    }

    public void refineToBeziers() {
        if (this.fOrder == 0) {
            throw new IllegalArgumentException("curve not initialized");
        }
        TGParametricArray tGParametricArray = new TGParametricArray(0);
        if (!this.isPinned()) {
            this.refineToPinned();
        }
        prStatic.RefineKVToBezier(this.fOrder, this.fNumPoints, this.fKnots.getArray(), tGParametricArray);
        if (tGParametricArray.getNumberOfValues() != this.fOrder + this.fNumPoints) {
            this.refine(tGParametricArray);
        }
    }

    public void refineToPinned() {
        if (this.isPinned()) {
            return;
        }
        TGParametricArray tGParametricArray = new TGParametricArray(this.fOrder + this.fNumPoints);
        prStatic.RefineKVToPinned(this.fOrder, this.fNumPoints, this.fKnots, tGParametricArray);
        this.refine(tGParametricArray);
    }

    public void reverseDirection() {
        Object object;
        if (this.fOrder == 0) {
            throw new IllegalArgumentException("curve not initialized");
        }
        TGRPoint[] tGRPointArray = this.fPoints.getArray();
        int n = 0;
        int n2 = this.fNumPoints - 1;
        while (n < n2) {
            object = tGRPointArray[n];
            tGRPointArray[n] = tGRPointArray[n2];
            tGRPointArray[n2] = object;
            ++n;
            --n2;
        }
        object = this.fKnots.getArray();
        n2 = this.fNumPoints + this.fOrder - 1;
        double d = object[n2] + object[0];
        n = 0;
        while (n < n2) {
            double d2 = object[n];
            object[n] = d - object[n2];
            object[n2] = d - d2;
            ++n;
            --n2;
        }
    }

    public void setKnotScheme(int n) {
        switch (n) {
            case 0: {
                prStatic.SetPinnedKnots(this.fOrder, this.fNumPoints, this.fKnots);
                break;
            }
            case 1: {
                int n2 = 0;
                while (n2 < this.fNumPoints + this.fOrder) {
                    this.fKnots.setValue(n2, n2);
                    ++n2;
                }
                break;
            }
            case 2: {
                prStatic.SetBezierKnots(this.fOrder, this.fNumPoints, this.fKnots);
                break;
            }
        }
    }

    public void setPoint(int n, TGRPoint tGRPoint) {
        this.fPoints.setPoint(n, tGRPoint);
    }
}

