/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.Albert;

import sun.awt.Albert.MAreaGeometry;
import sun.awt.Albert.TCAGAdd;
import sun.awt.Albert.TCAGNode;
import sun.awt.Albert.TGPoint;
import sun.awt.Albert.TGRect;
import sun.awt.Albert.TGrafExtractor;
import sun.awt.Albert.TGrafMatrix;

class TAddGeometry
extends MAreaGeometry {
    private MAreaGeometry fLeft;
    private MAreaGeometry fRight;
    private TGRect fBounds;

    public TAddGeometry() {
        this.fBounds = null;
    }

    public TAddGeometry(MAreaGeometry mAreaGeometry, MAreaGeometry mAreaGeometry2) {
        this.fLeft = mAreaGeometry;
        this.fRight = mAreaGeometry2;
        this.fBounds = null;
        this.updateTimeStamp();
    }

    public TAddGeometry(TAddGeometry tAddGeometry) {
        super(tAddGeometry);
        this.fLeft = null;
        this.fRight = null;
        this.fBounds = null;
        if (tAddGeometry.fLeft != null) {
            this.fLeft = (MAreaGeometry)tAddGeometry.fLeft.clone();
        }
        if (tAddGeometry.fRight != null) {
            this.fRight = (MAreaGeometry)tAddGeometry.fRight.clone();
        }
        if (tAddGeometry.fBounds != null) {
            this.fBounds = (TGRect)tAddGeometry.fBounds.clone();
        }
    }

    public Object clone() {
        return new TAddGeometry(this);
    }

    public MAreaGeometry cloneAndAdd(MAreaGeometry mAreaGeometry) {
        TAddGeometry tAddGeometry = new TAddGeometry(this);
        tAddGeometry.fLeft = MAreaGeometry.add(tAddGeometry.fLeft, mAreaGeometry);
        tAddGeometry.fBounds = null;
        tAddGeometry.updateTimeStamp();
        return tAddGeometry;
    }

    public boolean contains(TGPoint tGPoint) {
        return this.getBounds().contains(tGPoint) && (this.fLeft.contains(tGPoint) || this.fRight.contains(tGPoint));
    }

    public boolean contains(TGRect tGRect) {
        return this.fLeft.contains(tGRect) || this.fRight.contains(tGRect);
    }

    public final TAddGeometry copyFrom(TAddGeometry tAddGeometry) {
        if (this != tAddGeometry) {
            super.copyFrom(tAddGeometry);
            this.fLeft = tAddGeometry.fLeft;
            this.fRight = tAddGeometry.fRight;
            this.fBounds = tAddGeometry.fBounds;
        }
        return this;
    }

    public boolean equals(MAreaGeometry mAreaGeometry) {
        if (this.getClass().equals(mAreaGeometry.getClass())) {
            TAddGeometry tAddGeometry = (TAddGeometry)mAreaGeometry;
            return super.equals(mAreaGeometry) || this.fLeft == tAddGeometry.fLeft && this.fRight == tAddGeometry.fRight;
        }
        return false;
    }

    public void extract(TGrafExtractor tGrafExtractor, TCAGNode tCAGNode, TGrafMatrix tGrafMatrix) {
        TCAGAdd tCAGAdd = new TCAGAdd(tCAGNode);
        tGrafExtractor.adoptCAGNode(tCAGAdd);
        this.fLeft.extract(tGrafExtractor, tCAGAdd, tGrafMatrix);
        this.fRight.extract(tGrafExtractor, tCAGAdd.getRightLink(), tGrafMatrix);
    }

    public TGRect getBounds() {
        if (this.fBounds == null) {
            this.fBounds = new TGRect(this.fLeft.getBounds());
            this.fBounds.extendTo(this.fRight.getBounds());
        }
        return this.fBounds;
    }

    public boolean intersects(TGRect tGRect) {
        return (this.fLeft.intersects(tGRect) || this.fRight.intersects(tGRect)) && !this.contains(tGRect);
    }

    public boolean isEmpty() {
        return this.fLeft.isEmpty() && this.fRight.isEmpty();
    }

    public boolean isPolygonal() {
        return this.fLeft.isPolygonal() && this.fRight.isPolygonal();
    }

    public boolean isSingular() {
        return false;
    }
}

