/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.Albert;

import sun.awt.Albert.TAddGeometry;
import sun.awt.Albert.TCAGNode;
import sun.awt.Albert.TExclusiveOrGeometry;
import sun.awt.Albert.TGPoint;
import sun.awt.Albert.TGRect;
import sun.awt.Albert.TGrafExtractor;
import sun.awt.Albert.TGrafMatrix;
import sun.awt.Albert.TIntersectGeometry;
import sun.awt.Albert.TSubtractGeometry;
import sun.awt.Albert.TTransformedGeometry;

public abstract class MAreaGeometry {
    private long fTimeStamp;
    private static long fgTimeStampBase;
    private static final TGrafMatrix fkIdentity;

    static {
        fkIdentity = new TGrafMatrix();
    }

    protected MAreaGeometry() {
        this.updateTimeStamp();
    }

    protected MAreaGeometry(MAreaGeometry mAreaGeometry) {
        this.fTimeStamp = mAreaGeometry.fTimeStamp;
    }

    public static MAreaGeometry add(MAreaGeometry mAreaGeometry, MAreaGeometry mAreaGeometry2) {
        if (mAreaGeometry2 != null) {
            TGRect tGRect = mAreaGeometry.getBounds();
            TGRect tGRect2 = mAreaGeometry2.getBounds();
            if (mAreaGeometry2.isRectangular() && tGRect2.contains(tGRect)) {
                return mAreaGeometry2;
            }
            if (!(mAreaGeometry.isRectangular() && tGRect.contains(tGRect2) || mAreaGeometry.equals(mAreaGeometry2))) {
                return mAreaGeometry.cloneAndAdd(mAreaGeometry2);
            }
        }
        return mAreaGeometry;
    }

    public abstract Object clone();

    public MAreaGeometry cloneAndAdd(MAreaGeometry mAreaGeometry) {
        return new TAddGeometry(this, mAreaGeometry);
    }

    public MAreaGeometry cloneAndExclusiveOr(MAreaGeometry mAreaGeometry) {
        return new TExclusiveOrGeometry(this, mAreaGeometry);
    }

    public MAreaGeometry cloneAndIntersect(MAreaGeometry mAreaGeometry) {
        return new TIntersectGeometry(this, mAreaGeometry);
    }

    public MAreaGeometry cloneAndSubtract(MAreaGeometry mAreaGeometry) {
        return new TSubtractGeometry(this, mAreaGeometry);
    }

    public MAreaGeometry cloneAndTransform(TGrafMatrix tGrafMatrix) {
        return new TTransformedGeometry(this, tGrafMatrix);
    }

    public abstract boolean contains(TGPoint var1);

    public abstract boolean contains(TGRect var1);

    protected MAreaGeometry copyFrom(MAreaGeometry mAreaGeometry) {
        if (this != mAreaGeometry) {
            this.fTimeStamp = mAreaGeometry.fTimeStamp;
        }
        return this;
    }

    public boolean equals(MAreaGeometry mAreaGeometry) {
        return this.getTimeStamp() == mAreaGeometry.getTimeStamp();
    }

    public static MAreaGeometry exclusiveOr(MAreaGeometry mAreaGeometry, MAreaGeometry mAreaGeometry2) {
        if (mAreaGeometry2 != null) {
            if (mAreaGeometry.equals(mAreaGeometry2)) {
                return null;
            }
            return mAreaGeometry.cloneAndExclusiveOr(mAreaGeometry2);
        }
        return mAreaGeometry;
    }

    public final void extract(TGrafExtractor tGrafExtractor, TCAGNode tCAGNode) {
        this.extract(tGrafExtractor, tCAGNode, fkIdentity);
    }

    public abstract void extract(TGrafExtractor var1, TCAGNode var2, TGrafMatrix var3);

    public abstract TGRect getBounds();

    public long getTimeStamp() {
        return this.fTimeStamp;
    }

    public static MAreaGeometry intersect(MAreaGeometry mAreaGeometry, MAreaGeometry mAreaGeometry2) {
        if (mAreaGeometry2 != null) {
            TGRect tGRect;
            TGRect tGRect2 = mAreaGeometry.getBounds();
            if (!tGRect2.intersects(tGRect = mAreaGeometry2.getBounds())) {
                return null;
            }
            if (mAreaGeometry.isRectangular() && tGRect2.contains(tGRect)) {
                return mAreaGeometry2;
            }
            if (!(mAreaGeometry2.isRectangular() && tGRect.contains(tGRect2) && mAreaGeometry.equals(mAreaGeometry2))) {
                return mAreaGeometry.cloneAndIntersect(mAreaGeometry2);
            }
        }
        return mAreaGeometry;
    }

    public abstract boolean intersects(TGRect var1);

    public abstract boolean isEmpty();

    public boolean isPolygonal() {
        return false;
    }

    public boolean isRectangular() {
        return false;
    }

    public boolean isSingular() {
        return true;
    }

    private static synchronized long nextTimeStamp() {
        return ++fgTimeStampBase;
    }

    public static MAreaGeometry subtract(MAreaGeometry mAreaGeometry, MAreaGeometry mAreaGeometry2) {
        TGRect tGRect;
        TGRect tGRect2;
        if (mAreaGeometry2 != null && (tGRect2 = mAreaGeometry.getBounds()).intersects(tGRect = mAreaGeometry2.getBounds())) {
            if (mAreaGeometry2.isRectangular() && tGRect.contains(tGRect2) || mAreaGeometry.equals(mAreaGeometry2)) {
                return null;
            }
            return mAreaGeometry.cloneAndSubtract(mAreaGeometry2);
        }
        return mAreaGeometry;
    }

    final void updateTimeStamp() {
        this.fTimeStamp = MAreaGeometry.nextTimeStamp();
    }
}

