/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.Albert;

import java.awt.geom.PathIterator;
import sun.awt.Albert.TGLoop;
import sun.awt.Albert.TGPoint;

public class AreaPathIterator
implements PathIterator {
    TGLoop fGeometry = null;
    int fEndCurve = 0;
    int fCurrentIndex = 0;
    int fNextBreak = 0;

    public AreaPathIterator(TGLoop tGLoop) {
        if (tGLoop == null || tGLoop.isEmpty()) {
            this.fEndCurve = -1;
            this.fGeometry = null;
        } else {
            this.fGeometry = new TGLoop(tGLoop);
            if (this.fGeometry.getOrder() > 4) {
                throw new IllegalArgumentException("AreaPathIterator: Order of curve is higher than cubic!");
            }
            if (!this.fGeometry.isBezier()) {
                this.fGeometry.refineToBeziers();
            }
            this.fEndCurve = this.fGeometry.getNumberOfPoints();
        }
    }

    public int currentSegment(double[] dArray) {
        if (this.fGeometry == null || this.fCurrentIndex == this.fNextBreak) {
            this.extractPoints(1, dArray);
            return 0;
        }
        switch (this.fGeometry.getOrder()) {
            default: {
                this.extractPoints(1, dArray);
                return 1;
            }
            case 3: {
                this.extractPoints(2, dArray);
                return 2;
            }
            case 4: 
        }
        this.extractPoints(3, dArray);
        return 3;
    }

    public int currentSegment(float[] fArray) {
        double[] dArray = new double[6];
        int n = this.currentSegment(dArray);
        int n2 = 0;
        switch (n) {
            case 3: {
                ++n2;
            }
            case 2: {
                ++n2;
            }
            case 0: 
            case 1: {
                ++n2;
            }
        }
        n2 *= 2;
        int n3 = 0;
        while (n3 < n2) {
            fArray[n3] = (float)dArray[n3];
            ++n3;
        }
        return n;
    }

    private final void extractPoints(int n, double[] dArray) {
        int n2 = 0;
        int n3 = this.fCurrentIndex;
        int n4 = 0;
        while (n4 < n) {
            TGPoint tGPoint = this.fGeometry.getPoint(n3++).divW();
            dArray[n2++] = tGPoint.x;
            dArray[n2++] = tGPoint.y;
            ++n4;
        }
    }

    public int getWindingRule() {
        if (this.fGeometry == null || this.fGeometry.getEOFill()) {
            return 0;
        }
        return 1;
    }

    public boolean isDone() {
        return this.fCurrentIndex >= this.fEndCurve;
    }

    public void next() {
        if (this.fGeometry != null) {
            if (this.fCurrentIndex < this.fNextBreak) {
                int n = this.fGeometry.getOrder() - 1;
                if (n > 0) {
                    this.fCurrentIndex += n;
                }
            } else {
                this.fNextBreak = this.fGeometry.getNextDiscontinuity(this.fNextBreak);
                ++this.fCurrentIndex;
            }
        }
    }
}

