/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html.parser;

import java.io.IOException;
import java.io.Reader;
import javax.swing.text.ChangedCharSetException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.DTD;
import javax.swing.text.html.parser.Element;
import javax.swing.text.html.parser.Parser;
import javax.swing.text.html.parser.TagElement;

public class DocumentParser
extends Parser {
    private int inbody;
    private int intitle;
    private int inhead;
    private boolean seentitle;
    private HTMLEditorKit.ParserCallback callback = null;
    private boolean ignoreCharSet = false;
    private static final boolean debugFlag = false;

    public DocumentParser(DTD dTD) {
        super(dTD);
    }

    private void debug(String string) {
        System.out.println(string);
    }

    protected void handleComment(char[] cArray) {
        this.callback.handleComment(cArray, this.getCurrentPos());
    }

    protected void handleEmptyTag(TagElement tagElement) throws ChangedCharSetException {
        Element element = tagElement.getElement();
        if (element == this.dtd.meta && !this.ignoreCharSet) {
            String string;
            SimpleAttributeSet simpleAttributeSet = this.getAttributes();
            if (simpleAttributeSet != null && (string = (String)simpleAttributeSet.getAttribute(HTML.Attribute.CONTENT)) != null) {
                if ("content-type".equalsIgnoreCase((String)simpleAttributeSet.getAttribute(HTML.Attribute.HTTPEQUIV))) {
                    throw new ChangedCharSetException(string, false);
                }
                if ("charset".equalsIgnoreCase((String)simpleAttributeSet.getAttribute(HTML.Attribute.HTTPEQUIV))) {
                    throw new ChangedCharSetException(string, true);
                }
            }
        } else if (this.inbody != 0 || element == this.dtd.meta || element == this.dtd.base || element == this.dtd.isindex) {
            if (tagElement.fictional()) {
                this.callback.handleSimpleTag(tagElement.getHTMLTag(), new SimpleAttributeSet(), this.getCurrentPos());
            } else {
                this.callback.handleSimpleTag(tagElement.getHTMLTag(), this.getAttributes(), this.getCurrentPos());
                this.flushAttributes();
            }
        }
    }

    protected void handleEndTag(TagElement tagElement) {
        Element element = tagElement.getElement();
        if (element == this.dtd.body) {
            --this.inbody;
        } else if (element == this.dtd.title) {
            --this.intitle;
            this.seentitle = true;
        } else if (element == this.dtd.head) {
            --this.inhead;
        }
        this.callback.handleEndTag(tagElement.getHTMLTag(), this.getCurrentPos());
    }

    protected void handleError(int n, String string) {
        this.callback.handleError(string, this.getCurrentPos());
    }

    protected void handleStartTag(TagElement tagElement) {
        Element element = tagElement.getElement();
        if (element == this.dtd.body) {
            ++this.inbody;
        } else if (element != this.dtd.html) {
            if (element == this.dtd.head) {
                ++this.inhead;
            } else if (element == this.dtd.title) {
                ++this.intitle;
            }
        }
        if (tagElement.fictional()) {
            this.callback.handleStartTag(tagElement.getHTMLTag(), new SimpleAttributeSet(), this.getCurrentPos());
        } else {
            this.callback.handleStartTag(tagElement.getHTMLTag(), this.getAttributes(), this.getCurrentPos());
            this.flushAttributes();
        }
    }

    protected void handleText(char[] cArray) {
        if (cArray != null && (this.inbody != 0 || this.intitle != 0 && !this.seentitle)) {
            this.callback.handleText(cArray, this.getCurrentPos());
        }
    }

    public void parse(Reader reader, HTMLEditorKit.ParserCallback parserCallback, boolean bl) throws IOException {
        this.ignoreCharSet = bl;
        this.callback = parserCallback;
        this.parse(reader);
    }
}

