/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.text.AbstractWriter;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.Option;
import javax.swing.text.html.OptionComboBoxModel;
import javax.swing.text.html.OptionListModel;

public class HTMLWriter
extends AbstractWriter {
    private Stack blockElementStack = new Stack();
    private boolean inContent = false;
    private boolean inPre = false;
    private boolean inTextArea = false;
    private boolean newlineOutputed = false;
    private boolean completeDoc;
    private Vector tags = new Vector(10);
    private boolean indentNext = false;

    public HTMLWriter(Writer writer, HTMLDocument hTMLDocument) {
        super(writer, hTMLDocument);
        this.completeDoc = true;
    }

    public HTMLWriter(Writer writer, HTMLDocument hTMLDocument, int n, int n2) {
        super(writer, hTMLDocument, n, n2);
        this.completeDoc = n == 0 && n2 == hTMLDocument.getLength();
    }

    protected void closeOutUnwantedEmbeddedTags(AttributeSet attributeSet) throws IOException {
        int n = this.tags.size() - 1;
        while (n >= 0) {
            HTML.Tag tag = (HTML.Tag)this.tags.elementAt(n);
            if (attributeSet == null || this.noMatchForTagInAttributes(attributeSet, tag)) {
                this.tags.removeElementAt(n);
                this.write('<');
                this.write('/');
                this.write(tag.toString());
                this.write('>');
            }
            --n;
        }
    }

    protected void comment(Element element) throws BadLocationException, IOException {
        AttributeSet attributeSet = element.getAttributes();
        if (this.matchNameAttribute(attributeSet, HTML.Tag.COMMENT)) {
            Object object = attributeSet.getAttribute(HTML.Attribute.COMMENT);
            if (object instanceof String) {
                this.writeComment((String)object);
            } else {
                this.writeComment(null);
            }
        }
    }

    protected void emptyTag(Element element) throws BadLocationException, IOException {
        if (!this.inContent && !this.inPre) {
            this.indent();
        }
        AttributeSet attributeSet = element.getAttributes();
        this.closeOutUnwantedEmbeddedTags(attributeSet);
        this.writeEmbeddedTags(attributeSet);
        if (this.matchNameAttribute(attributeSet, HTML.Tag.CONTENT)) {
            this.inContent = true;
            this.text(element);
        } else if (this.matchNameAttribute(attributeSet, HTML.Tag.COMMENT)) {
            this.comment(element);
        } else {
            boolean bl = this.isBlockTag(element.getAttributes());
            if (this.inContent && bl) {
                this.write('\n');
                this.indent();
            }
            this.write('<');
            Object object = attributeSet != null ? attributeSet.getAttribute(StyleConstants.NameAttribute) : null;
            Object object2 = attributeSet != null ? attributeSet.getAttribute(HTML.Attribute.ENDTAG) : null;
            boolean bl2 = false;
            if (object != null && object2 != null && object2 instanceof String && ((String)object2).equals("true")) {
                bl2 = true;
                this.write('/');
            }
            this.write(element.getName());
            this.writeAttributes(attributeSet);
            this.write('>');
            if (this.matchNameAttribute(attributeSet, HTML.Tag.TITLE) && !bl2) {
                Document document = element.getDocument();
                String string = (String)document.getProperty("title");
                this.write(string);
            } else if (!this.inContent || bl) {
                this.write('\n');
                if (bl && this.inContent) {
                    this.indent();
                }
            }
        }
    }

    protected void endTag(Element element) throws IOException {
        if (this.synthesizedElement(element)) {
            return;
        }
        if (this.matchNameAttribute(element.getAttributes(), HTML.Tag.PRE)) {
            this.inPre = false;
        }
        this.closeOutUnwantedEmbeddedTags(element.getAttributes());
        if (this.inContent) {
            if (!this.newlineOutputed) {
                this.write('\n');
            }
            this.newlineOutputed = false;
            this.inContent = false;
        }
        this.indent();
        this.write('<');
        this.write('/');
        this.write(element.getName());
        this.write('>');
        this.write('\n');
    }

    private boolean indentNeedsIncrementing(Element element, Element element2) {
        if (element2.getParentElement() == element && !this.inPre) {
            if (this.indentNext) {
                this.indentNext = false;
                return true;
            }
            if (this.synthesizedElement(element2)) {
                this.indentNext = true;
            } else if (!this.synthesizedElement(element)) {
                return true;
            }
        }
        return false;
    }

    protected boolean isBlockTag(AttributeSet attributeSet) {
        Object object = attributeSet.getAttribute(StyleConstants.NameAttribute);
        if (object instanceof HTML.Tag) {
            HTML.Tag tag = (HTML.Tag)object;
            return tag.isBlock();
        }
        return false;
    }

    private boolean isFormElementWithContent(AttributeSet attributeSet) {
        return this.matchNameAttribute(attributeSet, HTML.Tag.TEXTAREA) || this.matchNameAttribute(attributeSet, HTML.Tag.SELECT);
    }

    protected boolean matchNameAttribute(AttributeSet attributeSet, HTML.Tag tag) {
        HTML.Tag tag2;
        Object object = attributeSet.getAttribute(StyleConstants.NameAttribute);
        return object instanceof HTML.Tag && (tag2 = (HTML.Tag)object) == tag;
    }

    private boolean noMatchForTagInAttributes(AttributeSet attributeSet, HTML.Tag tag) {
        if (attributeSet != null) {
            Enumeration enumeration = attributeSet.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                Object object = enumeration.nextElement();
                if (!(object instanceof HTML.Tag) || object != tag) continue;
                return false;
            }
        }
        return true;
    }

    protected void selectContent(AttributeSet attributeSet) throws IOException {
        Object object = attributeSet.getAttribute(StyleConstants.ModelAttribute);
        this.incrIndent();
        if (object instanceof OptionListModel) {
            OptionListModel optionListModel = (OptionListModel)object;
            int n = optionListModel.getSize();
            int n2 = 0;
            while (n2 < n) {
                Option option = (Option)optionListModel.getElementAt(n2);
                this.writeOption(option);
                ++n2;
            }
        } else if (object instanceof OptionComboBoxModel) {
            OptionComboBoxModel optionComboBoxModel = (OptionComboBoxModel)object;
            int n = optionComboBoxModel.getSize();
            int n3 = 0;
            while (n3 < n) {
                Option option = (Option)optionComboBoxModel.getElementAt(n3);
                this.writeOption(option);
                ++n3;
            }
        }
        this.decrIndent();
    }

    protected void startTag(Element element) throws IOException, BadLocationException {
        if (this.synthesizedElement(element)) {
            return;
        }
        if (this.matchNameAttribute(element.getAttributes(), HTML.Tag.PRE)) {
            this.inPre = true;
        }
        AttributeSet attributeSet = element.getAttributes();
        this.closeOutUnwantedEmbeddedTags(attributeSet);
        if (this.inContent) {
            this.write('\n');
            this.inContent = false;
            this.newlineOutputed = false;
        }
        this.indent();
        this.write('<');
        this.write(element.getName());
        this.writeAttributes(attributeSet);
        this.write('>');
        this.write('\n');
        if (this.matchNameAttribute(element.getAttributes(), HTML.Tag.TEXTAREA)) {
            this.textAreaContent(element.getAttributes());
        } else if (this.matchNameAttribute(element.getAttributes(), HTML.Tag.SELECT)) {
            this.selectContent(element.getAttributes());
        }
    }

    protected boolean synthesizedElement(Element element) {
        return this.matchNameAttribute(element.getAttributes(), HTML.Tag.IMPLIED);
    }

    protected void text(Element element) throws BadLocationException, IOException {
        String string = this.getText(element);
        this.newlineOutputed = false;
        if (string.length() > 0) {
            this.write(string);
            if (string.endsWith("\n")) {
                this.newlineOutputed = true;
            }
        }
    }

    protected void textAreaContent(AttributeSet attributeSet) throws BadLocationException, IOException {
        String string;
        Document document = (Document)attributeSet.getAttribute(StyleConstants.ModelAttribute);
        if (document != null && document.getLength() > 0 && (string = document.getText(0, document.getLength())) != null) {
            this.inTextArea = true;
            this.incrIndent();
            this.indent();
            this.write(string);
            this.write('\n');
            this.inTextArea = false;
            this.decrIndent();
        }
    }

    public void write() throws IOException, BadLocationException {
        ElementIterator elementIterator = this.getElementIterator();
        Element element = null;
        Element element2 = null;
        while ((element2 = elementIterator.next()) != null) {
            if (!this.inRange(element2)) continue;
            if (element != null) {
                Element element3;
                if (this.indentNeedsIncrementing(element, element2)) {
                    this.incrIndent();
                } else if (element.getParentElement() != element2.getParentElement()) {
                    element3 = (Element)this.blockElementStack.peek();
                    while (element3 != element2.getParentElement()) {
                        this.blockElementStack.pop();
                        if (!this.synthesizedElement(element3)) {
                            if (!this.matchNameAttribute(element3.getAttributes(), HTML.Tag.PRE)) {
                                this.decrIndent();
                            }
                            this.endTag(element3);
                        }
                        element3 = (Element)this.blockElementStack.peek();
                    }
                } else if (element.getParentElement() == element2.getParentElement() && (element3 = (Element)this.blockElementStack.peek()) == element) {
                    this.blockElementStack.pop();
                    this.endTag(element3);
                }
            }
            if (!element2.isLeaf() || this.isFormElementWithContent(element2.getAttributes())) {
                this.blockElementStack.push(element2);
                this.startTag(element2);
            } else {
                this.emptyTag(element2);
            }
            element = element2;
        }
        this.closeOutUnwantedEmbeddedTags(null);
        while (!this.blockElementStack.empty()) {
            element = (Element)this.blockElementStack.pop();
            if (this.synthesizedElement(element)) continue;
            if (!this.matchNameAttribute(element.getAttributes(), HTML.Tag.PRE)) {
                this.decrIndent();
            }
            this.endTag(element);
        }
        if (this.completeDoc) {
            this.writeAdditionalComments();
        }
    }

    protected void write(String string) throws IOException {
        if (this.inTextArea) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
            try {
                while (stringTokenizer.hasMoreTokens()) {
                    super.write(stringTokenizer.nextToken());
                    if (stringTokenizer.countTokens() == 0) continue;
                    this.write('\n');
                    this.indent();
                }
            }
            catch (NoSuchElementException noSuchElementException) {}
        } else {
            super.write(string);
        }
    }

    void writeAdditionalComments() throws IOException {
        Object object = this.getDocument().getProperty("AdditionalComments");
        if (object instanceof Vector) {
            Vector vector = (Vector)object;
            int n = 0;
            int n2 = vector.size();
            while (n < n2) {
                this.writeComment(vector.elementAt(n).toString());
                ++n;
            }
        }
    }

    protected void writeAttributes(AttributeSet attributeSet) throws IOException {
        Enumeration enumeration = attributeSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            if (object instanceof HTML.Tag || object == StyleConstants.NameAttribute || object == HTML.Attribute.ENDTAG || object == StyleConstants.ModelAttribute) continue;
            this.write(" " + object + "=" + attributeSet.getAttribute(object));
        }
    }

    void writeComment(String string) throws IOException {
        this.write('<');
        this.write('!');
        this.write('-');
        this.write('-');
        if (string != null) {
            this.write(string);
        }
        this.write('-');
        this.write('-');
        this.write('>');
        this.write('\n');
    }

    protected void writeEmbeddedTags(AttributeSet attributeSet) throws IOException {
        Enumeration enumeration = attributeSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            HTML.Tag tag;
            Object object = enumeration.nextElement();
            if (!(object instanceof HTML.Tag) || (tag = (HTML.Tag)object) == HTML.Tag.FORM || this.tags.contains(tag)) continue;
            this.write('<');
            this.write(tag.toString());
            Object object2 = attributeSet.getAttribute(tag);
            if (object2 != null && object2 instanceof AttributeSet) {
                this.writeAttributes((AttributeSet)object2);
            }
            this.write('>');
            this.tags.addElement(tag);
        }
    }

    protected void writeOption(Option option) throws IOException {
        this.indent();
        this.write('<');
        this.write("option ");
        if (option.getValue() != null) {
            this.write("value=" + option.getValue());
        }
        if (option.isSelected()) {
            this.write(" selected");
        }
        this.write('>');
        if (option.getLabel() != null) {
            this.write(option.getLabel());
        }
        this.write('\n');
    }
}

