/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Container;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Vector;
import javax.swing.SizeRequirements;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Bidi;
import javax.swing.text.BoxView;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.StateInvariantError;
import javax.swing.text.StyleConstants;
import javax.swing.text.TabExpander;
import javax.swing.text.TabSet;
import javax.swing.text.TabStop;
import javax.swing.text.TabableView;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class ParagraphView
extends BoxView
implements TabExpander {
    private int justification;
    private float lineSpacing;
    protected int firstLineIndent;
    private int tabBase;
    private int layoutSpan = -1;
    private Vector layoutPool;
    static char[] tabChars = new char[1];
    static char[] tabDecimalChars;

    static {
        ParagraphView.tabChars[0] = 9;
        tabDecimalChars = new char[2];
        ParagraphView.tabDecimalChars[0] = 9;
        ParagraphView.tabDecimalChars[1] = 46;
    }

    public ParagraphView(Element element) {
        super(element, 1);
        this.setPropertiesFromAttributes();
    }

    protected void adjustRow(Row row, int n, int n2) {
        int n3;
        View view;
        int n4 = row.getViewCount();
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = -1;
        boolean bl = false;
        int n9 = 0;
        while (n9 < n4) {
            view = row.getView(n9);
            int n10 = view.getBreakWeight(0, n2 + n5, n3 = n - n5);
            if (n10 >= n6) {
                n6 = n10;
                n8 = n9;
                n7 = n5;
                if (n10 >= 3000) break;
            }
            n5 = (int)((float)n5 + view.getPreferredSpan(0));
            ++n9;
        }
        if (n8 < 0) {
            return;
        }
        n3 = n - n7;
        view = row.getView(n8);
        view = view.breakView(0, view.getStartOffset(), n2 + n7, n3);
        View[] viewArray = new View[]{view};
        row.replace(n8, n4 - n8, viewArray);
        int n11 = this.layoutPool.size();
        int n12 = 0;
        while (n12 < n11) {
            view = (View)this.layoutPool.elementAt(n12);
            if (view.getParent() == null) {
                view.setParent(this);
            }
            ++n12;
        }
    }

    public View breakView(int n, float f, Shape shape) {
        if (n == 1) {
            if (shape != null) {
                Rectangle rectangle = shape.getBounds();
                this.setSize(rectangle.width, rectangle.height);
            }
            return this;
        }
        return this;
    }

    protected SizeRequirements calculateMinorAxisRequirements(int n, SizeRequirements sizeRequirements) {
        if (sizeRequirements == null) {
            sizeRequirements = new SizeRequirements();
        }
        float f = 0.0f;
        int n2 = this.layoutPool.size();
        int n3 = 0;
        while (n3 < n2) {
            View view = (View)this.layoutPool.elementAt(n3);
            f += view.getPreferredSpan(n);
            ++n3;
        }
        sizeRequirements.minimum = 0;
        sizeRequirements.preferred = (int)f;
        sizeRequirements.maximum = Integer.MAX_VALUE;
        sizeRequirements.alignment = 0.5f;
        return sizeRequirements;
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        Object object;
        this.setPropertiesFromAttributes();
        Element element = this.getElement();
        DocumentEvent.ElementChange elementChange = documentEvent.getChange(element);
        if (elementChange != null) {
            this.updateLogicalChildren(elementChange, viewFactory);
        }
        int n = documentEvent.getOffset();
        int n2 = n + documentEvent.getLength();
        int n3 = element.getElementIndex(n);
        int n4 = element.getElementIndex(n2 - 1);
        if (n == n2 && n4 < n3 && n3 > 0) {
            n4 = --n3 + 1;
        }
        int n5 = n3;
        while (n5 <= n4) {
            object = (View)this.layoutPool.elementAt(n5);
            ((View)object).changedUpdate(documentEvent, null, viewFactory);
            ++n5;
        }
        this.layoutSpan = Integer.MAX_VALUE;
        this.preferenceChanged(null, true, true);
        if (shape != null) {
            object = this.getInsideAllocation(shape);
            this.layout(((Rectangle)object).width, ((Rectangle)object).height);
            Container container = this.getContainer();
            container.repaint(((Rectangle)object).x, ((Rectangle)object).y, ((Rectangle)object).width, ((Rectangle)object).height);
        }
    }

    View createView(int n) {
        Element element;
        int n2 = this.getElement().getElementIndex(n);
        View view = (View)this.layoutPool.elementAt(n2);
        int n3 = view.getEndOffset();
        AbstractDocument abstractDocument = (AbstractDocument)this.getDocument();
        if (abstractDocument.getProperty("i18n").equals(Boolean.TRUE) && (element = abstractDocument.getBidiRootElement()).getElementCount() > 1) {
            int n4 = element.getElementIndex(n);
            Element element2 = element.getElement(n4);
            n3 = Math.min(element2.getEndOffset(), n3);
        }
        if (n == view.getStartOffset() && n3 == view.getEndOffset()) {
            return view;
        }
        view = view.createFragment(n, n3);
        return view;
    }

    protected int findOffsetToCharactersInString(char[] cArray, int n) {
        int n2 = cArray.length;
        int n3 = this.getEndOffset();
        Segment segment = new Segment();
        try {
            this.getDocument().getText(n, n3 - n, segment);
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
        int n4 = segment.offset;
        int n5 = segment.offset + segment.count;
        while (n4 < n5) {
            char c = segment.array[n4];
            int n6 = 0;
            while (n6 < n2) {
                if (c == cArray[n6]) {
                    return n4 - segment.offset + n;
                }
                ++n6;
            }
            ++n4;
        }
        return -1;
    }

    protected boolean flipEastAndWestAtEnds(int n, Position.Bias bias) {
        Document document = this.getDocument();
        return document instanceof AbstractDocument && !((AbstractDocument)document).isLeftToRight(this.getStartOffset(), this.getStartOffset() + 1);
    }

    public float getAlignment(int n) {
        switch (n) {
            case 1: {
                float f = 0.5f;
                if (this.getViewCount() != 0) {
                    int n2 = (int)this.getPreferredSpan(1);
                    View view = this.getView(0);
                    int n3 = (int)view.getPreferredSpan(1);
                    f = n2 != 0 ? (float)(n3 / 2) / (float)n2 : 0.0f;
                }
                return f;
            }
            case 0: {
                return 0.5f;
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + n);
    }

    public int getBreakWeight(int n, float f) {
        if (n == 1) {
            return 0;
        }
        return 0;
    }

    protected int getClosestPositionTo(int n, Position.Bias bias, Shape shape, int n2, Position.Bias[] biasArray, int n3, int n4) throws BadLocationException {
        JTextComponent jTextComponent = (JTextComponent)this.getContainer();
        Document document = this.getDocument();
        AbstractDocument abstractDocument = document instanceof AbstractDocument ? (AbstractDocument)document : null;
        View view = this.getView(n3);
        int n5 = -1;
        biasArray[0] = Position.Bias.Forward;
        int n6 = 0;
        int n7 = view.getViewCount();
        while (n6 < n7) {
            boolean bl;
            View view2 = view.getView(n6);
            int n8 = view2.getStartOffset();
            boolean bl2 = bl = abstractDocument != null ? abstractDocument.isLeftToRight(n8, n8 + 1) : true;
            if (bl) {
                n5 = n8;
                int n9 = view2.getEndOffset();
                while (n5 < n9) {
                    if (jTextComponent.modelToView((int)n5).getBounds().x >= n4) {
                        return n5;
                    }
                    ++n5;
                }
                --n5;
            } else {
                n5 = view2.getEndOffset() - 1;
                while (n5 >= n8) {
                    if (jTextComponent.modelToView((int)n5).getBounds().x >= n4) {
                        return n5;
                    }
                    --n5;
                }
                ++n5;
            }
            ++n6;
        }
        if (n5 == -1) {
            return this.getStartOffset();
        }
        return n5;
    }

    protected View getLayoutView(int n) {
        return (View)this.layoutPool.elementAt(n);
    }

    protected int getLayoutViewCount() {
        return this.layoutPool.size();
    }

    protected int getNextNorthSouthVisualPositionFrom(int n, Position.Bias bias, Shape shape, int n2, Position.Bias[] biasArray) throws BadLocationException {
        Rectangle rectangle;
        Point point;
        int n3;
        if (n == -1) {
            n3 = n2 == 1 ? this.getViewCount() - 1 : 0;
        } else {
            n3 = bias == Position.Bias.Backward && n > 0 ? this.getViewIndexAtPosition(n - 1) : this.getViewIndexAtPosition(n);
            if (n2 == 1) {
                if (n3 == 0) {
                    return -1;
                }
                --n3;
            } else if (++n3 >= this.getViewCount()) {
                return -1;
            }
        }
        JTextComponent jTextComponent = (JTextComponent)this.getContainer();
        Caret caret = jTextComponent.getCaret();
        Point point2 = point = caret != null ? caret.getMagicCaretPosition() : null;
        int n4 = point == null ? ((rectangle = jTextComponent.getUI().modelToView(jTextComponent, n, bias)) == null ? 0 : rectangle.getBounds().x) : point.x;
        return this.getClosestPositionTo(n, bias, shape, n2, biasArray, n3, n4);
    }

    protected float getPartialSize(int n, int n2) {
        float f = 0.0f;
        int n3 = this.getViewCount();
        int n4 = this.getElement().getElementIndex(n);
        n3 = this.layoutPool.size();
        while (n < n2 && n4 < n3) {
            View view = (View)this.layoutPool.elementAt(n4++);
            int n5 = view.getEndOffset();
            int n6 = Math.min(n2, n5);
            if (view instanceof TabableView) {
                f += ((TabableView)((Object)view)).getPartialSpan(n, n6);
            } else if (n == view.getStartOffset() && n6 == view.getEndOffset()) {
                f += view.getPreferredSpan(0);
            } else {
                return 0.0f;
            }
            n = n5;
        }
        return f;
    }

    protected float getTabBase() {
        return this.tabBase;
    }

    protected TabSet getTabSet() {
        return StyleConstants.getTabSet(this.getElement().getAttributes());
    }

    protected View getViewAtPosition(int n, Rectangle rectangle) {
        View view;
        int n2 = this.getViewCount();
        int n3 = 0;
        while (n3 < n2) {
            view = this.getView(n3);
            int n4 = view.getStartOffset();
            int n5 = view.getEndOffset();
            if (n >= n4 && n < n5) {
                if (rectangle != null) {
                    this.childAllocation(n3, rectangle);
                }
                return view;
            }
            ++n3;
        }
        if (n == this.getEndOffset()) {
            view = this.getView(n2 - 1);
            if (rectangle != null) {
                this.childAllocation(n2 - 1, rectangle);
            }
            return view;
        }
        return null;
    }

    protected int getViewIndexAtPosition(int n) {
        if (n < this.getStartOffset() || n >= this.getEndOffset()) {
            return -1;
        }
        int n2 = this.getViewCount() - 1;
        while (n2 >= 0) {
            View view = this.getView(n2);
            if (n >= view.getStartOffset() && n < view.getEndOffset()) {
                return n2;
            }
            --n2;
        }
        return -1;
    }

    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        int n;
        int n2;
        Element element = this.getElement();
        DocumentEvent.ElementChange elementChange = documentEvent.getChange(element);
        if (elementChange != null) {
            this.updateLogicalChildren(elementChange, viewFactory);
        }
        if (elementChange != null && elementChange.getChildrenAdded().length > 0) {
            int n3;
            int n4;
            Object object;
            Element element2;
            n2 = elementChange.getIndex();
            n = documentEvent.getOffset();
            if (n2 > 0 && (element2 = element.getElement(n2 - 1)).getEndOffset() >= n) {
                object = (View)this.layoutPool.elementAt(n2 - 1);
                ((View)object).insertUpdate(documentEvent, null, viewFactory);
            }
            if ((n4 = n2 + elementChange.getChildrenAdded().length) < this.layoutPool.size() && (n3 = (object = element.getElement(n4)).getStartOffset()) >= n && n3 <= n + documentEvent.getLength()) {
                View view = (View)this.layoutPool.elementAt(n4);
                view.insertUpdate(documentEvent, null, viewFactory);
            }
        } else {
            n2 = documentEvent.getOffset();
            n = element.getElementIndex(n2);
            View view = (View)this.layoutPool.elementAt(n);
            view.insertUpdate(documentEvent, null, viewFactory);
            if (n > 0 && view.getStartOffset() == n2) {
                view = (View)this.layoutPool.elementAt(n - 1);
                view.insertUpdate(documentEvent, null, viewFactory);
            }
        }
        this.layoutSpan = Integer.MAX_VALUE;
        this.preferenceChanged(null, true, true);
        Rectangle rectangle = this.getInsideAllocation(shape);
        if (rectangle != null) {
            this.layout(rectangle.width, rectangle.height);
            Container container = this.getContainer();
            container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    protected void layout(int n, int n2) {
        if (this.layoutSpan != n) {
            int n3 = n2;
            this.rebuildRows(n);
            int n4 = (int)this.getPreferredSpan(1);
            if (n3 != n4) {
                View view = this.getParent();
                view.preferenceChanged(this, false, true);
            }
        }
        super.layout(n, n2);
    }

    void layoutRow(Row row, int n) {
        int n2;
        int n3;
        View view;
        int n4 = this.tabBase + this.getLeftInset();
        int n5 = this.layoutSpan;
        int n6 = this.getEndOffset();
        int n7 = n4;
        int n8 = n5 -= (n4 += row.getLeftInset()) - n7;
        n7 = n4;
        while (n < n6 && n5 > 0) {
            view = this.createView(n);
            n3 = view instanceof TabableView ? (int)((TabableView)((Object)view)).getTabbedSpan(n4, this) : (int)view.getPreferredSpan(0);
            n4 += n3;
            row.append(view);
            n = view.getEndOffset();
            if (view.getBreakWeight(0, n, n5 -= n3) >= 3000) break;
        }
        if (n5 < 0) {
            this.adjustRow(row, n8, n7);
        } else if (row.getViewCount() == 0) {
            view = this.createView(n);
            row.append(view);
        }
        if (this.lineSpacing > 1.0f && (n3 = (int)((float)(n2 = (int)row.getPreferredSpan(1)) * this.lineSpacing) - n2) > 0) {
            row.setInsets(row.getTopInset(), row.getLeftInset(), (short)n3, row.getRightInset());
        }
    }

    protected void loadChildren(ViewFactory viewFactory) {
        this.layoutPool = new Vector();
        Element element = this.getElement();
        int n = element.getElementCount();
        int n2 = 0;
        while (n2 < n) {
            View view = viewFactory.create(element.getElement(n2));
            view.setParent(this);
            this.layoutPool.addElement(view);
            ++n2;
        }
    }

    public float nextTabStop(float f, int n) {
        int n2;
        if (this.justification != 0) {
            return f + 10.0f;
        }
        f -= (float)this.tabBase;
        TabSet tabSet = this.getTabSet();
        if (tabSet == null) {
            return this.tabBase + ((int)f / 72 + 1) * 72;
        }
        TabStop tabStop = tabSet.getTabAfter(f + 0.01f);
        if (tabStop == null) {
            return (float)this.tabBase + f + 5.0f;
        }
        int n3 = tabStop.getAlignment();
        switch (n3) {
            default: {
                return (float)this.tabBase + tabStop.getPosition();
            }
            case 5: {
                return (float)this.tabBase + tabStop.getPosition();
            }
            case 1: 
            case 2: {
                n2 = this.findOffsetToCharactersInString(tabChars, n + 1);
                break;
            }
            case 4: {
                n2 = this.findOffsetToCharactersInString(tabDecimalChars, n + 1);
            }
        }
        if (n2 == -1) {
            n2 = this.getEndOffset();
        }
        float f2 = this.getPartialSize(n + 1, n2);
        switch (n3) {
            case 1: 
            case 4: {
                return (float)this.tabBase + Math.max(f, tabStop.getPosition() - f2);
            }
            case 2: {
                return (float)this.tabBase + Math.max(f, tabStop.getPosition() - f2 / 2.0f);
            }
        }
        return f;
    }

    public void paint(Graphics graphics, Shape shape) {
        Rectangle rectangle = shape.getBounds();
        this.tabBase = rectangle.x;
        super.paint(graphics, shape);
    }

    void rebuildRows(int n) {
        this.layoutSpan = n;
        int n2 = this.getStartOffset();
        int n3 = this.getEndOffset();
        this.removeAll();
        int n4 = this.layoutPool.size();
        int n5 = 0;
        while (n5 < n4) {
            View view = (View)this.layoutPool.elementAt(n5);
            view.setParent(this);
            ++n5;
        }
        boolean bl = true;
        while (n2 < n3) {
            int n6 = n2;
            Row row = new Row(this.getElement());
            if (bl) {
                row.setInsets((short)0, (short)Math.min(n - 5, this.firstLineIndent), (short)0, (short)0);
                bl = false;
            }
            this.append(row);
            this.layoutRow(row, n2);
            n2 = row.getEndOffset();
            if (n2 > n6) continue;
            throw new StateInvariantError("infinite loop in formatting");
        }
    }

    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        Element element = this.getElement();
        DocumentEvent.ElementChange elementChange = documentEvent.getChange(element);
        if (elementChange != null) {
            this.updateLogicalChildren(elementChange, viewFactory);
        }
        if (elementChange == null || elementChange.getChildrenAdded().length == 0) {
            int n = documentEvent.getOffset();
            int n2 = element.getElementIndex(n);
            View view = (View)this.layoutPool.elementAt(n2);
            view.removeUpdate(documentEvent, null, viewFactory);
        }
        this.layoutSpan = Integer.MAX_VALUE;
        this.preferenceChanged(null, true, true);
        if (shape != null) {
            Rectangle rectangle = this.getInsideAllocation(shape);
            this.layout(rectangle.width, rectangle.height);
            Container container = this.getContainer();
            container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    protected void setFirstLineIndent(float f) {
        this.firstLineIndent = (int)f;
    }

    protected void setJustification(int n) {
        this.justification = n;
    }

    protected void setLineSpacing(float f) {
        this.lineSpacing = f;
    }

    protected void setPropertiesFromAttributes() {
        AttributeSet attributeSet = this.getAttributes();
        if (attributeSet != null) {
            this.setParagraphInsets(attributeSet);
            this.setJustification(StyleConstants.getAlignment(attributeSet));
            this.lineSpacing = StyleConstants.getLineSpacing(attributeSet);
            this.firstLineIndent = (int)StyleConstants.getFirstLineIndent(attributeSet);
        }
    }

    void updateLogicalChildren(DocumentEvent.ElementChange elementChange, ViewFactory viewFactory) {
        Object object;
        int n = elementChange.getIndex();
        Element[] elementArray = elementChange.getChildrenRemoved();
        int n2 = 0;
        while (n2 < elementArray.length) {
            object = (View)this.layoutPool.elementAt(n);
            ((View)object).setParent(null);
            this.layoutPool.removeElementAt(n);
            ++n2;
        }
        object = elementChange.getChildrenAdded();
        int n3 = 0;
        while (n3 < ((Element[])object).length) {
            View view = viewFactory.create((Element)object[n3]);
            view.setParent(this);
            this.layoutPool.insertElementAt(view, n + n3);
            ++n3;
        }
    }

    class Row
    extends BoxView {
        Row(Element element) {
            super(element, 0);
        }

        protected SizeRequirements calculateMinorAxisRequirements(int n, SizeRequirements sizeRequirements) {
            return this.baselineRequirements(n, sizeRequirements);
        }

        public float getAlignment(int n) {
            if (n == 0) {
                switch (ParagraphView.this.justification) {
                    case 0: {
                        return 0.0f;
                    }
                    case 2: {
                        return 1.0f;
                    }
                    case 1: 
                    case 3: {
                        return 0.5f;
                    }
                }
            }
            return super.getAlignment(n);
        }

        public AttributeSet getAttributes() {
            return ParagraphView.this.getAttributes();
        }

        public int getEndOffset() {
            int n = 0;
            int n2 = this.getViewCount();
            int n3 = 0;
            while (n3 < n2) {
                View view = this.getView(n3);
                n = Math.max(n, view.getEndOffset());
                ++n3;
            }
            return n;
        }

        public int getStartOffset() {
            int n = Integer.MAX_VALUE;
            int n2 = this.getViewCount();
            int n3 = 0;
            while (n3 < n2) {
                View view = this.getView(n3);
                n = Math.min(n, view.getStartOffset());
                ++n3;
            }
            return n;
        }

        protected View getViewAtPosition(int n, Rectangle rectangle) {
            View view;
            int n2 = this.getViewCount();
            int n3 = 0;
            while (n3 < n2) {
                view = this.getView(n3);
                int n4 = view.getStartOffset();
                int n5 = view.getEndOffset();
                if (n >= n4 && n < n5) {
                    if (rectangle != null) {
                        this.childAllocation(n3, rectangle);
                    }
                    return view;
                }
                ++n3;
            }
            if (n == this.getEndOffset()) {
                view = this.getView(n2 - 1);
                if (rectangle != null) {
                    this.childAllocation(n2 - 1, rectangle);
                }
                return view;
            }
            return null;
        }

        protected int getViewIndexAtPosition(int n) {
            if (n < this.getStartOffset() || n >= this.getEndOffset()) {
                return -1;
            }
            int n2 = this.getViewCount() - 1;
            while (n2 >= 0) {
                View view = this.getView(n2);
                if (n >= view.getStartOffset() && n < view.getEndOffset()) {
                    return n2;
                }
                --n2;
            }
            return -1;
        }

        protected void layout(int n, int n2) {
            int n3;
            Document document = this.getDocument();
            if (document.getProperty("i18n").equals(Boolean.TRUE) && (n3 = this.getViewCount()) > 1) {
                AbstractDocument abstractDocument = (AbstractDocument)this.getDocument();
                Element element = ((AbstractDocument)this.getElement().getDocument()).getBidiRootElement();
                byte[] byArray = new byte[n3];
                Object[] objectArray = new View[n3];
                int n4 = 0;
                while (n4 < n3) {
                    View view = this.getView(n4);
                    int n5 = element.getElementIndex(view.getStartOffset());
                    Element element2 = element.getElement(n5);
                    byArray[n4] = (byte)StyleConstants.getBidiLevel(element2.getAttributes());
                    objectArray[n4] = view;
                    ++n4;
                }
                Bidi.reorderVisually(byArray, objectArray);
                this.replace(0, n3, (View[])objectArray);
            }
            super.layout(n, n2);
        }

        protected void layoutMinorAxis(int n, int n2, int[] nArray, int[] nArray2) {
            this.baselineLayout(n, n2, nArray, nArray2);
        }

        protected void loadChildren(ViewFactory viewFactory) {
        }

        public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
            Rectangle rectangle = shape.getBounds();
            View view = this.getViewAtPosition(n, rectangle);
            if (view != null && !view.getElement().isLeaf()) {
                return super.modelToView(n, shape, bias);
            }
            rectangle = shape.getBounds();
            int n2 = rectangle.height;
            int n3 = rectangle.y;
            Shape shape2 = super.modelToView(n, shape, bias);
            rectangle = shape2.getBounds();
            rectangle.height = n2;
            rectangle.y = n3;
            return rectangle;
        }
    }
}

