/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.BoundedRangeModel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.PlainView;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.Utilities;
import javax.swing.text.ViewFactory;

public class FieldView
extends PlainView {
    public FieldView(Element element) {
        super(element);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Shape adjustAllocation(Shape shape) {
        Container container;
        if (shape == null) return null;
        Rectangle rectangle = shape.getBounds();
        int n = (int)this.getPreferredSpan(1);
        int n2 = (int)this.getPreferredSpan(0);
        if (rectangle.height != n) {
            int n3 = rectangle.height - n;
            rectangle.y += n3 / 2;
            rectangle.height -= n3;
        }
        if (!((container = this.getContainer()) instanceof JTextField)) return rectangle;
        JTextField jTextField = (JTextField)container;
        BoundedRangeModel boundedRangeModel = jTextField.getHorizontalVisibility();
        boundedRangeModel.setMaximum(Math.max(n2, rectangle.width));
        boundedRangeModel.setExtent(rectangle.width - 1);
        if (n2 < rectangle.width) {
            int n4 = rectangle.width - 1 - n2;
            switch (((JTextField)container).getHorizontalAlignment()) {
                case 0: {
                    rectangle.x += n4 / 2;
                    rectangle.width -= n4;
                    return rectangle;
                }
                case 4: {
                    rectangle.x += n4;
                    rectangle.width -= n4;
                    return rectangle;
                }
                default: {
                    return rectangle;
                }
            }
        }
        rectangle.width = n2;
        rectangle.x -= boundedRangeModel.getValue();
        return rectangle;
    }

    Shape adjustPaintRegion(Shape shape) {
        return this.adjustAllocation(shape);
    }

    protected FontMetrics getFontMetrics() {
        Container container = this.getContainer();
        return container.getFontMetrics(container.getFont());
    }

    public float getPreferredSpan(int n) {
        switch (n) {
            case 0: {
                int n2;
                Segment segment = this.getLineBuffer();
                Document document = this.getDocument();
                try {
                    document.getText(0, document.getLength(), segment);
                    n2 = Utilities.getTabbedTextWidth(segment, this.getFontMetrics(), 0, this, 0);
                }
                catch (BadLocationException badLocationException) {
                    n2 = 0;
                }
                return n2;
            }
        }
        return super.getPreferredSpan(n);
    }

    public int getResizeWeight(int n) {
        if (n == 0) {
            return 1;
        }
        return 0;
    }

    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        super.insertUpdate(documentEvent, this.adjustAllocation(shape), viewFactory);
        this.updateVisibilityModel();
    }

    public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
        return super.modelToView(n, this.adjustAllocation(shape), bias);
    }

    public void paint(Graphics graphics, Shape shape) {
        Rectangle rectangle = (Rectangle)shape;
        graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        super.paint(graphics, shape);
    }

    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        super.removeUpdate(documentEvent, this.adjustAllocation(shape), viewFactory);
        this.updateVisibilityModel();
    }

    void updateVisibilityModel() {
        Container container = this.getContainer();
        if (container instanceof JTextField) {
            JTextField jTextField = (JTextField)container;
            BoundedRangeModel boundedRangeModel = jTextField.getHorizontalVisibility();
            int n = (int)this.getPreferredSpan(0);
            int n2 = boundedRangeModel.getExtent();
            int n3 = Math.max(n, n2);
            n2 = n2 == 0 ? n3 : n2;
            int n4 = n3 - n2;
            boundedRangeModel.setRangeProperties(n4, n2, 0, n3, false);
        }
    }

    public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
        return super.viewToModel(f, f2, this.adjustAllocation(shape), biasArray);
    }
}

