/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Color;
import java.awt.Font;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.GapContent;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Segment;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StateInvariantError;
import javax.swing.text.Style;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import javax.swing.text.Utilities;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public class DefaultStyledDocument
extends AbstractDocument
implements StyledDocument {
    public static final int BUFFER_SIZE_DEFAULT = 4096;
    protected ElementBuffer buffer;
    private transient Vector listeningStyles = new Vector();
    private transient ChangeListener styleChangeListener;
    private transient ChangeListener styleContextChangeListener;
    static /* synthetic */ Class class$javax$swing$event$DocumentListener;

    public DefaultStyledDocument() {
        this((AbstractDocument.Content)new GapContent(4096), new StyleContext());
    }

    public DefaultStyledDocument(AbstractDocument.Content content, StyleContext styleContext) {
        super(content, styleContext);
        this.buffer = new ElementBuffer(this.createDefaultRoot());
        Style style = styleContext.getStyle("default");
        this.setLogicalStyle(0, style);
    }

    public DefaultStyledDocument(StyleContext styleContext) {
        this((AbstractDocument.Content)new GapContent(4096), styleContext);
    }

    public void addDocumentListener(DocumentListener documentListener) {
        Vector vector = this.listeningStyles;
        synchronized (vector) {
            int n = this.listenerList.getListenerCount(class$javax$swing$event$DocumentListener != null ? class$javax$swing$event$DocumentListener : (class$javax$swing$event$DocumentListener = DefaultStyledDocument.class$("javax.swing.event.DocumentListener")));
            super.addDocumentListener(documentListener);
            if (n == 0) {
                if (this.styleContextChangeListener == null) {
                    this.styleContextChangeListener = this.createStyleContextChangeListener();
                }
                if (this.styleContextChangeListener != null) {
                    StyleContext styleContext = (StyleContext)this.getAttributeContext();
                    styleContext.addChangeListener(this.styleContextChangeListener);
                }
                this.updateStylesListeningTo();
            }
        }
    }

    public Style addStyle(String string, Style style) {
        StyleContext styleContext = (StyleContext)this.getAttributeContext();
        return styleContext.addStyle(string, style);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void create(ElementSpec[] elementSpecArray) {
        try {
            try {
                Object object;
                if (this.getLength() != 0) {
                    this.remove(0, this.getLength());
                }
                this.writeLock();
                AbstractDocument.Content content = this.getContent();
                int n = elementSpecArray.length;
                StringBuffer stringBuffer = new StringBuffer();
                int n2 = 0;
                while (n2 < n) {
                    object = elementSpecArray[n2];
                    if (((ElementSpec)object).getLength() > 0) {
                        stringBuffer.append(((ElementSpec)object).getArray(), ((ElementSpec)object).getOffset(), ((ElementSpec)object).getLength());
                    }
                    ++n2;
                }
                object = content.insertString(0, stringBuffer.toString());
                int n3 = stringBuffer.length();
                DefaultStyledDocument defaultStyledDocument = this;
                defaultStyledDocument.getClass();
                AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = defaultStyledDocument.new AbstractDocument.DefaultDocumentEvent(0, n3, DocumentEvent.EventType.INSERT);
                defaultDocumentEvent.addEdit((UndoableEdit)object);
                this.buffer.create(n3, elementSpecArray, defaultDocumentEvent);
                super.insertUpdate(defaultDocumentEvent, null);
                defaultDocumentEvent.end();
                this.fireInsertUpdate(defaultDocumentEvent);
                this.fireUndoableEditUpdate(new UndoableEditEvent(this, defaultDocumentEvent));
            }
            catch (BadLocationException badLocationException) {
                throw new StateInvariantError("problem initializing");
            }
            Object var3_9 = null;
            this.writeUnlock();
        }
        catch (Throwable throwable) {
            Object var3_10 = null;
            this.writeUnlock();
            throw throwable;
        }
    }

    protected AbstractDocument.AbstractElement createDefaultRoot() {
        this.writeLock();
        SectionElement sectionElement = new SectionElement();
        DefaultStyledDocument defaultStyledDocument = this;
        defaultStyledDocument.getClass();
        AbstractDocument.BranchElement branchElement = defaultStyledDocument.new AbstractDocument.BranchElement(sectionElement, null);
        DefaultStyledDocument defaultStyledDocument2 = this;
        defaultStyledDocument2.getClass();
        AbstractDocument.LeafElement leafElement = defaultStyledDocument2.new AbstractDocument.LeafElement(branchElement, null, 0, 1);
        Element[] elementArray = new Element[]{leafElement};
        branchElement.replace(0, 0, elementArray);
        elementArray[0] = branchElement;
        sectionElement.replace(0, 0, elementArray);
        this.writeUnlock();
        return sectionElement;
    }

    short createSpecsForInsertAfterNewline(Element element, Element element2, AttributeSet attributeSet, Vector vector, int n, int n2) {
        if (element.getParentElement() == element2.getParentElement()) {
            ElementSpec elementSpec = new ElementSpec(attributeSet, 2);
            vector.addElement(elementSpec);
            elementSpec = new ElementSpec(attributeSet, 1);
            vector.addElement(elementSpec);
            if (element2.getEndOffset() != n2) {
                return 7;
            }
            Element element3 = element2.getParentElement();
            if (element3.getElementIndex(n) + 1 < element3.getElementCount()) {
                return 5;
            }
        } else {
            Vector vector2 = new Vector();
            Vector vector3 = new Vector();
            Element element4 = element2;
            while (element4 != null) {
                vector2.addElement(element4);
                element4 = element4.getParentElement();
            }
            element4 = element;
            int n3 = -1;
            while (element4 != null && (n3 = vector2.indexOf(element4)) == -1) {
                vector3.addElement(element4);
                element4 = element4.getParentElement();
            }
            if (element4 != null) {
                int n4 = 0;
                while (n4 < n3) {
                    vector.addElement(new ElementSpec(null, 2));
                    ++n4;
                }
                ElementSpec elementSpec = null;
                int n5 = vector3.size() - 1;
                while (n5 >= 0) {
                    elementSpec = new ElementSpec(((Element)vector3.elementAt(n5)).getAttributes(), 1);
                    if (n5 > 0) {
                        elementSpec.setDirection((short)5);
                    }
                    vector.addElement(elementSpec);
                    --n5;
                }
                if (vector3.size() > 0) {
                    return 5;
                }
                return 7;
            }
        }
        return 6;
    }

    ChangeListener createStyleChangeListener() {
        return new StyleChangeHandler();
    }

    ChangeListener createStyleContextChangeListener() {
        return new StyleContextChangeHandler();
    }

    public Color getBackground(AttributeSet attributeSet) {
        StyleContext styleContext = (StyleContext)this.getAttributeContext();
        return styleContext.getBackground(attributeSet);
    }

    public Element getCharacterElement(int n) {
        Element element = null;
        element = this.getDefaultRootElement();
        while (!element.isLeaf()) {
            int n2 = element.getElementIndex(n);
            element = element.getElement(n2);
        }
        return element;
    }

    public Element getDefaultRootElement() {
        return this.buffer.getRootElement();
    }

    public Font getFont(AttributeSet attributeSet) {
        StyleContext styleContext = (StyleContext)this.getAttributeContext();
        return styleContext.getFont(attributeSet);
    }

    public Color getForeground(AttributeSet attributeSet) {
        StyleContext styleContext = (StyleContext)this.getAttributeContext();
        return styleContext.getForeground(attributeSet);
    }

    public Style getLogicalStyle(int n) {
        Style style = null;
        Element element = this.getParagraphElement(n);
        if (element != null) {
            AttributeSet attributeSet = element.getAttributes();
            style = (Style)attributeSet.getResolveParent();
        }
        return style;
    }

    public Element getParagraphElement(int n) {
        Element element = null;
        element = this.getDefaultRootElement();
        while (!element.isLeaf()) {
            int n2 = element.getElementIndex(n);
            element = element.getElement(n2);
        }
        if (element != null) {
            return element.getParentElement();
        }
        return element;
    }

    public Style getStyle(String string) {
        StyleContext styleContext = (StyleContext)this.getAttributeContext();
        return styleContext.getStyle(string);
    }

    public Enumeration getStyleNames() {
        return ((StyleContext)this.getAttributeContext()).getStyleNames();
    }

    protected void insert(int n, ElementSpec[] elementSpecArray) throws BadLocationException {
        if (elementSpecArray == null || elementSpecArray.length == 0) {
            return;
        }
        try {
            Object object;
            this.writeLock();
            AbstractDocument.Content content = this.getContent();
            int n2 = elementSpecArray.length;
            StringBuffer stringBuffer = new StringBuffer();
            int n3 = 0;
            while (n3 < n2) {
                object = elementSpecArray[n3];
                if (((ElementSpec)object).getLength() > 0) {
                    stringBuffer.append(((ElementSpec)object).getArray(), ((ElementSpec)object).getOffset(), ((ElementSpec)object).getLength());
                }
                ++n3;
            }
            object = content.insertString(n, stringBuffer.toString());
            int n4 = stringBuffer.length();
            DefaultStyledDocument defaultStyledDocument = this;
            defaultStyledDocument.getClass();
            AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = defaultStyledDocument.new AbstractDocument.DefaultDocumentEvent(n, n4, DocumentEvent.EventType.INSERT);
            defaultDocumentEvent.addEdit((UndoableEdit)object);
            this.buffer.insert(n, n4, elementSpecArray, defaultDocumentEvent);
            super.insertUpdate(defaultDocumentEvent, null);
            defaultDocumentEvent.end();
            this.fireInsertUpdate(defaultDocumentEvent);
            this.fireUndoableEditUpdate(new UndoableEditEvent(this, defaultDocumentEvent));
        }
        finally {
            Object var4_10 = null;
            this.writeUnlock();
        }
    }

    protected void insertUpdate(AbstractDocument.DefaultDocumentEvent defaultDocumentEvent, AttributeSet attributeSet) {
        int n = defaultDocumentEvent.getOffset();
        int n2 = defaultDocumentEvent.getLength();
        if (attributeSet == null) {
            attributeSet = SimpleAttributeSet.EMPTY;
        }
        Element element = this.getParagraphElement(n + n2);
        AttributeSet attributeSet2 = element.getAttributes();
        Element element2 = this.getParagraphElement(n);
        Element element3 = element2.getElement(element2.getElementIndex(n));
        int n3 = n + n2;
        boolean bl = element3.getEndOffset() == n3;
        AttributeSet attributeSet3 = element3.getAttributes();
        try {
            Object object;
            Segment segment = new Segment();
            Vector vector = new Vector();
            ElementSpec elementSpec = null;
            boolean bl2 = false;
            short s = 6;
            if (n > 0) {
                this.getText(n - 1, 1, segment);
                if (segment.array[segment.offset] == '\n') {
                    bl2 = true;
                    s = this.createSpecsForInsertAfterNewline(element, element2, attributeSet2, vector, n, n3);
                    int n4 = vector.size() - 1;
                    while (n4 >= 0) {
                        ElementSpec elementSpec2 = (ElementSpec)vector.elementAt(n4);
                        if (elementSpec2.getType() == 1) {
                            elementSpec = elementSpec2;
                            break;
                        }
                        --n4;
                    }
                }
            }
            if (!bl2) {
                attributeSet2 = element2.getAttributes();
            }
            this.getText(n, n2, segment);
            char[] cArray = segment.array;
            int n5 = segment.offset + segment.count;
            int n6 = segment.offset;
            int n7 = segment.offset;
            while (n7 < n5) {
                if (cArray[n7] == '\n') {
                    int n8 = n7 + 1;
                    vector.addElement(new ElementSpec(attributeSet, 3, n8 - n6));
                    vector.addElement(new ElementSpec(null, 2));
                    elementSpec = new ElementSpec(attributeSet2, 1);
                    vector.addElement(elementSpec);
                    n6 = n8;
                }
                ++n7;
            }
            if (n6 < n5) {
                vector.addElement(new ElementSpec(attributeSet, 3, n5 - n6));
            }
            ElementSpec elementSpec3 = (ElementSpec)vector.firstElement();
            int n9 = this.getLength();
            if (elementSpec3.getType() == 3 && element3.getEndOffset() <= n9 && attributeSet3.isEqual(attributeSet)) {
                elementSpec3.setDirection((short)4);
            }
            if (elementSpec != null) {
                if (bl2) {
                    elementSpec.setDirection(s);
                } else if (element2.getEndOffset() != n3) {
                    elementSpec.setDirection((short)7);
                } else {
                    object = element2.getParentElement();
                    int n10 = object.getElementIndex(n);
                    if (n10 + 1 < object.getElementCount() && !object.getElement(n10 + 1).isLeaf()) {
                        elementSpec.setDirection((short)5);
                    }
                }
            }
            if (bl && n3 < n9) {
                Element element4;
                object = (ElementSpec)vector.lastElement();
                if (((ElementSpec)object).getType() == 3 && ((ElementSpec)object).getDirection() != 4 && (elementSpec == null && (element == element2 || bl2) || elementSpec != null && elementSpec.getDirection() != 6) && (element4 = element.getElement(element.getElementIndex(n3))).isLeaf() && attributeSet.equals(element4.getAttributes())) {
                    ((ElementSpec)object).setDirection((short)5);
                }
            } else if (!bl && elementSpec != null && elementSpec.getDirection() == 7 && ((ElementSpec)(object = (ElementSpec)vector.lastElement())).getType() == 3 && ((ElementSpec)object).getDirection() != 4 && attributeSet.isEqual(attributeSet3)) {
                ((ElementSpec)object).setDirection((short)5);
            }
            if (Utilities.isComposedTextAttributeDefined(attributeSet)) {
                ((MutableAttributeSet)attributeSet).addAttributes(attributeSet3);
                ((MutableAttributeSet)attributeSet).addAttribute("$ename", "content");
            }
            object = new ElementSpec[vector.size()];
            vector.copyInto((Object[])object);
            this.buffer.insert(n, n2, (ElementSpec[])object, defaultDocumentEvent);
        }
        catch (BadLocationException badLocationException) {}
        super.insertUpdate(defaultDocumentEvent, attributeSet);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        this.listeningStyles = new Vector();
        objectInputStream.defaultReadObject();
        if (this.styleContextChangeListener == null && this.listenerList.getListenerCount(class$javax$swing$event$DocumentListener != null ? class$javax$swing$event$DocumentListener : (class$javax$swing$event$DocumentListener = DefaultStyledDocument.class$("javax.swing.event.DocumentListener"))) > 0) {
            this.styleContextChangeListener = this.createStyleContextChangeListener();
            if (this.styleContextChangeListener != null) {
                StyleContext styleContext = (StyleContext)this.getAttributeContext();
                styleContext.addChangeListener(this.styleContextChangeListener);
            }
            this.updateStylesListeningTo();
        }
    }

    public void removeDocumentListener(DocumentListener documentListener) {
        Vector vector = this.listeningStyles;
        synchronized (vector) {
            super.removeDocumentListener(documentListener);
            if (this.listenerList.getListenerCount(class$javax$swing$event$DocumentListener != null ? class$javax$swing$event$DocumentListener : (class$javax$swing$event$DocumentListener = DefaultStyledDocument.class$("javax.swing.event.DocumentListener"))) == 0) {
                int n = this.listeningStyles.size() - 1;
                while (n >= 0) {
                    ((Style)this.listeningStyles.elementAt(n)).removeChangeListener(this.styleChangeListener);
                    --n;
                }
                this.listeningStyles.removeAllElements();
                if (this.styleContextChangeListener != null) {
                    StyleContext styleContext = (StyleContext)this.getAttributeContext();
                    styleContext.removeChangeListener(this.styleContextChangeListener);
                }
            }
        }
    }

    public void removeStyle(String string) {
        StyleContext styleContext = (StyleContext)this.getAttributeContext();
        styleContext.removeStyle(string);
    }

    protected void removeUpdate(AbstractDocument.DefaultDocumentEvent defaultDocumentEvent) {
        super.removeUpdate(defaultDocumentEvent);
        this.buffer.remove(defaultDocumentEvent.getOffset(), defaultDocumentEvent.getLength(), defaultDocumentEvent);
    }

    public void setCharacterAttributes(int n, int n2, AttributeSet attributeSet, boolean bl) {
        try {
            this.writeLock();
            DefaultStyledDocument defaultStyledDocument = this;
            defaultStyledDocument.getClass();
            AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = defaultStyledDocument.new AbstractDocument.DefaultDocumentEvent(n, n2, DocumentEvent.EventType.CHANGE);
            this.buffer.change(n, n2, defaultDocumentEvent);
            AttributeSet attributeSet2 = attributeSet.copyAttributes();
            int n3 = Integer.MAX_VALUE;
            int n4 = n;
            while (n4 < n + n2) {
                Element element = this.getCharacterElement(n4);
                n3 = element.getEndOffset();
                MutableAttributeSet mutableAttributeSet = (MutableAttributeSet)element.getAttributes();
                defaultDocumentEvent.addEdit(new AttributeUndoableEdit(element, attributeSet2, bl));
                if (bl) {
                    mutableAttributeSet.removeAttributes(mutableAttributeSet);
                }
                mutableAttributeSet.addAttributes(attributeSet);
                n4 = n3;
            }
            defaultDocumentEvent.end();
            this.fireChangedUpdate(defaultDocumentEvent);
            this.fireUndoableEditUpdate(new UndoableEditEvent(this, defaultDocumentEvent));
        }
        finally {
            Object var6_11 = null;
            this.writeUnlock();
        }
    }

    public void setLogicalStyle(int n, Style style) {
        Element element = this.getParagraphElement(n);
        if (element != null && element instanceof AbstractDocument.AbstractElement) {
            try {
                this.writeLock();
                StyleChangeUndoableEdit styleChangeUndoableEdit = new StyleChangeUndoableEdit((AbstractDocument.AbstractElement)element, style);
                ((AbstractDocument.AbstractElement)element).setResolveParent(style);
                int n2 = element.getStartOffset();
                int n3 = element.getEndOffset();
                DefaultStyledDocument defaultStyledDocument = this;
                defaultStyledDocument.getClass();
                AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = defaultStyledDocument.new AbstractDocument.DefaultDocumentEvent(n2, n3 - n2, DocumentEvent.EventType.CHANGE);
                defaultDocumentEvent.addEdit(styleChangeUndoableEdit);
                defaultDocumentEvent.end();
                this.fireChangedUpdate(defaultDocumentEvent);
                this.fireUndoableEditUpdate(new UndoableEditEvent(this, defaultDocumentEvent));
            }
            finally {
                Object var5_8 = null;
                this.writeUnlock();
            }
        }
    }

    public void setParagraphAttributes(int n, int n2, AttributeSet attributeSet, boolean bl) {
        try {
            this.writeLock();
            DefaultStyledDocument defaultStyledDocument = this;
            defaultStyledDocument.getClass();
            AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = defaultStyledDocument.new AbstractDocument.DefaultDocumentEvent(n, n2, DocumentEvent.EventType.CHANGE);
            AttributeSet attributeSet2 = attributeSet.copyAttributes();
            Element element = this.getDefaultRootElement();
            int n3 = element.getElementIndex(n);
            int n4 = element.getElementIndex(n + (n2 > 0 ? n2 - 1 : 0));
            int n5 = n3;
            while (n5 <= n4) {
                Element element2 = element.getElement(n5);
                MutableAttributeSet mutableAttributeSet = (MutableAttributeSet)element2.getAttributes();
                defaultDocumentEvent.addEdit(new AttributeUndoableEdit(element2, attributeSet2, bl));
                if (bl) {
                    mutableAttributeSet.removeAttributes(mutableAttributeSet);
                }
                mutableAttributeSet.addAttributes(attributeSet);
                ++n5;
            }
            defaultDocumentEvent.end();
            this.fireChangedUpdate(defaultDocumentEvent);
            this.fireUndoableEditUpdate(new UndoableEditEvent(this, defaultDocumentEvent));
        }
        finally {
            Object var6_13 = null;
            this.writeUnlock();
        }
    }

    protected void styleChanged(Style style) {
        DefaultStyledDocument defaultStyledDocument = this;
        defaultStyledDocument.getClass();
        AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = defaultStyledDocument.new AbstractDocument.DefaultDocumentEvent(0, this.getLength(), DocumentEvent.EventType.CHANGE);
        defaultDocumentEvent.end();
        this.fireChangedUpdate(defaultDocumentEvent);
    }

    void updateStylesListeningTo() {
        Vector vector = this.listeningStyles;
        synchronized (vector) {
            StyleContext styleContext = (StyleContext)this.getAttributeContext();
            if (this.styleChangeListener == null) {
                this.styleChangeListener = this.createStyleChangeListener();
            }
            if (this.styleChangeListener != null && styleContext != null) {
                Style style;
                Enumeration enumeration = styleContext.getStyleNames();
                Vector vector2 = (Vector)this.listeningStyles.clone();
                this.listeningStyles.removeAllElements();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    style = styleContext.getStyle(string);
                    int n = vector2.indexOf(style);
                    this.listeningStyles.addElement(style);
                    if (n == -1) {
                        style.addChangeListener(this.styleChangeListener);
                        continue;
                    }
                    vector2.removeElementAt(n);
                }
                int n = vector2.size() - 1;
                while (n >= 0) {
                    style = (Style)vector2.elementAt(n);
                    style.removeChangeListener(this.styleChangeListener);
                    --n;
                }
                if (this.listeningStyles.size() == 0) {
                    this.styleChangeListener = null;
                }
            }
        }
    }

    protected class SectionElement
    extends AbstractDocument.BranchElement {
        public SectionElement() {
            super(null, null);
        }

        public String getName() {
            return "section";
        }
    }

    public static class ElementSpec {
        public static final short StartTagType = 1;
        public static final short EndTagType = 2;
        public static final short ContentType = 3;
        public static final short JoinPreviousDirection = 4;
        public static final short JoinNextDirection = 5;
        public static final short OriginateDirection = 6;
        public static final short JoinFractureDirection = 7;
        private AttributeSet attr;
        private int len;
        private short type;
        private short direction;
        private int offs;
        private char[] data;

        public ElementSpec(AttributeSet attributeSet, short s) {
            this(attributeSet, s, null, 0, 0);
        }

        public ElementSpec(AttributeSet attributeSet, short s, int n) {
            this(attributeSet, s, null, 0, n);
        }

        public ElementSpec(AttributeSet attributeSet, short s, char[] cArray, int n, int n2) {
            this.attr = attributeSet;
            this.type = s;
            this.data = cArray;
            this.offs = n;
            this.len = n2;
            this.direction = (short)6;
        }

        public char[] getArray() {
            return this.data;
        }

        public AttributeSet getAttributes() {
            return this.attr;
        }

        public short getDirection() {
            return this.direction;
        }

        public int getLength() {
            return this.len;
        }

        public int getOffset() {
            return this.offs;
        }

        public short getType() {
            return this.type;
        }

        public void setDirection(short s) {
            this.direction = s;
        }

        public void setType(short s) {
            this.type = s;
        }

        public String toString() {
            String string = "??";
            String string2 = "??";
            switch (this.type) {
                case 1: {
                    string = "StartTag";
                    break;
                }
                case 3: {
                    string = "Content";
                    break;
                }
                case 2: {
                    string = "EndTag";
                    break;
                }
            }
            switch (this.direction) {
                case 4: {
                    string2 = "JoinPrevious";
                    break;
                }
                case 5: {
                    string2 = "JoinNext";
                    break;
                }
                case 6: {
                    string2 = "Originate";
                    break;
                }
                case 7: {
                    string2 = "Fracture";
                    break;
                }
            }
            return String.valueOf(string) + ":" + string2 + ":" + this.getLength();
        }
    }

    public class ElementBuffer
    implements Serializable {
        Element root;
        transient int pos;
        transient int offset;
        transient int length;
        transient int endOffset;
        transient Vector endJoin;
        transient Vector changes;
        transient Stack path;
        transient boolean insertOp;
        transient boolean recreateLeafs;
        transient ElemChanges[] insertPath;
        transient boolean createdFracture;
        transient Element fracturedParent;
        transient Element fracturedChild;
        transient boolean offsetLastIndex;
        transient boolean offsetLastIndexOnReplace;

        public ElementBuffer(Element element) {
            this.root = element;
            this.changes = new Vector();
            this.path = new Stack();
            this.endJoin = new Vector();
        }

        void advance(int n) {
            this.pos += n;
        }

        void beginEdits(int n, int n2) {
            this.offset = n;
            this.length = n2;
            this.endOffset = n + n2;
            this.pos = n;
            if (this.changes == null) {
                this.changes = new Vector();
            } else {
                this.changes.removeAllElements();
            }
            if (this.path == null) {
                this.path = new Stack();
            } else {
                this.path.removeAllElements();
            }
            if (this.endJoin == null) {
                this.endJoin = new Vector();
            } else {
                this.endJoin.removeAllElements();
            }
            this.fracturedParent = null;
            this.fracturedChild = null;
            this.offsetLastIndexOnReplace = false;
            this.offsetLastIndex = false;
        }

        boolean canJoin(Element element, Element element2) {
            if (element == null || element2 == null) {
                return false;
            }
            if (element.isLeaf() != element2.isLeaf()) {
                return false;
            }
            if (element.getName().equals("paragraph") && element2.getName().equals("paragraph")) {
                return true;
            }
            return element.getAttributes().isEqual(element2.getAttributes());
        }

        public void change(int n, int n2, AbstractDocument.DefaultDocumentEvent defaultDocumentEvent) {
            this.beginEdits(n, n2);
            this.changeUpdate();
            this.endEdits(defaultDocumentEvent);
        }

        protected void changeUpdate() {
            boolean bl = this.split(this.offset, this.length);
            if (!bl) {
                while (this.path.size() != 0) {
                    this.pop();
                }
                this.split(this.offset + this.length, 0);
            }
            while (this.path.size() != 0) {
                this.pop();
            }
        }

        public Element clone(Element element, Element element2) {
            if (element2.isLeaf()) {
                return DefaultStyledDocument.this.createLeafElement(element, element2.getAttributes(), element2.getStartOffset(), element2.getEndOffset());
            }
            Element element3 = DefaultStyledDocument.this.createBranchElement(element, element2.getAttributes());
            int n = element2.getElementCount();
            Element[] elementArray = new Element[n];
            int n2 = 0;
            while (n2 < n) {
                elementArray[n2] = this.clone(element3, element2.getElement(n2));
                ++n2;
            }
            ((AbstractDocument.BranchElement)element3).replace(0, 0, elementArray);
            return element3;
        }

        void create(int n, ElementSpec[] elementSpecArray, AbstractDocument.DefaultDocumentEvent defaultDocumentEvent) {
            this.insertOp = true;
            this.beginEdits(this.offset, n);
            this.push(this.root, 0);
            ElemChanges elemChanges = (ElemChanges)this.path.peek();
            int n2 = 0;
            while (n2 < this.root.getElementCount()) {
                elemChanges.removed.addElement(this.root.getElement(n2));
                ++n2;
            }
            int n3 = elementSpecArray.length;
            int n4 = 1;
            while (n4 < n3) {
                this.insertElement(elementSpecArray[n4]);
                ++n4;
            }
            while (this.path.size() != 0) {
                this.pop();
            }
            this.endEdits(defaultDocumentEvent);
            this.insertOp = false;
        }

        void endEdits(AbstractDocument.DefaultDocumentEvent defaultDocumentEvent) {
            int n = this.changes.size();
            int n2 = 0;
            while (n2 < n) {
                ElemChanges elemChanges = (ElemChanges)this.changes.elementAt(n2);
                Object[] objectArray = new Element[elemChanges.removed.size()];
                elemChanges.removed.copyInto(objectArray);
                Object[] objectArray2 = new Element[elemChanges.added.size()];
                elemChanges.added.copyInto(objectArray2);
                int n3 = elemChanges.index;
                ((AbstractDocument.BranchElement)elemChanges.parent).replace(n3, objectArray.length, (Element[])objectArray2);
                AbstractDocument.ElementEdit elementEdit = new AbstractDocument.ElementEdit((AbstractDocument.BranchElement)elemChanges.parent, n3, (Element[])objectArray, (Element[])objectArray2);
                defaultDocumentEvent.addEdit(elementEdit);
                ++n2;
            }
        }

        void fracture(int n) {
            int n2 = this.insertPath.length;
            int n3 = -1;
            boolean bl = this.recreateLeafs;
            ElemChanges elemChanges = this.insertPath[n2 - 1];
            boolean bl2 = elemChanges.index + 1 < elemChanges.parent.getElementCount();
            int n4 = bl ? n2 : -1;
            int n5 = n2 - 1;
            this.createdFracture = true;
            int n6 = n2 - 2;
            while (n6 >= 0) {
                ElemChanges elemChanges2 = this.insertPath[n6];
                if (elemChanges2.added.size() > 0 || n6 == n) {
                    n3 = n6;
                    if (!bl && bl2) {
                        bl = true;
                        if (n4 == -1) {
                            n4 = n5 + 1;
                        }
                    }
                }
                if (!bl2 && elemChanges2.index < elemChanges2.parent.getElementCount()) {
                    bl2 = true;
                    n5 = n6;
                }
                --n6;
            }
            if (bl) {
                if (n3 == -1) {
                    n3 = n2 - 1;
                }
                this.fractureFrom(this.insertPath, n3, n4);
            }
        }

        void fractureDeepestLeaf(ElementSpec[] elementSpecArray) {
            ElemChanges elemChanges = (ElemChanges)this.path.peek();
            Element element = elemChanges.parent.getElement(elemChanges.index);
            Element element2 = DefaultStyledDocument.this.createLeafElement(elemChanges.parent, element.getAttributes(), element.getStartOffset(), this.offset);
            elemChanges.added.addElement(element2);
            elemChanges.removed.addElement(element);
            if (element.getEndOffset() != this.endOffset) {
                this.recreateLeafs = true;
            } else {
                this.offsetLastIndex = true;
            }
        }

        void fractureFrom(ElemChanges[] elemChangesArray, int n, int n2) {
            ElemChanges elemChanges = elemChangesArray[n];
            int n3 = elemChangesArray.length;
            Object object = n + 1 == n3 ? elemChanges.parent.getElement(elemChanges.index) : elemChanges.parent.getElement(elemChanges.index - 1);
            Element element = object.isLeaf() ? DefaultStyledDocument.this.createLeafElement(elemChanges.parent, object.getAttributes(), Math.max(this.endOffset, object.getStartOffset()), object.getEndOffset()) : DefaultStyledDocument.this.createBranchElement(elemChanges.parent, object.getAttributes());
            this.fracturedParent = elemChanges.parent;
            this.fracturedChild = element;
            Element element2 = element;
            while (++n < n2) {
                Element[] elementArray;
                int n4;
                boolean bl = n + 1 == n2;
                boolean bl2 = n + 1 == n3;
                elemChanges = elemChangesArray[n];
                object = bl ? (this.offsetLastIndex || !bl2 ? null : elemChanges.parent.getElement(elemChanges.index)) : elemChanges.parent.getElement(elemChanges.index - 1);
                element = object != null ? (object.isLeaf() ? DefaultStyledDocument.this.createLeafElement(element2, object.getAttributes(), Math.max(this.endOffset, object.getStartOffset()), object.getEndOffset()) : DefaultStyledDocument.this.createBranchElement(element2, object.getAttributes())) : null;
                int n5 = elemChanges.parent.getElementCount() - elemChanges.index;
                int n6 = 1;
                if (element == null) {
                    if (bl2) {
                        --n5;
                        n4 = elemChanges.index + 1;
                    } else {
                        n4 = elemChanges.index;
                    }
                    n6 = 0;
                    elementArray = new Element[n5];
                } else {
                    if (!bl) {
                        ++n5;
                        n4 = elemChanges.index;
                    } else {
                        n4 = elemChanges.index + 1;
                    }
                    elementArray = new Element[n5];
                    elementArray[0] = element;
                }
                int n7 = n6;
                while (n7 < n5) {
                    Element element3 = elemChanges.parent.getElement(n4++);
                    elementArray[n7] = this.recreateFracturedElement(element2, element3);
                    elemChanges.removed.addElement(element3);
                    ++n7;
                }
                ((AbstractDocument.BranchElement)element2).replace(0, 0, elementArray);
                element2 = element;
            }
        }

        public Element getRootElement() {
            return this.root;
        }

        public void insert(int n, int n2, ElementSpec[] elementSpecArray, AbstractDocument.DefaultDocumentEvent defaultDocumentEvent) {
            this.insertOp = true;
            this.beginEdits(n, n2);
            this.insertUpdate(elementSpecArray);
            this.endEdits(defaultDocumentEvent);
            this.insertOp = false;
        }

        void insertElement(ElementSpec elementSpec) {
            ElemChanges elemChanges = (ElemChanges)this.path.peek();
            block0 : switch (elementSpec.getType()) {
                case 1: {
                    switch (elementSpec.getDirection()) {
                        case 5: {
                            Element element = elemChanges.parent.getElement(elemChanges.index);
                            if (element.isLeaf()) {
                                if (elemChanges.index + 1 < elemChanges.parent.getElementCount()) {
                                    element = elemChanges.parent.getElement(elemChanges.index + 1);
                                } else {
                                    throw new StateInvariantError("Join next to leaf");
                                }
                            }
                            this.push(element, 0, true);
                            break block0;
                        }
                        case 7: {
                            if (!this.createdFracture) {
                                this.fracture(this.path.size() - 1);
                            }
                            if (!elemChanges.isFracture) {
                                this.push(this.fracturedChild, 0, true);
                                break block0;
                            }
                            this.push(elemChanges.parent.getElement(0), 0, true);
                            break block0;
                        }
                    }
                    Element element = DefaultStyledDocument.this.createBranchElement(elemChanges.parent, elementSpec.getAttributes());
                    elemChanges.added.addElement(element);
                    this.push(element, 0);
                    break;
                }
                case 2: {
                    this.pop();
                    break;
                }
                case 3: {
                    int n = elementSpec.getLength();
                    if (elementSpec.getDirection() != 5) {
                        Element element = DefaultStyledDocument.this.createLeafElement(elemChanges.parent, elementSpec.getAttributes(), this.pos, this.pos + n);
                        elemChanges.added.addElement(element);
                    } else if (!elemChanges.isFracture) {
                        Element element = null;
                        if (this.insertPath != null) {
                            int n2 = this.insertPath.length - 1;
                            while (n2 >= 0) {
                                if (this.insertPath[n2] == elemChanges) {
                                    if (n2 == this.insertPath.length - 1) break;
                                    element = elemChanges.parent.getElement(elemChanges.index);
                                    break;
                                }
                                --n2;
                            }
                        }
                        if (element == null) {
                            element = elemChanges.parent.getElement(elemChanges.index + 1);
                        }
                        Element element2 = DefaultStyledDocument.this.createLeafElement(elemChanges.parent, element.getAttributes(), this.pos, element.getEndOffset());
                        elemChanges.added.addElement(element2);
                        elemChanges.removed.addElement(element);
                    } else {
                        Element element = elemChanges.parent.getElement(0);
                        Element element3 = DefaultStyledDocument.this.createLeafElement(elemChanges.parent, element.getAttributes(), this.pos, element.getEndOffset());
                        elemChanges.added.addElement(element3);
                        elemChanges.removed.addElement(element);
                    }
                    this.pos += n;
                    break;
                }
            }
        }

        void insertFirstContent(ElementSpec[] elementSpecArray) {
            ElementSpec elementSpec = elementSpecArray[0];
            ElemChanges elemChanges = (ElemChanges)this.path.peek();
            Element element = elemChanges.parent.getElement(elemChanges.index);
            int n = this.offset + elementSpec.getLength();
            boolean bl = elementSpecArray.length == 1;
            switch (elementSpec.getDirection()) {
                case 4: {
                    if (element.getEndOffset() != n && !bl) {
                        Element element2 = DefaultStyledDocument.this.createLeafElement(elemChanges.parent, element.getAttributes(), element.getStartOffset(), n);
                        elemChanges.added.addElement(element2);
                        elemChanges.removed.addElement(element);
                        if (element.getEndOffset() != this.endOffset) {
                            this.recreateLeafs = true;
                            break;
                        }
                        this.offsetLastIndex = true;
                        break;
                    }
                    this.offsetLastIndex = true;
                    this.offsetLastIndexOnReplace = true;
                    break;
                }
                case 5: {
                    if (this.offset == 0) break;
                    Element element3 = DefaultStyledDocument.this.createLeafElement(elemChanges.parent, element.getAttributes(), element.getStartOffset(), this.offset);
                    elemChanges.added.addElement(element3);
                    Element element4 = elemChanges.parent.getElement(elemChanges.index + 1);
                    element3 = bl ? DefaultStyledDocument.this.createLeafElement(elemChanges.parent, element4.getAttributes(), this.offset, element4.getEndOffset()) : DefaultStyledDocument.this.createLeafElement(elemChanges.parent, element4.getAttributes(), this.offset, n);
                    elemChanges.added.addElement(element3);
                    elemChanges.removed.addElement(element);
                    elemChanges.removed.addElement(element4);
                    break;
                }
                default: {
                    Element element5;
                    if (element.getStartOffset() != this.offset) {
                        element5 = DefaultStyledDocument.this.createLeafElement(elemChanges.parent, element.getAttributes(), element.getStartOffset(), this.offset);
                        elemChanges.added.addElement(element5);
                    }
                    elemChanges.removed.addElement(element);
                    element5 = DefaultStyledDocument.this.createLeafElement(elemChanges.parent, elementSpec.getAttributes(), this.offset, n);
                    elemChanges.added.addElement(element5);
                    if (element.getEndOffset() != this.endOffset) {
                        this.recreateLeafs = true;
                        break;
                    }
                    this.offsetLastIndex = true;
                }
            }
        }

        protected void insertUpdate(ElementSpec[] elementSpecArray) {
            int n;
            Element element = this.root;
            int n2 = element.getElementIndex(this.offset);
            while (!element.isLeaf()) {
                Element element2 = element.getElement(n2);
                this.push(element, element2.isLeaf() ? n2 : n2 + 1);
                element = element2;
                n2 = element.getElementIndex(this.offset);
            }
            this.insertPath = new ElemChanges[this.path.size()];
            this.path.copyInto(this.insertPath);
            this.createdFracture = false;
            this.recreateLeafs = false;
            if (elementSpecArray[0].getType() == 3) {
                this.insertFirstContent(elementSpecArray);
                this.pos += elementSpecArray[0].getLength();
                n = 1;
            } else {
                this.fractureDeepestLeaf(elementSpecArray);
                n = 0;
            }
            int n3 = elementSpecArray.length;
            while (n < n3) {
                this.insertElement(elementSpecArray[n]);
                ++n;
            }
            if (!this.createdFracture) {
                this.fracture(-1);
            }
            while (this.path.size() != 0) {
                this.pop();
            }
            if (this.offsetLastIndex && this.offsetLastIndexOnReplace) {
                ++this.insertPath[this.insertPath.length - 1].index;
            }
            int n4 = this.insertPath.length - 1;
            while (n4 >= 0) {
                ElemChanges elemChanges = this.insertPath[n4];
                if (elemChanges.parent == this.fracturedParent) {
                    elemChanges.added.addElement(this.fracturedChild);
                }
                if (!(elemChanges.added.size() <= 0 && elemChanges.removed.size() <= 0 || this.changes.contains(elemChanges))) {
                    this.changes.addElement(elemChanges);
                }
                --n4;
            }
        }

        Element join(Element element, Element element2, Element element3, int n, int n2) {
            if (element2.isLeaf() && element3.isLeaf()) {
                return DefaultStyledDocument.this.createLeafElement(element, element2.getAttributes(), element2.getStartOffset(), element3.getEndOffset());
            }
            if (!element2.isLeaf() && !element3.isLeaf()) {
                Element element4;
                Element element5 = DefaultStyledDocument.this.createBranchElement(element, element2.getAttributes());
                int n3 = element2.getElementIndex(n);
                int n4 = element3.getElementIndex(n2);
                Element element6 = element2.getElement(n3);
                if (element6.getStartOffset() == n) {
                    element6 = null;
                }
                if ((element4 = element3.getElement(n4)).getStartOffset() == n2) {
                    element4 = null;
                }
                Vector vector = new Vector();
                int n5 = 0;
                while (n5 < n3) {
                    vector.addElement(this.clone(element5, element2.getElement(n5)));
                    ++n5;
                }
                if (this.canJoin(element6, element4)) {
                    Element element7 = this.join(element5, element6, element4, n, n2);
                    vector.addElement(element7);
                } else {
                    if (element6 != null) {
                        vector.addElement(this.clone(element5, element6));
                    }
                    if (element4 != null) {
                        vector.addElement(this.clone(element5, element4));
                    }
                }
                int n6 = element3.getElementCount();
                int n7 = element4 == null ? n4 : n4 + 1;
                while (n7 < n6) {
                    vector.addElement(this.clone(element5, element3.getElement(n7)));
                    ++n7;
                }
                Object[] objectArray = new Element[vector.size()];
                vector.copyInto(objectArray);
                ((AbstractDocument.BranchElement)element5).replace(0, 0, (Element[])objectArray);
                return element5;
            }
            throw new StateInvariantError("No support to join leaf element with non-leaf element");
        }

        void pop() {
            Element element;
            ElemChanges elemChanges = (ElemChanges)this.path.peek();
            this.path.pop();
            if (elemChanges.added.size() > 0 || elemChanges.removed.size() > 0) {
                this.changes.addElement(elemChanges);
            } else if (!this.path.isEmpty() && (element = elemChanges.parent).getElementCount() == 0) {
                elemChanges = (ElemChanges)this.path.peek();
                elemChanges.added.removeElement(element);
            }
        }

        void push(Element element, int n) {
            this.push(element, n, false);
        }

        void push(Element element, int n, boolean bl) {
            ElemChanges elemChanges = new ElemChanges(element, n, bl);
            this.path.push(elemChanges);
        }

        Element recreateFracturedElement(Element element, Element element2) {
            if (element2.isLeaf()) {
                return DefaultStyledDocument.this.createLeafElement(element, element2.getAttributes(), Math.max(element2.getStartOffset(), this.endOffset), element2.getEndOffset());
            }
            Element element3 = DefaultStyledDocument.this.createBranchElement(element, element2.getAttributes());
            int n = element2.getElementCount();
            Element[] elementArray = new Element[n];
            int n2 = 0;
            while (n2 < n) {
                elementArray[n2] = this.recreateFracturedElement(element3, element2.getElement(n2));
                ++n2;
            }
            ((AbstractDocument.BranchElement)element3).replace(0, 0, elementArray);
            return element3;
        }

        public void remove(int n, int n2, AbstractDocument.DefaultDocumentEvent defaultDocumentEvent) {
            this.beginEdits(n, n2);
            this.removeUpdate();
            this.endEdits(defaultDocumentEvent);
        }

        boolean removeElements(Element element, int n, int n2) {
            if (!element.isLeaf()) {
                int n3 = element.getElementIndex(n);
                int n4 = element.getElementIndex(n2);
                this.push(element, n3);
                ElemChanges elemChanges = (ElemChanges)this.path.peek();
                if (n3 == n4) {
                    Element element2 = element.getElement(n3);
                    if (n <= element2.getStartOffset() && n2 >= element2.getEndOffset()) {
                        elemChanges.removed.addElement(element2);
                    } else if (this.removeElements(element2, n, n2)) {
                        elemChanges.removed.addElement(element2);
                    }
                } else {
                    boolean bl;
                    Element element3 = element.getElement(n3);
                    Element element4 = element.getElement(n4);
                    boolean bl2 = bl = n2 < element.getEndOffset();
                    if (bl && this.canJoin(element3, element4)) {
                        int n5 = n3;
                        while (n5 <= n4) {
                            elemChanges.removed.addElement(element.getElement(n5));
                            ++n5;
                        }
                        Element element5 = this.join(element, element3, element4, n, n2);
                        elemChanges.added.addElement(element5);
                    } else {
                        int n6 = n3 + 1;
                        int n7 = n4 - 1;
                        if (element3.getStartOffset() == n || n3 == 0 && element3.getStartOffset() > n && element3.getEndOffset() <= n2) {
                            element3 = null;
                            n6 = n3;
                        }
                        if (!bl) {
                            element4 = null;
                            ++n7;
                        } else if (element4.getStartOffset() == n2) {
                            element4 = null;
                        }
                        if (n6 <= n7) {
                            elemChanges.index = n6;
                        }
                        int n8 = n6;
                        while (n8 <= n7) {
                            elemChanges.removed.addElement(element.getElement(n8));
                            ++n8;
                        }
                        if (element3 != null && this.removeElements(element3, n, n2)) {
                            elemChanges.removed.insertElementAt(element3, 0);
                            elemChanges.index = n3;
                        }
                        if (element4 != null && this.removeElements(element4, n, n2)) {
                            elemChanges.removed.addElement(element4);
                        }
                    }
                }
                this.pop();
                if (element.getElementCount() == elemChanges.removed.size() - elemChanges.added.size()) {
                    return true;
                }
            }
            return false;
        }

        protected void removeUpdate() {
            this.removeElements(this.root, this.offset, this.offset + this.length);
        }

        boolean split(int n, int n2) {
            boolean bl = false;
            Element element = this.root;
            int n3 = element.getElementIndex(n);
            while (!element.isLeaf()) {
                this.push(element, n3);
                element = element.getElement(n3);
                n3 = element.getElementIndex(n);
            }
            ElemChanges elemChanges = (ElemChanges)this.path.peek();
            Element element2 = elemChanges.parent.getElement(elemChanges.index);
            if (element2.getStartOffset() != n) {
                int n4;
                int n5 = n4 = elemChanges.index;
                if (n + n2 < elemChanges.parent.getEndOffset() && n2 != 0) {
                    n5 = elemChanges.parent.getElementIndex(n + n2);
                    if (n5 == n4) {
                        elemChanges.removed.addElement(element2);
                        element = DefaultStyledDocument.this.createLeafElement(elemChanges.parent, element2.getAttributes(), element2.getStartOffset(), n);
                        elemChanges.added.addElement(element);
                        element = DefaultStyledDocument.this.createLeafElement(elemChanges.parent, element2.getAttributes(), n, n + n2);
                        elemChanges.added.addElement(element);
                        element = DefaultStyledDocument.this.createLeafElement(elemChanges.parent, element2.getAttributes(), n + n2, element2.getEndOffset());
                        elemChanges.added.addElement(element);
                        return true;
                    }
                    element2 = elemChanges.parent.getElement(n5);
                    if (n + n2 == element2.getStartOffset()) {
                        n5 = n4;
                    }
                    bl = true;
                }
                this.pos = n;
                element2 = elemChanges.parent.getElement(n4);
                elemChanges.removed.addElement(element2);
                element = DefaultStyledDocument.this.createLeafElement(elemChanges.parent, element2.getAttributes(), element2.getStartOffset(), this.pos);
                elemChanges.added.addElement(element);
                element = DefaultStyledDocument.this.createLeafElement(elemChanges.parent, element2.getAttributes(), this.pos, element2.getEndOffset());
                elemChanges.added.addElement(element);
                int n6 = n4 + 1;
                while (n6 < n5) {
                    element2 = elemChanges.parent.getElement(n6);
                    elemChanges.removed.addElement(element2);
                    elemChanges.added.addElement(element2);
                    ++n6;
                }
                if (n5 != n4) {
                    element2 = elemChanges.parent.getElement(n5);
                    this.pos = n + n2;
                    elemChanges.removed.addElement(element2);
                    element = DefaultStyledDocument.this.createLeafElement(elemChanges.parent, element2.getAttributes(), element2.getStartOffset(), this.pos);
                    elemChanges.added.addElement(element);
                    element = DefaultStyledDocument.this.createLeafElement(elemChanges.parent, element2.getAttributes(), this.pos, element2.getEndOffset());
                    elemChanges.added.addElement(element);
                }
            }
            return bl;
        }

        class ElemChanges {
            Element parent;
            int index;
            Vector added;
            Vector removed;
            boolean isFracture;

            ElemChanges(Element element, int n, boolean bl) {
                this.parent = element;
                this.index = n;
                this.isFracture = bl;
                this.added = new Vector();
                this.removed = new Vector();
            }

            public String toString() {
                return "added: " + this.added + "\nremoved: " + this.removed + "\n";
            }
        }
    }

    public static class AttributeUndoableEdit
    extends AbstractUndoableEdit {
        protected AttributeSet newAttributes;
        protected AttributeSet copy;
        protected boolean isReplacing;
        protected Element element;

        public AttributeUndoableEdit(Element element, AttributeSet attributeSet, boolean bl) {
            this.element = element;
            this.newAttributes = attributeSet;
            this.isReplacing = bl;
            this.copy = element.getAttributes().copyAttributes();
        }

        public void redo() throws CannotRedoException {
            super.redo();
            MutableAttributeSet mutableAttributeSet = (MutableAttributeSet)this.element.getAttributes();
            if (this.isReplacing) {
                mutableAttributeSet.removeAttributes(mutableAttributeSet);
            }
            mutableAttributeSet.addAttributes(this.newAttributes);
        }

        public void undo() throws CannotUndoException {
            super.undo();
            MutableAttributeSet mutableAttributeSet = (MutableAttributeSet)this.element.getAttributes();
            mutableAttributeSet.removeAttributes(this.newAttributes);
            mutableAttributeSet.addAttributes(this.copy);
        }
    }

    static class StyleChangeUndoableEdit
    extends AbstractUndoableEdit {
        protected AbstractDocument.AbstractElement element;
        protected Style newStyle;
        protected AttributeSet oldStyle;

        public StyleChangeUndoableEdit(AbstractDocument.AbstractElement abstractElement, Style style) {
            this.element = abstractElement;
            this.newStyle = style;
            this.oldStyle = abstractElement.getResolveParent();
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.element.setResolveParent(this.newStyle);
        }

        public void undo() throws CannotUndoException {
            super.undo();
            this.element.setResolveParent(this.oldStyle);
        }
    }

    class StyleChangeHandler
    implements ChangeListener {
        StyleChangeHandler() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            Object object = changeEvent.getSource();
            if (object != null && object instanceof Style) {
                DefaultStyledDocument.this.styleChanged((Style)object);
            } else {
                DefaultStyledDocument.this.styleChanged(null);
            }
        }
    }

    class StyleContextChangeHandler
    implements ChangeListener {
        StyleContextChangeHandler() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            DefaultStyledDocument.this.updateStylesListeningTo();
        }
    }
}

