/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.ScrollPaneConstants;
import javax.swing.Scrollable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ScrollPaneUI;
import javax.swing.plaf.UIResource;

public class BasicScrollPaneUI
extends ScrollPaneUI
implements ScrollPaneConstants {
    protected JScrollPane scrollpane;
    protected ChangeListener vsbChangeListener;
    protected ChangeListener hsbChangeListener;
    protected ChangeListener viewportChangeListener;
    protected PropertyChangeListener spPropertyChangeListener;

    protected ChangeListener createHSBChangeListener() {
        return new HSBChangeListener();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicScrollPaneUI();
    }

    protected ChangeListener createVSBChangeListener() {
        return new VSBChangeListener();
    }

    protected ChangeListener createViewportChangeListener() {
        return new ViewportChangeHandler();
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return null;
    }

    protected void installDefaults(JScrollPane jScrollPane) {
        LookAndFeel.installBorder(jScrollPane, "ScrollPane.border");
        LookAndFeel.installColorsAndFont(jScrollPane, "ScrollPane.background", "ScrollPane.foreground", "ScrollPane.font");
        Border border = jScrollPane.getViewportBorder();
        if (border == null || border instanceof UIResource) {
            border = UIManager.getBorder("ScrollPane.viewportBorder");
            jScrollPane.setViewportBorder(border);
        }
    }

    protected void installKeyboardActions(JScrollPane jScrollPane) {
        jScrollPane.registerKeyboardAction(new ScrollAction("ScrollUp", 1, -1), KeyStroke.getKeyStroke(33, 0), 1);
        jScrollPane.registerKeyboardAction(new ScrollAction("ScrollDown", 1, 1), KeyStroke.getKeyStroke(34, 0), 1);
        jScrollPane.registerKeyboardAction(new ScrollAction("ScrollLeft", 0, -1), KeyStroke.getKeyStroke(33, 2), 1);
        jScrollPane.registerKeyboardAction(new ScrollAction("ScrollDown", 0, 1), KeyStroke.getKeyStroke(34, 2), 1);
        jScrollPane.registerKeyboardAction(new ScrollHomeAction("ScrollHome"), KeyStroke.getKeyStroke(36, 2), 1);
        jScrollPane.registerKeyboardAction(new ScrollEndAction("ScrollEnd"), KeyStroke.getKeyStroke(35, 2), 1);
    }

    protected void installListeners(JScrollPane jScrollPane) {
        this.vsbChangeListener = this.createVSBChangeListener();
        this.hsbChangeListener = this.createHSBChangeListener();
        this.viewportChangeListener = this.createViewportChangeListener();
        this.spPropertyChangeListener = this.createPropertyChangeListener();
        JViewport jViewport = this.scrollpane.getViewport();
        JScrollBar jScrollBar = this.scrollpane.getVerticalScrollBar();
        JScrollBar jScrollBar2 = this.scrollpane.getHorizontalScrollBar();
        if (jViewport != null) {
            jViewport.addChangeListener(this.viewportChangeListener);
        }
        if (jScrollBar != null) {
            jScrollBar.getModel().addChangeListener(this.vsbChangeListener);
        }
        if (jScrollBar2 != null) {
            jScrollBar2.getModel().addChangeListener(this.hsbChangeListener);
        }
        this.scrollpane.addPropertyChangeListener(this.spPropertyChangeListener);
    }

    public void installUI(JComponent jComponent) {
        this.scrollpane = (JScrollPane)jComponent;
        this.installDefaults(this.scrollpane);
        this.installListeners(this.scrollpane);
        this.installKeyboardActions(this.scrollpane);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        Border border = this.scrollpane.getViewportBorder();
        if (border != null) {
            Rectangle rectangle = this.scrollpane.getViewportBorderBounds();
            border.paintBorder(this.scrollpane, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    protected void syncScrollPaneWithViewport() {
        JViewport jViewport = this.scrollpane.getViewport();
        JScrollBar jScrollBar = this.scrollpane.getVerticalScrollBar();
        JScrollBar jScrollBar2 = this.scrollpane.getHorizontalScrollBar();
        JViewport jViewport2 = this.scrollpane.getRowHeader();
        JViewport jViewport3 = this.scrollpane.getColumnHeader();
        if (jViewport != null) {
            int n;
            int n2;
            int n3;
            Dimension dimension = jViewport.getExtentSize();
            Dimension dimension2 = jViewport.getViewSize();
            Point point = jViewport.getViewPosition();
            if (jScrollBar != null) {
                n3 = dimension.height;
                n2 = dimension2.height;
                n = Math.max(0, Math.min(point.y, n2 - n3));
                jScrollBar.setValues(n, n3, 0, n2);
            }
            if (jScrollBar2 != null) {
                n3 = dimension.width;
                n2 = dimension2.width;
                n = Math.max(0, Math.min(point.x, n2 - n3));
                jScrollBar2.setValues(n, n3, 0, n2);
            }
            if (jViewport2 != null) {
                Point point2 = jViewport2.getViewPosition();
                point2.y = jViewport.getViewPosition().y;
                jViewport2.setViewPosition(point2);
            }
            if (jViewport3 != null) {
                Point point3 = jViewport3.getViewPosition();
                point3.x = jViewport.getViewPosition().x;
                jViewport3.setViewPosition(point3);
            }
        }
    }

    protected void uninstallDefaults(JScrollPane jScrollPane) {
        LookAndFeel.uninstallBorder(this.scrollpane);
        if (this.scrollpane.getViewportBorder() instanceof UIResource) {
            this.scrollpane.setViewportBorder(null);
        }
    }

    protected void uninstallKeyboardActions(JScrollPane jScrollPane) {
        jScrollPane.unregisterKeyboardAction(KeyStroke.getKeyStroke(33, 0));
        jScrollPane.unregisterKeyboardAction(KeyStroke.getKeyStroke(34, 0));
        jScrollPane.unregisterKeyboardAction(KeyStroke.getKeyStroke(33, 2));
        jScrollPane.unregisterKeyboardAction(KeyStroke.getKeyStroke(34, 2));
        jScrollPane.unregisterKeyboardAction(KeyStroke.getKeyStroke(36, 2));
        jScrollPane.unregisterKeyboardAction(KeyStroke.getKeyStroke(35, 2));
    }

    protected void uninstallListeners(JComponent jComponent) {
        JViewport jViewport = this.scrollpane.getViewport();
        JScrollBar jScrollBar = this.scrollpane.getVerticalScrollBar();
        JScrollBar jScrollBar2 = this.scrollpane.getHorizontalScrollBar();
        if (jViewport != null) {
            jViewport.removeChangeListener(this.viewportChangeListener);
        }
        if (jScrollBar != null) {
            jScrollBar.getModel().removeChangeListener(this.vsbChangeListener);
        }
        if (jScrollBar2 != null) {
            jScrollBar2.getModel().removeChangeListener(this.hsbChangeListener);
        }
        this.scrollpane.removePropertyChangeListener(this.spPropertyChangeListener);
        this.vsbChangeListener = null;
        this.hsbChangeListener = null;
        this.viewportChangeListener = null;
        this.spPropertyChangeListener = null;
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults(this.scrollpane);
        this.uninstallListeners(this.scrollpane);
        this.uninstallKeyboardActions(this.scrollpane);
        this.scrollpane = null;
    }

    protected void updateColumnHeader(PropertyChangeEvent propertyChangeEvent) {
        JViewport jViewport = (JViewport)propertyChangeEvent.getNewValue();
        if (jViewport != null) {
            JViewport jViewport2 = this.scrollpane.getViewport();
            Point point = jViewport.getViewPosition();
            point.x = jViewport2 != null ? jViewport2.getViewPosition().x : 0;
            jViewport.setViewPosition(point);
            this.scrollpane.add((Component)jViewport, "COLUMN_HEADER");
        }
    }

    protected void updateRowHeader(PropertyChangeEvent propertyChangeEvent) {
        JViewport jViewport = (JViewport)propertyChangeEvent.getNewValue();
        if (jViewport != null) {
            JViewport jViewport2 = this.scrollpane.getViewport();
            Point point = jViewport.getViewPosition();
            point.y = jViewport2 != null ? jViewport2.getViewPosition().y : 0;
            jViewport.setViewPosition(point);
        }
    }

    protected void updateScrollBarDisplayPolicy(PropertyChangeEvent propertyChangeEvent) {
        this.scrollpane.revalidate();
        this.scrollpane.repaint();
    }

    protected void updateViewport(PropertyChangeEvent propertyChangeEvent) {
        JViewport jViewport = (JViewport)propertyChangeEvent.getOldValue();
        JViewport jViewport2 = (JViewport)propertyChangeEvent.getNewValue();
        if (jViewport != null) {
            jViewport.removeChangeListener(this.viewportChangeListener);
        }
        if (jViewport2 != null) {
            Point point = jViewport2.getViewPosition();
            point.x = Math.max(point.x, 0);
            point.y = Math.max(point.y, 0);
            jViewport2.setViewPosition(point);
            jViewport2.addChangeListener(this.viewportChangeListener);
        }
    }

    public class ViewportChangeHandler
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            BasicScrollPaneUI.this.syncScrollPaneWithViewport();
        }
    }

    public class HSBChangeListener
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            JViewport jViewport = BasicScrollPaneUI.this.scrollpane.getViewport();
            if (jViewport != null) {
                BoundedRangeModel boundedRangeModel = (BoundedRangeModel)changeEvent.getSource();
                Point point = jViewport.getViewPosition();
                point.x = boundedRangeModel.getValue();
                jViewport.setViewPosition(point);
            }
        }
    }

    public class VSBChangeListener
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            JViewport jViewport = BasicScrollPaneUI.this.scrollpane.getViewport();
            if (jViewport != null) {
                BoundedRangeModel boundedRangeModel = (BoundedRangeModel)changeEvent.getSource();
                Point point = jViewport.getViewPosition();
                point.y = boundedRangeModel.getValue();
                jViewport.setViewPosition(point);
            }
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("verticalScrollBarDisplayPolicy")) {
                BasicScrollPaneUI.this.updateScrollBarDisplayPolicy(propertyChangeEvent);
            } else if (string.equals("horizontalScrollBarDisplayPolicy")) {
                BasicScrollPaneUI.this.updateScrollBarDisplayPolicy(propertyChangeEvent);
            } else if (string.equals("viewport")) {
                BasicScrollPaneUI.this.updateViewport(propertyChangeEvent);
            } else if (string.equals("rowHeader")) {
                BasicScrollPaneUI.this.updateRowHeader(propertyChangeEvent);
            } else if (string.equals("columnHeader")) {
                BasicScrollPaneUI.this.updateColumnHeader(propertyChangeEvent);
            }
        }
    }

    private abstract class ScrollPaneAction
    extends AbstractAction {
        protected ScrollPaneAction(String string) {
            super(string);
        }

        public boolean isEnabled() {
            return BasicScrollPaneUI.this.scrollpane != null && BasicScrollPaneUI.this.scrollpane.isEnabled();
        }
    }

    private class ScrollAction
    extends ScrollPaneAction {
        protected int orientation;
        protected int direction;

        protected ScrollAction(String string, int n, int n2) {
            super(string);
            this.orientation = n;
            this.direction = n2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Component component;
            JViewport jViewport = BasicScrollPaneUI.this.scrollpane.getViewport();
            if (jViewport != null && (component = jViewport.getView()) != null) {
                Rectangle rectangle = jViewport.getViewRect();
                Dimension dimension = component.getSize();
                int n = component instanceof Scrollable ? ((Scrollable)((Object)component)).getScrollableBlockIncrement(rectangle, this.orientation, this.direction) : (this.orientation == 1 ? rectangle.height : rectangle.width);
                if (this.orientation == 1) {
                    rectangle.y += n * this.direction;
                    if (rectangle.y + rectangle.height > dimension.height) {
                        rectangle.y = Math.max(0, dimension.height - rectangle.height);
                    }
                } else {
                    rectangle.x += n * this.direction;
                    if (rectangle.x + rectangle.width > dimension.width) {
                        rectangle.x = Math.max(0, dimension.width - rectangle.width);
                    }
                }
                jViewport.setViewPosition(rectangle.getLocation());
            }
        }
    }

    private class ScrollHomeAction
    extends ScrollPaneAction {
        protected ScrollHomeAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Component component;
            JViewport jViewport = BasicScrollPaneUI.this.scrollpane.getViewport();
            if (jViewport != null && (component = jViewport.getView()) != null) {
                jViewport.setViewPosition(new Point(0, 0));
            }
        }
    }

    private class ScrollEndAction
    extends ScrollPaneAction {
        protected ScrollEndAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Component component;
            JViewport jViewport = BasicScrollPaneUI.this.scrollpane.getViewport();
            if (jViewport != null && (component = jViewport.getView()) != null) {
                Rectangle rectangle = jViewport.getViewRect();
                Rectangle rectangle2 = component.getBounds();
                jViewport.setViewPosition(new Point(rectangle2.width - rectangle.width, rectangle2.height - rectangle.height));
            }
        }
    }
}

