/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import javax.swing.MutableComboBoxModel;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.plaf.ComboBoxUI;

public class JComboBox
extends JComponent
implements ItemSelectable,
ListDataListener,
ActionListener,
Accessible {
    private static final String uiClassID = "ComboBoxUI";
    protected ComboBoxModel dataModel;
    protected ListCellRenderer renderer;
    protected ComboBoxEditor editor;
    protected int maximumRowCount = 8;
    protected boolean isEditable = false;
    protected Object selectedItemReminder = null;
    protected KeySelectionManager keySelectionManager = null;
    protected String actionCommand = "comboBoxChanged";
    protected boolean lightWeightPopupEnabled = true;
    static /* synthetic */ Class class$java$awt$event$ItemListener;
    static /* synthetic */ Class class$java$awt$event$ActionListener;

    public JComboBox() {
        this.setModel(new DefaultComboBoxModel());
        this.installAncestorListener();
        this.updateUI();
    }

    public JComboBox(Vector vector) {
        this.setModel(new DefaultComboBoxModel(vector));
        this.installAncestorListener();
        this.updateUI();
    }

    public JComboBox(ComboBoxModel comboBoxModel) {
        this.setModel(comboBoxModel);
        this.installAncestorListener();
        this.setOpaque(true);
        this.updateUI();
    }

    public JComboBox(Object[] objectArray) {
        this.setModel(new DefaultComboBoxModel(objectArray));
        this.installAncestorListener();
        this.updateUI();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = this.getEditor().getItem();
        this.getModel().setSelectedItem(object);
        this.getUI().setPopupVisible(this, false);
    }

    public void addActionListener(ActionListener actionListener) {
        this.listenerList.add(class$java$awt$event$ActionListener != null ? class$java$awt$event$ActionListener : (class$java$awt$event$ActionListener = JComboBox.class$("java.awt.event.ActionListener")), actionListener);
    }

    public void addItem(Object object) {
        this.checkMutableComboBoxModel();
        ((MutableComboBoxModel)this.dataModel).addElement(object);
    }

    public void addItemListener(ItemListener itemListener) {
        this.listenerList.add(class$java$awt$event$ItemListener != null ? class$java$awt$event$ItemListener : (class$java$awt$event$ItemListener = JComboBox.class$("java.awt.event.ItemListener")), itemListener);
    }

    void checkMutableComboBoxModel() {
        if (!(this.dataModel instanceof MutableComboBoxModel)) {
            throw new InternalError("Cannot use this method with a non-Mutable data model.");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void configureEditor(ComboBoxEditor comboBoxEditor, Object object) {
        comboBoxEditor.setItem(object);
    }

    public void contentsChanged(ListDataEvent listDataEvent) {
        ComboBoxModel comboBoxModel = this.getModel();
        Object object = comboBoxModel.getSelectedItem();
        if (this.selectedItemReminder == null) {
            if (object != null) {
                this.selectedItemChanged();
            }
        } else if (!this.selectedItemReminder.equals(object)) {
            this.selectedItemChanged();
        }
        if (!this.isEditable() && object != null) {
            boolean bl = true;
            Object object2 = comboBoxModel.getSelectedItem();
            int n = 0;
            int n2 = comboBoxModel.getSize();
            while (n < n2) {
                Object object3 = comboBoxModel.getElementAt(n);
                if (object3.equals(object2)) {
                    bl = false;
                    break;
                }
                ++n;
            }
            if (bl) {
                if (comboBoxModel.getSize() > 0) {
                    this.setSelectedIndex(0);
                } else {
                    this.setSelectedItem(null);
                }
            }
        }
    }

    protected KeySelectionManager createDefaultKeySelectionManager() {
        return new DefaultKeySelectionManager();
    }

    protected void fireActionEvent() {
        ActionEvent actionEvent = null;
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$java$awt$event$ActionListener != null ? class$java$awt$event$ActionListener : JComboBox.class$("java.awt.event.ActionListener"))) {
                if (actionEvent == null) {
                    actionEvent = new ActionEvent(this, 1001, this.getActionCommand());
                }
                ((ActionListener)objectArray[n + 1]).actionPerformed(actionEvent);
            }
            n -= 2;
        }
    }

    protected void fireItemStateChanged(ItemEvent itemEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$java$awt$event$ItemListener != null ? class$java$awt$event$ItemListener : JComboBox.class$("java.awt.event.ItemListener"))) {
                ((ItemListener)objectArray[n + 1]).itemStateChanged(itemEvent);
            }
            n -= 2;
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJComboBox();
        }
        return this.accessibleContext;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public ComboBoxEditor getEditor() {
        return this.editor;
    }

    public Object getItemAt(int n) {
        return this.dataModel.getElementAt(n);
    }

    public int getItemCount() {
        return this.dataModel.getSize();
    }

    public KeySelectionManager getKeySelectionManager() {
        return this.keySelectionManager;
    }

    public int getMaximumRowCount() {
        return this.maximumRowCount;
    }

    public ComboBoxModel getModel() {
        return this.dataModel;
    }

    public ListCellRenderer getRenderer() {
        return this.renderer;
    }

    public int getSelectedIndex() {
        Object object = this.dataModel.getSelectedItem();
        int n = 0;
        int n2 = this.dataModel.getSize();
        while (n < n2) {
            Object object2 = this.dataModel.getElementAt(n);
            if (object2.equals(object)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Object getSelectedItem() {
        return this.dataModel.getSelectedItem();
    }

    public Object[] getSelectedObjects() {
        Object object = this.getSelectedItem();
        if (object == null) {
            return new Object[0];
        }
        Object[] objectArray = new Object[]{object};
        return objectArray;
    }

    public ComboBoxUI getUI() {
        return (ComboBoxUI)this.ui;
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public void hidePopup() {
        this.setPopupVisible(false);
    }

    public void insertItemAt(Object object, int n) {
        this.checkMutableComboBoxModel();
        ((MutableComboBoxModel)this.dataModel).insertElementAt(object, n);
    }

    protected void installAncestorListener() {
        this.addAncestorListener(new AncestorListener(){

            public void ancestorAdded(AncestorEvent ancestorEvent) {
                JComboBox.this.hidePopup();
            }

            public void ancestorMoved(AncestorEvent ancestorEvent) {
                JComboBox.this.hidePopup();
            }

            public void ancestorRemoved(AncestorEvent ancestorEvent) {
                JComboBox.this.hidePopup();
            }
        });
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
        this.contentsChanged(listDataEvent);
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.contentsChanged(listDataEvent);
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public boolean isFocusTraversable() {
        return this.getUI().isFocusTraversable(this);
    }

    public boolean isLightWeightPopupEnabled() {
        return this.lightWeightPopupEnabled;
    }

    public boolean isPopupVisible() {
        return this.getUI().isPopupVisible(this);
    }

    protected String paramString() {
        String string = this.selectedItemReminder != null ? this.selectedItemReminder.toString() : "";
        String string2 = this.isEditable ? "true" : "false";
        String string3 = this.lightWeightPopupEnabled ? "true" : "false";
        return String.valueOf(super.paramString()) + ",isEditable=" + string2 + ",lightWeightPopupEnabled=" + string3 + ",maximumRowCount=" + this.maximumRowCount + ",selectedItemReminder=" + string;
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 9) {
            this.hidePopup();
        }
        super.processKeyEvent(keyEvent);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listenerList.remove(class$java$awt$event$ActionListener != null ? class$java$awt$event$ActionListener : (class$java$awt$event$ActionListener = JComboBox.class$("java.awt.event.ActionListener")), actionListener);
    }

    public void removeAllItems() {
        this.checkMutableComboBoxModel();
        MutableComboBoxModel mutableComboBoxModel = (MutableComboBoxModel)this.dataModel;
        int n = mutableComboBoxModel.getSize();
        if (mutableComboBoxModel instanceof DefaultComboBoxModel) {
            ((DefaultComboBoxModel)mutableComboBoxModel).removeAllElements();
        } else {
            int n2 = 0;
            while (n2 < n) {
                Object object = mutableComboBoxModel.getElementAt(0);
                mutableComboBoxModel.removeElement(object);
                ++n2;
            }
        }
    }

    public void removeItem(Object object) {
        this.checkMutableComboBoxModel();
        ((MutableComboBoxModel)this.dataModel).removeElement(object);
    }

    public void removeItemAt(int n) {
        this.checkMutableComboBoxModel();
        ((MutableComboBoxModel)this.dataModel).removeElementAt(n);
    }

    public void removeItemListener(ItemListener itemListener) {
        this.listenerList.remove(class$java$awt$event$ItemListener != null ? class$java$awt$event$ItemListener : (class$java$awt$event$ItemListener = JComboBox.class$("java.awt.event.ItemListener")), itemListener);
    }

    public boolean selectWithKeyChar(char c) {
        int n;
        if (this.keySelectionManager == null) {
            this.keySelectionManager = this.createDefaultKeySelectionManager();
        }
        if ((n = this.keySelectionManager.selectionForKey(c, this.getModel())) != -1) {
            this.setSelectedIndex(n);
            return true;
        }
        return false;
    }

    protected void selectedItemChanged() {
        if (this.selectedItemReminder != null) {
            this.fireItemStateChanged(new ItemEvent(this, 701, this.selectedItemReminder, 2));
        }
        this.selectedItemReminder = this.getModel().getSelectedItem();
        if (this.selectedItemReminder != null) {
            this.fireItemStateChanged(new ItemEvent(this, 701, this.selectedItemReminder, 1));
        }
        this.fireActionEvent();
    }

    public void setActionCommand(String string) {
        this.actionCommand = string;
    }

    public void setEditable(boolean bl) {
        boolean bl2 = bl != this.isEditable;
        this.isEditable = bl;
        if (bl2) {
            this.firePropertyChange("editable", this.isEditable ^ true, this.isEditable);
        }
    }

    public void setEditor(ComboBoxEditor comboBoxEditor) {
        ComboBoxEditor comboBoxEditor2 = this.editor;
        if (this.editor != null) {
            this.editor.removeActionListener(this);
        }
        this.editor = comboBoxEditor;
        if (this.editor != null) {
            this.editor.addActionListener(this);
        }
        this.firePropertyChange("editor", comboBoxEditor2, this.editor);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.firePropertyChange("enabled", this.isEnabled() ^ true, this.isEnabled());
    }

    public void setKeySelectionManager(KeySelectionManager keySelectionManager) {
        this.keySelectionManager = keySelectionManager;
    }

    public void setLightWeightPopupEnabled(boolean bl) {
        this.lightWeightPopupEnabled = bl;
    }

    public void setMaximumRowCount(int n) {
        int n2 = this.maximumRowCount;
        this.maximumRowCount = n;
        this.firePropertyChange("maximumRowCount", n2, this.maximumRowCount);
    }

    public void setModel(ComboBoxModel comboBoxModel) {
        ComboBoxModel comboBoxModel2 = this.dataModel;
        if (this.dataModel != null) {
            this.dataModel.removeListDataListener(this);
        }
        this.dataModel = comboBoxModel;
        this.firePropertyChange("model", comboBoxModel2, this.dataModel);
        this.dataModel.addListDataListener(this);
        this.invalidate();
    }

    public void setPopupVisible(boolean bl) {
        this.getUI().setPopupVisible(this, bl);
    }

    public void setRenderer(ListCellRenderer listCellRenderer) {
        ListCellRenderer listCellRenderer2 = this.renderer;
        this.renderer = listCellRenderer;
        this.firePropertyChange("renderer", listCellRenderer2, this.renderer);
        this.invalidate();
    }

    public void setSelectedIndex(int n) {
        int n2 = this.dataModel.getSize();
        if (n == -1) {
            this.setSelectedItem(null);
        } else {
            if (n < -1 || n >= n2) {
                throw new IllegalArgumentException("setSelectedIndex: " + n + " out of bounds");
            }
            this.setSelectedItem(this.dataModel.getElementAt(n));
        }
    }

    public void setSelectedItem(Object object) {
        this.dataModel.setSelectedItem(object);
    }

    public void setUI(ComboBoxUI comboBoxUI) {
        super.setUI(comboBoxUI);
    }

    public void showPopup() {
        this.setPopupVisible(true);
    }

    public void updateUI() {
        this.setUI((ComboBoxUI)UIManager.getUI(this));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.ui != null && this.getUIClassID().equals(uiClassID)) {
            this.ui.installUI(this);
        }
    }

    public static interface KeySelectionManager {
        public int selectionForKey(char var1, ComboBoxModel var2);
    }

    class DefaultKeySelectionManager
    implements KeySelectionManager,
    Serializable {
        DefaultKeySelectionManager() {
        }

        public int selectionForKey(char c, ComboBoxModel comboBoxModel) {
            String string;
            int n;
            int n2;
            int n3 = -1;
            Object object = comboBoxModel.getSelectedItem();
            if (object != null) {
                object = object.toString();
                n2 = 0;
                n = comboBoxModel.getSize();
                while (n2 < n) {
                    if (object.equals(comboBoxModel.getElementAt(n2).toString())) {
                        n3 = n2;
                        break;
                    }
                    ++n2;
                }
            }
            String string2 = String.valueOf(c).toLowerCase();
            c = string2.charAt(0);
            n2 = ++n3;
            n = comboBoxModel.getSize();
            while (n2 < n) {
                string = comboBoxModel.getElementAt(n2).toString().toLowerCase();
                if (string.length() > 0 && string.charAt(0) == c) {
                    return n2;
                }
                ++n2;
            }
            n2 = 0;
            while (n2 < n3) {
                string = comboBoxModel.getElementAt(n2).toString().toLowerCase();
                if (string.length() > 0 && string.charAt(0) == c) {
                    return n2;
                }
                ++n2;
            }
            return -1;
        }
    }

    protected class AccessibleJComboBox
    extends JComponent.AccessibleJComponent
    implements AccessibleAction {
        protected AccessibleJComboBox() {
        }

        public boolean doAccessibleAction(int n) {
            if (n == 0) {
                JComboBox.this.setPopupVisible(JComboBox.this.isPopupVisible() ^ true);
                return true;
            }
            return false;
        }

        public AccessibleAction getAccessibleAction() {
            return this;
        }

        public int getAccessibleActionCount() {
            return 1;
        }

        public String getAccessibleActionDescription(int n) {
            if (n == 0) {
                return new String("togglePopup");
            }
            return null;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.COMBO_BOX;
        }
    }
}

