/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.IOException;
import java.io.ObjectOutputStream;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JToggleButton;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.plaf.MenuItemUI;

public class JCheckBoxMenuItem
extends JMenuItem
implements SwingConstants,
Accessible {
    private static final String uiClassID = "CheckBoxMenuItemUI";

    public JCheckBoxMenuItem() {
        this(null, null, false);
    }

    public JCheckBoxMenuItem(String string) {
        this(string, null, false);
    }

    public JCheckBoxMenuItem(String string, Icon icon) {
        this(string, icon, false);
    }

    public JCheckBoxMenuItem(String string, Icon icon, boolean bl) {
        this.setModel(new JToggleButton.ToggleButtonModel());
        this.init(string, icon);
        this.setBorderPainted(false);
        this.setFocusPainted(false);
        this.setHorizontalTextPosition(4);
        this.setHorizontalAlignment(2);
        this.setSelected(bl);
        this.updateUI();
    }

    public JCheckBoxMenuItem(String string, boolean bl) {
        this(string, null, bl);
    }

    public JCheckBoxMenuItem(Icon icon) {
        this(null, icon, false);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJCheckBoxMenuItem();
        }
        return this.accessibleContext;
    }

    public synchronized Object[] getSelectedObjects() {
        if (!this.isSelected()) {
            return null;
        }
        Object[] objectArray = new Object[]{this.getText()};
        return objectArray;
    }

    public boolean getState() {
        return this.isSelected();
    }

    public String getUIClassID() {
        return uiClassID;
    }

    protected void init(String string, Icon icon) {
        if (string != null) {
            this.setText(string);
            if (icon != null) {
                this.setVerticalTextPosition(3);
            }
        }
        if (icon != null) {
            this.setIcon(icon);
        }
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
            }

            public void focusLost(FocusEvent focusEvent) {
                if (JCheckBoxMenuItem.this.isFocusPainted()) {
                    JCheckBoxMenuItem.this.repaint();
                }
            }
        });
    }

    protected String paramString() {
        return super.paramString();
    }

    public void requestFocus() {
    }

    public synchronized void setState(boolean bl) {
        this.setSelected(bl);
    }

    public void updateUI() {
        this.setUI((MenuItemUI)UIManager.getUI(this));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.ui != null && this.getUIClassID().equals(uiClassID)) {
            this.ui.installUI(this);
        }
    }

    protected class AccessibleJCheckBoxMenuItem
    extends JMenuItem.AccessibleJMenuItem {
        protected AccessibleJCheckBoxMenuItem() {
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.CHECK_BOX;
        }
    }
}

