/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class HashMap
extends AbstractMap
implements Map,
Cloneable,
Serializable {
    private transient Entry[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;
    private transient int modCount = 0;
    private transient Set keySet = null;
    private transient Set entrySet = null;
    private transient Collection values = null;
    private static final int KEYS = 0;
    private static final int VALUES = 1;
    private static final int ENTRIES = 2;

    public HashMap() {
        this(101, 0.75f);
    }

    public HashMap(int n) {
        this(n, 0.75f);
    }

    public HashMap(int n, float f) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Initial Capacity: " + n);
        }
        if (f <= 0.0f) {
            throw new IllegalArgumentException("Illegal Load factor: " + f);
        }
        if (n == 0) {
            n = 1;
        }
        this.loadFactor = f;
        this.table = new Entry[n];
        this.threshold = (int)((float)n * f);
    }

    public HashMap(Map map) {
        this(Math.max(2 * map.size(), 11), 0.75f);
        this.putAll(map);
    }

    int capacity() {
        return this.table.length;
    }

    public void clear() {
        Entry[] entryArray = this.table;
        ++this.modCount;
        int n = entryArray.length;
        while (--n >= 0) {
            entryArray[n] = null;
        }
        this.count = 0;
    }

    public Object clone() {
        try {
            HashMap hashMap = (HashMap)super.clone();
            hashMap.table = new Entry[this.table.length];
            int n = this.table.length;
            while (n-- > 0) {
                Entry entry = hashMap.table[n] = this.table[n] != null ? (Entry)this.table[n].clone() : null;
            }
            hashMap.keySet = null;
            hashMap.entrySet = null;
            hashMap.values = null;
            hashMap.modCount = 0;
            return hashMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean containsKey(Object object) {
        Entry[] entryArray = this.table;
        if (object != null) {
            int n = object.hashCode();
            int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
            Entry entry = entryArray[n2];
            while (entry != null) {
                if (entry.hash == n && object.equals(entry.key)) {
                    return true;
                }
                entry = entry.next;
            }
        } else {
            Entry entry = entryArray[0];
            while (entry != null) {
                if (entry.key == null) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    public boolean containsValue(Object object) {
        Entry[] entryArray = this.table;
        if (object == null) {
            int n = entryArray.length;
            while (n-- > 0) {
                Entry entry = entryArray[n];
                while (entry != null) {
                    if (entry.value == null) {
                        return true;
                    }
                    entry = entry.next;
                }
            }
        } else {
            int n = entryArray.length;
            while (n-- > 0) {
                Entry entry = entryArray[n];
                while (entry != null) {
                    if (object.equals(entry.value)) {
                        return true;
                    }
                    entry = entry.next;
                }
            }
        }
        return false;
    }

    public Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet(){

                public void clear() {
                    HashMap.this.clear();
                }

                public boolean contains(Object object) {
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)object;
                    Object object2 = entry.getKey();
                    Entry[] entryArray = HashMap.this.table;
                    int n = object2 == null ? 0 : object2.hashCode();
                    int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
                    Entry entry2 = entryArray[n2];
                    while (entry2 != null) {
                        if (entry2.hash == n && entry2.equals(entry)) {
                            return true;
                        }
                        entry2 = entry2.next;
                    }
                    return false;
                }

                public Iterator iterator() {
                    return new HashIterator(2);
                }

                public boolean remove(Object object) {
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)object;
                    Object object2 = entry.getKey();
                    Entry[] entryArray = HashMap.this.table;
                    int n = object2 == null ? 0 : object2.hashCode();
                    int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
                    Entry entry2 = entryArray[n2];
                    Entry entry3 = null;
                    while (entry2 != null) {
                        if (entry2.hash == n && entry2.equals(entry)) {
                            HashMap hashMap = HashMap.this;
                            hashMap.modCount = hashMap.modCount + 1;
                            if (entry3 != null) {
                                entry3.next = entry2.next;
                            } else {
                                entryArray[n2] = entry2.next;
                            }
                            HashMap hashMap2 = HashMap.this;
                            hashMap2.count = hashMap2.count - 1;
                            entry2.value = null;
                            return true;
                        }
                        entry3 = entry2;
                        entry2 = entry2.next;
                    }
                    return false;
                }

                public int size() {
                    return HashMap.this.count;
                }
            };
        }
        return this.entrySet;
    }

    public Object get(Object object) {
        Entry[] entryArray = this.table;
        if (object != null) {
            int n = object.hashCode();
            int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
            Entry entry = entryArray[n2];
            while (entry != null) {
                if (entry.hash == n && object.equals(entry.key)) {
                    return entry.value;
                }
                entry = entry.next;
            }
        } else {
            Entry entry = entryArray[0];
            while (entry != null) {
                if (entry.key == null) {
                    return entry.value;
                }
                entry = entry.next;
            }
        }
        return null;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new AbstractSet(){

                public void clear() {
                    HashMap.this.clear();
                }

                public boolean contains(Object object) {
                    return HashMap.this.containsKey(object);
                }

                public Iterator iterator() {
                    return new HashIterator(0);
                }

                public boolean remove(Object object) {
                    return HashMap.this.remove(object) != null;
                }

                public int size() {
                    return HashMap.this.count;
                }
            };
        }
        return this.keySet;
    }

    float loadFactor() {
        return this.loadFactor;
    }

    public Object put(Object object, Object object2) {
        Entry entry;
        Entry[] entryArray = this.table;
        int n = 0;
        int n2 = 0;
        if (object != null) {
            n = object.hashCode();
            n2 = (n & Integer.MAX_VALUE) % entryArray.length;
            entry = entryArray[n2];
            while (entry != null) {
                if (entry.hash == n && object.equals(entry.key)) {
                    Object object3 = entry.value;
                    entry.value = object2;
                    return object3;
                }
                entry = entry.next;
            }
        } else {
            entry = entryArray[0];
            while (entry != null) {
                if (entry.key == null) {
                    Object object4 = entry.value;
                    entry.value = object2;
                    return object4;
                }
                entry = entry.next;
            }
        }
        ++this.modCount;
        if (this.count >= this.threshold) {
            this.rehash();
            entryArray = this.table;
            n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        }
        entryArray[n2] = entry = new Entry(n, object, object2, entryArray[n2]);
        ++this.count;
        return null;
    }

    public void putAll(Map map) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.table = new Entry[n];
        int n2 = objectInputStream.readInt();
        int n3 = 0;
        while (n3 < n2) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            this.put(object, object2);
            ++n3;
        }
    }

    private void rehash() {
        int n = this.table.length;
        Entry[] entryArray = this.table;
        int n2 = n * 2 + 1;
        Entry[] entryArray2 = new Entry[n2];
        ++this.modCount;
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.table = entryArray2;
        int n3 = n;
        while (n3-- > 0) {
            Entry entry = entryArray[n3];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.next;
                int n4 = (entry2.hash & Integer.MAX_VALUE) % n2;
                entry2.next = entryArray2[n4];
                entryArray2[n4] = entry2;
            }
        }
    }

    public Object remove(Object object) {
        Entry[] entryArray = this.table;
        if (object != null) {
            int n = object.hashCode();
            int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
            Entry entry = entryArray[n2];
            Entry entry2 = null;
            while (entry != null) {
                if (entry.hash == n && object.equals(entry.key)) {
                    ++this.modCount;
                    if (entry2 != null) {
                        entry2.next = entry.next;
                    } else {
                        entryArray[n2] = entry.next;
                    }
                    --this.count;
                    Object object2 = entry.value;
                    entry.value = null;
                    return object2;
                }
                entry2 = entry;
                entry = entry.next;
            }
        } else {
            Entry entry = entryArray[0];
            Entry entry3 = null;
            while (entry != null) {
                if (entry.key == null) {
                    ++this.modCount;
                    if (entry3 != null) {
                        entry3.next = entry.next;
                    } else {
                        entryArray[0] = entry.next;
                    }
                    --this.count;
                    Object object3 = entry.value;
                    entry.value = null;
                    return object3;
                }
                entry3 = entry;
                entry = entry.next;
            }
        }
        return null;
    }

    public int size() {
        return this.count;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new AbstractCollection(){

                public void clear() {
                    HashMap.this.clear();
                }

                public boolean contains(Object object) {
                    return HashMap.this.containsValue(object);
                }

                public Iterator iterator() {
                    return new HashIterator(1);
                }

                public int size() {
                    return HashMap.this.count;
                }
            };
        }
        return this.values;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.table.length);
        objectOutputStream.writeInt(this.count);
        int n = this.table.length - 1;
        while (n >= 0) {
            Entry entry = this.table[n];
            while (entry != null) {
                objectOutputStream.writeObject(entry.key);
                objectOutputStream.writeObject(entry.value);
                entry = entry.next;
            }
            --n;
        }
    }

    private static class Entry
    implements Map.Entry {
        int hash;
        Object key;
        Object value;
        Entry next;

        Entry(int n, Object object, Object object2, Entry entry) {
            this.hash = n;
            this.key = object;
            this.value = object2;
            this.next = entry;
        }

        protected Object clone() {
            return new Entry(this.hash, this.key, this.value, this.next == null ? null : (Entry)this.next.clone());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            if (this.key == null) {
                if (entry.getKey() != null) {
                    return false;
                }
            } else {
                boolean bl = this.key.equals(entry.getKey());
                if (!bl) return false;
            }
            if (this.value == null) {
                if (entry.getValue() == null) return true;
                return false;
            }
            boolean bl = this.value.equals(entry.getValue());
            if (bl) return true;
            return false;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public int hashCode() {
            return this.hash ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public Object setValue(Object object) {
            Object object2 = this.value;
            this.value = object;
            return object2;
        }

        public String toString() {
            return String.valueOf(this.key.toString()) + "=" + this.value.toString();
        }
    }

    private class HashIterator
    implements Iterator {
        Entry[] table;
        int index;
        Entry entry;
        Entry lastReturned;
        int type;
        private int expectedModCount;

        HashIterator(int n) {
            this.table = HashMap.this.table;
            this.index = this.table.length;
            this.entry = null;
            this.lastReturned = null;
            this.expectedModCount = HashMap.this.modCount;
            this.type = n;
        }

        public boolean hasNext() {
            while (this.entry == null && this.index > 0) {
                this.entry = this.table[--this.index];
            }
            return this.entry != null;
        }

        /*
         * Unable to fully structure code
         */
        public Object next() {
            if (HashMap.access$2(HashMap.this) == this.expectedModCount) ** GOTO lbl4
            throw new ConcurrentModificationException();
lbl-1000:
            // 1 sources

            {
                this.entry = this.table[--this.index];
lbl4:
                // 2 sources

                ** while (this.entry == null && this.index > 0)
            }
lbl5:
            // 1 sources

            if (this.entry != null) {
                var1_1 = this.lastReturned = this.entry;
                this.entry = var1_1.next;
                return this.type == 0 ? var1_1.key : (this.type == 1 ? var1_1.value : var1_1);
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (HashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Entry[] entryArray = HashMap.this.table;
            int n = (this.lastReturned.hash & Integer.MAX_VALUE) % entryArray.length;
            Entry entry = entryArray[n];
            Entry entry2 = null;
            while (entry != null) {
                if (entry == this.lastReturned) {
                    HashMap hashMap = HashMap.this;
                    hashMap.modCount = hashMap.modCount + 1;
                    ++this.expectedModCount;
                    if (entry2 == null) {
                        entryArray[n] = entry.next;
                    } else {
                        entry2.next = entry.next;
                    }
                    HashMap hashMap2 = HashMap.this;
                    hashMap2.count = hashMap2.count - 1;
                    this.lastReturned = null;
                    return;
                }
                entry2 = entry;
                entry = entry.next;
            }
            throw new ConcurrentModificationException();
        }
    }
}

