/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.CharacterIterator;
import java.text.EntryPair;
import java.text.Normalizer;
import java.text.RuleBasedCollator;
import java.util.Vector;

public final class CollationElementIterator {
    public static final int NULLORDER = -1;
    static final int UNMAPPEDCHARVALUE = 0x7FFF0000;
    private Normalizer text = null;
    private int[] buffer = null;
    private int expIndex = 0;
    private StringBuffer key = new StringBuffer(5);
    private int swapOrder = 0;
    private RuleBasedCollator ordering;

    CollationElementIterator(String string, RuleBasedCollator ruleBasedCollator) {
        this.ordering = ruleBasedCollator;
        if (string.length() != 0) {
            this.text = new Normalizer(string, ruleBasedCollator.getDecomposition());
        }
    }

    CollationElementIterator(CharacterIterator characterIterator, RuleBasedCollator ruleBasedCollator) {
        this.ordering = ruleBasedCollator;
        this.text = new Normalizer(characterIterator, ruleBasedCollator.getDecomposition());
    }

    public int getMaxExpansion(int n) {
        return this.ordering.getMaxExpansion(n);
    }

    public int getOffset() {
        return this.text != null ? this.text.getOffset() : 0;
    }

    static final boolean isIgnorable(int n) {
        return CollationElementIterator.primaryOrder(n) == 0;
    }

    public int next() {
        if (this.text == null) {
            return -1;
        }
        if (this.text.getDecomposition() != this.ordering.getDecomposition()) {
            this.text.setDecomposition(this.ordering.getDecomposition());
        }
        if (this.buffer != null) {
            if (this.expIndex < this.buffer.length) {
                return this.strengthOrder(this.buffer[this.expIndex++]);
            }
            this.buffer = null;
            this.expIndex = 0;
        } else if (this.swapOrder != 0) {
            int n = this.swapOrder << 16;
            this.swapOrder = 0;
            return n;
        }
        char c = this.text.next();
        if (c == '\uffff') {
            return -1;
        }
        int n = this.ordering.getUnicodeOrder(c);
        if (n == -1) {
            this.swapOrder = c;
            return 0x7FFF0000;
        }
        if (n >= 0x7F000000) {
            n = this.nextContractChar(c);
        }
        if (n >= 0x7E000000) {
            this.buffer = this.ordering.getExpandValueList(n);
            this.expIndex = 0;
            n = this.buffer[this.expIndex++];
        }
        return this.strengthOrder(n);
    }

    private int nextContractChar(char c) {
        Vector vector = this.ordering.getContractValues(c);
        EntryPair entryPair = (EntryPair)vector.firstElement();
        int n = entryPair.value;
        this.key.setLength(0);
        this.key.append(c);
        while ((c = this.text.next()) != '\uffff') {
            this.key.append(c);
            int n2 = RuleBasedCollator.getEntry(vector, this.key.toString(), true);
            if (n2 == -1) {
                c = this.text.previous();
                break;
            }
            entryPair = (EntryPair)vector.elementAt(n2);
            n = entryPair.value;
        }
        return n;
    }

    private int prevContractChar(char c) {
        Vector vector = this.ordering.getContractValues(c);
        EntryPair entryPair = (EntryPair)vector.firstElement();
        int n = entryPair.value;
        this.key.setLength(0);
        this.key.append(c);
        while ((c = this.text.previous()) != '\uffff') {
            this.key.append(c);
            int n2 = RuleBasedCollator.getEntry(vector, this.key.toString(), false);
            if (n2 == -1) {
                c = this.text.next();
                break;
            }
            entryPair = (EntryPair)vector.elementAt(n2);
            n = entryPair.value;
        }
        return n;
    }

    public int previous() {
        if (this.text == null) {
            return -1;
        }
        if (this.text.getDecomposition() != this.ordering.getDecomposition()) {
            this.text.setDecomposition(this.ordering.getDecomposition());
        }
        if (this.buffer != null) {
            if (this.expIndex > 0) {
                return this.strengthOrder(this.buffer[--this.expIndex]);
            }
            this.buffer = null;
            this.expIndex = 0;
        } else if (this.swapOrder != 0) {
            int n = this.swapOrder << 16;
            this.swapOrder = 0;
            return n;
        }
        char c = this.text.previous();
        if (c == '\uffff') {
            return -1;
        }
        int n = this.ordering.getUnicodeOrder(c);
        if (n == -1) {
            this.swapOrder = 0x7FFF0000;
            return c;
        }
        if (n >= 0x7F000000) {
            n = this.prevContractChar(c);
        }
        if (n >= 0x7E000000) {
            this.buffer = this.ordering.getExpandValueList(n);
            this.expIndex = this.buffer.length;
            n = this.buffer[--this.expIndex];
        }
        return this.strengthOrder(n);
    }

    public static final int primaryOrder(int n) {
        return (n &= 0xFFFF0000) >>> 16;
    }

    public void reset() {
        if (this.text != null) {
            this.text.reset();
            this.text.setDecomposition(this.ordering.getDecomposition());
        }
        this.buffer = null;
        this.expIndex = 0;
        this.swapOrder = 0;
    }

    public static final short secondaryOrder(int n) {
        return (short)((n &= 0xFF00) >> 8);
    }

    public void setOffset(int n) {
        if (this.text != null) {
            this.text.setOffset(n);
        }
        this.buffer = null;
        this.expIndex = 0;
        this.swapOrder = 0;
    }

    public void setText(String string) {
        this.buffer = null;
        this.swapOrder = 0;
        this.expIndex = 0;
        if (this.text == null) {
            this.text = new Normalizer(string, this.ordering.getDecomposition());
        } else {
            this.text.setDecomposition(this.ordering.getDecomposition());
            this.text.setText(string);
        }
    }

    public void setText(CharacterIterator characterIterator) {
        this.buffer = null;
        this.swapOrder = 0;
        this.expIndex = 0;
        if (this.text == null) {
            this.text = new Normalizer(characterIterator, this.ordering.getDecomposition());
        } else {
            this.text.setDecomposition(this.ordering.getDecomposition());
            this.text.setText(characterIterator);
        }
    }

    final int strengthOrder(int n) {
        int n2 = this.ordering.getStrength();
        if (n2 == 0) {
            n &= 0xFFFF0000;
        } else if (n2 == 1) {
            n &= 0xFFFFFF00;
        }
        return n;
    }

    public static final short tertiaryOrder(int n) {
        return (short)(n &= 0xFF);
    }
}

