/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.BufferedOutputStream;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedOutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;

class UNIXProcess
extends Process
implements Runnable {
    static Hashtable subprocs = null;
    private boolean isalive = false;
    private int exit_code = 0;
    private FileDescriptor stdin_fd;
    private FileDescriptor stdout_fd;
    private FileDescriptor stderr_fd;
    private FileDescriptor sync_fd;
    int pid;
    private OutputStream stdin_stream;
    private InputStream raw_stdout;
    private InputStream raw_stderr;
    private ProcessInputStream piped_stdout_in;
    private ProcessInputStream piped_stderr_in;
    private PipedOutputStream piped_stdout_out;
    private PipedOutputStream piped_stderr_out;
    private int numReaders;

    static {
        subprocs = new Hashtable();
        UNIXProcess.initLockObject();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                class Java_lang_UNIXProcess$5 {
                    /* synthetic */ Java_lang_UNIXProcess$5() {
                    }
                }
                Thread thread = new Thread(new UNIXProcess(), "process reaper");
                thread.setDaemon(true);
                thread.start();
                return null;
            }
        });
    }

    private UNIXProcess() {
    }

    UNIXProcess(String[] stringArray, String[] stringArray2) throws IOException {
        this.stdin_fd = new FileDescriptor();
        this.stdout_fd = new FileDescriptor();
        this.stderr_fd = new FileDescriptor();
        this.sync_fd = new FileDescriptor();
        this.pid = this.forkAndExec(stringArray, stringArray2, this.stdin_fd, this.stdout_fd, this.stderr_fd, this.sync_fd);
        this.isalive = true;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                UNIXProcess.this.stdin_stream = new BufferedOutputStream(new FileOutputStream(UNIXProcess.this.stdin_fd));
                UNIXProcess.this.raw_stdout = new FileInputStream(UNIXProcess.this.stdout_fd);
                UNIXProcess.this.raw_stderr = new FileInputStream(UNIXProcess.this.stderr_fd);
                return null;
            }
        });
        this.piped_stdout_out = new PipedOutputStream();
        this.piped_stderr_out = new PipedOutputStream();
        this.piped_stdout_in = new ProcessInputStream(this, this.piped_stdout_out, this.raw_stdout);
        this.piped_stderr_in = new ProcessInputStream(this, this.piped_stderr_out, this.raw_stderr);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Thread thread = new Thread(UNIXProcess.this.piped_stdout_in, "stdout reader pid=" + UNIXProcess.this.pid);
                thread.setDaemon(true);
                Thread thread2 = new Thread(UNIXProcess.this.piped_stderr_in, "stderr reader pid=" + UNIXProcess.this.pid);
                thread2.setDaemon(true);
                thread.start();
                thread2.start();
                return null;
            }
        });
        this.numReaders = 2;
        subprocs.put(new Integer(this.pid), this);
        FileOutputStream fileOutputStream = (FileOutputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new FileOutputStream(UNIXProcess.this.sync_fd);
            }
        });
        fileOutputStream.write(65);
        fileOutputStream.close();
    }

    static /* synthetic */ OutputStream access$1(UNIXProcess uNIXProcess) {
        return uNIXProcess.stdin_stream;
    }

    static /* synthetic */ InputStream access$4(UNIXProcess uNIXProcess) {
        return uNIXProcess.raw_stdout;
    }

    static /* synthetic */ InputStream access$7(UNIXProcess uNIXProcess) {
        return uNIXProcess.raw_stderr;
    }

    private static void deadChild(int n, int n2) {
        UNIXProcess uNIXProcess = (UNIXProcess)subprocs.get(new Integer(n));
        if (uNIXProcess != null) {
            UNIXProcess uNIXProcess2 = uNIXProcess;
            synchronized (uNIXProcess2) {
                uNIXProcess.isalive = false;
                subprocs.remove(new Integer(n));
                uNIXProcess.exit_code = n2;
                uNIXProcess.notifyAll();
            }
        }
    }

    synchronized void decrNumReaders() {
        if (--this.numReaders <= 0) {
            try {
                this.stdin_stream.close();
            }
            catch (IOException iOException) {}
            try {
                this.raw_stdout.close();
            }
            catch (IOException iOException) {}
            try {
                this.raw_stderr.close();
            }
            catch (IOException iOException) {}
        }
        this.notifyAll();
    }

    public native void destroy();

    public synchronized int exitValue() {
        if (this.isalive) {
            throw new IllegalThreadStateException("process hasn't exited");
        }
        return this.exit_code;
    }

    private native int forkAndExec(String[] var1, String[] var2, FileDescriptor var3, FileDescriptor var4, FileDescriptor var5, FileDescriptor var6) throws IOException;

    public InputStream getErrorStream() {
        return this.piped_stderr_in;
    }

    public InputStream getInputStream() {
        return this.piped_stdout_in;
    }

    synchronized int getNumReaders() throws InterruptedException {
        return this.numReaders;
    }

    public OutputStream getOutputStream() {
        return this.stdin_stream;
    }

    static native void initLockObject();

    public native void run();

    public synchronized int waitFor() throws InterruptedException {
        while (this.isalive) {
            this.wait();
        }
        return this.exit_code;
    }
}

