/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.File;
import java.io.FileSystem;
import java.io.IOException;
import java.security.AccessController;
import sun.security.action.GetPropertyAction;

class UnixFileSystem
extends FileSystem {
    private final char slash = ((String)AccessController.doPrivileged(new GetPropertyAction("file.separator"))).charAt(0);
    private final char colon = ((String)AccessController.doPrivileged(new GetPropertyAction("path.separator"))).charAt(0);

    static {
        UnixFileSystem.initIDs();
    }

    public native String canonicalize(String var1) throws IOException;

    public native boolean checkAccess(File var1, boolean var2);

    public int compare(File file, File file2) {
        return file.getPath().compareTo(file2.getPath());
    }

    public native boolean createDirectory(File var1);

    public native boolean createFileExclusively(String var1) throws IOException;

    public native boolean delete(File var1);

    public synchronized native boolean deleteOnExit(File var1);

    public int getBooleanAttributes(File file) {
        int n = this.getBooleanAttributes0(file);
        String string = file.getName();
        boolean bl = string.length() > 0 && string.charAt(0) == '.';
        return n | (bl ? 8 : 0);
    }

    public native int getBooleanAttributes0(File var1);

    public String getDefaultParent() {
        return "/";
    }

    public native long getLastModifiedTime(File var1);

    public native long getLength(File var1);

    public char getPathSeparator() {
        return this.colon;
    }

    public char getSeparator() {
        return this.slash;
    }

    public int hashCode(File file) {
        return file.getPath().hashCode() ^ 0x12D591;
    }

    private static native void initIDs();

    public boolean isAbsolute(File file) {
        return file.getPrefixLength() != 0;
    }

    public native String[] list(File var1);

    public File[] listRoots() {
        try {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkRead("/");
            }
            return new File[]{new File("/")};
        }
        catch (SecurityException securityException) {
            return new File[0];
        }
    }

    public String normalize(String string) {
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            char c = string.charAt(n3);
            if (n2 == 47 && c == '/') {
                return this.normalize(string, n, n3 - 1);
            }
            n2 = c;
            ++n3;
        }
        if (n2 == 47) {
            return this.normalize(string, n, n - 1);
        }
        return string;
    }

    private String normalize(String string, int n, int n2) {
        if (n == 0) {
            return string;
        }
        int n3 = n;
        while (n3 > 0 && string.charAt(n3 - 1) == '/') {
            --n3;
        }
        if (n3 == 0) {
            return "/";
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        if (n2 > 0) {
            stringBuffer.append(string.substring(0, n2));
        }
        int n4 = 0;
        int n5 = n2;
        while (n5 < n3) {
            char c = string.charAt(n5);
            if (n4 != 47 || c != '/') {
                stringBuffer.append(c);
                n4 = c;
            }
            ++n5;
        }
        return stringBuffer.toString();
    }

    public int prefixLength(String string) {
        if (string.length() == 0) {
            return 0;
        }
        return string.charAt(0) == '/' ? 1 : 0;
    }

    public native boolean rename(File var1, File var2);

    public String resolve(File file) {
        if (this.isAbsolute(file)) {
            return file.getPath();
        }
        return this.resolve(System.getProperty("user.dir"), file.getPath());
    }

    public String resolve(String string, String string2) {
        if (string2.equals("")) {
            return string;
        }
        if (string2.charAt(0) == '/') {
            if (string.equals("/")) {
                return string2;
            }
            return String.valueOf(string) + string2;
        }
        if (string.equals("/")) {
            return String.valueOf(string) + string2;
        }
        return String.valueOf(string) + '/' + string2;
    }

    public native boolean setLastModifiedTime(File var1, long var2);

    public native boolean setReadOnly(File var1);
}

