/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.DataInput;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.io.UTFDataFormatException;

public class DataInputStream
extends FilterInputStream
implements DataInput {
    private char[] lineBuffer;

    public DataInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public final int read(byte[] byArray) throws IOException {
        return this.in.read(byArray, 0, byArray.length);
    }

    public final int read(byte[] byArray, int n, int n2) throws IOException {
        return this.in.read(byArray, n, n2);
    }

    public final boolean readBoolean() throws IOException {
        int n = this.in.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n != 0;
    }

    public final byte readByte() throws IOException {
        int n = this.in.read();
        if (n < 0) {
            throw new EOFException();
        }
        return (byte)n;
    }

    public final char readChar() throws IOException {
        int n;
        InputStream inputStream = this.in;
        int n2 = inputStream.read();
        if ((n2 | (n = inputStream.read())) < 0) {
            throw new EOFException();
        }
        return (char)((n2 << 8) + n);
    }

    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public final void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public final void readFully(byte[] byArray, int n, int n2) throws IOException {
        InputStream inputStream = this.in;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = inputStream.read(byArray, n + n3, n2 - n3);
            if (n4 < 0) {
                throw new EOFException();
            }
            n3 += n4;
        }
    }

    public final int readInt() throws IOException {
        int n;
        int n2;
        int n3;
        InputStream inputStream = this.in;
        int n4 = inputStream.read();
        if ((n4 | (n3 = inputStream.read()) | (n2 = inputStream.read()) | (n = inputStream.read())) < 0) {
            throw new EOFException();
        }
        return (n4 << 24) + (n3 << 16) + (n2 << 8) + n;
    }

    public final String readLine() throws IOException {
        int n;
        InputStream inputStream = this.in;
        char[] cArray = this.lineBuffer;
        if (cArray == null) {
            cArray = this.lineBuffer = new char[128];
        }
        int n2 = cArray.length;
        int n3 = 0;
        block4: while (true) {
            n = inputStream.read();
            switch (n) {
                case 13: {
                    int n4 = inputStream.read();
                    if (n4 == 10 || n4 == -1) break block4;
                    if (!(inputStream instanceof PushbackInputStream)) {
                        inputStream = this.in = new PushbackInputStream(inputStream);
                    }
                    ((PushbackInputStream)inputStream).unread(n4);
                    break block4;
                }
                default: {
                    if (--n2 < 0) {
                        cArray = new char[n3 + 128];
                        n2 = cArray.length - n3 - 1;
                        System.arraycopy(this.lineBuffer, 0, cArray, 0, n3);
                        this.lineBuffer = cArray;
                    }
                    cArray[n3++] = (char)n;
                    continue block4;
                }
                case -1: 
                case 10: 
            }
            break;
        }
        if (n == -1 && n3 == 0) {
            return null;
        }
        return String.copyValueOf(cArray, 0, n3);
    }

    public final long readLong() throws IOException {
        InputStream inputStream = this.in;
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    public final short readShort() throws IOException {
        int n;
        InputStream inputStream = this.in;
        int n2 = inputStream.read();
        if ((n2 | (n = inputStream.read())) < 0) {
            throw new EOFException();
        }
        return (short)((n2 << 8) + n);
    }

    public final String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    public static final String readUTF(DataInput dataInput) throws IOException {
        int n = dataInput.readUnsignedShort();
        char[] cArray = new char[n];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            int n4 = dataInput.readUnsignedByte();
            switch (n4 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++n2;
                    cArray[n3++] = (char)n4;
                    break;
                }
                case 12: 
                case 13: {
                    if ((n2 += 2) > n) {
                        throw new UTFDataFormatException();
                    }
                    int n5 = dataInput.readUnsignedByte();
                    if ((n5 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    cArray[n3++] = (char)((n4 & 0x1F) << 6 | n5 & 0x3F);
                    break;
                }
                case 14: {
                    if ((n2 += 3) > n) {
                        throw new UTFDataFormatException();
                    }
                    int n5 = dataInput.readUnsignedByte();
                    int n6 = dataInput.readUnsignedByte();
                    if ((n5 & 0xC0) != 128 || (n6 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    cArray[n3++] = (char)((n4 & 0xF) << 12 | (n5 & 0x3F) << 6 | n6 & 0x3F);
                    break;
                }
                default: {
                    throw new UTFDataFormatException();
                }
            }
        }
        return new String(cArray, 0, n3);
    }

    public final int readUnsignedByte() throws IOException {
        int n = this.in.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n;
    }

    public final int readUnsignedShort() throws IOException {
        int n;
        InputStream inputStream = this.in;
        int n2 = inputStream.read();
        if ((n2 | (n = inputStream.read())) < 0) {
            throw new EOFException();
        }
        return (n2 << 8) + n;
    }

    public final int skipBytes(int n) throws IOException {
        InputStream inputStream = this.in;
        int n2 = 0;
        int n3 = 0;
        while (n2 < n && (n3 = (int)inputStream.skip(n - n2)) > 0) {
            n2 += n3;
        }
        return n2;
    }
}

