/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import sun.java2d.loops.ImageData;

public class IndexColorModel
extends ColorModel {
    private int[] rgb = null;
    private int map_size = 0;
    private int transparent_index = -1;
    private boolean allgrayopaque;

    static {
        ColorModel.loadLibraries();
        IndexColorModel.initIDs();
    }

    public IndexColorModel(int n, int n2, byte[] byArray, int n3, boolean bl) {
        this(n, n2, byArray, n3, bl, -1);
        if (n < 1 || n > 32) {
            throw new IllegalArgumentException("Number of bits must be between 1 and 32.");
        }
    }

    public IndexColorModel(int n, int n2, byte[] byArray, int n3, boolean bl, int n4) {
        super(n, IndexColorModel.setBits(n, bl || n4 > -1), ColorSpace.getInstance(1000), bl || n4 > -1, false, bl ? 3 : (n4 >= 0 ? 2 : 1), ColorModel.getDefaultTransferType(n));
        if (n < 1 || n > 32) {
            throw new IllegalArgumentException("Number of bits must be between 1 and 32.");
        }
        if (n2 <= 1) {
            throw new IllegalArgumentException("Map size (" + n2 + ") must be >= 1");
        }
        this.map_size = n2;
        this.rgb = new int[Math.max(n2, 256)];
        int n5 = n3;
        int n6 = 255;
        this.transparency = 1;
        int n7 = 0;
        while (n7 < n2) {
            this.rgb[n7] = (byArray[n5++] & 0xFF) << 16 | (byArray[n5++] & 0xFF) << 8 | byArray[n5++] & 0xFF;
            if (bl && (n6 = byArray[n5++]) != 255 && this.transparency != 3) {
                this.transparency = n6 == 0 ? 2 : 3;
            }
            int n8 = n7++;
            this.rgb[n8] = this.rgb[n8] | n6 << 24;
        }
        this.setTransparentPixel(n4);
        if (this.transparent_index >= 0) {
            if (this.transparency == 1) {
                this.transparency = 2;
            }
        } else if (this.transparency == 1) {
            this.supportsAlpha = false;
            this.numComponents = 3;
        }
        if (this.supportsAlpha) {
            this.nBits = new int[4];
            this.nBits[3] = 8;
            this.nBits[2] = 8;
            this.nBits[1] = 8;
            this.nBits[0] = 8;
        } else {
            if (this.transparent_index > -1) {
                this.nBits = new int[4];
                this.nBits[3] = 1;
            } else {
                this.nBits = new int[3];
            }
            this.nBits[2] = 8;
            this.nBits[1] = 8;
            this.nBits[0] = 8;
        }
        this.checkAllGrayOpaque();
    }

    public IndexColorModel(int n, int n2, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        super(n, IndexColorModel.setBits(n, false), ColorSpace.getInstance(1000), false, false, 1, ColorModel.getDefaultTransferType(n));
        if (n < 1 || n > 32) {
            throw new IllegalArgumentException("Number of bits must be between 1 and 32.");
        }
        this.setRGBs(n2, byArray, byArray2, byArray3, null);
        this.checkAllGrayOpaque();
    }

    public IndexColorModel(int n, int n2, byte[] byArray, byte[] byArray2, byte[] byArray3, int n3) {
        super(n, IndexColorModel.setBits(n, n3 >= 0), ColorSpace.getInstance(1000), n3 > -1, false, 2, ColorModel.getDefaultTransferType(n));
        if (n < 1 || n > 32) {
            throw new IllegalArgumentException("Number of bits must be between 1 and 32.");
        }
        this.setRGBs(n2, byArray, byArray2, byArray3, null);
        if (n3 > -1) {
            this.transparency = 2;
            this.setTransparentPixel(n3);
        }
        this.checkAllGrayOpaque();
    }

    public IndexColorModel(int n, int n2, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        super(n, IndexColorModel.setBits(n, true), ColorSpace.getInstance(1000), true, false, 3, ColorModel.getDefaultTransferType(n));
        if (n < 1 || n > 32) {
            throw new IllegalArgumentException("Number of bits must be between 1 and 32.");
        }
        this.setRGBs(n2, byArray, byArray2, byArray3, byArray4);
        this.setTransparentPixel(-1);
        this.checkAllGrayOpaque();
    }

    public IndexColorModel(int n, int n2, int[] nArray, int n3, boolean bl, int n4, int n5) {
        super(n, IndexColorModel.setBits(n, bl), ColorSpace.getInstance(1000), bl ? true : n4 >= 0, false, bl ? 3 : (n4 >= 0 ? 2 : 1), ColorModel.getDefaultTransferType(n));
        if (n < 1 || n > 32) {
            throw new IllegalArgumentException("Number of bits must be between 1 and 32.");
        }
        if (n2 <= 1) {
            throw new IllegalArgumentException("Map size (" + n2 + ") must be >= 1");
        }
        this.map_size = n2;
        this.rgb = new int[Math.max(n2, 256)];
        int n6 = n3;
        int n7 = -16777216;
        this.transparency = 1;
        if (!bl) {
            int n8 = 0;
            while (n8 < n2) {
                this.rgb[n8] = nArray[n6] | 0xFF000000;
                ++n8;
                ++n6;
            }
        } else {
            int n9 = 0;
            while (n9 < n2) {
                this.rgb[n9] = nArray[n6];
                n7 = nArray[n6] & 0xFF000000;
                if (n7 != -16777216 && this.transparency != 3) {
                    this.transparency = n7 == 0 ? 2 : 3;
                }
                ++n9;
                ++n6;
            }
        }
        this.setTransparentPixel(n4);
        if (this.transparent_index >= 0 && this.transparency == 1) {
            this.transparency = 2;
        }
        this.checkAllGrayOpaque();
    }

    private void checkAllGrayOpaque() {
        this.allgrayopaque = false;
        if (this.transparent_index >= 0 || this.transparency == 3) {
            return;
        }
        int n = 0;
        while (n < this.map_size) {
            int n2 = this.rgb[n];
            if (n2 != 0) {
                if ((n2 & 0xFF000000) != -16777216) {
                    return;
                }
                if ((n2 >> 16 & 0xFF) != (n2 >> 8 & 0xFF) || (n2 >> 8 & 0xFF) != (n2 & 0xFF)) {
                    return;
                }
            }
            ++n;
        }
        this.allgrayopaque = true;
        this.transparency = 1;
    }

    public BufferedImage convertToIntDiscrete(Raster raster, boolean bl) {
        ColorModel colorModel = bl || this.transparency == 3 ? ColorModel.getRGBdefault() : (this.transparency == 2 ? new DirectColorModel(25, 0xFF0000, 65280, 255, 0x1000000) : new DirectColorModel(24, 0xFF0000, 65280, 255));
        int n = raster.getWidth();
        int n2 = raster.getHeight();
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(n, n2);
        Object object = null;
        int[] nArray = null;
        int n3 = raster.getMinX();
        int n4 = raster.getMinY();
        int n5 = 0;
        while (n5 < n2) {
            nArray = (object = raster.getDataElements(n3, n4, n, 1, object)) instanceof int[] ? (int[])object : DataBuffer.toIntArray(object);
            int n6 = 0;
            while (n6 < n) {
                nArray[n6] = this.rgb[nArray[n6]];
                ++n6;
            }
            writableRaster.setDataElements(0, n5, n, 1, nArray);
            ++n5;
            ++n4;
        }
        return new BufferedImage(colorModel, writableRaster, false, null);
    }

    public SampleModel createCompatibleSampleModel(int n, int n2) {
        int[] nArray = new int[]{0};
        return new ComponentSampleModel(this.transferType, n, n2, 1, n, nArray);
    }

    public WritableRaster createCompatibleWritableRaster(int n, int n2) {
        WritableRaster writableRaster;
        if (this.pixel_bits == 1 || this.pixel_bits == 2 || this.pixel_bits == 4) {
            writableRaster = Raster.createPackedRaster(0, n, n2, 1, this.pixel_bits, null);
        } else if (this.pixel_bits <= 8) {
            writableRaster = Raster.createInterleavedRaster(0, n, n2, 1, null);
        } else if (this.pixel_bits <= 16) {
            writableRaster = Raster.createInterleavedRaster(1, n, n2, 1, null);
        } else {
            throw new UnsupportedOperationException("This method is not supported  for pixel bits > 16.");
        }
        return writableRaster;
    }

    public void finalize() {
        ImageData.freeNativeICMData(this);
    }

    public final int getAlpha(int n) {
        return this.rgb[n] >> 24 & 0xFF;
    }

    public final void getAlphas(byte[] byArray) {
        int n = 0;
        while (n < this.map_size) {
            byArray[n] = (byte)(this.rgb[n] >> 24);
            ++n;
        }
    }

    public final int getBlue(int n) {
        return this.rgb[n] & 0xFF;
    }

    public final void getBlues(byte[] byArray) {
        int n = 0;
        while (n < this.map_size) {
            byArray[n] = (byte)this.rgb[n];
            ++n;
        }
    }

    public int[] getComponentSize() {
        if (this.nBits == null) {
            if (this.supportsAlpha) {
                this.nBits = new int[4];
                this.nBits[3] = 8;
            } else {
                this.nBits = new int[3];
            }
            this.nBits[2] = 8;
            this.nBits[1] = 8;
            this.nBits[0] = 8;
        }
        return this.nBits;
    }

    public int[] getComponents(int n, int[] nArray, int n2) {
        if (nArray == null) {
            nArray = new int[n2 + this.numComponents];
        }
        nArray[n2] = this.getRed(n);
        nArray[n2 + 1] = this.getGreen(n);
        nArray[n2 + 2] = this.getBlue(n);
        if (this.supportsAlpha && nArray.length - n2 > 3) {
            nArray[n2 + 3] = this.getAlpha(n);
        }
        return nArray;
    }

    public int[] getComponents(Object object, int[] nArray, int n) {
        int n2;
        switch (this.transferType) {
            case 0: {
                byte[] byArray = (byte[])object;
                n2 = byArray[0] & 0xFF;
                break;
            }
            case 1: {
                short[] sArray = (short[])object;
                n2 = sArray[0] & 0xFFFF;
                break;
            }
            case 3: {
                int[] nArray2 = (int[])object;
                n2 = nArray2[0];
                break;
            }
            default: {
                throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
            }
        }
        return this.getComponents(n2, nArray, n);
    }

    public int getDataElement(int[] nArray, int n) {
        int n2;
        int n3 = nArray[n] << 16 | nArray[n + 1] << 8 | nArray[n + 2];
        n3 = this.supportsAlpha ? (n3 |= nArray[n + 3] << 24) : (n3 |= 0xFF000000);
        Object object = this.getDataElements(n3, null);
        switch (this.transferType) {
            case 0: {
                byte[] byArray = (byte[])object;
                n2 = byArray[0] & 0xFF;
                break;
            }
            case 1: {
                short[] sArray = (short[])object;
                n2 = sArray[0];
                break;
            }
            case 3: {
                int[] nArray2 = (int[])object;
                n2 = nArray2[0];
                break;
            }
            default: {
                throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
            }
        }
        return n2;
    }

    public Object getDataElements(int n, Object object) {
        int n2;
        int n3 = n >> 16 & 0xFF;
        int n4 = n >> 8 & 0xFF;
        int n5 = n & 0xFF;
        int n6 = n >>> 24;
        int n7 = 0;
        if (n6 == 0) {
            if (this.transparent_index > -1) {
                n7 = this.transparent_index;
            } else {
                n2 = 0;
                while (n2 < this.map_size) {
                    if (this.rgb[n2] < 0x1000000) {
                        this.transparent_index = n2;
                        n7 = n2;
                        break;
                    }
                    ++n2;
                }
            }
        } else {
            n2 = 16581375;
            int n8 = 255;
            int n9 = 0;
            while (n9 < this.map_size) {
                int n10 = this.rgb[n9];
                int n11 = (n10 >>> 24) - n6;
                if (n11 < 0) {
                    n11 = -n11;
                }
                if (n11 <= n8) {
                    n8 = n11;
                    n11 = (n10 >> 16 & 0xFF) - n3;
                    int n12 = n11 * n11;
                    if (n12 < n2 && (n12 += (n11 = (n10 >> 8 & 0xFF) - n4) * n11) < n2 && (n12 += (n11 = (n10 & 0xFF) - n5) * n11) < n2) {
                        n7 = n9;
                        n2 = n12;
                    }
                }
                ++n9;
            }
        }
        boolean bl = n3 == n4 && n4 == n5;
        switch (this.transferType) {
            case 3: {
                int[] nArray;
                if (object == null) {
                    nArray = new int[1];
                    object = nArray;
                } else {
                    nArray = (int[])object;
                }
                nArray[0] = n7;
                break;
            }
            case 0: {
                byte[] byArray;
                if (object == null) {
                    byArray = new byte[1];
                    object = byArray;
                } else {
                    byArray = (byte[])object;
                }
                byArray[0] = (byte)n7;
                break;
            }
            case 1: {
                short[] sArray;
                if (object == null) {
                    sArray = new short[1];
                    object = sArray;
                } else {
                    sArray = (short[])object;
                }
                sArray[0] = (short)n7;
                break;
            }
            default: {
                throw new IllegalArgumentException("This method has not been implemented for transferType " + this.transferType);
            }
        }
        return object;
    }

    public Object getDataElements(int[] nArray, int n, Object object) {
        int n2 = nArray[n] << 16 | nArray[n + 1] << 8 | nArray[n + 2];
        n2 = this.supportsAlpha ? (n2 |= nArray[n + 3] << 24) : (n2 &= 0xFF000000);
        return this.getDataElements(n2, object);
    }

    public final int getGreen(int n) {
        return this.rgb[n] >> 8 & 0xFF;
    }

    public final void getGreens(byte[] byArray) {
        int n = 0;
        while (n < this.map_size) {
            byArray[n] = (byte)(this.rgb[n] >> 8);
            ++n;
        }
    }

    public final int getMapSize() {
        return this.map_size;
    }

    public final int getRGB(int n) {
        return this.rgb[n];
    }

    public final void getRGBs(int[] nArray) {
        System.arraycopy(this.rgb, 0, nArray, 0, this.map_size);
    }

    public final int getRed(int n) {
        return this.rgb[n] >> 16 & 0xFF;
    }

    public final void getReds(byte[] byArray) {
        int n = 0;
        while (n < this.map_size) {
            byArray[n] = (byte)(this.rgb[n] >> 16);
            ++n;
        }
    }

    public int getTransparency() {
        return this.transparency;
    }

    public final int getTransparentPixel() {
        return this.transparent_index;
    }

    private static native void initIDs();

    public boolean isCompatibleRaster(Raster raster) {
        int n = raster.getSampleModel().getSampleSize(0);
        return raster.getTransferType() == this.transferType && raster.getNumBands() == 1 && 1 << n >= this.map_size;
    }

    public boolean isCompatibleSampleModel(SampleModel sampleModel) {
        if (!(sampleModel instanceof ComponentSampleModel)) {
            return false;
        }
        if (sampleModel.getTransferType() != this.transferType) {
            return false;
        }
        return this.numComponents == sampleModel.getNumBands();
    }

    private static int[] setBits(int n, boolean bl) {
        int[] nArray = new int[3 + (bl ? 1 : 0)];
        nArray[2] = 8;
        nArray[1] = 8;
        nArray[0] = 8;
        if (bl) {
            nArray[3] = 8;
        }
        return nArray;
    }

    private void setRGBs(int n, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        if (n < 1) {
            throw new IllegalArgumentException("Map size (" + n + ") must be >= 1");
        }
        this.map_size = n;
        this.rgb = new int[Math.max(n, 256)];
        int n2 = 255;
        this.transparency = 1;
        int n3 = 0;
        while (n3 < n) {
            if (byArray4 != null && (n2 = byArray4[n3] & 0xFF) != 255 && this.transparency != 3) {
                this.transparency = n2 == 0 ? 2 : 3;
            }
            this.rgb[n3] = n2 << 24 | (byArray[n3] & 0xFF) << 16 | (byArray2[n3] & 0xFF) << 8 | byArray3[n3] & 0xFF;
            ++n3;
        }
        this.nBits = new int[4];
        this.nBits[3] = 8;
        this.nBits[2] = 8;
        this.nBits[1] = 8;
        this.nBits[0] = 8;
        this.maxBits = 8;
    }

    private void setTransparentPixel(int n) {
        if (n >= this.map_size || n < 0) {
            n = -1;
        } else {
            int n2 = n;
            this.rgb[n2] = this.rgb[n2] & 0xFFFFFF;
        }
        this.transparent_index = n;
    }

    public String toString() {
        return new String("IndexColorModel: #pixelBits = " + this.pixel_bits + " numComponents = " + this.numComponents + " color space = " + this.colorSpace + " transparency = " + this.transparency + " transIndex   = " + this.transparent_index + " has alpha = " + this.supportsAlpha + " isAlphaPre = " + this.isAlphaPremultiplied);
    }
}

