/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import sun.awt.Albert.AreaPathIterator;
import sun.awt.Albert.MAreaGeometry;
import sun.awt.Albert.TCAGRoot;
import sun.awt.Albert.TEllipseGeometry;
import sun.awt.Albert.TGCurve;
import sun.awt.Albert.TGEllipse;
import sun.awt.Albert.TGLoop;
import sun.awt.Albert.TGPoint;
import sun.awt.Albert.TGPolygon;
import sun.awt.Albert.TGRect;
import sun.awt.Albert.TGrafMatrix;
import sun.awt.Albert.TLoopGeometry;
import sun.awt.Albert.TOutlineMakerVertexEngine;
import sun.awt.Albert.TPathExtractor;
import sun.awt.Albert.TPolygonGeometry;
import sun.awt.Albert.TRectGeometry;
import sun.awt.Albert.TSamplingExtractor;

public class Area
implements Shape,
Cloneable {
    private MAreaGeometry fGeometry = null;
    private TGLoop fCachedPath = null;
    private double fCachedTimeStamp = 0.0;
    private boolean fCachedVertices = false;

    public Area() {
    }

    public Area(Shape shape) {
        if (shape == null) {
            return;
        }
        if (shape instanceof Rectangle2D) {
            TGRect tGRect = new TGRect((RectangularShape)shape);
            this.fGeometry = new TRectGeometry(tGRect);
            return;
        }
        if (shape instanceof Ellipse2D) {
            TGRect tGRect = new TGRect((RectangularShape)shape);
            this.fGeometry = new TEllipseGeometry(new TGEllipse(tGRect));
            return;
        }
        if (shape instanceof Polygon) {
            TGPolygon tGPolygon = new TGPolygon((Polygon)shape);
            this.fGeometry = tGPolygon.getNumberOfPoints() == 4 && tGPolygon.isRectilinear() && tGPolygon.getPoint(0).equals(tGPolygon.getPoint(2)) && tGPolygon.getPoint(1).equals(tGPolygon.getPoint(3)) ? new TRectGeometry(tGPolygon.getBounds()) : new TPolygonGeometry(tGPolygon);
            return;
        }
        if (shape instanceof Area) {
            MAreaGeometry mAreaGeometry = ((Area)shape).fGeometry;
            if (mAreaGeometry != null) {
                this.fGeometry = (MAreaGeometry)mAreaGeometry.clone();
            }
            return;
        }
        TGCurve tGCurve = new TGCurve();
        double[] dArray = new double[6];
        TGPoint tGPoint = new TGPoint();
        TGPoint tGPoint2 = new TGPoint();
        TGPoint tGPoint3 = new TGPoint();
        TGPoint tGPoint4 = null;
        PathIterator pathIterator = shape.getPathIterator(null);
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(dArray)) {
                default: {
                    tGPoint2.x = dArray[0];
                    tGPoint2.y = dArray[1];
                    tGPoint.copyFrom(tGPoint2);
                    break;
                }
                case 1: {
                    tGPoint3.x = dArray[0];
                    tGPoint3.y = dArray[1];
                    tGCurve.concatenate(new TGCurve(tGPoint2, tGPoint3));
                    tGPoint4 = tGPoint2;
                    tGPoint2 = tGPoint3;
                    tGPoint3 = tGPoint4;
                    break;
                }
                case 2: {
                    tGPoint3.x = dArray[2];
                    tGPoint3.y = dArray[3];
                    tGPoint4 = new TGPoint(dArray[0], dArray[1]);
                    tGCurve.concatenate(new TGCurve(tGPoint2, tGPoint4, tGPoint3));
                    tGPoint4 = tGPoint2;
                    tGPoint2 = tGPoint3;
                    tGPoint3 = tGPoint4;
                    break;
                }
                case 3: {
                    tGPoint3.x = dArray[4];
                    tGPoint3.y = dArray[5];
                    tGPoint4 = new TGPoint(dArray[0], dArray[1]);
                    TGPoint tGPoint5 = new TGPoint(dArray[2], dArray[3]);
                    tGCurve.concatenate(new TGCurve(tGPoint2, tGPoint4, tGPoint5, tGPoint3));
                    tGPoint4 = tGPoint2;
                    tGPoint2 = tGPoint3;
                    tGPoint3 = tGPoint4;
                    break;
                }
                case 4: {
                    if (tGPoint.equals(tGPoint2)) break;
                    tGCurve.concatenate(new TGCurve(tGPoint2, tGPoint));
                    tGPoint2.copyFrom(tGPoint);
                    break;
                }
            }
            pathIterator.next();
        }
        boolean bl = pathIterator.getWindingRule() == 0;
        TGLoop tGLoop = new TGLoop(tGCurve, bl);
        this.fGeometry = new TLoopGeometry(tGLoop);
    }

    Area(MAreaGeometry mAreaGeometry) {
        this.fGeometry = mAreaGeometry;
    }

    public void add(Area area) {
        MAreaGeometry mAreaGeometry = area.fGeometry;
        if (this.fGeometry == null) {
            if (mAreaGeometry != null) {
                this.fGeometry = mAreaGeometry;
            }
        } else if (mAreaGeometry != null) {
            this.fGeometry = MAreaGeometry.add(this.fGeometry, mAreaGeometry);
        }
    }

    public Object clone() {
        return new Area(this.fGeometry);
    }

    public boolean contains(double d, double d2) {
        TGPoint tGPoint = new TGPoint(d, d2);
        return this.fGeometry != null && this.fGeometry.contains(tGPoint);
    }

    public boolean contains(double d, double d2, double d3, double d4) {
        TGRect tGRect = new TGRect(d, d2, d + d3, d2 + d4);
        return this.fGeometry != null && this.fGeometry.contains(tGRect);
    }

    public boolean contains(Point2D point2D) {
        TGPoint tGPoint = new TGPoint(point2D);
        return this.fGeometry != null && this.fGeometry.contains(tGPoint);
    }

    public boolean contains(Rectangle2D rectangle2D) {
        TGRect tGRect = new TGRect(rectangle2D);
        return this.fGeometry != null && this.fGeometry.contains(tGRect);
    }

    public Area createTransformedArea(AffineTransform affineTransform) {
        Area area = new Area(this);
        area.transform(affineTransform);
        return area;
    }

    public boolean equals(Area area) {
        MAreaGeometry mAreaGeometry = area.fGeometry;
        return this.fGeometry != null && mAreaGeometry != null && this.fGeometry.equals(mAreaGeometry);
    }

    public void exclusiveOr(Area area) {
        MAreaGeometry mAreaGeometry = area.fGeometry;
        if (mAreaGeometry != null) {
            this.fGeometry = this.fGeometry == null ? mAreaGeometry : MAreaGeometry.exclusiveOr(this.fGeometry, mAreaGeometry);
        }
    }

    TGLoop extract(double d) {
        TGLoop tGLoop = null;
        long l = this.getTimeStamp();
        if (this.fGeometry != null) {
            boolean bl;
            boolean bl2 = bl = d != Double.POSITIVE_INFINITY || this.fGeometry.isPolygonal();
            if (this.fCachedPath != null && this.fCachedTimeStamp == (double)l && this.fCachedVertices == bl) {
                return this.fCachedPath;
            }
            if (bl) {
                tGLoop = new TGLoop();
                TOutlineMakerVertexEngine tOutlineMakerVertexEngine = new TOutlineMakerVertexEngine(tGLoop);
                TSamplingExtractor tSamplingExtractor = new TSamplingExtractor(tOutlineMakerVertexEngine, d);
                TCAGRoot tCAGRoot = new TCAGRoot();
                this.fGeometry.extract(tSamplingExtractor, tCAGRoot);
                tSamplingExtractor.render(tCAGRoot);
            } else {
                TPathExtractor tPathExtractor = new TPathExtractor();
                TCAGRoot tCAGRoot = new TCAGRoot();
                this.fGeometry.extract(tPathExtractor, tCAGRoot);
                tPathExtractor.render(tCAGRoot);
                tGLoop = tPathExtractor.getPath();
            }
            this.fCachedTimeStamp = l;
            this.fCachedVertices = bl;
            this.fCachedPath = tGLoop;
        }
        return tGLoop;
    }

    public Rectangle getBounds() {
        return this.internalGetBounds().getBounds();
    }

    public Rectangle2D getBounds2D() {
        return this.internalGetBounds();
    }

    public PathIterator getPathIterator(AffineTransform affineTransform) {
        return this.getPathIterator(affineTransform, 0.01);
    }

    public PathIterator getPathIterator(AffineTransform affineTransform, double d) {
        if (affineTransform == null || affineTransform.isIdentity()) {
            return new AreaPathIterator(this.extract(d));
        }
        return new AreaPathIterator(this.createTransformedArea(affineTransform).extract(d));
    }

    long getTimeStamp() {
        if (this.fGeometry == null) {
            return 0L;
        }
        return this.fGeometry.getTimeStamp();
    }

    TGRect internalGetBounds() {
        if (this.fGeometry != null) {
            TGRect tGRect = this.fGeometry.getBounds();
            return new TGRect(tGRect);
        }
        return new TGRect(0.0, 0.0, 0.0, 0.0);
    }

    public void intersect(Area area) {
        if (this.fGeometry != null) {
            MAreaGeometry mAreaGeometry = area.fGeometry;
            this.fGeometry = mAreaGeometry == null ? mAreaGeometry : MAreaGeometry.intersect(this.fGeometry, mAreaGeometry);
        }
    }

    public boolean intersects(double d, double d2, double d3, double d4) {
        TGRect tGRect = new TGRect(d, d2, d + d3, d2 + d4);
        return this.fGeometry != null && (this.fGeometry.intersects(tGRect) || this.fGeometry.contains(tGRect));
    }

    public boolean intersects(Rectangle2D rectangle2D) {
        TGRect tGRect = new TGRect(rectangle2D);
        return this.fGeometry != null && this.fGeometry.intersects(tGRect);
    }

    public boolean isEmpty() {
        return this.fGeometry == null || this.fGeometry.isEmpty() || this.getPathIterator(null).isDone();
    }

    public boolean isPolygonal() {
        return this.fGeometry == null || this.fGeometry.isPolygonal();
    }

    public boolean isRectangular() {
        return this.fGeometry == null || this.fGeometry.isRectangular();
    }

    public boolean isSingular() {
        return this.fGeometry == null || this.fGeometry.isSingular();
    }

    public void reset() {
        this.fGeometry = null;
    }

    public void subtract(Area area) {
        MAreaGeometry mAreaGeometry;
        if (this.fGeometry != null && (mAreaGeometry = area.fGeometry) != null) {
            this.fGeometry = MAreaGeometry.subtract(this.fGeometry, mAreaGeometry);
        }
    }

    public void transform(AffineTransform affineTransform) {
        TGrafMatrix tGrafMatrix = new TGrafMatrix(affineTransform);
        if (this.fGeometry != null && !tGrafMatrix.isIdentity()) {
            this.fGeometry = this.fGeometry.cloneAndTransform(tGrafMatrix);
        }
    }
}

