/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Dimension;
import java.awt.TextComponent;
import java.awt.Toolkit;
import java.awt.peer.TextAreaPeer;

public class TextArea
extends TextComponent {
    int rows;
    int columns;
    private static final String base = "text";
    private static int nameCounter = 0;
    public static final int SCROLLBARS_BOTH = 0;
    public static final int SCROLLBARS_VERTICAL_ONLY = 1;
    public static final int SCROLLBARS_HORIZONTAL_ONLY = 2;
    public static final int SCROLLBARS_NONE = 3;
    private int scrollbarVisibility;
    private static final long serialVersionUID = 3692302836626095722L;

    static {
        Toolkit.loadLibraries();
        TextArea.initIDs();
    }

    public TextArea() {
        this("", 0, 0, 0);
    }

    public TextArea(int n, int n2) {
        this("", n, n2, 0);
    }

    public TextArea(String string) {
        this(string, 0, 0, 0);
    }

    public TextArea(String string, int n, int n2) {
        this(string, n, n2, 0);
    }

    public TextArea(String string, int n, int n2, int n3) {
        super(string);
        this.rows = n;
        this.columns = n2;
        this.scrollbarVisibility = n3 >= 0 && n3 <= 3 ? n3 : 0;
    }

    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.peer == null) {
                this.peer = this.getToolkit().createTextArea(this);
            }
            super.addNotify();
        }
    }

    public void append(String string) {
        this.appendText(string);
    }

    public synchronized void appendText(String string) {
        if (this.peer != null) {
            this.insertText(string, this.getText().length());
        } else {
            this.text = String.valueOf(this.text) + string;
        }
    }

    String constructComponentName() {
        Class clazz = this.getClass();
        synchronized (clazz) {
            String string = base + nameCounter++;
            Object var3_3 = null;
            return string;
        }
    }

    public int getColumns() {
        return this.columns;
    }

    public Dimension getMinimumSize() {
        return this.minimumSize();
    }

    public Dimension getMinimumSize(int n, int n2) {
        return this.minimumSize(n, n2);
    }

    public Dimension getPreferredSize() {
        return this.preferredSize();
    }

    public Dimension getPreferredSize(int n, int n2) {
        return this.preferredSize(n, n2);
    }

    public int getRows() {
        return this.rows;
    }

    public int getScrollbarVisibility() {
        return this.scrollbarVisibility;
    }

    private static native void initIDs();

    public void insert(String string, int n) {
        this.insertText(string, n);
    }

    public synchronized void insertText(String string, int n) {
        TextAreaPeer textAreaPeer = (TextAreaPeer)this.peer;
        if (textAreaPeer != null) {
            textAreaPeer.insertText(string, n);
        } else {
            this.text = String.valueOf(this.text.substring(0, n)) + string + this.text.substring(n);
        }
    }

    public Dimension minimumSize() {
        Object object = this.getTreeLock();
        synchronized (object) {
            Dimension dimension = this.rows > 0 && this.columns > 0 ? this.minimumSize(this.rows, this.columns) : super.minimumSize();
            Object var3_3 = null;
            return dimension;
        }
    }

    public Dimension minimumSize(int n, int n2) {
        Object object = this.getTreeLock();
        synchronized (object) {
            TextAreaPeer textAreaPeer = (TextAreaPeer)this.peer;
            Dimension dimension = textAreaPeer != null ? textAreaPeer.minimumSize(n, n2) : super.minimumSize();
            Object var5_6 = null;
            return dimension;
        }
    }

    protected String paramString() {
        String string;
        switch (this.scrollbarVisibility) {
            case 0: {
                string = "both";
                break;
            }
            case 1: {
                string = "vertical-only";
                break;
            }
            case 2: {
                string = "horizontal-only";
                break;
            }
            case 3: {
                string = "none";
                break;
            }
            default: {
                string = "invalid display policy";
            }
        }
        return String.valueOf(super.paramString()) + ",rows=" + this.rows + ",columns=" + this.columns + ", scrollbarVisibility=" + string;
    }

    public Dimension preferredSize() {
        Object object = this.getTreeLock();
        synchronized (object) {
            Dimension dimension = this.rows > 0 && this.columns > 0 ? this.preferredSize(this.rows, this.columns) : super.preferredSize();
            Object var3_3 = null;
            return dimension;
        }
    }

    public Dimension preferredSize(int n, int n2) {
        Object object = this.getTreeLock();
        synchronized (object) {
            TextAreaPeer textAreaPeer = (TextAreaPeer)this.peer;
            Dimension dimension = textAreaPeer != null ? textAreaPeer.preferredSize(n, n2) : super.preferredSize();
            Object var5_6 = null;
            return dimension;
        }
    }

    public void replaceRange(String string, int n, int n2) {
        this.replaceText(string, n, n2);
    }

    public synchronized void replaceText(String string, int n, int n2) {
        TextAreaPeer textAreaPeer = (TextAreaPeer)this.peer;
        if (textAreaPeer != null) {
            textAreaPeer.replaceText(string, n, n2);
        } else {
            this.text = String.valueOf(this.text.substring(0, n)) + string + this.text.substring(n2);
        }
    }

    public void setColumns(int n) {
        int n2 = this.columns;
        if (n < 0) {
            throw new IllegalArgumentException("columns less than zero.");
        }
        if (n != n2) {
            this.columns = n;
            this.invalidate();
        }
    }

    public void setRows(int n) {
        int n2 = this.rows;
        if (n < 0) {
            throw new IllegalArgumentException("rows less than zero.");
        }
        if (n != n2) {
            this.rows = n;
            this.invalidate();
        }
    }
}

