/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public class Polygon
implements Shape,
Serializable {
    public int npoints = 0;
    public int[] xpoints = new int[4];
    public int[] ypoints = new int[4];
    protected Rectangle bounds = null;
    private static final long serialVersionUID = -6460061437900069969L;

    public Polygon() {
    }

    public Polygon(int[] nArray, int[] nArray2, int n) {
        this.npoints = n;
        this.xpoints = new int[n];
        this.ypoints = new int[n];
        System.arraycopy(nArray, 0, this.xpoints, 0, n);
        System.arraycopy(nArray2, 0, this.ypoints, 0, n);
    }

    public void addPoint(int n, int n2) {
        if (this.npoints == this.xpoints.length) {
            int[] nArray = new int[this.npoints * 2];
            System.arraycopy(this.xpoints, 0, nArray, 0, this.npoints);
            this.xpoints = nArray;
            nArray = new int[this.npoints * 2];
            System.arraycopy(this.ypoints, 0, nArray, 0, this.npoints);
            this.ypoints = nArray;
        }
        this.xpoints[this.npoints] = n;
        this.ypoints[this.npoints] = n2;
        ++this.npoints;
        if (this.bounds != null) {
            this.updateBounds(n, n2);
        }
    }

    void calculateBounds(int[] nArray, int[] nArray2, int n) {
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MIN_VALUE;
        int n5 = Integer.MIN_VALUE;
        int n6 = 0;
        while (n6 < n) {
            int n7 = nArray[n6];
            n2 = Math.min(n2, n7);
            n4 = Math.max(n4, n7);
            int n8 = nArray2[n6];
            n3 = Math.min(n3, n8);
            n5 = Math.max(n5, n8);
            ++n6;
        }
        this.bounds = new Rectangle(n2, n3, n4 - n2, n5 - n3);
    }

    public boolean contains(double d, double d2) {
        if (this.getBoundingBox().contains(d, d2)) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            while (n3 < this.npoints && (double)this.ypoints[n3] == d2) {
                ++n3;
            }
            int n4 = 0;
            while (n4 < this.npoints) {
                int n5 = (n3 + 1) % this.npoints;
                int n6 = this.xpoints[n5] - this.xpoints[n3];
                int n7 = this.ypoints[n5] - this.ypoints[n3];
                if (n7 != 0) {
                    double d3;
                    double d4 = d - (double)this.xpoints[n3];
                    double d5 = d2 - (double)this.ypoints[n3];
                    if ((double)this.ypoints[n5] == d2 && (double)this.xpoints[n5] >= d) {
                        n2 = this.ypoints[n3];
                    }
                    if ((double)this.ypoints[n3] == d2 && (double)this.xpoints[n3] >= d && (double)n2 > d2 != (double)this.ypoints[n5] > d2) {
                        --n;
                    }
                    if ((d3 = d5 / (double)n7) >= 0.0 && d3 <= 1.0 && d3 * (double)n6 >= d4) {
                        ++n;
                    }
                }
                n3 = n5;
                ++n4;
            }
            return n % 2 != 0;
        }
        return false;
    }

    public boolean contains(double d, double d2, double d3, double d4) {
        return new Area(this).contains(d, d2, d3, d4);
    }

    public boolean contains(int n, int n2) {
        return this.contains((double)n, (double)n2);
    }

    public boolean contains(Point point) {
        return this.contains(point.x, point.y);
    }

    public boolean contains(Point2D point2D) {
        return this.contains(point2D.getX(), point2D.getY());
    }

    public boolean contains(Rectangle2D rectangle2D) {
        return this.contains(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public Rectangle getBoundingBox() {
        if (this.bounds == null) {
            this.calculateBounds(this.xpoints, this.ypoints, this.npoints);
        }
        return this.bounds;
    }

    public Rectangle getBounds() {
        return this.getBoundingBox();
    }

    public Rectangle2D getBounds2D() {
        Rectangle rectangle = this.getBounds();
        return new Rectangle2D.Float(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public PathIterator getPathIterator(AffineTransform affineTransform) {
        return new PolygonPathIterator(this, affineTransform);
    }

    public PathIterator getPathIterator(AffineTransform affineTransform, double d) {
        return this.getPathIterator(affineTransform);
    }

    public boolean inside(int n, int n2) {
        return this.contains((double)n, (double)n2);
    }

    public boolean intersects(double d, double d2, double d3, double d4) {
        return new Area(this).intersects(d, d2, d3, d4);
    }

    public boolean intersects(Rectangle2D rectangle2D) {
        return this.intersects(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public void translate(int n, int n2) {
        int n3 = 0;
        while (n3 < this.npoints) {
            int n4 = n3;
            this.xpoints[n4] = this.xpoints[n4] + n;
            int n5 = n3++;
            this.ypoints[n5] = this.ypoints[n5] + n2;
        }
        if (this.bounds != null) {
            this.bounds.translate(n, n2);
        }
    }

    void updateBounds(int n, int n2) {
        if (n < this.bounds.x) {
            this.bounds.width += this.bounds.x - n;
            this.bounds.x = n;
        } else {
            this.bounds.width = Math.max(this.bounds.width, n - this.bounds.x);
        }
        if (n2 < this.bounds.y) {
            this.bounds.height += this.bounds.y - n2;
            this.bounds.y = n2;
        } else {
            this.bounds.height = Math.max(this.bounds.height, n2 - this.bounds.y);
        }
    }

    class PolygonPathIterator
    implements PathIterator {
        Polygon poly;
        AffineTransform transform;
        int index;

        public PolygonPathIterator(Polygon polygon2, AffineTransform affineTransform) {
            this.poly = polygon2;
            this.transform = affineTransform;
        }

        public int currentSegment(double[] dArray) {
            if (this.index >= this.poly.npoints) {
                return 4;
            }
            dArray[0] = this.poly.xpoints[this.index];
            dArray[1] = this.poly.ypoints[this.index];
            if (this.transform != null) {
                this.transform.transform(dArray, 0, dArray, 0, 1);
            }
            return this.index == 0 ? 0 : 1;
        }

        public int currentSegment(float[] fArray) {
            if (this.index >= this.poly.npoints) {
                return 4;
            }
            fArray[0] = this.poly.xpoints[this.index];
            fArray[1] = this.poly.ypoints[this.index];
            if (this.transform != null) {
                this.transform.transform(fArray, 0, fArray, 0, 1);
            }
            return this.index == 0 ? 0 : 1;
        }

        public int getWindingRule() {
            return 0;
        }

        public boolean isDone() {
            return this.index > this.poly.npoints;
        }

        public void next() {
            ++this.index;
        }
    }
}

