/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Color;
import java.awt.GradientPaintContext;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;

public class GradientPaint
implements Paint {
    Point2D.Float p1;
    Point2D.Float p2;
    Color color1;
    Color color2;
    boolean cyclic;

    public GradientPaint(float f, float f2, Color color, float f3, float f4, Color color2) {
        this.p1 = new Point2D.Float(f, f2);
        this.p2 = new Point2D.Float(f3, f4);
        this.color1 = color;
        this.color2 = color2;
    }

    public GradientPaint(float f, float f2, Color color, float f3, float f4, Color color2, boolean bl) {
        this(f, f2, color, f3, f4, color2);
        this.cyclic = bl;
    }

    public GradientPaint(Point2D point2D, Color color, Point2D point2D2, Color color2) {
        this.p1 = new Point2D.Float((float)point2D.getX(), (float)point2D.getY());
        this.p2 = new Point2D.Float((float)point2D2.getX(), (float)point2D2.getY());
        this.color1 = color;
        this.color2 = color2;
    }

    public GradientPaint(Point2D point2D, Color color, Point2D point2D2, Color color2, boolean bl) {
        this(point2D, color, point2D2, color2);
        this.cyclic = bl;
    }

    public PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
        Point2D point2D = affineTransform.transform(this.p1, null);
        Point2D point2D2 = affineTransform.transform(this.p2, null);
        return new GradientPaintContext(point2D, point2D2, this.color1, this.color2, this.cyclic);
    }

    public Color getColor1() {
        return this.color1;
    }

    public Color getColor2() {
        return this.color2;
    }

    public Point2D getPoint1() {
        return new Point2D.Float(this.p1.x, this.p1.y);
    }

    public Point2D getPoint2() {
        return new Point2D.Float(this.p2.x, this.p2.y);
    }

    public int getTransparency() {
        int n;
        int n2 = this.color1.getAlpha();
        return (n2 & (n = this.color2.getAlpha())) == 255 ? 1 : 3;
    }

    public boolean isCyclic() {
        return this.cyclic;
    }
}

