/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.Component;
import java.awt.EventDispatchThread;
import java.awt.EventQueue;
import java.awt.EventQueueItem;
import java.awt.MenuComponent;
import java.awt.Toolkit;
import java.awt.event.InvocationEvent;
import java.awt.event.KeyEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.EmptyStackException;
import sun.awt.MagicEvent;

public class EventQueue {
    private static int threadInitNumber;
    private EventQueueItem queue = null;
    private EventQueueItem queueTail = null;
    private EventQueueItem lastPriorityItem = null;
    private EventQueue nextQueue;
    private EventQueue previousQueue;
    private EventDispatchThread dispatchThread;
    private static final boolean debug = false;

    public EventQueue() {
        String string = "AWT-EventQueue-" + EventQueue.nextThreadNum();
        this.dispatchThread = new EventDispatchThread(string, this);
        this.dispatchThread.setPriority(6);
        this.dispatchThread.start();
    }

    final synchronized void changeKeyEventFocus(Object object) {
        EventQueueItem eventQueueItem = this.queue;
        while (eventQueueItem != null) {
            if (eventQueueItem.event instanceof KeyEvent) {
                eventQueueItem.event.setSource(object);
            }
            eventQueueItem = eventQueueItem.next;
        }
    }

    protected void dispatchEvent(AWTEvent aWTEvent) {
        Object object = aWTEvent.getSource();
        if (aWTEvent instanceof ActiveEvent) {
            ((ActiveEvent)((Object)aWTEvent)).dispatch();
        } else if (object instanceof Component) {
            ((Component)object).dispatchEvent(aWTEvent);
        } else if (object instanceof MenuComponent) {
            ((MenuComponent)object).dispatchEvent(aWTEvent);
        } else {
            System.err.println("unable to dispatch event: " + aWTEvent);
        }
    }

    final EventDispatchThread getDispatchThread() {
        return this.dispatchThread;
    }

    public synchronized AWTEvent getNextEvent() throws InterruptedException {
        while (this.queue == null) {
            this.wait();
        }
        EventQueueItem eventQueueItem = this.queue;
        if (this.queue == this.lastPriorityItem) {
            this.lastPriorityItem = null;
        }
        this.queue = this.queue.next;
        if (this.queue == null) {
            this.queueTail = null;
        }
        return eventQueueItem.event;
    }

    public static void invokeAndWait(Runnable runnable) throws InterruptedException, InvocationTargetException {
        if (EventQueue.isDispatchThread()) {
            throw new Error("Cannot call invokeAndWait from the event dispatcher thread");
        }
        class AWTInvocationLock {
            AWTInvocationLock() {
            }
        }
        AWTInvocationLock aWTInvocationLock = new AWTInvocationLock();
        EventQueue eventQueue = Toolkit.getEventQueue();
        InvocationEvent invocationEvent = new InvocationEvent(Toolkit.getDefaultToolkit(), runnable, aWTInvocationLock, true);
        Object object = aWTInvocationLock;
        synchronized (object) {
            Toolkit.getEventQueue().postEvent(invocationEvent);
            aWTInvocationLock.wait();
        }
        object = invocationEvent.getException();
        if (object != null) {
            throw new InvocationTargetException((Throwable)object);
        }
    }

    public static void invokeLater(Runnable runnable) {
        Toolkit.getEventQueue().postEvent(new InvocationEvent((Object)Toolkit.getDefaultToolkit(), runnable));
    }

    public static boolean isDispatchThread() {
        EventQueue eventQueue = Toolkit.getEventQueue();
        EventQueue eventQueue2 = eventQueue.nextQueue;
        while (eventQueue2 != null) {
            eventQueue = eventQueue2;
            eventQueue2 = eventQueue.nextQueue;
        }
        return Thread.currentThread() == eventQueue.dispatchThread;
    }

    private static synchronized int nextThreadNum() {
        return threadInitNumber++;
    }

    public synchronized AWTEvent peekEvent() {
        return this.queue != null ? this.queue.event : null;
    }

    public synchronized AWTEvent peekEvent(int n) {
        EventQueueItem eventQueueItem = this.queue;
        while (eventQueueItem != null) {
            if (eventQueueItem.id == n) {
                return eventQueueItem.event;
            }
            eventQueueItem = eventQueueItem.next;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void pop() throws EmptyStackException {
        EventQueue eventQueue = this.previousQueue;
        EventQueue eventQueue2 = eventQueue != null ? eventQueue : this;
        synchronized (eventQueue2) {
            EventQueue eventQueue3 = this;
            synchronized (eventQueue3) {
                if (this.nextQueue != null) {
                    this.nextQueue.pop();
                    return;
                }
                if (this.previousQueue == null) {
                    throw new EmptyStackException();
                }
                this.previousQueue.nextQueue = null;
                while (this.peekEvent() != null) {
                    boolean bl = this.lastPriorityItem != null;
                    try {
                        this.previousQueue.postEvent(this.getNextEvent(), bl);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.previousQueue = null;
            }
        }
        this.dispatchThread.stopDispatching();
    }

    public synchronized void postEvent(AWTEvent aWTEvent) {
        long l;
        if (aWTEvent instanceof MagicEvent && ((l = ((MagicEvent)aWTEvent).getFlags()) & 1L) != 0L) {
            this.postEvent(aWTEvent, true);
            return;
        }
        this.postEvent(aWTEvent, false);
    }

    private void postEvent(AWTEvent aWTEvent, boolean bl) {
        if (this.nextQueue != null) {
            this.nextQueue.postEvent(aWTEvent);
            return;
        }
        Object object = aWTEvent.getSource();
        EventQueueItem eventQueueItem = new EventQueueItem(aWTEvent);
        if (this.queue == null) {
            this.queue = this.queueTail = eventQueueItem;
            if (bl) {
                this.lastPriorityItem = eventQueueItem;
            }
            this.notifyAll();
        } else {
            if (object instanceof Component) {
                EventQueueItem eventQueueItem2 = this.queue;
                while (true) {
                    AWTEvent aWTEvent2;
                    if (eventQueueItem2.id == eventQueueItem.id && eventQueueItem2.source == object && (aWTEvent2 = ((Component)object).coalesceEvents(eventQueueItem2.event, aWTEvent)) != null) {
                        eventQueueItem2.event = aWTEvent2;
                        return;
                    }
                    if (eventQueueItem2.next == null) break;
                    eventQueueItem2 = eventQueueItem2.next;
                }
            }
            if (bl && this.lastPriorityItem == null) {
                eventQueueItem.next = this.queue;
                this.queue = this.lastPriorityItem = eventQueueItem;
            } else if (bl && this.lastPriorityItem == this.queueTail) {
                this.queueTail.next = eventQueueItem;
                this.queueTail = this.lastPriorityItem = eventQueueItem;
            } else if (bl) {
                eventQueueItem.next = this.lastPriorityItem.next;
                this.lastPriorityItem.next = eventQueueItem;
                this.lastPriorityItem = eventQueueItem;
            } else {
                this.queueTail.next = eventQueueItem;
                this.queueTail = eventQueueItem;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void push(EventQueue eventQueue) {
        if (this.nextQueue != null) {
            this.nextQueue.push(eventQueue);
            return;
        }
        EventQueue eventQueue2 = eventQueue;
        synchronized (eventQueue2) {
            while (true) {
                if (this.peekEvent() == null) {
                    eventQueue.previousQueue = this;
                    break;
                }
                boolean bl = this.lastPriorityItem != null;
                try {
                    eventQueue.postEvent(this.getNextEvent(), bl);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.nextQueue = eventQueue;
    }

    final synchronized void removeSourceEvents(Object object) {
        EventQueueItem eventQueueItem = this.queue;
        EventQueueItem eventQueueItem2 = null;
        while (eventQueueItem != null) {
            if (eventQueueItem.source == object) {
                if (eventQueueItem == this.lastPriorityItem) {
                    this.lastPriorityItem = eventQueueItem2;
                }
                if (eventQueueItem2 == null) {
                    this.queue = eventQueueItem.next;
                } else {
                    eventQueueItem2.next = eventQueueItem.next;
                }
            } else {
                eventQueueItem2 = eventQueueItem;
            }
            eventQueueItem = eventQueueItem.next;
        }
        this.queueTail = eventQueueItem2;
    }

    synchronized void removeSourceEvents(Object object, int n) {
        EventQueueItem eventQueueItem = this.queue;
        EventQueueItem eventQueueItem2 = null;
        while (eventQueueItem != null) {
            if (eventQueueItem.event.getSource().equals(object) && eventQueueItem.id == n) {
                if (eventQueueItem2 == null) {
                    this.queue = eventQueueItem.next;
                } else {
                    eventQueueItem2.next = eventQueueItem.next;
                }
            }
            eventQueueItem2 = eventQueueItem;
            eventQueueItem = eventQueueItem.next;
        }
    }
}

