/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.EventQueue;

class EventDispatchThread
extends Thread {
    private EventQueue theQueue;
    private boolean doDispatch = true;

    EventDispatchThread(String string, EventQueue eventQueue) {
        super(string);
        this.theQueue = eventQueue;
    }

    EventQueue getEventQueue() {
        return this.theQueue;
    }

    boolean isDispatching(EventQueue eventQueue) {
        return this.theQueue.equals(eventQueue);
    }

    public void run() {
        while (this.doDispatch && !this.isInterrupted()) {
            try {
                AWTEvent aWTEvent = this.theQueue.getNextEvent();
                this.theQueue.dispatchEvent(aWTEvent);
            }
            catch (ThreadDeath threadDeath) {
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            catch (Throwable throwable) {
                System.err.println("Exception occurred during event dispatching:");
                throwable.printStackTrace();
            }
        }
    }

    public void stopDispatching() {
        block2: {
            this.doDispatch = false;
            this.theQueue.postEvent(new EmptyEvent());
            if (Thread.currentThread() == this) break block2;
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    class EmptyEvent
    extends AWTEvent
    implements ActiveEvent {
        public EmptyEvent() {
            super(EventDispatchThread.this, 0);
        }

        public void dispatch() {
        }
    }
}

