/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.peer.DialogPeer;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class Dialog
extends Window {
    boolean resizable = true;
    boolean modal;
    String title;
    private static final String base = "dialog";
    private static int nameCounter;
    private static final long serialVersionUID = 5920926903803293709L;

    static {
        Toolkit.loadLibraries();
        Dialog.initIDs();
        nameCounter = 0;
    }

    public Dialog(Dialog dialog) {
        this(dialog, "", false);
    }

    public Dialog(Dialog dialog, String string) {
        this(dialog, string, false);
    }

    public Dialog(Dialog dialog, String string, boolean bl) {
        super(dialog);
        if (dialog == null) {
            throw new IllegalArgumentException("null owner dialog");
        }
        this.title = string;
        this.modal = bl;
    }

    public Dialog(Frame frame) {
        this(frame, "", false);
    }

    public Dialog(Frame frame, String string) {
        this(frame, string, false);
    }

    public Dialog(Frame frame, String string, boolean bl) {
        super(frame);
        if (frame == null) {
            throw new IllegalArgumentException("null owner frame");
        }
        this.title = string;
        this.modal = bl;
    }

    public Dialog(Frame frame, boolean bl) {
        this(frame, "", bl);
    }

    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.peer == null) {
                this.peer = this.getToolkit().createDialog(this);
            }
            super.addNotify();
        }
    }

    String constructComponentName() {
        Class clazz = this.getClass();
        synchronized (clazz) {
            String string = base + nameCounter++;
            Object var3_3 = null;
            return string;
        }
    }

    public String getTitle() {
        return this.title;
    }

    private static native void initIDs();

    public boolean isModal() {
        return this.modal;
    }

    public boolean isResizable() {
        return this.resizable;
    }

    protected String paramString() {
        String string = String.valueOf(super.paramString()) + (this.modal ? ",modal" : ",modeless");
        if (this.title != null) {
            string = String.valueOf(string) + ",title=" + this.title;
        }
        return string;
    }

    public void setModal(boolean bl) {
        this.modal = bl;
    }

    public void setResizable(boolean bl) {
        boolean bl2 = false;
        Dialog dialog = this;
        synchronized (dialog) {
            this.resizable = bl;
            DialogPeer dialogPeer = (DialogPeer)this.peer;
            if (dialogPeer != null) {
                dialogPeer.setResizable(bl);
                bl2 = true;
            }
        }
        if (bl2 && this.valid) {
            this.invalidate();
        }
    }

    public synchronized void setTitle(String string) {
        this.title = string;
        DialogPeer dialogPeer = (DialogPeer)this.peer;
        if (dialogPeer != null) {
            dialogPeer.setTitle(string);
        }
    }

    public void show() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.parent != null && this.parent.getPeer() == null) {
                this.parent.addNotify();
            }
            if (this.peer == null) {
                this.addNotify();
            }
        }
        this.validate();
        if (this.visible) {
            this.toFront();
        } else {
            this.visible = true;
            if (this.isModal()) {
                EventQueue eventQueue;
                object = null;
                EventQueue eventQueue2 = eventQueue = Toolkit.getEventQueue();
                synchronized (eventQueue2) {
                    if (EventQueue.isDispatchThread()) {
                        object = (EventQueue)AccessController.doPrivileged(new PrivilegedAction(){

                            public Object run() {
                                EventQueue eventQueue;
                                String string = Toolkit.getProperty("AWT.EventQueueClass", "java.awt.EventQueue");
                                try {
                                    eventQueue = (EventQueue)Class.forName(string).newInstance();
                                }
                                catch (Exception exception) {
                                    System.err.println("Failed loading " + string + ": " + exception);
                                    eventQueue = new EventQueue();
                                }
                                return eventQueue;
                            }
                        });
                        eventQueue.push((EventQueue)object);
                    }
                }
                if ((this.state & 1) == 0) {
                    this.postWindowEvent(200);
                    this.state |= 1;
                }
                this.peer.show();
                if (object != null) {
                    ((EventQueue)object).getDispatchThread().stopDispatching();
                    eventQueue.pop();
                }
            } else {
                this.peer.show();
                if ((this.state & 1) == 0) {
                    this.postWindowEvent(200);
                    this.state |= 1;
                }
            }
        }
    }
}

