/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.java;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import sun.tools.java.BinaryConstantPool;
import sun.tools.java.Constants;
import sun.tools.java.Environment;
import sun.tools.java.Identifier;

public final class BinaryAttribute
implements Constants {
    Identifier name;
    byte[] data;
    BinaryAttribute next;

    BinaryAttribute(Identifier identifier, byte[] byArray, BinaryAttribute binaryAttribute) {
        this.name = identifier;
        this.data = byArray;
        this.next = binaryAttribute;
    }

    public byte[] getData() {
        return this.data;
    }

    public Identifier getName() {
        return this.name;
    }

    public BinaryAttribute getNextAttribute() {
        return this.next;
    }

    public static BinaryAttribute load(DataInputStream dataInputStream, BinaryConstantPool binaryConstantPool, int n) throws IOException {
        BinaryAttribute binaryAttribute = null;
        int n2 = dataInputStream.readUnsignedShort();
        int n3 = 0;
        while (n3 < n2) {
            Identifier identifier = binaryConstantPool.getIdentifier(dataInputStream.readUnsignedShort());
            int n4 = dataInputStream.readInt();
            if (identifier.equals(Constants.idCode) && (n & 2) == 0) {
                dataInputStream.skipBytes(n4);
            } else {
                byte[] byArray = new byte[n4];
                dataInputStream.readFully(byArray);
                binaryAttribute = new BinaryAttribute(identifier, byArray, binaryAttribute);
            }
            ++n3;
        }
        return binaryAttribute;
    }

    static void write(BinaryAttribute binaryAttribute, DataOutputStream dataOutputStream, BinaryConstantPool binaryConstantPool, Environment environment) throws IOException {
        int n = 0;
        BinaryAttribute binaryAttribute2 = binaryAttribute;
        while (binaryAttribute2 != null) {
            ++n;
            binaryAttribute2 = binaryAttribute2.next;
        }
        dataOutputStream.writeShort(n);
        BinaryAttribute binaryAttribute3 = binaryAttribute;
        while (binaryAttribute3 != null) {
            Identifier identifier = binaryAttribute3.name;
            byte[] byArray = binaryAttribute3.data;
            dataOutputStream.writeShort(binaryConstantPool.indexString(identifier.toString(), environment));
            dataOutputStream.writeInt(byArray.length);
            dataOutputStream.write(byArray, 0, byArray.length);
            binaryAttribute3 = binaryAttribute3.next;
        }
    }
}

