/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.debug;

import sun.tools.debug.RemoteAgent;
import sun.tools.debug.RemoteClass;
import sun.tools.debug.RemoteObject;
import sun.tools.debug.RemoteStackFrame;
import sun.tools.debug.RemoteStackVariable;

public class RemoteThread
extends RemoteObject {
    private int currentFrame = 0;
    private RemoteStackFrame[] stack;
    private boolean suspended = false;

    RemoteThread(RemoteAgent remoteAgent, int n, RemoteClass remoteClass) {
        super(remoteAgent, 19, n, remoteClass);
    }

    private void assureSuspended() throws Exception {
        int n = this.agent.getThreadStatus(this.id);
        if (n != 5 && n != 6) {
            throw new IllegalAccessError();
        }
    }

    public void cont() throws Exception {
        if (!this.suspended) {
            this.agent.resumeThread(this.id);
        }
    }

    public void down(int n) throws Exception {
        this.assureSuspended();
        if (this.currentFrame - n < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.currentFrame -= n;
    }

    public RemoteStackFrame[] dumpStack() throws Exception {
        this.resetStack();
        return this.getStack();
    }

    public RemoteStackFrame getCurrentFrame() throws Exception {
        this.assureSuspended();
        return this.getStack()[this.currentFrame];
    }

    public int getCurrentFrameIndex() {
        return this.currentFrame;
    }

    public String getName() throws Exception {
        return this.agent.getThreadName(this.id);
    }

    private synchronized RemoteStackFrame[] getStack() throws Exception {
        if (this.stack == null) {
            this.stack = this.agent.dumpStack(this);
        }
        return this.stack;
    }

    public RemoteStackVariable getStackVariable(String string) throws Exception {
        this.agent.message("getStackVariable: thread=" + this.getName() + ", currentFrame=" + this.currentFrame);
        this.assureSuspended();
        return this.getStack()[this.currentFrame].getLocalVariable(string);
    }

    public RemoteStackVariable[] getStackVariables() throws Exception {
        this.agent.message("getStackVariables: thread=" + this.getName() + ", currentFrame=" + this.currentFrame);
        this.assureSuspended();
        return this.getStack()[this.currentFrame].getLocalVariables();
    }

    public String getStatus() throws Exception {
        int n = this.agent.getThreadStatus(this.id);
        switch (n) {
            case -1: {
                return "";
            }
            case 0: {
                return "zombie";
            }
            case 1: {
                return "running";
            }
            case 2: {
                return "sleeping";
            }
            case 3: {
                return "waiting in a monitor";
            }
            case 4: {
                return "cond. waiting";
            }
            case 5: {
                return "suspended";
            }
            case 6: {
                return "at breakpoint";
            }
        }
        return "invalid status returned";
    }

    public boolean isSuspended() {
        int n;
        try {
            n = this.agent.getThreadStatus(this.id);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("ThreadStatus failed with " + exception);
        }
        return n == 5 || n == 6;
    }

    public void next() throws Exception {
        this.assureSuspended();
        this.agent.stepNextThread(this.id);
    }

    public void resetCurrentFrameIndex() {
        this.currentFrame = 0;
    }

    synchronized void resetStack() {
        this.stack = null;
    }

    public void resume() throws Exception {
        if (this.suspended) {
            this.agent.resumeThread(this.id);
            this.suspended = false;
        }
    }

    public void setCurrentFrameIndex(int n) {
        this.currentFrame = n;
    }

    public void step(boolean bl) throws Exception {
        this.assureSuspended();
        this.agent.stepThread(this.id, bl);
    }

    public void stepOut() throws Exception {
        this.assureSuspended();
        this.agent.stepOutThread(this.id);
    }

    public void stop() throws Exception {
        this.agent.stopThread(this.id);
    }

    public void suspend() throws Exception {
        if (!this.suspended) {
            this.agent.suspendThread(this.id);
            this.resetStack();
            this.suspended = true;
        }
    }

    public void up(int n) throws Exception {
        this.assureSuspended();
        if (this.currentFrame + n >= this.getStack().length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.currentFrame += n;
    }
}

