/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.agent;

import java.io.IOException;
import sun.tools.agent.AbsentInformationException;
import sun.tools.agent.Agent;
import sun.tools.agent.AgentConstants;
import sun.tools.agent.Breakpoint;
import sun.tools.agent.CachedMethod;
import sun.tools.agent.Event;
import sun.tools.agent.StackFrame;
import sun.tools.agent.StepConstants;
import sun.tools.agent.StepRequest;
import sun.tools.java.RuntimeConstants;

class StepHandler
extends Thread
implements StepConstants,
AgentConstants {
    private static final int opc_invokevirtual_quick = 214;
    private static final int opc_invokenonvirtual_quick = 215;
    private static final int opc_invokesuper_quick = 216;
    private static final int opc_invokestatic_quick = 217;
    private static final int opc_invokeinterface_quick = 218;
    private static final int opc_invokevirtualobject_quick = 219;
    private static final int opc_invokevirtual_quick_w = 226;
    private static final int opc_ldc_quick = 203;
    private static final int opc_ldc_w_quick = 204;
    private static final int opc_getfield_quick = 206;
    private static final int opc_putfield_quick = 207;
    private static final int opc_getfield2_quick = 208;
    private static final int opc_putfield2_quick = 209;
    private static final int opc_putstatic_quick = 211;
    private static final int opc_getstatic2_quick = 212;
    private static final int opc_putstatic2_quick = 213;
    private static final int opc_new_quick = 221;
    private static final int opc_anewarray_quick = 222;
    private static final int opc_multianewarray_quick = 223;
    private static final int opc_checkcast_quick = 224;
    private static final int opc_instanceof_quick = 225;
    private static final int opc_getfield_quick_w = 227;
    private static final int opc_putfield_quick_w = 228;
    private final int MIN_QUICK_OPCODE = 203;
    private final int MAX_QUICK_OPCODE = 228;
    private Agent agent;
    private Event event;
    private boolean waitingForBreak = false;
    private boolean exceptionOccurred = false;
    private boolean userMustSeeException = false;
    private boolean hitUserBreak = false;
    private boolean stepping = false;
    private static boolean[] invokeMap = new boolean[256];
    private static boolean[] branchMap;

    static {
        int n = 0;
        while (n < invokeMap.length) {
            StepHandler.invokeMap[n] = false;
            ++n;
        }
        StepHandler.invokeMap[182] = true;
        StepHandler.invokeMap[183] = true;
        StepHandler.invokeMap[184] = true;
        StepHandler.invokeMap[185] = true;
        StepHandler.invokeMap[214] = true;
        StepHandler.invokeMap[215] = true;
        StepHandler.invokeMap[216] = true;
        StepHandler.invokeMap[217] = true;
        StepHandler.invokeMap[218] = true;
        StepHandler.invokeMap[219] = true;
        StepHandler.invokeMap[226] = true;
        StepHandler.invokeMap[18] = true;
        StepHandler.invokeMap[19] = true;
        StepHandler.invokeMap[203] = true;
        StepHandler.invokeMap[204] = true;
        StepHandler.invokeMap[187] = true;
        StepHandler.invokeMap[189] = true;
        StepHandler.invokeMap[197] = true;
        StepHandler.invokeMap[192] = true;
        StepHandler.invokeMap[193] = true;
        StepHandler.invokeMap[178] = true;
        StepHandler.invokeMap[179] = true;
        StepHandler.invokeMap[180] = true;
        StepHandler.invokeMap[181] = true;
        StepHandler.invokeMap[206] = true;
        StepHandler.invokeMap[207] = true;
        StepHandler.invokeMap[208] = true;
        StepHandler.invokeMap[209] = true;
        StepHandler.invokeMap[211] = true;
        StepHandler.invokeMap[212] = true;
        StepHandler.invokeMap[213] = true;
        StepHandler.invokeMap[221] = true;
        StepHandler.invokeMap[222] = true;
        StepHandler.invokeMap[223] = true;
        StepHandler.invokeMap[224] = true;
        StepHandler.invokeMap[225] = true;
        StepHandler.invokeMap[227] = true;
        StepHandler.invokeMap[228] = true;
        branchMap = new boolean[256];
        n = 0;
        while (n < branchMap.length) {
            StepHandler.branchMap[n] = false;
            ++n;
        }
        StepHandler.branchMap[167] = true;
        StepHandler.branchMap[200] = true;
        StepHandler.branchMap[153] = true;
        StepHandler.branchMap[198] = true;
        StepHandler.branchMap[155] = true;
        StepHandler.branchMap[158] = true;
        StepHandler.branchMap[154] = true;
        StepHandler.branchMap[199] = true;
        StepHandler.branchMap[157] = true;
        StepHandler.branchMap[156] = true;
        StepHandler.branchMap[159] = true;
        StepHandler.branchMap[160] = true;
        StepHandler.branchMap[161] = true;
        StepHandler.branchMap[163] = true;
        StepHandler.branchMap[164] = true;
        StepHandler.branchMap[162] = true;
        StepHandler.branchMap[168] = true;
        StepHandler.branchMap[201] = true;
        StepHandler.branchMap[169] = true;
        StepHandler.branchMap[171] = true;
        StepHandler.branchMap[170] = true;
        StepHandler.branchMap[191] = true;
        StepHandler.branchMap[172] = true;
        StepHandler.branchMap[173] = true;
        StepHandler.branchMap[174] = true;
        StepHandler.branchMap[175] = true;
        StepHandler.branchMap[176] = true;
        StepHandler.branchMap[177] = true;
    }

    StepHandler(Agent agent) {
        super("Step handler");
        this.agent = agent;
    }

    private boolean frameEquals(StackFrame stackFrame, StackFrame stackFrame2, boolean bl) {
        boolean bl2;
        if (bl) {
            bl2 = stackFrame.getBCI() == stackFrame2.getBCI();
        } else {
            int n = stackFrame.getLinenumber();
            int n2 = stackFrame2.getLinenumber();
            bl2 = n == -1 || n2 == -1 ? stackFrame.getBCI() == stackFrame2.getBCI() : n == n2;
        }
        return bl2 && stackFrame.getMethod() == stackFrame2.getMethod();
    }

    private StackFrame[] getCurrentStackTrace(Thread thread) {
        return StackFrame.getStackFrames(thread);
    }

    private int getReturnBCI(StackFrame stackFrame) {
        int n;
        try {
            int n2 = stackFrame.getBCI();
            if (n2 == -1) {
                return -1;
            }
            n = stackFrame.getMethod().byteAt(n2);
        }
        catch (AbsentInformationException absentInformationException) {
            return -1;
        }
        if (this.isBranchOpcode(n)) {
            return -1;
        }
        return stackFrame.getBCI() + this.instructionLength(n);
    }

    private int instructionLength(int n) {
        if (n < 203) {
            return RuntimeConstants.opcLengths[n];
        }
        if (n <= 228) {
            switch (n) {
                case 203: {
                    return 2;
                }
                case 218: {
                    return 5;
                }
                case 223: {
                    return 4;
                }
            }
            return 3;
        }
        throw new IllegalArgumentException("Invalid opcode");
    }

    private synchronized void internalStepInstruction(Thread thread) throws InterruptedException {
        try {
            this.hitUserBreak = false;
            do {
                this.agent.setSingleStep(thread, true);
                this.agent.resumeLastSuspendedThreads();
                this.waitForBreak();
            } while (this.exceptionOccurred && !this.userMustSeeException);
            if (Breakpoint.exists(this.event.getMethod(), this.event.bci)) {
                this.hitUserBreak = true;
            }
        }
        catch (InterruptedException interruptedException) {
            this.agent.setSingleStep(thread, false);
            throw interruptedException;
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            Agent.error("step failed: " + illegalThreadStateException.getMessage());
        }
    }

    private boolean isBranchOpcode(int n) {
        return branchMap[n];
    }

    private boolean isExecutingLine(StackFrame[] stackFrameArray, StackFrame[] stackFrameArray2) {
        int n = stackFrameArray2.length - stackFrameArray.length;
        if (n < 0) {
            return false;
        }
        boolean bl = false;
        int n2 = 0;
        while (n2 < stackFrameArray.length) {
            if (!this.frameEquals(stackFrameArray[n2], stackFrameArray2[n2 + n], bl)) {
                Agent.message("stacks don't match at level " + n2);
                return false;
            }
            bl = true;
            ++n2;
        }
        return true;
    }

    private boolean isInvokeOpcode(int n) {
        return invokeMap[n];
    }

    private boolean isWithinLine(StackFrame[] stackFrameArray, StackFrame[] stackFrameArray2) {
        if (stackFrameArray2.length != stackFrameArray.length) {
            return false;
        }
        return this.isExecutingLine(stackFrameArray, stackFrameArray2);
    }

    synchronized boolean notifyBreak(Event event) {
        if (this.waitingForBreak) {
            this.event = (Event)event.clone();
            this.notify();
            return true;
        }
        return false;
    }

    synchronized boolean notifyException(Event event, boolean bl) {
        if (this.waitingForBreak) {
            this.event = (Event)event.clone();
            this.exceptionOccurred = true;
            this.userMustSeeException = bl;
            this.agent.suspendAllThreads();
            this.notify();
            return true;
        }
        return false;
    }

    private void notifyRemoteDebugger() throws IOException {
        if (this.exceptionOccurred && this.userMustSeeException) {
            this.agent.reportAppException(this.event);
        } else {
            this.agent.reportBreakpoint(this.event);
        }
    }

    private synchronized void requestStep(int n, int n2, Thread thread) {
        if (this.stepping) {
            this.stepping = false;
            this.notify();
        }
        StepRequest.make(n, n2, thread);
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    StepRequest stepRequest = this.waitForRequest();
                    if (stepRequest.depth == 2) {
                        this.stepOut(stepRequest.thread);
                        continue;
                    }
                    if (stepRequest.granularity == 1) {
                        this.stepLine(stepRequest.depth, stepRequest.thread);
                        continue;
                    }
                    this.stepInstruction(stepRequest.thread);
                }
            }
            catch (InterruptedException interruptedException) {
                Agent.message("Step interrupted");
                continue;
            }
            break;
        }
    }

    private StackFrame[] runOnceTo(CachedMethod cachedMethod, int n, Thread thread) throws NoSuchMethodException, InterruptedException, IOException {
        int n2;
        CachedMethod cachedMethod2;
        StackFrame[] stackFrameArray = null;
        this.hitUserBreak = false;
        boolean bl = Breakpoint.exists(cachedMethod, n);
        try {
            if (!bl) {
                Breakpoint breakpoint = Breakpoint.addBreakpoint(cachedMethod, n, 2);
                breakpoint.setThread(thread);
            } else {
                Agent.message("run-to breakpoint already there, not setting");
            }
            do {
                this.agent.resumeLastSuspendedThreads();
                this.waitForBreak();
                if (!this.exceptionOccurred || this.userMustSeeException || this.event.thread == thread) continue;
                Agent.message("run-to ignoring exception in another thread");
            } while (this.exceptionOccurred && !this.userMustSeeException && this.event.thread != thread);
            stackFrameArray = this.getCurrentStackTrace(this.event.thread);
            cachedMethod2 = stackFrameArray[0].getMethod();
            n2 = stackFrameArray[0].getBCI();
        }
        finally {
            Object var9_9 = null;
            if (!bl && Breakpoint.exists(cachedMethod, n)) {
                Agent.message("removing run-to breakpoint");
                Breakpoint.deleteBreakpoint(cachedMethod, n);
            }
        }
        boolean bl2 = this.hitUserBreak = !this.exceptionOccurred && (bl || n2 != n || cachedMethod2 != cachedMethod);
        if (this.hitUserBreak) {
            Agent.message("Hit a real user breakpoint.");
        }
        return stackFrameArray;
    }

    private StackFrame[] runTo(CachedMethod cachedMethod, int n, Thread thread, int n2) throws NoSuchMethodException, InterruptedException, IOException {
        StackFrame[] stackFrameArray;
        StackFrame[] stackFrameArray2 = stackFrameArray = this.getCurrentStackTrace(thread);
        boolean bl = false;
        while (!bl) {
            boolean bl2;
            stackFrameArray2 = this.runOnceTo(cachedMethod, n, thread);
            do {
                bl2 = false;
                CachedMethod cachedMethod2 = stackFrameArray2[0].getMethod();
                int n3 = stackFrameArray2[0].getBCI();
                Thread thread2 = this.event.thread;
                if (this.exceptionOccurred && !this.userMustSeeException) {
                    CachedMethod cachedMethod3 = this.event.getCatchMethod();
                    int n4 = this.event.getCatchBCI();
                    Agent.message("exception (" + this.event + ") at " + cachedMethod2.getName() + " (" + n3 + ") while running over, going to catch at " + cachedMethod3.getName() + " (" + n4 + ")");
                    stackFrameArray2 = this.runOnceTo(cachedMethod3, n4, thread);
                    cachedMethod2 = stackFrameArray2[0].getMethod();
                    n3 = stackFrameArray2[0].getBCI();
                    if (n3 != n4 || cachedMethod2 != cachedMethod3) {
                        if (this.exceptionOccurred) {
                            Agent.message("Recursive exception");
                            bl2 = true;
                            continue;
                        }
                        Agent.message("couldn't get to catch bci");
                        bl = true;
                        continue;
                    }
                    if (this.isExecutingLine(stackFrameArray, stackFrameArray2) && stackFrameArray.length != stackFrameArray2.length) continue;
                    Agent.message("catch bci is not within line, stopping");
                    bl = true;
                    continue;
                }
                if (this.exceptionOccurred || this.hitUserBreak) {
                    bl = true;
                    continue;
                }
                if (stackFrameArray2.length <= n2) {
                    bl = true;
                    continue;
                }
                Agent.message("debuggee is recursing. continuing...");
            } while (bl2);
        }
        return stackFrameArray2;
    }

    private boolean runToReturn(StackFrame[] stackFrameArray, Thread thread) throws NoSuchMethodException, InterruptedException, IOException {
        StackFrame stackFrame;
        int n;
        boolean bl = false;
        if (stackFrameArray.length > 1 && (n = this.getReturnBCI(stackFrame = stackFrameArray[1])) != -1) {
            StackFrame[] stackFrameArray2;
            do {
                stackFrameArray2 = this.runTo(stackFrame.getMethod(), n, thread, stackFrameArray.length - 1);
            } while ((!this.exceptionOccurred || !this.userMustSeeException) && !this.hitUserBreak && stackFrameArray2.length >= stackFrameArray.length);
            bl = true;
        }
        return bl;
    }

    private synchronized void stepInstruction(Thread thread) throws InterruptedException {
        block2: {
            if (Agent.systemThread(thread)) break block2;
            Agent.message("stepping " + thread.getName());
            try {
                this.internalStepInstruction(thread);
                this.notifyRemoteDebugger();
            }
            catch (IOException iOException) {
                Agent.error("step failed: " + iOException.getMessage());
            }
        }
    }

    private synchronized void stepLine(int n, Thread thread) throws InterruptedException {
        block13: {
            if (Agent.systemThread(thread)) break block13;
            Agent.message("next stepping " + thread.getName());
            try {
                boolean bl;
                boolean bl2;
                StackFrame[] stackFrameArray = this.getCurrentStackTrace(thread);
                if (stackFrameArray[0].getLinenumber() == -1) {
                    Agent.message("no line information available, single-stepping.");
                    this.internalStepInstruction(thread);
                    this.notifyRemoteDebugger();
                    return;
                }
                StackFrame[] stackFrameArray2 = stackFrameArray;
                CachedMethod cachedMethod = stackFrameArray2[0].getMethod();
                int n2 = stackFrameArray2[0].getBCI();
                do {
                    int n3;
                    int n4;
                    try {
                        n4 = cachedMethod.byteAt(n2);
                    }
                    catch (AbsentInformationException absentInformationException) {
                        Agent.message("byte-code information available, single-stepping.");
                        this.internalStepInstruction(thread);
                        this.notifyRemoteDebugger();
                        return;
                    }
                    if (this.isInvokeOpcode(n4) && n == 0) {
                        n3 = n2 + this.instructionLength(n4);
                        stackFrameArray2 = this.runTo(cachedMethod, n3, thread, stackFrameArray.length);
                        cachedMethod = stackFrameArray2[0].getMethod();
                        n2 = stackFrameArray2[0].getBCI();
                    } else {
                        this.internalStepInstruction(thread);
                        stackFrameArray2 = this.getCurrentStackTrace(this.event.thread);
                        cachedMethod = stackFrameArray2[0].getMethod();
                        n2 = stackFrameArray2[0].getBCI();
                        if (!(n != 0 || stackFrameArray.length >= stackFrameArray2.length || thread != this.event.thread || this.hitUserBreak || this.exceptionOccurred && this.userMustSeeException)) {
                            n3 = this.runToReturn(stackFrameArray2, thread) ? 1 : 0;
                            if (n3 != 0) {
                                stackFrameArray2 = this.getCurrentStackTrace(this.event.thread);
                                cachedMethod = stackFrameArray2[0].getMethod();
                                n2 = stackFrameArray2[0].getBCI();
                            } else {
                                Agent.message("unexpectedly stepped into a method. Can't find a return address");
                                break;
                            }
                        }
                    }
                    bl2 = n == 0 ? this.isExecutingLine(stackFrameArray, stackFrameArray2) ^ true : this.isWithinLine(stackFrameArray, stackFrameArray2) ^ true;
                    boolean bl3 = bl = this.exceptionOccurred && this.userMustSeeException || this.hitUserBreak;
                } while (!bl2 && !bl);
                this.notifyRemoteDebugger();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                Agent.error("next step failed: " + illegalThreadStateException.getMessage());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Agent.error("next step failed: " + noSuchMethodException.getMessage());
            }
            catch (IOException iOException) {
                Agent.error("next step failed: " + iOException.getMessage());
            }
        }
    }

    synchronized void stepNextThread(Thread thread) {
        this.requestStep(1, 0, thread);
    }

    private synchronized void stepOut(Thread thread) throws InterruptedException {
        block5: {
            if (Agent.systemThread(thread)) break block5;
            Agent.message("stepping out " + thread.getName());
            try {
                StackFrame[] stackFrameArray = this.getCurrentStackTrace(thread);
                boolean bl = this.runToReturn(stackFrameArray, thread);
                if (!bl) {
                    Agent.message("Unable to step out; single stepping");
                    this.hitUserBreak = false;
                    this.internalStepInstruction(thread);
                }
                this.notifyRemoteDebugger();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                Agent.error("step out failed: " + illegalThreadStateException.getMessage());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Agent.error("step out failed: " + noSuchMethodException.getMessage());
            }
            catch (IOException iOException) {
                Agent.error("step out failed: " + iOException.getMessage());
            }
        }
    }

    synchronized void stepOutThread(Thread thread) {
        this.requestStep(0, 2, thread);
    }

    synchronized void stepThread(Thread thread, boolean bl) {
        this.requestStep(bl ? 1 : 0, 1, thread);
    }

    synchronized void waitForBreak() throws InterruptedException {
        this.exceptionOccurred = false;
        this.event = null;
        this.waitingForBreak = true;
        Agent.message("waiting for break...");
        this.wait();
        this.waitingForBreak = false;
        if (!this.stepping) {
            throw new InterruptedException();
        }
    }

    private StepRequest waitForRequest() {
        this.stepping = false;
        StepRequest stepRequest = StepRequest.get();
        this.stepping = true;
        return stepRequest;
    }
}

