/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.agent;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import sun.tools.agent.AbsentInformationException;
import sun.tools.agent.AgentConstants;
import sun.tools.agent.AgentOutputStream;
import sun.tools.agent.Breakpoint;
import sun.tools.agent.CachedClass;
import sun.tools.agent.CachedField;
import sun.tools.agent.CachedLocalVariable;
import sun.tools.agent.CachedMethod;
import sun.tools.agent.Event;
import sun.tools.agent.Handler;
import sun.tools.agent.Location;
import sun.tools.agent.MainThread;
import sun.tools.agent.ObjectCache;
import sun.tools.agent.ResponseStream;
import sun.tools.agent.StackFrame;
import sun.tools.agent.StepHandler;
import sun.tools.agent.ThreadList;
import sun.tools.java.ClassFile;
import sun.tools.java.ClassPath;
import sun.tools.java.Identifier;
import sun.tools.java.Package;

class Agent
implements Runnable,
AgentConstants {
    static Agent the_Agent = null;
    ServerSocket socket;
    boolean useSockets;
    DataOutputStream asyncOutputStream;
    PipedInputStream cmdInputPipe = null;
    PipedOutputStream cmdOutputPipe = null;
    PipedOutputStream asyncOutputPipe = null;
    ObjectCache objectCache;
    private Handler handler;
    StepHandler stepHandler;
    Class mainCallerClass;
    private AgentOutputStream agentOut;
    private static PrintWriter messageWriter = null;
    static boolean runBegun = false;
    static Object runBegunLock = new Object();
    private ThreadGroup mainGroup = null;
    private DataOutputStream out = null;
    private ResponseStream outBuffer = null;
    private ClassPath sourcePath = null;
    private Object pipeLock = new Object();
    static boolean verbose = false;
    private static ClassLoader appClassLoader = ClassLoader.getSystemClassLoader();
    private ThreadList lastSuspended;
    volatile boolean debuggerTerminating = false;

    static {
        System.loadLibrary("agent");
    }

    Agent() {
        this.useSockets = false;
        the_Agent = this;
    }

    Agent(int n) {
        this.useSockets = true;
        the_Agent = this;
        int n2 = 0;
        while (true) {
            try {
                this.socket = new ServerSocket(n, 10);
                System.out.println("Agent password=" + this.makePassword(this.socket.getLocalPort()));
                return;
            }
            catch (Exception exception) {
                Agent.message("[Waiting to create port]\n");
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                if (n2 >= 10) {
                    Agent.error("**Failed to create port\n");
                    return;
                }
                ++n2;
                continue;
            }
            break;
        }
    }

    public static synchronized native void addSystemThread(Thread var0);

    static void beginRun() {
        Object object = runBegunLock;
        synchronized (object) {
            runBegun = true;
            runBegunLock.notifyAll();
        }
    }

    public static void boot(int n) {
        String string = System.getProperty("java.compiler");
        if (!string.equals("NONE") && !string.equals("")) {
            throw new IllegalArgumentException("The JIT compiler must be disabled in debug mode; use -Djava.compiler=NONE to disable it");
        }
        Agent agent = new Agent(n);
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup.getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        Thread thread = new Thread(threadGroup, agent, "Debugger agent");
        thread.setDaemon(true);
        thread.setPriority(10);
        thread.start();
    }

    static synchronized void connectToAgent(PipedOutputStream pipedOutputStream, PipedInputStream pipedInputStream, PipedInputStream pipedInputStream2) throws IOException {
        if (the_Agent == null || Agent.the_Agent.useSockets) {
            throw new IllegalAccessError();
        }
        Agent.the_Agent.cmdInputPipe = new PipedInputStream(pipedOutputStream);
        Agent.the_Agent.cmdOutputPipe = new PipedOutputStream(pipedInputStream);
        Agent.the_Agent.asyncOutputPipe = new PipedOutputStream(pipedInputStream2);
        Object object = Agent.the_Agent.pipeLock;
        synchronized (object) {
            Agent.the_Agent.pipeLock.notifyAll();
        }
    }

    private String cookieToString(int n) {
        int n2;
        int n3 = "23456789abcdefghijkmnpqrstuvwxyz".length();
        int n4 = 0;
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer(32);
        while (n > 0) {
            if (n < n3) {
                stringBuffer.append("23456789abcdefghijkmnpqrstuvwxyz".charAt(n));
                n = 0;
            } else {
                n2 = n % n3;
                n /= n3;
                stringBuffer.append("23456789abcdefghijkmnpqrstuvwxyz".charAt(n2));
            }
            ++n4;
        }
        if (n4 > 0) {
            n2 = stringBuffer.length();
            char[] cArray = new char[n2];
            int n5 = 0;
            while (n2-- > 0) {
                cArray[n2] = stringBuffer.charAt(n5++);
            }
            return String.valueOf(cArray);
        }
        return "0";
    }

    public static void debuggable_boot() {
        Agent agent = new Agent();
        Thread thread = new Thread(agent);
        thread.setDaemon(true);
        thread.setName("Debugger agent");
        thread.setPriority(10);
        thread.start();
    }

    private void dumpClasses() throws IOException {
        Agent.message("dumpClasses()");
        Enumeration enumeration = this.objectCache.elements();
        Vector vector = new Vector();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            try {
                Object e = enumeration.nextElement();
                if (e == null || !(e instanceof CachedClass)) continue;
                vector.addElement(e);
                ++n;
            }
            catch (Exception exception) {
                Agent.exceptionError(exception, "dumpClasses() failed: " + exception.toString());
            }
        }
        this.out.writeInt(n);
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.writeObject(enumeration.nextElement());
        }
    }

    static void error(String string) {
        String string2 = "[Internal debug-agent error: " + string + "]";
        System.out.println(string2);
        Agent.message(string2);
    }

    static void exceptionError(Throwable throwable, String string) {
        String string2 = "[Internal debug-agent exception: " + throwable + " - " + string + "]";
        System.out.println(string2);
        if (messageWriter != null) {
            messageWriter.println(string2);
            throwable.printStackTrace(messageWriter);
        }
    }

    static String exceptionStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        return stringWriter.toString();
    }

    public static ClassLoader getAppLoader() {
        return appClassLoader;
    }

    native Class[] getClasses();

    native boolean getFieldBoolean(Object var1, long var2);

    native byte getFieldByte(Object var1, long var2);

    native char getFieldChar(Object var1, long var2);

    native double getFieldDouble(Object var1, long var2);

    native float getFieldFloat(Object var1, long var2);

    native int getFieldInt(Object var1, long var2);

    native long getFieldLong(Object var1, long var2);

    native Object getFieldObject(Object var1, long var2);

    native short getFieldShort(Object var1, long var2);

    native boolean getStackBoolean(Thread var1, int var2, int var3);

    native double getStackDouble(Thread var1, int var2, int var3);

    native float getStackFloat(Thread var1, int var2, int var3);

    native int getStackInt(Thread var1, int var2, int var3);

    native long getStackLong(Thread var1, int var2, int var3);

    native Object getStackObject(Thread var1, int var2, int var3);

    native boolean getStaticFieldBoolean(Class var1, long var2);

    native byte getStaticFieldByte(Class var1, long var2);

    native char getStaticFieldChar(Class var1, long var2);

    native double getStaticFieldDouble(Class var1, long var2);

    native float getStaticFieldFloat(Class var1, long var2);

    native int getStaticFieldInt(Class var1, long var2);

    native long getStaticFieldLong(Class var1, long var2);

    native Object getStaticFieldObject(Class var1, long var2);

    native short getStaticFieldShort(Class var1, long var2);

    native int getThreadStatus(Thread var1);

    synchronized void handle(int n, DataInputStream dataInputStream, DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(n);
        switch (n) {
            case 49: {
                Class[] classArray = this.getClasses();
                dataOutputStream.writeInt(classArray.length);
                int n2 = 0;
                while (n2 < classArray.length) {
                    this.writeObject(classArray[n2]);
                    ++n2;
                }
                return;
            }
            case 20: {
                String string;
                CachedClass cachedClass = this.readClass(dataInputStream);
                try {
                    string = cachedClass.getSourceFileName();
                }
                catch (AbsentInformationException absentInformationException) {
                    string = "";
                }
                Class clazz = cachedClass.realClass;
                dataOutputStream.writeUTF(clazz.getName());
                dataOutputStream.writeUTF(string);
                dataOutputStream.writeInt(clazz.isInterface() ? 1 : 0);
                this.writeObject(clazz.getSuperclass());
                this.writeObject(clazz.getClassLoader());
                Class<?>[] classArray = clazz.getInterfaces();
                dataOutputStream.writeInt(classArray.length);
                int n3 = 0;
                while (n3 < classArray.length) {
                    this.writeObject(classArray[n3]);
                    ++n3;
                }
                return;
            }
            case 21: {
                dataOutputStream.writeUTF(this.readThread(dataInputStream).getName());
                return;
            }
            case 22: {
                String string = dataInputStream.readUTF();
                try {
                    this.writeObject(Class.forName(string, true, Agent.getAppLoader()));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Agent.message("no such class: " + string);
                    this.writeObject(null);
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    Agent.message("no such class: " + string);
                    this.writeObject(null);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Agent.message("illegal class name: " + string);
                    this.writeObject(null);
                }
                return;
            }
            case 31: {
                Thread thread = this.readThread(dataInputStream);
                int n4 = this.getThreadStatus(thread);
                Agent.message("thread " + thread + " status " + n4);
                dataOutputStream.writeInt(n4);
                return;
            }
            case 32: {
                Thread thread = this.readThread(dataInputStream);
                Event event = Handler.the_event;
                synchronized (event) {
                    Thread thread2 = this.temporarySuspend(thread);
                    StackFrame[] stackFrameArray = StackFrame.getStackFrames(thread);
                    int n5 = stackFrameArray.length;
                    if (n5 > 2 && stackFrameArray[n5 - 2].getRealClass() == this.mainCallerClass) {
                        n5 -= 2;
                    }
                    dataOutputStream.writeInt(n5);
                    int n6 = 0;
                    while (n6 < n5) {
                        StackFrame stackFrame = stackFrameArray[n6];
                        this.writeObject(stackFrame);
                        dataOutputStream.writeUTF(stackFrame.getClassName());
                        dataOutputStream.writeUTF(stackFrame.getMethodName());
                        dataOutputStream.writeUTF(stackFrame.getMethodSignature());
                        dataOutputStream.writeInt(stackFrame.getLinenumber());
                        dataOutputStream.writeInt(stackFrame.getBCI());
                        this.writeObject(stackFrame.getRealClass());
                        List list = stackFrame.getLocalVariables();
                        dataOutputStream.writeInt(list.size());
                        Iterator iterator = list.iterator();
                        while (iterator.hasNext()) {
                            CachedLocalVariable cachedLocalVariable = (CachedLocalVariable)iterator.next();
                            Agent.message("lvar: slot=" + cachedLocalVariable.slot + ", name=" + cachedLocalVariable.name + ", sig=" + cachedLocalVariable.signature + ", argument=" + cachedLocalVariable.isArgument());
                            dataOutputStream.writeInt(cachedLocalVariable.slot);
                            dataOutputStream.writeUTF(cachedLocalVariable.name);
                            dataOutputStream.writeUTF(cachedLocalVariable.signature);
                            dataOutputStream.writeBoolean(cachedLocalVariable.isArgument());
                        }
                        ++n6;
                    }
                    this.temporaryResume(thread2);
                }
                return;
            }
            case 50: {
                Thread thread = this.readThread(dataInputStream);
                int n7 = dataInputStream.readInt();
                int n8 = dataInputStream.readInt();
                char c = dataInputStream.readChar();
                switch (c) {
                    case 'Z': {
                        this.write(this.getStackBoolean(thread, n7, n8));
                        return;
                    }
                    case 'B': {
                        this.write((byte)this.getStackInt(thread, n7, n8));
                        return;
                    }
                    case 'C': {
                        this.write((char)this.getStackInt(thread, n7, n8));
                        return;
                    }
                    case 'S': {
                        this.write((short)this.getStackInt(thread, n7, n8));
                        return;
                    }
                    case 'I': {
                        this.write(this.getStackInt(thread, n7, n8));
                        return;
                    }
                    case 'J': {
                        this.write(this.getStackLong(thread, n7, n8));
                        return;
                    }
                    case 'F': {
                        this.write(this.getStackFloat(thread, n7, n8));
                        return;
                    }
                    case 'D': {
                        this.write(this.getStackDouble(thread, n7, n8));
                        return;
                    }
                    case 'L': 
                    case '[': {
                        Object object;
                        try {
                            object = this.getStackObject(thread, n7, n8);
                        }
                        catch (Throwable throwable) {
                            Agent.message("CMD_GET_STACK_VALUE - getStackObject - returning null because of exception: " + throwable.getMessage());
                            if (messageWriter != null) {
                                throwable.printStackTrace(messageWriter);
                            }
                            object = null;
                        }
                        this.writeObject(object);
                        return;
                    }
                    case 'V': {
                        this.writeObject(null);
                        return;
                    }
                }
                String string = new String("bogus signature(" + c + ")");
                Agent.error(string);
                this.writeObject(string);
                return;
            }
            case 69: {
                Thread thread = this.readThread(dataInputStream);
                int n9 = dataInputStream.readInt();
                int n10 = dataInputStream.readInt();
                int n11 = dataInputStream.readInt();
                switch (n11) {
                    case 0: {
                        this.setStackBoolean(thread, n9, n10, dataInputStream.readBoolean());
                        break;
                    }
                    case 4: {
                        this.setStackInt(thread, n9, n10, dataInputStream.readInt());
                        break;
                    }
                    case 5: {
                        this.setStackLong(thread, n9, n10, dataInputStream.readLong());
                        break;
                    }
                    case 7: {
                        this.setStackDouble(thread, n9, n10, dataInputStream.readDouble());
                        break;
                    }
                    default: {
                        Agent.error("bogus type(" + n11 + ")");
                    }
                }
                return;
            }
            case 23: {
                int n12 = dataInputStream.readInt();
                int[] nArray = new int[n12];
                int n13 = 0;
                while (n13 < n12) {
                    nArray[n13] = dataInputStream.readInt();
                    ++n13;
                }
                dataOutputStream.flush();
                n = dataInputStream.read();
                dataOutputStream.writeInt(n);
                switch (n) {
                    case 24: {
                        try {
                            this.objectCache.freeAllBut(nArray);
                            Enumeration enumeration = this.objectCache.elements();
                            while (enumeration.hasMoreElements()) {
                                Object e = enumeration.nextElement();
                                if (e == null) continue;
                                dataOutputStream.writeInt(this.objectCache.getId(e));
                            }
                            dataOutputStream.writeInt(0);
                        }
                        catch (Exception exception) {
                            Agent.exceptionError(exception, "CMD_MARK_OBJECTS failed: ");
                        }
                        break;
                    }
                    default: {
                        Agent.error("mark objects command failed");
                    }
                }
                dataOutputStream.flush();
                return;
            }
            case 47: {
                ThreadGroup[] threadGroupArray = new ThreadGroup[1000];
                ThreadGroup threadGroup = this.readThreadGroup(dataInputStream);
                int n14 = 0;
                if (threadGroup == null) {
                    Agent.message("Getting all threadgroups");
                    threadGroup = Thread.currentThread().getThreadGroup();
                    n14 = threadGroup.enumerate(threadGroupArray);
                    dataOutputStream.writeInt(n14 + 1);
                    this.writeObject(threadGroup);
                } else {
                    Agent.message("Getting threadgroups for " + threadGroup.getName());
                    n14 = threadGroup.enumerate(threadGroupArray);
                    dataOutputStream.writeInt(n14);
                }
                int n15 = 0;
                while (n15 < n14) {
                    this.writeObject(threadGroupArray[n15]);
                    ++n15;
                }
                return;
            }
            case 48: {
                ThreadGroup threadGroup = this.readThreadGroup(dataInputStream);
                this.writeObject(threadGroup.getParent());
                dataOutputStream.writeUTF(threadGroup.getName());
                dataOutputStream.writeInt(threadGroup.getMaxPriority());
                dataOutputStream.writeBoolean(threadGroup.isDaemon());
                return;
            }
            case 25: {
                Thread[] threadArray = new Thread[2000];
                ThreadGroup threadGroup = this.readThreadGroup(dataInputStream);
                boolean bl = dataInputStream.readBoolean();
                Agent.message("Getting threads for " + threadGroup.getName());
                int n16 = threadGroup.enumerate(threadArray, bl);
                dataOutputStream.writeInt(n16);
                int n17 = 0;
                while (n17 < n16) {
                    this.writeObject(threadArray[n17]);
                    ++n17;
                }
                return;
            }
            case 26: {
                MainThread mainThread;
                String[] stringArray = new String[dataInputStream.read() - 1];
                String string = dataInputStream.readUTF();
                int n18 = 0;
                while (n18 < stringArray.length) {
                    stringArray[n18] = dataInputStream.readUTF();
                    ++n18;
                }
                ThreadGroup threadGroup = this.mainGroup;
                this.mainGroup = null;
                try {
                    CachedClass cachedClass = CachedClass.getCachedClass(string);
                    this.mainGroup = new ThreadGroup(String.valueOf(cachedClass.getName()) + ".main");
                    mainThread = new MainThread(this, this.mainGroup, cachedClass.realClass, stringArray);
                    this.writeObject(this.mainGroup);
                }
                catch (Throwable throwable) {
                    Agent.message(Agent.exceptionStackTrace(throwable));
                    this.writeObject(null);
                    return;
                }
                if (threadGroup != null) {
                    Agent.message("stopping the currently running " + this.mainGroup);
                    try {
                        threadGroup.stop();
                        Agent.message("finished stop");
                    }
                    catch (Exception exception) {
                        Agent.message("stopping current thread group failed");
                        Agent.message(Agent.exceptionStackTrace(exception));
                    }
                }
                this.resumeLastSuspendedThreads();
                this.mainCallerClass = mainThread.getClass();
                try {
                    mainThread.start();
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    Agent.exceptionError(illegalThreadStateException, " main thread already started");
                }
                Agent.beginRun();
                return;
            }
            case 27: {
                this.suspendSingleThread(this.readThread(dataInputStream));
                return;
            }
            case 28: {
                this.resumeThread(this.readThread(dataInputStream));
                return;
            }
            case 29: {
                this.resumeLastSuspendedThreads();
                return;
            }
            case 30: {
                this.suspendAllThreads();
                return;
            }
            case 35: {
                int n19;
                CachedClass cachedClass = this.readClass(dataInputStream);
                ArrayList<CachedField> arrayList = new ArrayList<CachedField>();
                try {
                    while (cachedClass != null) {
                        CachedField[] cachedFieldArray = cachedClass.getFields();
                        n19 = 0;
                        while (n19 < cachedFieldArray.length) {
                            arrayList.add(cachedFieldArray[n19]);
                            ++n19;
                        }
                        cachedClass = cachedClass.getSuperclass();
                    }
                }
                catch (AbsentInformationException absentInformationException) {
                    dataOutputStream.writeInt(0);
                    return;
                }
                int n20 = arrayList.size();
                dataOutputStream.writeInt(n20);
                n19 = 0;
                while (n19 < n20) {
                    CachedField cachedField = (CachedField)arrayList.get(n20 - 1 - n19);
                    this.writeField(dataOutputStream, cachedField);
                    dataOutputStream.writeUTF(cachedField.getName());
                    dataOutputStream.writeUTF(cachedField.getTypeSignature());
                    try {
                        dataOutputStream.writeShort(cachedField.getModifiers());
                        this.writeObject(cachedField.getDefiningClass());
                    }
                    catch (AbsentInformationException absentInformationException) {
                        dataOutputStream.writeShort(0);
                        this.writeObject(cachedClass);
                    }
                    ++n19;
                }
                return;
            }
            case 36: {
                CachedMethod[] cachedMethodArray;
                CachedClass cachedClass = this.readClass(dataInputStream);
                try {
                    cachedMethodArray = cachedClass.getMethods();
                }
                catch (AbsentInformationException absentInformationException) {
                    dataOutputStream.writeInt(0);
                    return;
                }
                dataOutputStream.writeInt(cachedMethodArray.length);
                int n21 = 0;
                while (n21 < cachedMethodArray.length) {
                    CachedMethod cachedMethod = cachedMethodArray[n21];
                    this.writeMethod(dataOutputStream, cachedMethod);
                    dataOutputStream.writeUTF(cachedMethod.getName());
                    dataOutputStream.writeUTF(cachedMethod.getTypeSignature());
                    try {
                        dataOutputStream.writeShort(cachedMethod.getModifiers());
                        this.writeObject(cachedMethod.getDefiningClass());
                    }
                    catch (AbsentInformationException absentInformationException) {
                        dataOutputStream.writeShort(0);
                        this.writeObject(cachedClass);
                    }
                    ++n21;
                }
                return;
            }
            case 40: {
                Object object = this.readObject(dataInputStream);
                int n22 = dataInputStream.readInt();
                int n23 = dataInputStream.readInt();
                int n24 = dataInputStream.readInt();
                dataOutputStream.writeInt(n24 - n23 + 1);
                switch (n22) {
                    case 2: {
                        char[] cArray = (char[])object;
                        int n25 = n23;
                        while (n25 <= n24) {
                            this.write(cArray[n25]);
                            ++n25;
                        }
                        return;
                    }
                    case 1: {
                        byte[] byArray = (byte[])object;
                        int n26 = n23;
                        while (n26 <= n24) {
                            this.write(byArray[n26]);
                            ++n26;
                        }
                        return;
                    }
                    case 9: 
                    case 10: 
                    case 17: {
                        Object[] objectArray = (Object[])object;
                        int n27 = n23;
                        while (n27 <= n24) {
                            this.writeObject(objectArray[n27]);
                            ++n27;
                        }
                        return;
                    }
                    case 6: {
                        float[] fArray = (float[])object;
                        int n28 = n23;
                        while (n28 <= n24) {
                            this.write(fArray[n28]);
                            ++n28;
                        }
                        return;
                    }
                    case 7: {
                        double[] dArray = (double[])object;
                        int n29 = n23;
                        while (n29 <= n24) {
                            this.write(dArray[n29]);
                            ++n29;
                        }
                        return;
                    }
                    case 4: {
                        int[] nArray = (int[])object;
                        int n30 = n23;
                        while (n30 <= n24) {
                            this.write(nArray[n30]);
                            ++n30;
                        }
                        return;
                    }
                    case 5: {
                        long[] lArray = (long[])object;
                        int n31 = n23;
                        while (n31 <= n24) {
                            this.write(lArray[n31]);
                            ++n31;
                        }
                        return;
                    }
                    case 3: {
                        short[] sArray = (short[])object;
                        int n32 = n23;
                        while (n32 <= n24) {
                            this.write(sArray[n32]);
                            ++n32;
                        }
                        return;
                    }
                    case 0: {
                        boolean[] blArray = (boolean[])object;
                        int n33 = n23;
                        while (n33 <= n24) {
                            this.write(blArray[n33]);
                            ++n33;
                        }
                        return;
                    }
                }
                int n34 = n23;
                while (n34 <= n24) {
                    this.writeObject(null);
                    ++n34;
                }
                return;
            }
            case 39: {
                Object object = this.readObject(dataInputStream);
                Class<?> clazz = object instanceof Class ? (Class<?>)object : object.getClass();
                CachedField cachedField = this.readField(dataInputStream, clazz);
                String string = cachedField.getTypeSignature();
                if (string == null) {
                    this.writeObject(new ArrayIndexOutOfBoundsException("invalid field " + cachedField));
                    return;
                }
                long l = cachedField.fieldID;
                if (object instanceof Class) {
                    this.writeStaticFieldWithSignature(clazz, l, string);
                } else {
                    this.writeFieldWithSignature(object, l, string);
                }
                return;
            }
            case 68: {
                Object object = this.readObject(dataInputStream);
                Class<?> clazz = object instanceof Class ? (Class<?>)object : object.getClass();
                CachedField cachedField = this.readField(dataInputStream, clazz);
                long l = cachedField.fieldID;
                int n35 = dataInputStream.readInt();
                if (object instanceof Class) {
                    this.setStaticField(clazz, l, n35, dataInputStream);
                } else {
                    this.setField(object, l, n35, dataInputStream);
                }
                return;
            }
            case 41: {
                Location location;
                CachedClass cachedClass = this.readClass(dataInputStream);
                int n36 = dataInputStream.readInt();
                try {
                    location = cachedClass.lineToLocation(n36);
                }
                catch (AbsentInformationException absentInformationException) {
                    location = null;
                }
                String string = "";
                if (location == null) {
                    string = "No code at line " + n36 + ", or class is optimized.";
                } else {
                    CachedMethod cachedMethod = location.method;
                    try {
                        Breakpoint.addBreakpoint(cachedMethod, location.startBCI, 1);
                    }
                    catch (Exception exception) {
                        Agent.message(Agent.exceptionStackTrace(exception));
                        string = exception.toString();
                    }
                }
                dataOutputStream.writeUTF(string);
                return;
            }
            case 42: {
                CachedMethod cachedMethod = this.readMethod(dataInputStream);
                String string = "";
                try {
                    Breakpoint.addBreakpoint(cachedMethod, 0, 1);
                }
                catch (Exception exception) {
                    Agent.message(Agent.exceptionStackTrace(exception));
                    string = exception.toString();
                }
                dataOutputStream.writeUTF(string);
                return;
            }
            case 65: {
                Breakpoint[] breakpointArray = Breakpoint.listBreakpoints();
                dataOutputStream.writeInt(breakpointArray.length);
                int n37 = 0;
                while (n37 < breakpointArray.length) {
                    Breakpoint breakpoint = breakpointArray[n37];
                    try {
                        dataOutputStream.writeUTF(String.valueOf(breakpoint.getRealClass().getName()) + ":" + breakpoint.method.bciToLocation((int)breakpoint.bci).line);
                    }
                    catch (AbsentInformationException absentInformationException) {
                        dataOutputStream.writeUTF(String.valueOf(breakpoint.getRealClass().getName()) + "." + breakpoint.method.getName());
                    }
                    ++n37;
                }
                return;
            }
            case 43: {
                String string = "";
                dataOutputStream.writeUTF(string);
                return;
            }
            case 44: {
                Location location;
                String string = "";
                CachedClass cachedClass = this.readClass(dataInputStream);
                int n38 = dataInputStream.readInt();
                Agent.message("clearing bkpt at " + cachedClass.getName() + ":" + n38);
                try {
                    location = cachedClass.lineToLocation(n38);
                }
                catch (AbsentInformationException absentInformationException) {
                    location = null;
                }
                if (location == null) {
                    string = "No code at line " + n38 + ", or class is optimized.";
                } else {
                    CachedMethod cachedMethod = location.method;
                    try {
                        Breakpoint.deleteBreakpoint(cachedMethod, location.startBCI);
                    }
                    catch (Exception exception) {
                        Agent.message(Agent.exceptionStackTrace(exception));
                        string = exception.toString();
                    }
                }
                dataOutputStream.writeUTF(string);
                return;
            }
            case 45: {
                CachedMethod cachedMethod = this.readMethod(dataInputStream);
                Agent.message("clearing bkpt at " + cachedMethod.getName());
                String string = "";
                try {
                    Breakpoint.deleteBreakpoint(cachedMethod, 0);
                }
                catch (Exception exception) {
                    Agent.message(Agent.exceptionStackTrace(exception));
                    string = exception.toString();
                }
                dataOutputStream.writeUTF(string);
                return;
            }
            case 53: {
                String string = "";
                try {
                    CachedClass cachedClass = this.readClass(dataInputStream);
                    this.handler.catchExceptionClass(cachedClass.realClass);
                }
                catch (Exception exception) {
                    Agent.exceptionError(exception, " catchExceptionClass failed: ");
                }
                return;
            }
            case 54: {
                String string = "";
                try {
                    CachedClass cachedClass = this.readClass(dataInputStream);
                    this.handler.ignoreExceptionClass(cachedClass.realClass);
                }
                catch (Exception exception) {
                    Agent.exceptionError(exception, "ignoreExceptionClass failed: ");
                }
                return;
            }
            case 55: {
                Class[] classArray = this.handler.getCatchList();
                dataOutputStream.writeInt(classArray.length);
                int n39 = 0;
                while (n39 < classArray.length) {
                    this.writeObject(classArray[n39]);
                    ++n39;
                }
                return;
            }
            case 56: {
                Thread thread = this.readThread(dataInputStream);
                thread.stop();
                Agent.message(String.valueOf(thread.getName()) + " stopped.");
                return;
            }
            case 57: {
                ThreadGroup threadGroup = this.readThreadGroup(dataInputStream);
                threadGroup.stop();
                Agent.message(String.valueOf(threadGroup.getName()) + " stopped.");
                return;
            }
            case 51: {
                verbose = dataInputStream.readBoolean();
                return;
            }
            case 34: {
                switch (dataInputStream.readInt()) {
                    case 2: {
                        dataOutputStream.writeInt((int)Runtime.getRuntime().freeMemory());
                        break;
                    }
                    case 1: {
                        dataOutputStream.writeInt((int)Runtime.getRuntime().totalMemory());
                        break;
                    }
                    case 3: {
                        Runtime.getRuntime().traceMethodCalls(dataInputStream.readInt() != 0);
                        break;
                    }
                    case 4: {
                        Runtime.getRuntime().traceInstructions(dataInputStream.readInt() != 0);
                        break;
                    }
                }
                return;
            }
            case 59: {
                String string = dataInputStream.readUTF();
                String string2 = dataInputStream.readUTF();
                int n40 = string2.lastIndexOf(46);
                String string3 = n40 >= 0 ? string2.substring(0, n40) : "";
                Package package_ = null;
                try {
                    package_ = new Package(this.sourcePath, Identifier.lookup(string3));
                }
                catch (Exception exception) {
                    Agent.message("cannot create a Package for " + string3);
                    dataOutputStream.writeInt(-1);
                    return;
                }
                ClassFile classFile = null;
                InputStream inputStream = null;
                try {
                    classFile = package_.getSourceFile(string);
                    if (classFile == null) {
                        Agent.message("no source " + string);
                        dataOutputStream.writeInt(-1);
                        return;
                    }
                    inputStream = classFile.getInputStream();
                }
                catch (Exception exception) {
                    Agent.message("cannot find " + string);
                    dataOutputStream.writeInt(-1);
                    return;
                }
                int n41 = (int)classFile.length();
                dataOutputStream.writeInt(n41);
                byte[] byArray = new byte[n41];
                try {
                    int n42 = 0;
                    int n43 = byArray.length;
                    while (n43 > 0) {
                        int n44 = inputStream.read(byArray, n42, n43);
                        if (n44 == -1) {
                            throw new IOException();
                        }
                        n42 += n44;
                        n43 -= n44;
                    }
                    dataOutputStream.write(byArray);
                }
                catch (IOException iOException) {
                    Agent.exceptionError(iOException, " unable to read " + string);
                    return;
                }
                inputStream.close();
                return;
            }
            case 60: {
                Object object = this.readObject(dataInputStream);
                String string = "";
                try {
                    string = object.toString();
                }
                catch (Exception exception) {}
                dataOutputStream.writeUTF(string);
                return;
            }
            case 61: {
                dataOutputStream.writeUTF(this.sourcePath.toString());
                return;
            }
            case 62: {
                String string = dataInputStream.readUTF();
                if (string == null) {
                    string = ".";
                }
                this.sourcePath = new ClassPath(string);
                return;
            }
            case 63: {
                this.stepHandler.stepThread(this.readThread(dataInputStream), dataInputStream.readBoolean());
                return;
            }
            case 64: {
                this.stepHandler.stepNextThread(this.readThread(dataInputStream));
                return;
            }
            case 73: {
                this.stepHandler.stepOutThread(this.readThread(dataInputStream));
                return;
            }
            case 70: {
                this.objectCache.free(dataInputStream.readInt());
                return;
            }
            case 71: {
                int[] nArray;
                CachedClass cachedClass = this.readClass(dataInputStream);
                try {
                    nArray = cachedClass.getLinenumbers();
                }
                catch (AbsentInformationException absentInformationException) {
                    dataOutputStream.writeInt(0);
                    return;
                }
                int n45 = nArray.length;
                dataOutputStream.writeInt(n45);
                int n46 = 0;
                while (n46 < n45) {
                    dataOutputStream.writeInt(nArray[n46]);
                    ++n46;
                }
                return;
            }
            case 72: {
                int n47;
                CachedClass cachedClass = this.readClass(dataInputStream);
                int n48 = dataInputStream.readInt();
                try {
                    CachedMethod[] cachedMethodArray = cachedClass.getMethods();
                    n47 = cachedMethodArray[n48].getLinenumber();
                }
                catch (AbsentInformationException absentInformationException) {
                    n47 = -1;
                }
                dataOutputStream.writeInt(n47);
                return;
            }
            case 58: {
                this.debuggerTerminating = true;
                if (this.lastSuspended != null) {
                    this.resumeLastSuspendedThreads();
                }
                System.exit(0);
            }
        }
        Agent.error("command not understood: " + n);
    }

    native void initAgent(Event var1, StackFrame var2);

    private static void initSystemThread(String string) {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        if (!threadGroup.getName().equals("system")) {
            Agent.error("findThread called from wrong threadgroup (" + threadGroup.getName() + ")");
            return;
        }
        Thread[] threadArray = new Thread[40];
        int n = threadGroup.enumerate(threadArray, false);
        int n2 = 0;
        while (n2 < n) {
            if (threadArray[n2].getName().equals(string)) {
                Agent.message("adding " + string + " to system thread list");
                Agent.addSystemThread(threadArray[n2]);
                return;
            }
            ++n2;
        }
        Agent.message(String.valueOf(string) + " not found in system threadgroup");
    }

    private static void initSystemThreadList() {
        Agent.initSystemThread("Debugger agent");
        Agent.initSystemThread("Breakpoint handler");
        Agent.initSystemThread("Step handler");
        Agent.initSystemThread("Finalizer");
        Agent.initSystemThread("Reference Handler");
        Agent.initSystemThread("Signal dispatcher");
    }

    static boolean isDebuggable() {
        return the_Agent != null && !Agent.the_Agent.useSockets;
    }

    private String makePassword(int n) {
        if (n > 65535) {
            System.err.println("Invalid port number (" + n + ")???");
            System.exit(1);
        }
        int n2 = (int)(Math.round(Math.random() * 2048.0) % 2048L);
        int n3 = 0;
        int n4 = 3;
        int n5 = 0;
        while (n5 < 8) {
            int n6 = (n & n4) << n5 + 1;
            int n7 = (n2 & 1 << n5) << n5 * 2;
            n3 |= n6 | n7;
            n4 <<= 2;
            ++n5;
        }
        return this.cookieToString(n3 |= (n2 & 0x700) << 16);
    }

    static void message(String string) {
        if (messageWriter != null) {
            messageWriter.println("[debug agent: " + string + "]");
        }
    }

    private CachedClass readClass(DataInputStream dataInputStream) throws IOException {
        return (CachedClass)this.objectCache.getObject(dataInputStream.readInt());
    }

    private CachedField readField(DataInputStream dataInputStream, Class clazz) throws IOException {
        CachedClass cachedClass = CachedClass.getCachedClass(clazz);
        long l = dataInputStream.readInt();
        CachedField cachedField = null;
        while (cachedClass != null && cachedField == null) {
            try {
                cachedField = cachedClass.getField(l);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            cachedClass = cachedClass.getSuperclass();
        }
        return cachedField;
    }

    private CachedMethod readMethod(DataInputStream dataInputStream) throws IOException {
        CachedClass cachedClass = this.readClass(dataInputStream);
        long l = dataInputStream.readInt();
        return cachedClass.getMethod(l);
    }

    private Object readObject(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        Object object = this.objectCache.getObject(n);
        if (object instanceof CachedClass) {
            object = ((CachedClass)object).realClass;
        }
        return object;
    }

    private Thread readThread(DataInputStream dataInputStream) throws IOException {
        return (Thread)this.objectCache.getObject(dataInputStream.readInt());
    }

    private ThreadGroup readThreadGroup(DataInputStream dataInputStream) throws IOException {
        return (ThreadGroup)this.objectCache.getObject(dataInputStream.readInt());
    }

    public static synchronized native void removeSystemThread(Thread var0);

    void reportAppException(Event event) throws IOException {
        String string = event.catch_clazz == null || event.catch_clazz == this.mainCallerClass ? "Uncaught exception: " : "Exception: ";
        String string2 = Agent.exceptionStackTrace(event.exception);
        string = string.concat(string2);
        DataOutputStream dataOutputStream = this.asyncOutputStream;
        synchronized (dataOutputStream) {
            this.asyncOutputStream.write(52);
            this.writeObject(event.thread, this.asyncOutputStream);
            this.asyncOutputStream.writeUTF(string);
            this.asyncOutputStream.flush();
        }
    }

    void reportAppExit() {
        Agent.message("report application exit");
        try {
            DataOutputStream dataOutputStream = this.asyncOutputStream;
            synchronized (dataOutputStream) {
                this.asyncOutputStream.write(67);
                this.asyncOutputStream.flush();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (IOException iOException) {
            Agent.message("unable to notify debugger");
        }
    }

    void reportBreakpoint(Event event) throws IOException {
        DataOutputStream dataOutputStream = this.asyncOutputStream;
        synchronized (dataOutputStream) {
            this.asyncOutputStream.write(46);
            this.writeObject(event.thread, this.asyncOutputStream);
            this.asyncOutputStream.flush();
        }
    }

    void reportThreadEnd(Event event) throws IOException {
        DataOutputStream dataOutputStream = this.asyncOutputStream;
        synchronized (dataOutputStream) {
            this.asyncOutputStream.write(66);
            this.writeObject(event.thread, this.asyncOutputStream);
            this.asyncOutputStream.flush();
        }
    }

    void resumeLastSuspendedThreads() {
        ThreadList threadList = this.lastSuspended;
        this.lastSuspended = null;
        if (threadList == null) {
            Agent.message("no last suspended to resume");
            return;
        }
        Agent.message("resumeLastSuspendedThreads()");
        int n = 0;
        while (n < threadList.count) {
            this.resumeThread(threadList.threads[n]);
            ++n;
        }
    }

    private void resumeThread(Thread thread) {
        block2: {
            if (Agent.systemThread(thread)) break block2;
            try {
                thread.resume();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                Agent.exceptionError(illegalThreadStateException, " resume failed: ");
            }
        }
    }

    public void run() {
        PrintStream printStream = null;
        PrintStream printStream2 = null;
        Socket socket = null;
        Socket socket2 = null;
        this.sourcePath = new ClassPath();
        this.setUpMessageWriter();
        try {
            this.objectCache = new ObjectCache();
            this.handler = new Handler(this);
            this.handler.setPriority(9);
            this.stepHandler = new StepHandler(this);
            this.stepHandler.start();
            this.handler.start();
            Agent.initSystemThreadList();
            this.initAgent(Handler.the_event, new StackFrame());
            Class<?> clazz = this.getClass();
            Object object = clazz;
            synchronized (object) {
                clazz.notifyAll();
            }
            while (true) {
                Object object2;
                printStream = System.out;
                printStream2 = System.err;
                if (this.useSockets) {
                    socket = this.socket.accept();
                    Agent.message("cmd socket: " + socket.toString());
                    object = new DataInputStream(new BufferedInputStream(socket.getInputStream()));
                    this.outBuffer = new ResponseStream(socket.getOutputStream(), 8192);
                    this.out = new DataOutputStream(this.outBuffer);
                    socket2 = this.socket.accept();
                    this.asyncOutputStream = new DataOutputStream(new BufferedOutputStream(socket2.getOutputStream()));
                    this.agentOut = new AgentOutputStream(this.asyncOutputStream);
                    object2 = new BufferedOutputStream(this.agentOut, 128);
                    PrintStream printStream3 = new PrintStream((OutputStream)object2, true);
                    System.setOut(printStream3);
                    System.setErr(printStream3);
                } else {
                    try {
                        object2 = Agent.the_Agent.pipeLock;
                        synchronized (object2) {
                            Agent.the_Agent.pipeLock.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    object = new DataInputStream(this.cmdInputPipe);
                    this.outBuffer = new ResponseStream(this.cmdOutputPipe, 8192);
                    this.out = new DataOutputStream(this.outBuffer);
                    this.asyncOutputStream = new DataOutputStream(this.asyncOutputPipe);
                    this.agentOut = new AgentOutputStream(this.asyncOutputStream);
                    object2 = new PrintStream(this.agentOut, true);
                    System.setOut((PrintStream)object2);
                    System.setErr((PrintStream)object2);
                }
                Agent.message("connection accepted");
                this.out.writeInt(3);
                try {
                    this.writeObject(Class.forName("java.lang.Object"));
                    this.writeObject(Class.forName("java.lang.Class"));
                    this.writeObject(Class.forName("java.lang.String"));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    System.exit(1);
                }
                this.dumpClasses();
                this.writeObject(Thread.currentThread().getThreadGroup());
                this.out.flush();
                try {
                    int n = ((FilterInputStream)object).read();
                    while (n != -1) {
                        try {
                            this.handle(n, (DataInputStream)object, this.out);
                        }
                        catch (Throwable throwable) {
                            Agent.exceptionError(throwable, " during command processing");
                            this.outBuffer.reset();
                            this.out.writeInt(-2);
                            this.out.writeUTF(throwable.toString());
                        }
                        this.out.flush();
                        n = ((FilterInputStream)object).read();
                    }
                }
                catch (Exception exception) {
                    System.setOut(printStream);
                    System.setErr(printStream2);
                    Agent.exceptionError(exception, " during command processing");
                }
                System.setOut(printStream);
                System.setErr(printStream2);
                Agent.message("connection closed");
            }
        }
        catch (ThreadDeath threadDeath) {
            System.setOut(printStream);
            System.setErr(printStream2);
            Agent.message("ThreadDeath caught - and rethrown.");
            throw threadDeath;
        }
        catch (IOException iOException) {
            block27: {
                System.setOut(printStream);
                System.setErr(printStream2);
                Agent.message("IOException caught.");
                if (socket2 != null) {
                    try {
                        socket2.close();
                    }
                    catch (Exception exception) {}
                }
                if (socket == null) break block27;
                try {
                    socket.close();
                }
                catch (Exception exception) {}
            }
            return;
        }
    }

    private void setField(Object object, long l, int n, DataInputStream dataInputStream) throws IOException {
        switch (n) {
            case 0: {
                this.setFieldBoolean(object, l, dataInputStream.readBoolean());
                break;
            }
            case 1: {
                this.setFieldByte(object, l, dataInputStream.readByte());
                break;
            }
            case 2: {
                this.setFieldChar(object, l, dataInputStream.readChar());
                break;
            }
            case 3: {
                this.setFieldShort(object, l, dataInputStream.readShort());
                break;
            }
            case 4: {
                this.setFieldInt(object, l, dataInputStream.readInt());
                break;
            }
            case 5: {
                this.setFieldLong(object, l, dataInputStream.readLong());
                break;
            }
            case 6: {
                this.setFieldFloat(object, l, dataInputStream.readFloat());
                break;
            }
            case 7: {
                this.setFieldDouble(object, l, dataInputStream.readDouble());
                break;
            }
            default: {
                Agent.error("bogus type(" + n + ")");
            }
        }
    }

    native void setFieldBoolean(Object var1, long var2, boolean var4);

    native void setFieldByte(Object var1, long var2, byte var4);

    native void setFieldChar(Object var1, long var2, char var4);

    native void setFieldDouble(Object var1, long var2, double var4);

    native void setFieldFloat(Object var1, long var2, float var4);

    native void setFieldInt(Object var1, long var2, int var4);

    native void setFieldLong(Object var1, long var2, long var4);

    native void setFieldShort(Object var1, long var2, short var4);

    native void setSingleStep(Thread var1, boolean var2);

    native void setStackBoolean(Thread var1, int var2, int var3, boolean var4);

    native void setStackDouble(Thread var1, int var2, int var3, double var4);

    native void setStackInt(Thread var1, int var2, int var3, int var4);

    native void setStackLong(Thread var1, int var2, int var3, long var4);

    private void setStaticField(Class clazz, long l, int n, DataInputStream dataInputStream) throws IOException {
        switch (n) {
            case 0: {
                this.setStaticFieldBoolean(clazz, l, dataInputStream.readBoolean());
                break;
            }
            case 1: {
                this.setStaticFieldByte(clazz, l, dataInputStream.readByte());
                break;
            }
            case 2: {
                this.setStaticFieldChar(clazz, l, dataInputStream.readChar());
                break;
            }
            case 3: {
                this.setStaticFieldShort(clazz, l, dataInputStream.readShort());
                break;
            }
            case 4: {
                this.setStaticFieldInt(clazz, l, dataInputStream.readInt());
                break;
            }
            case 5: {
                this.setStaticFieldLong(clazz, l, dataInputStream.readLong());
                break;
            }
            case 6: {
                this.setStaticFieldFloat(clazz, l, dataInputStream.readFloat());
                break;
            }
            case 7: {
                this.setStaticFieldDouble(clazz, l, dataInputStream.readDouble());
                break;
            }
            default: {
                Agent.error("bogus type(" + n + ")");
            }
        }
    }

    native void setStaticFieldBoolean(Class var1, long var2, boolean var4);

    native void setStaticFieldByte(Class var1, long var2, byte var4);

    native void setStaticFieldChar(Class var1, long var2, char var4);

    native void setStaticFieldDouble(Class var1, long var2, double var4);

    native void setStaticFieldFloat(Class var1, long var2, float var4);

    native void setStaticFieldInt(Class var1, long var2, int var4);

    native void setStaticFieldLong(Class var1, long var2, long var4);

    native void setStaticFieldShort(Class var1, long var2, short var4);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setUpMessageWriter() {
        FileReader fileReader = null;
        try {
            try {
                char[] cArray = new char[256];
                fileReader = new FileReader(".agentLog");
                int n = fileReader.read(cArray, 0, 255);
                String string = new String(cArray, 0, n).trim();
                try {
                    messageWriter = new PrintWriter((Writer)new FileWriter(string, true), true);
                    messageWriter.println("---- debug agent message log ----");
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (IOException iOException) {
                    if (messageWriter != null) {
                        messageWriter.close();
                    }
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
            }
            Object var3_5 = null;
            if (fileReader == null) return;
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            if (fileReader == null) throw throwable;
            try {
                fileReader.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            fileReader.close();
            return;
        }
        catch (IOException iOException) {}
    }

    void suspendAllThreads() {
        Agent.message("suspendAllThreads()");
        ThreadList threadList = new ThreadList();
        Event event = Handler.the_event;
        synchronized (event) {
            DataOutputStream dataOutputStream = this.asyncOutputStream;
            synchronized (dataOutputStream) {
                Agent.suspendListOfThreads(threadList.count, threadList.threads);
                this.lastSuspended = threadList;
            }
        }
    }

    public static native void suspendListOfThreads(int var0, Thread[] var1);

    void suspendSingleThread(Thread thread) {
        if (!Agent.systemThread(thread)) {
            Event event = Handler.the_event;
            synchronized (event) {
                DataOutputStream dataOutputStream = this.asyncOutputStream;
                synchronized (dataOutputStream) {
                    Agent.suspendSpecificThread(thread);
                }
            }
        }
    }

    public static native void suspendSpecificThread(Thread var0);

    public static synchronized native boolean systemThread(Thread var0);

    private void temporaryResume(Thread thread) {
        if (thread == null) {
            return;
        }
        try {
            thread.resume();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {}
    }

    private Thread temporarySuspend(Thread thread) {
        if (Agent.systemThread(thread)) {
            return null;
        }
        int n = this.getThreadStatus(thread);
        if (n == 5 || n == 6) {
            return null;
        }
        this.suspendSingleThread(thread);
        return thread;
    }

    static String toHex(int n) {
        char[] cArray = new char[10];
        int n2 = 0;
        while (n2 < 10) {
            cArray[n2] = 48;
            ++n2;
        }
        cArray[1] = 120;
        int n3 = 9;
        while (n != 0) {
            int n4 = n & 0xF;
            cArray[n3] = (char)(n4 < 10 ? 48 + n4 : 97 + n4 - 10);
            n >>>= 4;
            --n3;
        }
        return new String(cArray);
    }

    void write(byte by) throws IOException {
        this.out.writeInt(1);
        this.out.writeByte(by);
    }

    void write(char c) throws IOException {
        this.out.writeInt(2);
        this.out.writeChar(c);
    }

    void write(double d) throws IOException {
        this.out.writeInt(7);
        this.out.writeDouble(d);
    }

    void write(float f) throws IOException {
        this.out.writeInt(6);
        this.out.writeFloat(f);
    }

    void write(int n) throws IOException {
        this.out.writeInt(4);
        this.out.writeInt(n);
    }

    void write(long l) throws IOException {
        this.out.writeInt(5);
        this.out.writeLong(l);
    }

    void write(short s) throws IOException {
        this.out.writeInt(3);
        this.out.writeShort(s);
    }

    void write(boolean bl) throws IOException {
        this.out.writeInt(0);
        this.out.writeBoolean(bl);
    }

    private void writeField(DataOutputStream dataOutputStream, CachedField cachedField) throws IOException {
        dataOutputStream.writeInt((int)cachedField.fieldID);
    }

    private void writeFieldWithSignature(Object object, long l, String string) throws IOException {
        switch (string.charAt(0)) {
            case 'Z': {
                this.write(this.getFieldBoolean(object, l));
                return;
            }
            case 'B': {
                this.write(this.getFieldByte(object, l));
                return;
            }
            case 'C': {
                this.write(this.getFieldChar(object, l));
                return;
            }
            case 'S': {
                this.write(this.getFieldShort(object, l));
                return;
            }
            case 'I': {
                this.write(this.getFieldInt(object, l));
                return;
            }
            case 'J': {
                this.write(this.getFieldLong(object, l));
                return;
            }
            case 'F': {
                this.write(this.getFieldFloat(object, l));
                return;
            }
            case 'D': {
                this.write(this.getFieldDouble(object, l));
                return;
            }
            case 'L': 
            case '[': {
                Object object2 = this.getFieldObject(object, l);
                this.writeObject(object2);
                return;
            }
            case 'V': {
                this.writeObject(null);
                return;
            }
        }
        String string2 = "bogus signature(" + string + ")";
        Agent.error(string2);
        this.writeObject(string2);
    }

    private void writeMethod(DataOutputStream dataOutputStream, CachedMethod cachedMethod) throws IOException {
        dataOutputStream.writeInt((int)cachedMethod.methodID);
    }

    void writeObject(Object object) throws IOException {
        this.writeObject(object, this.out);
    }

    void writeObject(Object object, DataOutputStream dataOutputStream) throws IOException {
        int n = 0;
        boolean bl = false;
        if (object == null) {
            dataOutputStream.writeInt(17);
        } else if (object instanceof Class) {
            dataOutputStream.writeInt(16);
            CachedClass cachedClass = CachedClass.getCachedClass((Class)object);
            n = this.objectCache.getId(cachedClass);
        } else if (object instanceof CachedClass) {
            dataOutputStream.writeInt(16);
            n = this.objectCache.getId(object);
        } else if (object instanceof String) {
            dataOutputStream.writeInt(18);
            n = this.objectCache.getId(object);
        } else {
            if (object instanceof Thread) {
                dataOutputStream.writeInt(19);
            } else if (object instanceof ThreadGroup) {
                dataOutputStream.writeInt(15);
            } else if (object.getClass().isArray()) {
                dataOutputStream.writeInt(9);
                bl = true;
            } else {
                dataOutputStream.writeInt(17);
            }
            Class<?> clazz = object.getClass();
            CachedClass cachedClass = CachedClass.getCachedClass(clazz);
            n = this.objectCache.getId(cachedClass);
            dataOutputStream.writeInt(n);
            n = this.objectCache.getId(object);
        }
        dataOutputStream.writeInt(n);
        if (bl) {
            dataOutputStream.writeInt(Array.getLength(object));
        }
    }

    private void writeStaticFieldWithSignature(Class clazz, long l, String string) throws IOException {
        switch (string.charAt(0)) {
            case 'Z': {
                this.write(this.getStaticFieldBoolean(clazz, l));
                return;
            }
            case 'B': {
                this.write(this.getStaticFieldByte(clazz, l));
                return;
            }
            case 'C': {
                this.write(this.getStaticFieldChar(clazz, l));
                return;
            }
            case 'S': {
                this.write(this.getStaticFieldShort(clazz, l));
                return;
            }
            case 'I': {
                this.write(this.getStaticFieldInt(clazz, l));
                return;
            }
            case 'J': {
                this.write(this.getStaticFieldLong(clazz, l));
                return;
            }
            case 'F': {
                this.write(this.getStaticFieldFloat(clazz, l));
                return;
            }
            case 'D': {
                this.write(this.getStaticFieldDouble(clazz, l));
                return;
            }
            case 'L': 
            case '[': {
                Object object = this.getStaticFieldObject(clazz, l);
                this.writeObject(object);
                return;
            }
            case 'V': {
                this.writeObject(null);
                return;
            }
        }
        String string2 = "bogus signature(" + string + ")";
        Agent.error(string2);
        this.writeObject(string2);
    }
}

