/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javadoc;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.Tag;
import com.sun.javadoc.ThrowsTag;
import com.sun.tools.javadoc.ClassDocImpl;
import com.sun.tools.javadoc.Comment;
import com.sun.tools.javadoc.ExecutableMemberDocImpl;
import com.sun.tools.javadoc.Res;
import com.sun.tools.javadoc.TagImpl;

class ThrowsTagImpl
extends TagImpl
implements ThrowsTag {
    final String exceptionName;
    final String exceptionComment;
    final ClassDoc exceptionClass;
    private static ClassDocImpl runtimeException;

    ThrowsTagImpl(Doc doc, String string, String string2) {
        super(doc, string, string2);
        if (runtimeException == null) {
            runtimeException = ClassDocImpl.lookup("java.lang.RuntimeException");
        }
        String[] stringArray = this.divideAtWhite();
        this.exceptionName = stringArray[0];
        this.exceptionComment = stringArray[1];
        if (!(doc instanceof ExecutableMemberDocImpl)) {
            Res.warning("tag.not_on_method", doc.toString(), this.text);
            this.exceptionClass = null;
        } else {
            ExecutableMemberDocImpl executableMemberDocImpl = (ExecutableMemberDocImpl)doc;
            ClassDoc classDoc = executableMemberDocImpl.containingClass();
            this.exceptionClass = classDoc.findClass(this.exceptionName);
            if (this.exceptionClass != null && !ThrowsTagImpl.isOK(this.exceptionClass, executableMemberDocImpl.thrownExceptions())) {
                Res.warning("tag.throws.does_not_declare", executableMemberDocImpl.qualifiedName(), this.exceptionClass.qualifiedName());
            }
        }
    }

    public ClassDoc exception() {
        return this.exceptionClass;
    }

    public String exceptionComment() {
        return this.exceptionComment;
    }

    public String exceptionName() {
        return this.exceptionName;
    }

    public Tag[] inlineTags() {
        return Comment.getInlineTags(this.holder, this.exceptionComment);
    }

    private static boolean isOK(ClassDoc classDoc, ClassDoc[] classDocArray) {
        if (classDoc.isError()) {
            return true;
        }
        if (classDoc.subclassOf(runtimeException)) {
            return true;
        }
        int n = 0;
        while (n < classDocArray.length) {
            if (classDoc.subclassOf(classDocArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public String kind() {
        return "@throws";
    }
}

