/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javadoc;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ConstructorDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.tools.javadoc.ConstructorDocImpl;
import com.sun.tools.javadoc.Env;
import com.sun.tools.javadoc.ExecutableMemberDocImpl;
import com.sun.tools.javadoc.FieldDocImpl;
import com.sun.tools.javadoc.MethodDocImpl;
import com.sun.tools.javadoc.PackageDocImpl;
import com.sun.tools.javadoc.ProgramElementDocImpl;
import com.sun.tools.javadoc.Res;
import com.sun.tools.javadoc.SerializedForm;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import sun.tools.java.ClassDeclaration;
import sun.tools.java.ClassDefinition;
import sun.tools.java.ClassNotFound;
import sun.tools.java.Environment;
import sun.tools.java.Identifier;
import sun.tools.java.IdentifierToken;
import sun.tools.java.Imports;
import sun.tools.java.MemberDefinition;
import sun.tools.javac.SourceClass;

class ClassDocImpl
extends ProgramElementDocImpl
implements ClassDoc {
    private static Map classMap = new HashMap();
    private static final int INTERFACE = 1;
    private static final int ORDINARY_CLASS = 2;
    private static final int EXCEPTION = 3;
    private static final int ERROR = 4;
    private int kind;
    final String qualifier;
    final String name;
    final ClassDocImpl superclass;
    final PackageDocImpl containingPackage;
    final List fields = new ArrayList();
    final List methods = new ArrayList();
    final List constructors = new ArrayList();
    final List innerClasses = new ArrayList();
    ClassDocImpl[] interfaces = new ClassDocImpl[0];
    final List importedClasses = new ArrayList();
    final List importedPackages = new ArrayList();
    boolean isIncluded;
    private SerializedForm serializedForm;
    private static final int NOT_SERIALIZABLE = 1;
    private static final int SERIALIZABLE = 2;
    private static final int EXTERNALIZABLE = 4;
    private int serializationKind;
    private static ClassDeclaration serializableClassDecl;
    private static ClassDeclaration externalizableClassDecl;
    static LinkedList constructionCompletionQueue;

    static {
        constructionCompletionQueue = new LinkedList();
    }

    private ClassDocImpl(Env env, ClassDeclaration classDeclaration) {
        this(env, classDeclaration, "", 0, null, null);
        this.kind = 2;
        this.isIncluded = false;
    }

    private ClassDocImpl(Env env, ClassDeclaration classDeclaration, String string, int n, ClassDefinition classDefinition, ClassDocImpl classDocImpl) {
        super(env, string, n, classDefinition);
        this.superclass = classDocImpl;
        this.kind = this.kind;
        Identifier identifier = classDeclaration.getName();
        Identifier identifier2 = identifier.getQualifier();
        this.qualifier = identifier2.toString();
        this.containingPackage = PackageDocImpl.getPackageDocImpl(env, this.qualifier);
        this.containingPackage.addClass(this);
        this.name = identifier.getFlatName().toString();
        classMap.put(this.qualifiedName(), this);
    }

    private ClassDocImpl(Env env, ClassDefinition classDefinition, ClassDeclaration classDeclaration) {
        this(env, classDeclaration, classDefinition.getDocumentation(), classDefinition.getModifiers(), classDefinition.getOuterClass(), ClassDocImpl.superclass(env, classDefinition));
        this.kind = this.kind(classDefinition);
        this.isIncluded = this.containingPackage.isIncluded && this.shouldDocument(classDefinition);
        constructionCompletionQueue.addLast(new DefDoc(classDefinition, this));
    }

    public ClassDoc asClassDoc() {
        return this;
    }

    public ConstructorDoc[] constructors() {
        return this.constructors.toArray(new ConstructorDoc[this.constructors.size()]);
    }

    public PackageDoc containingPackage() {
        return this.containingPackage;
    }

    public boolean definesSerializableFields() {
        return this.serializedForm != null ? this.serializedForm.definesSerializableFields() : false;
    }

    public String dimension() {
        return "";
    }

    public FieldDoc[] fields() {
        return this.fields.toArray(new FieldDoc[this.fields.size()]);
    }

    private void fillInMembers(Env env, ClassDefinition classDefinition) {
        MemberDefinition memberDefinition = classDefinition.getFirstMember();
        while (memberDefinition != null) {
            if (this.shouldDocument(memberDefinition)) {
                if (memberDefinition.isConstructor()) {
                    this.constructors.add(ConstructorDocImpl.getConstructorDocImpl(env, memberDefinition));
                } else if (memberDefinition.isMethod()) {
                    this.methods.add(MethodDocImpl.getMethodDocImpl(env, memberDefinition));
                } else if (memberDefinition.isVariable()) {
                    this.fields.add(FieldDocImpl.getFieldDocImpl(env, memberDefinition));
                } else if (memberDefinition.isInnerClass()) {
                    this.innerClasses.add(ClassDocImpl.getClassDocImpl(env, memberDefinition.getInnerClass()));
                }
            }
            memberDefinition = memberDefinition.getNextMember();
        }
    }

    public ClassDoc findClass(String string) {
        Object object;
        ClassDoc classDoc = ClassDocImpl.lookup(string);
        if (classDoc != null) {
            return classDoc;
        }
        Iterator iterator = this.innerClasses.iterator();
        while (iterator.hasNext()) {
            classDoc = (ClassDoc)iterator.next();
            if (classDoc.name().equals(string) || classDoc.name().endsWith(string)) {
                return classDoc;
            }
            object = classDoc.findClass(string);
            if (object == null) continue;
            return object;
        }
        classDoc = this.containingPackage.findClass(string);
        if (classDoc != null) {
            return classDoc;
        }
        object = this.importedClasses.iterator();
        while (object.hasNext()) {
            classDoc = (ClassDocImpl)object.next();
            if (!classDoc.name().equals(string)) continue;
            return classDoc;
        }
        Iterator iterator2 = this.importedPackages.iterator();
        while (iterator2.hasNext()) {
            PackageDoc packageDoc = (PackageDoc)iterator2.next();
            classDoc = packageDoc.findClass(string);
            if (classDoc == null) continue;
            return classDoc;
        }
        return null;
    }

    public ConstructorDoc findConstructor(String string, String[] stringArray) {
        int n = 0;
        while (n < this.constructors.size()) {
            ConstructorDoc constructorDoc = (ConstructorDoc)this.constructors.get(n);
            if (((ExecutableMemberDocImpl)((Object)constructorDoc)).hasNameAndParameters(string, stringArray)) {
                return constructorDoc;
            }
            ++n;
        }
        return null;
    }

    public FieldDoc findField(String string) {
        FieldDoc fieldDoc;
        ClassDoc[] classDocArray;
        int n = 0;
        while (n < this.fields.size()) {
            classDocArray = (ClassDoc[])this.fields.get(n);
            if (classDocArray.name().equals(string)) {
                return classDocArray;
            }
            ++n;
        }
        if (this.containingClass != null && (fieldDoc = this.containingClass.findField(string)) != null) {
            return fieldDoc;
        }
        if (this.superclass != null && (fieldDoc = this.superclass.findField(string)) != null) {
            return fieldDoc;
        }
        classDocArray = this.interfaces();
        int n2 = 0;
        while (n2 < classDocArray.length) {
            fieldDoc = ((ClassDocImpl)classDocArray[n2]).findField(string);
            if (fieldDoc != null) {
                return fieldDoc;
            }
            ++n2;
        }
        return null;
    }

    public MethodDoc findMethod(String string, String[] stringArray) {
        MethodDoc methodDoc;
        int n = 0;
        while (n < this.methods.size()) {
            methodDoc = (MethodDoc)this.methods.get(n);
            if (((ExecutableMemberDocImpl)((Object)methodDoc)).hasNameAndParameters(string, stringArray)) {
                return methodDoc;
            }
            ++n;
        }
        if (this.containingClass != null && (methodDoc = this.containingClass.findMethod(string, stringArray)) != null) {
            return methodDoc;
        }
        if (this.superclass != null && (methodDoc = this.superclass.findMethod(string, stringArray)) != null) {
            return methodDoc;
        }
        ClassDoc[] classDocArray = this.interfaces();
        int n2 = 0;
        while (n2 < classDocArray.length) {
            methodDoc = ((ClassDocImpl)classDocArray[n2]).findMethod(string, stringArray);
            if (methodDoc != null) {
                return methodDoc;
            }
            ++n2;
        }
        return null;
    }

    static ClassDocImpl getClassDocImpl(Env env, ClassDeclaration classDeclaration) {
        ClassDocImpl classDocImpl;
        block2: {
            classDocImpl = ClassDocImpl.lookup(classDeclaration);
            if (classDocImpl != null) break block2;
            try {
                ClassDefinition classDefinition = classDeclaration.getClassDefinition(env);
                classDocImpl = new ClassDocImpl(env, classDefinition, classDeclaration);
            }
            catch (ClassNotFound classNotFound) {
                Res.warning("doc.class_not_found", classNotFound.name.toString());
                classDocImpl = new ClassDocImpl(env, classDeclaration);
            }
        }
        return classDocImpl;
    }

    static ClassDocImpl getClassDocImpl(Env env, ClassDefinition classDefinition) {
        return ClassDocImpl.getClassDocImpl(env, classDefinition.getClassDeclaration());
    }

    public ClassDoc[] implementedInterfaces() {
        return this.interfaces();
    }

    private static int implementsSerialExtern(Environment environment, ClassDeclaration classDeclaration, int n) throws ClassNotFound {
        if (classDeclaration.equals(externalizableClassDecl)) {
            return 6;
        }
        if (classDeclaration.equals(serializableClassDecl)) {
            n |= 2;
        }
        while (classDeclaration != null) {
            ClassDeclaration[] classDeclarationArray = classDeclaration.getClassDefinition(environment).getInterfaces();
            int n2 = 0;
            while (n2 < classDeclarationArray.length) {
                if (((n |= ClassDocImpl.implementsSerialExtern(environment, classDeclarationArray[n2], n)) & 4) != 0) {
                    return 6;
                }
                ++n2;
            }
            classDeclaration = classDeclaration.getClassDefinition(environment).getSuperClass();
        }
        return n;
    }

    public ClassDoc[] importedClasses() {
        return this.importedClasses.toArray(new ClassDoc[this.importedClasses.size()]);
    }

    public PackageDoc[] importedPackages() {
        return this.importedPackages.toArray(new PackageDoc[this.importedPackages.size()]);
    }

    public ClassDoc[] innerClasses() {
        return this.innerClasses.toArray(new ClassDoc[this.innerClasses.size()]);
    }

    public ClassDoc[] interfaces() {
        ClassDoc[] classDocArray = new ClassDoc[this.interfaces.length];
        int n = 0;
        while (n < this.interfaces.length) {
            classDocArray[n] = this.interfaces[n];
            ++n;
        }
        return classDocArray;
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.modifiers);
    }

    public boolean isClass() {
        return this.kind != 1;
    }

    public boolean isError() {
        return this.kind == 4;
    }

    public boolean isException() {
        return this.kind == 3;
    }

    public boolean isExternalizable() {
        return (this.serializationKind & 4) != 0;
    }

    public boolean isIncluded() {
        return this.isIncluded;
    }

    public boolean isInterface() {
        return this.kind == 1;
    }

    public boolean isOrdinaryClass() {
        return this.kind == 2;
    }

    public boolean isSerializable() {
        return (this.serializationKind & 2) != 0;
    }

    private int kind(ClassDefinition classDefinition) {
        if (classDefinition.isInterface()) {
            return 1;
        }
        if (this.superclass == null) {
            return 2;
        }
        boolean bl = this.qualifier.equals("java.lang");
        if (bl && this.name.equals("Exception")) {
            return 3;
        }
        if (bl && this.name.equals("Error")) {
            return 4;
        }
        return this.superclass.kind;
    }

    static final ClassDocImpl lookup(String string) {
        return (ClassDocImpl)classMap.get(string);
    }

    static final ClassDocImpl lookup(ClassDeclaration classDeclaration) {
        return ClassDocImpl.lookup(ClassDocImpl.qualifiedName(classDeclaration));
    }

    public MethodDoc[] methods() {
        return this.methods.toArray(new MethodDoc[this.methods.size()]);
    }

    public String name() {
        return this.name;
    }

    public String qualifiedName() {
        if (this.qualifier.length() == 0) {
            return this.name;
        }
        return this.qualifier + '.' + this.name;
    }

    static String qualifiedName(ClassDeclaration classDeclaration) {
        Identifier identifier = classDeclaration.getName();
        Identifier identifier2 = Identifier.lookup(identifier.getQualifier(), identifier.getFlatName());
        return identifier2.toString();
    }

    public String qualifiedTypeName() {
        return this.qualifiedName();
    }

    static void secondPhaseConstruction(Env env) {
        serializableClassDecl = env.getClassDeclaration(Identifier.lookup("java.io.Serializable"));
        externalizableClassDecl = env.getClassDeclaration(Identifier.lookup("java.io.Externalizable"));
        while (constructionCompletionQueue.size() != 0) {
            DefDoc defDoc = (DefDoc)constructionCompletionQueue.removeFirst();
            defDoc.classdoc.secondPhaseConstructor(env, defDoc.def);
        }
        constructionCompletionQueue = null;
        serializableClassDecl = null;
        externalizableClassDecl = null;
    }

    private void secondPhaseConstructor(Env env, ClassDefinition classDefinition) {
        this.setImplementedInterfaces(env, classDefinition);
        this.setImports(env, classDefinition);
        this.fillInMembers(env, classDefinition);
        this.setSerializationKind(env, classDefinition);
        if (this.isSerializable()) {
            this.serializedForm = new SerializedForm(env, classDefinition, this);
        }
    }

    public FieldDoc[] serializableFields() {
        return this.serializedForm == null ? new FieldDoc[]{} : this.serializedForm.fields();
    }

    public MethodDoc[] serializationMethods() {
        return this.serializedForm == null ? new MethodDoc[]{} : this.serializedForm.methods();
    }

    private void setImplementedInterfaces(Env env, ClassDefinition classDefinition) {
        ClassDeclaration[] classDeclarationArray = classDefinition.getInterfaces();
        this.interfaces = new ClassDocImpl[classDeclarationArray.length];
        int n = 0;
        while (n < classDeclarationArray.length) {
            this.interfaces[n] = ClassDocImpl.getClassDocImpl(env, classDeclarationArray[n]);
            ++n;
        }
    }

    private void setImports(Env env, ClassDefinition classDefinition) {
        if (classDefinition instanceof SourceClass) {
            Object object;
            Imports imports = ((SourceClass)classDefinition).getImports();
            List list = imports.getImportedClasses();
            int n = list.size();
            int n2 = 0;
            while (n2 < n) {
                object = ((IdentifierToken)list.get(n2)).getName();
                object = env.resolvePackageQualifiedName((Identifier)object);
                try {
                    ClassDefinition classDefinition2 = env.getClassDefinition((Identifier)object);
                    this.importedClasses.add(ClassDocImpl.getClassDocImpl(env, classDefinition2));
                }
                catch (ClassNotFound classNotFound) {
                    System.err.println("Internal error: *IMPORT*NOT*FOUND* " + ((Identifier)object).toString() + " - ignoring");
                }
                ++n2;
            }
            object = imports.getImportedPackages();
            int n3 = object.size();
            int n4 = 0;
            while (n4 < n3) {
                Identifier identifier = ((IdentifierToken)object.get(n4)).getName();
                this.importedPackages.add(PackageDocImpl.getPackageDocImpl(env, identifier.toString()));
                ++n4;
            }
        }
    }

    private void setSerializationKind(Env env, ClassDefinition classDefinition) {
        try {
            this.serializationKind = ClassDocImpl.implementsSerialExtern(env, classDefinition.getClassDeclaration(), 1);
        }
        catch (ClassNotFound classNotFound) {
            Res.warning("doc.class_not_found", classNotFound.name.toString());
        }
    }

    public boolean subclassOf(ClassDoc classDoc) {
        if (classDoc == this) {
            return true;
        }
        if (this.superclass == null) {
            return false;
        }
        return this.superclass.subclassOf(classDoc);
    }

    public ClassDoc superclass() {
        return this.superclass;
    }

    private static ClassDocImpl superclass(Env env, ClassDefinition classDefinition) {
        ClassDeclaration classDeclaration = classDefinition.getSuperClass(env);
        if (classDeclaration == null || classDefinition.isInterface()) {
            return null;
        }
        return ClassDocImpl.getClassDocImpl(env, classDeclaration);
    }

    ClassDocImpl thisClassDocImpl() {
        return this;
    }

    public String toString() {
        return this.qualifiedName();
    }

    public String typeName() {
        return this.name;
    }

    private static class DefDoc {
        final ClassDefinition def;
        final ClassDocImpl classdoc;

        DefDoc(ClassDefinition classDefinition, ClassDocImpl classDocImpl) {
            this.def = classDefinition;
            this.classdoc = classDocImpl;
        }
    }
}

