/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.standard;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.tools.doclets.DirectoryManager;
import com.sun.tools.doclets.DocletAbortException;
import com.sun.tools.doclets.standard.ClassSubWriter;
import com.sun.tools.doclets.standard.ClassUseMapper;
import com.sun.tools.doclets.standard.ConfigurationStandard;
import com.sun.tools.doclets.standard.ConstructorSubWriter;
import com.sun.tools.doclets.standard.FieldSubWriter;
import com.sun.tools.doclets.standard.HtmlStandardWriter;
import com.sun.tools.doclets.standard.MethodSubWriter;
import com.sun.tools.doclets.standard.Standard;
import com.sun.tools.doclets.standard.SubWriterHolderWriter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

public class ClassUseWriter
extends SubWriterHolderWriter {
    final ClassDoc classdoc;
    final Map pkgToSubclass;
    final Map pkgToSubinterface;
    final Map pkgToImplementingClass;
    final Map pkgToField;
    final Map pkgToMethodReturn;
    final Map pkgToMethodArgs;
    final Map pkgToMethodThrows;
    final Map pkgToConstructorArgs;
    final Map pkgToConstructorThrows;
    final SortedSet pkgSet;
    final MethodSubWriter methodSubWriter;
    final ConstructorSubWriter constrSubWriter;
    final FieldSubWriter fieldSubWriter;
    final ClassSubWriter classSubWriter;

    public ClassUseWriter(ClassUseMapper classUseMapper, String string, String string2, String string3, ClassDoc classDoc) throws IOException, DocletAbortException {
        super(string, string2, string3);
        this.classdoc = classDoc;
        HtmlStandardWriter.currentcd = classDoc;
        this.pkgSet = new TreeSet();
        this.pkgToSubclass = this.pkgDivide(classUseMapper.classToSubclass);
        this.pkgToSubinterface = this.pkgDivide(classUseMapper.classToSubinterface);
        this.pkgToImplementingClass = this.pkgDivide(classUseMapper.classToImplementingClass);
        this.pkgToField = this.pkgDivide(classUseMapper.classToField);
        this.pkgToMethodReturn = this.pkgDivide(classUseMapper.classToMethodReturn);
        this.pkgToMethodArgs = this.pkgDivide(classUseMapper.classToMethodArgs);
        this.pkgToMethodThrows = this.pkgDivide(classUseMapper.classToMethodThrows);
        this.pkgToConstructorArgs = this.pkgDivide(classUseMapper.classToConstructorArgs);
        this.pkgToConstructorThrows = this.pkgDivide(classUseMapper.classToConstructorThrows);
        if (!this.pkgSet.equals(classUseMapper.classToPackage.get(classDoc))) {
            System.err.println("Internal error: package sets don't match: " + this.pkgSet + " with: " + classUseMapper.classToPackage.get(classDoc));
        }
        this.methodSubWriter = new MethodSubWriter(this);
        this.constrSubWriter = new ConstructorSubWriter(this);
        this.fieldSubWriter = new FieldSubWriter(this);
        this.classSubWriter = new ClassSubWriter(this);
    }

    public static void generate(ClassUseMapper classUseMapper, ClassDoc classDoc) throws DocletAbortException {
        String string = DirectoryManager.getDirectoryPath(classDoc.containingPackage());
        if (string.length() > 0) {
            string = String.valueOf(string) + File.separator;
        }
        string = String.valueOf(string) + "class-use";
        String string2 = String.valueOf(classDoc.name()) + ".html";
        String string3 = classDoc.containingPackage().name();
        string3 = String.valueOf(string3) + (string3.length() > 0 ? ".class-use" : "class-use");
        String string4 = DirectoryManager.getRelativePath(string3);
        try {
            ClassUseWriter classUseWriter = new ClassUseWriter(classUseMapper, string, string2, string4, classDoc);
            classUseWriter.generateClassUseFile();
            classUseWriter.close();
        }
        catch (IOException iOException) {
            Standard.configuration();
            ConfigurationStandard.standardmessage.error("doclet.exception_encountered", iOException.toString(), string2);
            throw new DocletAbortException();
        }
    }

    protected void generateClassList() throws IOException {
        Iterator iterator = this.pkgSet.iterator();
        while (iterator.hasNext()) {
            PackageDoc packageDoc = (PackageDoc)iterator.next();
            this.anchor(packageDoc.name());
            this.tableIndexSummary();
            this.tableHeaderStart("#CCCCFF");
            this.printText("doclet.ClassUse_Uses.of.0.in.1", this.getClassLink(this.classdoc), this.getPackageLink(packageDoc));
            this.tableHeaderEnd();
            this.tableEnd();
            this.space();
            this.p();
            this.generateClassUse(packageDoc);
        }
    }

    protected void generateClassUse() throws IOException {
        if (Standard.configuration().packages.length > 1) {
            this.generatePackageList();
        }
        this.generateClassList();
    }

    protected void generateClassUse(PackageDoc packageDoc) throws IOException {
        String string = this.getClassLink(this.classdoc);
        String string2 = this.getPackageLink(packageDoc);
        this.classSubWriter.printUseInfo(this.pkgToSubclass.get(packageDoc), this.getText("doclet.ClassUse_Subclass", string, string2));
        this.classSubWriter.printUseInfo(this.pkgToSubinterface.get(packageDoc), this.getText("doclet.ClassUse_Subinterface", string, string2));
        this.classSubWriter.printUseInfo(this.pkgToImplementingClass.get(packageDoc), this.getText("doclet.ClassUse_ImplementingClass", string, string2));
        this.fieldSubWriter.printUseInfo(this.pkgToField.get(packageDoc), this.getText("doclet.ClassUse_Field", string, string2));
        this.methodSubWriter.printUseInfo(this.pkgToMethodReturn.get(packageDoc), this.getText("doclet.ClassUse_MethodReturn", string, string2));
        this.methodSubWriter.printUseInfo(this.pkgToMethodArgs.get(packageDoc), this.getText("doclet.ClassUse_MethodArgs", string, string2));
        this.methodSubWriter.printUseInfo(this.pkgToMethodThrows.get(packageDoc), this.getText("doclet.ClassUse_MethodThrows", string, string2));
        this.constrSubWriter.printUseInfo(this.pkgToConstructorArgs.get(packageDoc), this.getText("doclet.ClassUse_ConstructorArgs", string, string2));
        this.constrSubWriter.printUseInfo(this.pkgToConstructorThrows.get(packageDoc), this.getText("doclet.ClassUse_ConstructorThrows", string, string2));
    }

    protected void generateClassUseFile() throws IOException {
        this.printClassUseHeader();
        if (this.pkgSet.size() > 0) {
            this.generateClassUse();
        } else {
            this.printText("doclet.ClassUse_No.usage.of.0", this.classdoc.qualifiedName());
            this.p();
        }
        this.printClassUseFooter();
    }

    protected void generatePackageList() throws IOException {
        this.tableIndexSummary();
        this.tableHeaderStart("#CCCCFF");
        this.printText("doclet.ClassUse_Packages.that.use.0", this.getClassLink(this.classdoc));
        this.tableHeaderEnd();
        Iterator iterator = this.pkgSet.iterator();
        while (iterator.hasNext()) {
            PackageDoc packageDoc = (PackageDoc)iterator.next();
            this.generatePackageUse(packageDoc);
        }
        this.tableEnd();
        this.space();
        this.p();
    }

    protected void generatePackageUse(PackageDoc packageDoc) throws IOException {
        this.trBgcolorStyle("white", "TableRowColor");
        this.summaryRow(0);
        this.printHyperLink("", packageDoc.name(), packageDoc.name(), true);
        this.summaryRowEnd();
        this.summaryRow(0);
        this.printSummaryComment(packageDoc);
        this.space();
        this.summaryRowEnd();
        this.trEnd();
    }

    protected void navLinkClass() {
        this.navCellStart();
        this.printClassLink(this.classdoc, "", this.getText("doclet.Class"), true, "NavBarFont1");
        this.navCellEnd();
    }

    protected void navLinkClassUse() {
        this.navCellRevStart();
        this.fontStyle("NavBarFont1Rev");
        this.boldText("doclet.navClassUse");
        this.fontEnd();
        this.navCellEnd();
    }

    protected void navLinkPackage() {
        this.navCellStart();
        this.printHyperLink("../package-summary.html", "", this.getText("doclet.Package"), true, "NavBarFont1");
        this.navCellEnd();
    }

    protected void navLinkTree() {
        this.navCellStart();
        if (this.classdoc.containingPackage().isIncluded()) {
            this.printHyperLink("../package-tree.html", "", this.getText("doclet.Tree"), true, "NavBarFont1");
        } else {
            this.printHyperLink(String.valueOf(this.relativepath) + "overview-tree.html", "", this.getText("doclet.Tree"), true, "NavBarFont1");
        }
        this.navCellEnd();
    }

    private Map pkgDivide(Map map) {
        HashMap<PackageDoc, ArrayList<ProgramElementDoc>> hashMap = new HashMap<PackageDoc, ArrayList<ProgramElementDoc>>();
        List list = (List)map.get(this.classdoc);
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ProgramElementDoc programElementDoc = (ProgramElementDoc)iterator.next();
                PackageDoc packageDoc = programElementDoc.containingPackage();
                this.pkgSet.add(packageDoc);
                ArrayList<ProgramElementDoc> arrayList = (ArrayList<ProgramElementDoc>)hashMap.get(packageDoc);
                if (arrayList == null) {
                    arrayList = new ArrayList<ProgramElementDoc>();
                    hashMap.put(packageDoc, arrayList);
                }
                arrayList.add(programElementDoc);
            }
        }
        return hashMap;
    }

    protected void printClassUseFooter() {
        this.hr();
        this.navLinks(false);
        this.printBottom();
        this.printBodyHtmlEnd();
    }

    protected void printClassUseHeader() {
        String string = this.getText(this.classdoc.isInterface() ? "doclet.Interface" : "doclet.Class");
        String string2 = this.classdoc.qualifiedName();
        this.printHeader(this.getText("doclet.Window_ClassUse_Header", Standard.configuration().windowtitle, string, string2));
        this.navLinks(true);
        this.hr();
        this.center();
        this.h2();
        this.boldText("doclet.ClassUse_Title", string, string2);
        this.h2End();
        this.centerEnd();
    }
}

