/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BandedSampleModel;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import sun.awt.image.ByteBandedRaster;
import sun.awt.image.ByteInterleavedRaster;
import sun.awt.image.BytePackedRaster;
import sun.awt.image.IntegerInterleavedRaster;
import sun.awt.image.ShortBandedRaster;
import sun.awt.image.ShortInterleavedRaster;
import sun.awt.image.SunWritableRaster;

public class Raster {
    protected SampleModel sampleModel;
    protected DataBuffer dataBuffer;
    protected int minX;
    protected int minY;
    protected int width;
    protected int height;
    protected int sampleModelTranslateX;
    protected int sampleModelTranslateY;
    protected int numBands;
    protected int numDataElements;
    protected Raster parent;

    private static native void initIDs();

    protected Raster(SampleModel sampleModel, Point point) {
        this(sampleModel, sampleModel.createDataBuffer(), point);
    }

    protected Raster(SampleModel sampleModel, DataBuffer dataBuffer, Point point) {
        this(sampleModel, dataBuffer, new Rectangle(point.x, point.y, sampleModel.getWidth(), sampleModel.getHeight()), point, null);
    }

    protected Raster(SampleModel sampleModel, DataBuffer dataBuffer, Rectangle rectangle, Point point, Raster raster) {
        this.sampleModel = sampleModel;
        this.dataBuffer = dataBuffer;
        this.minX = rectangle.x;
        this.minY = rectangle.y;
        this.width = rectangle.width;
        this.height = rectangle.height;
        if (point != null) {
            this.sampleModelTranslateX = point.x;
            this.sampleModelTranslateY = point.y;
        }
        this.numBands = sampleModel.getNumBands();
        this.numDataElements = sampleModel.getNumDataElements();
        this.parent = raster;
    }

    public static WritableRaster createInterleavedRaster(int n, int n2, int n3, int n4, Point point) {
        int n5;
        int[] nArray = new int[n4];
        for (n5 = 0; n5 < n4; ++n5) {
            nArray[n5] = n5;
        }
        n5 = n4 * n2;
        return Raster.createInterleavedRaster(n, n2, n3, n5, n4, nArray, point);
    }

    public static WritableRaster createInterleavedRaster(int n, int n2, int n3, int n4, int n5, int[] nArray, Point point) {
        PixelInterleavedSampleModel pixelInterleavedSampleModel = new PixelInterleavedSampleModel(n, n2, n3, n5, n4, nArray);
        if (point == null) {
            point = new Point(0, 0);
        }
        if (n == 0) {
            return new ByteInterleavedRaster(pixelInterleavedSampleModel, point);
        }
        if (n == 2) {
            return new ShortInterleavedRaster(pixelInterleavedSampleModel, point);
        }
        throw new IllegalArgumentException("Data type is not supported.");
    }

    public static WritableRaster createBandedRaster(int n, int n2, int n3, int n4, Point point) {
        BandedSampleModel bandedSampleModel = new BandedSampleModel(n, n2, n3, n4);
        if (point == null) {
            point = new Point(0, 0);
        }
        if (n == 0) {
            return new ByteBandedRaster(bandedSampleModel, point);
        }
        if (n == 1) {
            return new ShortBandedRaster(bandedSampleModel, point);
        }
        if (n == 3) {
            return new SunWritableRaster(bandedSampleModel, point);
        }
        throw new IllegalArgumentException("Data type is not supported.");
    }

    public static WritableRaster createBandedRaster(int n, int n2, int n3, int n4, int[] nArray, int[] nArray2, Point point) {
        BandedSampleModel bandedSampleModel = new BandedSampleModel(n, n2, n3, n4, nArray, nArray2);
        if (point == null) {
            point = new Point(0, 0);
        }
        if (n == 0) {
            return new ByteBandedRaster(bandedSampleModel, point);
        }
        if (n == 1) {
            return new ShortBandedRaster(bandedSampleModel, point);
        }
        if (n == 3) {
            return new SunWritableRaster(bandedSampleModel, point);
        }
        throw new IllegalArgumentException("Data type is not supported.");
    }

    public static WritableRaster createPackedRaster(int n, int n2, int n3, int[] nArray, Point point) {
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = new SinglePixelPackedSampleModel(n, n2, n3, nArray);
        if (point == null) {
            point = new Point(0, 0);
        }
        if (n == 0) {
            return new ByteInterleavedRaster(singlePixelPackedSampleModel, point);
        }
        if (n == 1) {
            return new ShortInterleavedRaster(singlePixelPackedSampleModel, point);
        }
        if (n == 3) {
            return new IntegerInterleavedRaster(singlePixelPackedSampleModel, point);
        }
        throw new IllegalArgumentException("Data type is not supported.");
    }

    public static WritableRaster createPackedRaster(int n, int n2, int n3, int n4, int n5, Point point) {
        if (n4 <= 0 || n4 * n5 > Raster.getTypeBits(n)) {
            throw new IllegalArgumentException();
        }
        if (point == null) {
            point = new Point(0, 0);
        }
        if (n != 0 && n != 1 && n != 3) {
            throw new IllegalArgumentException("Data type is not supported.");
        }
        if (n4 == 1) {
            MultiPixelPackedSampleModel multiPixelPackedSampleModel = new MultiPixelPackedSampleModel(n, n2, n3, n5);
            if (n == 0 && (n5 == 1 || n5 == 2 || n5 == 4)) {
                return new BytePackedRaster(multiPixelPackedSampleModel, point);
            }
            return new SunWritableRaster(multiPixelPackedSampleModel, point);
        }
        int[] nArray = new int[n4];
        int n6 = 1;
        int n7 = n5;
        while (--n7 != 0) {
            n6 = n6 << 1 | 1;
        }
        for (n7 = 0; n7 < n4; ++n7) {
            nArray[n7] = n6;
            n6 <<= n5;
        }
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = new SinglePixelPackedSampleModel(n, n2, n3, nArray);
        if (n == 0) {
            return new ByteInterleavedRaster(singlePixelPackedSampleModel, point);
        }
        if (n == 1) {
            return new ShortInterleavedRaster(singlePixelPackedSampleModel, point);
        }
        return new IntegerInterleavedRaster(singlePixelPackedSampleModel, point);
    }

    public static WritableRaster createInterleavedRaster(DataBuffer dataBuffer, int n, int n2, int n3, int n4, int[] nArray, Point point) {
        PixelInterleavedSampleModel pixelInterleavedSampleModel = new PixelInterleavedSampleModel(dataBuffer.getDataType(), n, n2, n4, n3, nArray);
        if (point == null) {
            point = new Point(0, 0);
        }
        if (dataBuffer.getDataType() == 0) {
            return new ByteInterleavedRaster((SampleModel)pixelInterleavedSampleModel, dataBuffer, point);
        }
        if (dataBuffer.getDataType() == 1) {
            return new ShortInterleavedRaster((SampleModel)pixelInterleavedSampleModel, dataBuffer, point);
        }
        throw new IllegalArgumentException("Data type is not supported.");
    }

    public static WritableRaster createBandedRaster(DataBuffer dataBuffer, int n, int n2, int n3, int[] nArray, int[] nArray2, Point point) {
        BandedSampleModel bandedSampleModel = new BandedSampleModel(dataBuffer.getDataType(), n, n2, n3, nArray, nArray2);
        if (point == null) {
            point = new Point(0, 0);
        }
        if (dataBuffer.getDataType() == 0) {
            return new ByteBandedRaster((SampleModel)bandedSampleModel, dataBuffer, point);
        }
        if (dataBuffer.getDataType() == 1) {
            return new ShortBandedRaster((SampleModel)bandedSampleModel, dataBuffer, point);
        }
        if (dataBuffer.getDataType() == 3) {
            return new SunWritableRaster(bandedSampleModel, dataBuffer, point);
        }
        throw new IllegalArgumentException("Data type is not supported.");
    }

    public static WritableRaster createPackedRaster(DataBuffer dataBuffer, int n, int n2, int n3, int[] nArray, Point point) {
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = new SinglePixelPackedSampleModel(dataBuffer.getDataType(), n, n2, n3, nArray);
        if (point == null) {
            point = new Point(0, 0);
        }
        if (dataBuffer.getDataType() == 0) {
            return new ByteInterleavedRaster((SampleModel)singlePixelPackedSampleModel, dataBuffer, point);
        }
        if (dataBuffer.getDataType() == 1) {
            return new ShortInterleavedRaster((SampleModel)singlePixelPackedSampleModel, dataBuffer, point);
        }
        if (dataBuffer.getDataType() == 3) {
            return new IntegerInterleavedRaster((SampleModel)singlePixelPackedSampleModel, dataBuffer, point);
        }
        throw new IllegalArgumentException("Data type is not supported.");
    }

    public static WritableRaster createPackedRaster(DataBuffer dataBuffer, int n, int n2, int n3, Point point) {
        int n4;
        MultiPixelPackedSampleModel multiPixelPackedSampleModel = new MultiPixelPackedSampleModel(dataBuffer.getDataType(), n, n2, n3);
        if (point == null) {
            point = new Point(0, 0);
        }
        if ((n4 = dataBuffer.getDataType()) != 0 && n4 != 1 && n4 != 3) {
            throw new IllegalArgumentException("Data type is not supported.");
        }
        if (n4 == 0 && (n3 == 1 || n3 == 2 || n3 == 4)) {
            return new BytePackedRaster((SampleModel)multiPixelPackedSampleModel, dataBuffer, point);
        }
        return new SunWritableRaster(multiPixelPackedSampleModel, dataBuffer, point);
    }

    public static Raster createRaster(SampleModel sampleModel, DataBuffer dataBuffer, Point point) {
        return new Raster(sampleModel, dataBuffer, point);
    }

    public static WritableRaster createWritableRaster(SampleModel sampleModel, Point point) {
        if (sampleModel instanceof PixelInterleavedSampleModel) {
            if (sampleModel.dataType == 0) {
                return new ByteInterleavedRaster(sampleModel, point);
            }
            if (sampleModel.dataType == 2) {
                return new ShortInterleavedRaster(sampleModel, point);
            }
        } else if (sampleModel instanceof BandedSampleModel) {
            if (sampleModel.dataType == 0) {
                return new ByteBandedRaster(sampleModel, point);
            }
            if (sampleModel.dataType == 1) {
                return new ShortBandedRaster(sampleModel, point);
            }
        } else if (sampleModel instanceof SinglePixelPackedSampleModel || sampleModel instanceof MultiPixelPackedSampleModel) {
            if (sampleModel.numBands == 1) {
                if (sampleModel.dataType == 0) {
                    return new BytePackedRaster(sampleModel, point);
                }
            } else {
                if (sampleModel.dataType == 0) {
                    return new ByteInterleavedRaster(sampleModel, point);
                }
                if (sampleModel.dataType == 1) {
                    return new ShortInterleavedRaster(sampleModel, point);
                }
                if (sampleModel.dataType == 3) {
                    return new IntegerInterleavedRaster(sampleModel, point);
                }
            }
        }
        return new SunWritableRaster(sampleModel, point);
    }

    public static WritableRaster createWritableRaster(SampleModel sampleModel, DataBuffer dataBuffer, Point point) {
        if (sampleModel instanceof PixelInterleavedSampleModel) {
            if (sampleModel.dataType == 0) {
                return new ByteInterleavedRaster(sampleModel, dataBuffer, point);
            }
            if (sampleModel.dataType == 2) {
                return new ShortInterleavedRaster(sampleModel, dataBuffer, point);
            }
        } else if (sampleModel instanceof BandedSampleModel) {
            if (sampleModel.dataType == 0) {
                return new ByteBandedRaster(sampleModel, dataBuffer, point);
            }
            if (sampleModel.dataType == 1) {
                return new ShortBandedRaster(sampleModel, dataBuffer, point);
            }
        } else if (sampleModel instanceof SinglePixelPackedSampleModel || sampleModel instanceof MultiPixelPackedSampleModel) {
            if (sampleModel.numBands == 1) {
                if (sampleModel.dataType == 0) {
                    return new BytePackedRaster(sampleModel, dataBuffer, point);
                }
            } else {
                if (sampleModel.dataType == 0) {
                    return new ByteInterleavedRaster(sampleModel, dataBuffer, point);
                }
                if (sampleModel.dataType == 1) {
                    return new ShortInterleavedRaster(sampleModel, dataBuffer, point);
                }
                if (sampleModel.dataType == 3) {
                    return new IntegerInterleavedRaster(sampleModel, dataBuffer, point);
                }
            }
        }
        return new SunWritableRaster(sampleModel, dataBuffer, point);
    }

    public Raster getParent() {
        return this.parent;
    }

    public final int getSampleModelTranslateX() {
        return this.sampleModelTranslateX;
    }

    public final int getSampleModelTranslateY() {
        return this.sampleModelTranslateY;
    }

    public WritableRaster createCompatibleWritableRaster() {
        return new SunWritableRaster(this.getSampleModel(), new Point(this.minX, this.minY));
    }

    public WritableRaster createCompatibleWritableRaster(int n, int n2) {
        return this.createCompatibleWritableRaster(this.minX, this.minY, n, n2);
    }

    public WritableRaster createCompatibleWritableRaster(Rectangle rectangle) {
        return this.createCompatibleWritableRaster(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public WritableRaster createCompatibleWritableRaster(int n, int n2, int n3, int n4) {
        SampleModel sampleModel = this.getSampleModel().createCompatibleSampleModel(n3, n4);
        return new SunWritableRaster(sampleModel, sampleModel.createDataBuffer(), new Point(n, n2));
    }

    public Raster createTranslatedChild(int n, int n2) {
        return this.createChild(this.minX, this.minY, this.width, this.height, n, n2, null);
    }

    public Raster createChild(int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        if (n < this.minX || n + n3 > this.minX + this.width || n2 < this.minY || n2 + n4 > this.minY + this.height) {
            throw new RasterFormatException("Child raster extends beyond parent");
        }
        SampleModel sampleModel = nArray == null ? this.sampleModel : this.sampleModel.createSubsetSampleModel(nArray);
        return new Raster(sampleModel, this.dataBuffer, new Rectangle(n5, n6, n3, n4), new Point(this.sampleModelTranslateX + n5 - n, this.sampleModelTranslateY + n6 - n2), this);
    }

    public Rectangle getBounds() {
        return new Rectangle(this.minX, this.minY, this.width, this.height);
    }

    public final int getMinX() {
        return this.minX;
    }

    public final int getMinY() {
        return this.minY;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final int getNumBands() {
        return this.numBands;
    }

    public final int getNumDataElements() {
        return this.numDataElements;
    }

    public final int getTransferType() {
        return this.sampleModel.getTransferType();
    }

    public DataBuffer getDataBuffer() {
        return this.dataBuffer;
    }

    public SampleModel getSampleModel() {
        return this.sampleModel;
    }

    public Object getDataElements(int n, int n2, Object object) {
        return this.sampleModel.getDataElements(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, object, this.dataBuffer);
    }

    public Object getDataElements(int n, int n2, int n3, int n4, Object object) {
        return this.sampleModel.getDataElements(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, n3, n4, object, this.dataBuffer);
    }

    public int[] getPixel(int n, int n2, int[] nArray) {
        return this.sampleModel.getPixel(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, nArray, this.dataBuffer);
    }

    public float[] getPixel(int n, int n2, float[] fArray) {
        return this.sampleModel.getPixel(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, fArray, this.dataBuffer);
    }

    public double[] getPixel(int n, int n2, double[] dArray) {
        return this.sampleModel.getPixel(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, dArray, this.dataBuffer);
    }

    public int[] getPixels(int n, int n2, int n3, int n4, int[] nArray) {
        return this.sampleModel.getPixels(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, n3, n4, nArray, this.dataBuffer);
    }

    public float[] getPixels(int n, int n2, int n3, int n4, float[] fArray) {
        return this.sampleModel.getPixels(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, n3, n4, fArray, this.dataBuffer);
    }

    public double[] getPixels(int n, int n2, int n3, int n4, double[] dArray) {
        return this.sampleModel.getPixels(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, n3, n4, dArray, this.dataBuffer);
    }

    public int getSample(int n, int n2, int n3) {
        return this.sampleModel.getSample(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, n3, this.dataBuffer);
    }

    public float getSampleFloat(int n, int n2, int n3) {
        return this.sampleModel.getSampleFloat(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, n3, this.dataBuffer);
    }

    public double getSampleDouble(int n, int n2, int n3) {
        return this.sampleModel.getSampleDouble(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, n3, this.dataBuffer);
    }

    public int[] getSamples(int n, int n2, int n3, int n4, int n5, int[] nArray) {
        return this.sampleModel.getSamples(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, n3, n4, n5, nArray, this.dataBuffer);
    }

    public float[] getSamples(int n, int n2, int n3, int n4, int n5, float[] fArray) {
        return this.sampleModel.getSamples(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, n3, n4, n5, fArray, this.dataBuffer);
    }

    public double[] getSamples(int n, int n2, int n3, int n4, int n5, double[] dArray) {
        return this.sampleModel.getSamples(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, n3, n4, n5, dArray, this.dataBuffer);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append("[(");
        stringBuffer.append(this.minX).append(",").append(this.minY).append("), ");
        stringBuffer.append(this.width).append(" x ").append(this.height).append(",");
        stringBuffer.append(this.sampleModel).append(",");
        stringBuffer.append(this.dataBuffer);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private static int getTypeBits(int n) {
        switch (n) {
            case 0: {
                return 8;
            }
            case 1: 
            case 2: {
                return 16;
            }
            case 3: 
            case 4: {
                return 32;
            }
            case 5: {
                return 64;
            }
        }
        return 0;
    }

    static {
        ColorModel.loadLibraries();
        Raster.initIDs();
    }
}

