/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import gnu.java.awt.Buffers;
import java.awt.image.DataBuffer;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;

public class MultiPixelPackedSampleModel
extends SampleModel {
    private int scanlineStride;
    private int[] bitMasks;
    private int[] bitOffsets;
    private int[] sampleSize;
    private int dataBitOffset;
    private int elemBits;
    private int numberOfBits;
    private int numElems;

    public MultiPixelPackedSampleModel(int n, int n2, int n3, int n4) {
        this(n, n2, n3, n4, 0, 0);
    }

    public MultiPixelPackedSampleModel(int n, int n2, int n3, int n4, int n5, int n6) {
        super(n, n2, n3, 1);
        switch (n) {
            case 0: {
                this.elemBits = 8;
                break;
            }
            case 1: {
                this.elemBits = 16;
                break;
            }
            case 3: {
                this.elemBits = 32;
                break;
            }
            default: {
                throw new IllegalArgumentException("MultiPixelPackedSampleModel unsupported dataType");
            }
        }
        this.dataBitOffset = n6;
        this.numberOfBits = n4;
        if (n4 > this.elemBits) {
            throw new RasterFormatException("MultiPixelPackedSampleModel pixel size larger than dataType");
        }
        switch (n4) {
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 16: 
            case 32: {
                break;
            }
            default: {
                throw new RasterFormatException("MultiPixelPackedSampleModel pixel size not 2^n bits");
            }
        }
        this.numElems = this.elemBits / n4;
        if (n5 == 0) {
            n5 = (n6 + n2 * n4 - 1) / this.elemBits + 1;
        }
        this.scanlineStride = n5;
        this.sampleSize = new int[1];
        this.sampleSize[0] = n4;
        this.bitMasks = new int[this.numElems];
        this.bitOffsets = new int[this.numElems];
        for (int i = 0; i < this.numElems; ++i) {
            this.bitOffsets[this.numElems - i - 1] = n4 * i;
            this.bitMasks[this.numElems - i - 1] = (1 << n4) - 1 << this.bitOffsets[this.numElems - i - 1];
        }
    }

    @Override
    public SampleModel createCompatibleSampleModel(int n, int n2) {
        return new MultiPixelPackedSampleModel(this.dataType, n, n2, this.numberOfBits);
    }

    @Override
    public DataBuffer createDataBuffer() {
        int n = this.scanlineStride * this.height;
        if (this.dataBitOffset > 0) {
            n += (this.dataBitOffset - 1) / this.elemBits + 1;
        }
        return Buffers.createBuffer(this.getDataType(), n);
    }

    @Override
    public int getNumDataElements() {
        return 1;
    }

    @Override
    public int[] getSampleSize() {
        return (int[])this.sampleSize.clone();
    }

    @Override
    public int getSampleSize(int n) {
        return this.sampleSize[0];
    }

    public int getOffset(int n, int n2) {
        return this.scanlineStride * n2 + (this.dataBitOffset + n * this.numberOfBits) / this.elemBits;
    }

    public int getBitOffset(int n) {
        return (this.dataBitOffset + n * this.numberOfBits) % this.elemBits;
    }

    public int getDataBitOffset() {
        return this.dataBitOffset;
    }

    public int getScanlineStride() {
        return this.scanlineStride;
    }

    public int getPixelBitStride() {
        return this.numberOfBits;
    }

    @Override
    public int getTransferType() {
        if (this.numberOfBits <= DataBuffer.getDataTypeSize(0)) {
            return 0;
        }
        if (this.numberOfBits <= DataBuffer.getDataTypeSize(1)) {
            return 1;
        }
        return 3;
    }

    @Override
    public SampleModel createSubsetSampleModel(int[] nArray) {
        if (nArray != null && nArray.length != 1) {
            throw new RasterFormatException("MultiPixelPackedSampleModel only supports one band");
        }
        return new MultiPixelPackedSampleModel(this.dataType, this.width, this.height, this.numberOfBits, this.scanlineStride, this.dataBitOffset);
    }

    @Override
    public Object getDataElements(int n, int n2, Object object, DataBuffer dataBuffer) {
        int n3 = this.getSample(n, n2, 0, dataBuffer);
        switch (this.getTransferType()) {
            case 0: {
                if (object == null) {
                    object = new byte[1];
                }
                ((byte[])object)[0] = (byte)n3;
                return object;
            }
            case 1: {
                if (object == null) {
                    object = new short[1];
                }
                ((short[])object)[0] = (short)n3;
                return object;
            }
            case 3: {
                if (object == null) {
                    object = new int[1];
                }
                ((int[])object)[0] = n3;
                return object;
            }
        }
        throw new ClassCastException();
    }

    @Override
    public int[] getPixel(int n, int n2, int[] nArray, DataBuffer dataBuffer) {
        if (nArray == null) {
            nArray = new int[]{this.getSample(n, n2, 0, dataBuffer)};
        }
        return nArray;
    }

    @Override
    public int getSample(int n, int n2, int n3, DataBuffer dataBuffer) {
        int n4 = (this.dataBitOffset + n * this.numberOfBits) % this.elemBits / this.numberOfBits;
        int n5 = this.getOffset(n, n2);
        int n6 = dataBuffer.getElem(n5);
        return (n6 & this.bitMasks[n4]) >>> this.bitOffsets[n4];
    }

    @Override
    public void setDataElements(int n, int n2, Object object, DataBuffer dataBuffer) {
        int n3 = this.getTransferType();
        try {
            switch (n3) {
                case 0: {
                    byte[] byArray = (byte[])object;
                    this.setSample(n, n2, 0, byArray[0] & 0xFF, dataBuffer);
                    return;
                }
                case 1: {
                    short[] sArray = (short[])object;
                    this.setSample(n, n2, 0, sArray[0] & 0xFFFF, dataBuffer);
                    return;
                }
                case 3: {
                    int[] nArray = (int[])object;
                    this.setSample(n, n2, 0, nArray[0], dataBuffer);
                    return;
                }
            }
            throw new ClassCastException("Unsupported data type");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            String string = "While writing data elements, x=" + n + ", y=" + n2 + ", width=" + this.width + ", height=" + this.height + ", scanlineStride=" + this.scanlineStride + ", offset=" + this.getOffset(n, n2) + ", data.getSize()=" + dataBuffer.getSize() + ", data.getOffset()=" + dataBuffer.getOffset() + ": " + arrayIndexOutOfBoundsException;
            throw new ArrayIndexOutOfBoundsException(string);
        }
    }

    @Override
    public void setPixel(int n, int n2, int[] nArray, DataBuffer dataBuffer) {
        this.setSample(n, n2, 0, nArray[0], dataBuffer);
    }

    @Override
    public void setSample(int n, int n2, int n3, int n4, DataBuffer dataBuffer) {
        int n5 = (this.dataBitOffset + n * this.numberOfBits) % this.elemBits / this.numberOfBits;
        int n6 = this.getOffset(n, n2);
        n4 <<= this.bitOffsets[n5];
        int n7 = dataBuffer.getElem(n6);
        dataBuffer.setElem(n6, n7 |= (n4 &= this.bitMasks[n5]));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MultiPixelPackedSampleModel)) {
            return false;
        }
        MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)object;
        if (this.dataType != multiPixelPackedSampleModel.dataType) {
            return false;
        }
        if (this.width != multiPixelPackedSampleModel.width) {
            return false;
        }
        if (this.height != multiPixelPackedSampleModel.height) {
            return false;
        }
        if (this.numberOfBits != multiPixelPackedSampleModel.numberOfBits) {
            return false;
        }
        if (this.scanlineStride != multiPixelPackedSampleModel.scanlineStride) {
            return false;
        }
        return this.dataBitOffset == multiPixelPackedSampleModel.dataBitOffset;
    }

    public int hashCode() {
        int n = 193;
        n = 37 * n + this.dataType;
        n = 37 * n + this.width;
        n = 37 * n + this.height;
        n = 37 * n + this.numberOfBits;
        n = 37 * n + this.scanlineStride;
        n = 37 * n + this.dataBitOffset;
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append("[");
        stringBuffer.append("scanlineStride=").append(this.scanlineStride);
        for (int i = 0; i < this.bitMasks.length; ++i) {
            stringBuffer.append(", mask[").append(i).append("]=0x").append(Integer.toHexString(this.bitMasks[i]));
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

