/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import gnu.java.awt.Buffers;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;

public final class BandedSampleModel
extends ComponentSampleModel {
    private int[] bitMasks;
    private int[] bitOffsets;
    private int[] sampleSize;
    private int dataBitOffset;
    private int elemBits;
    private int numberOfBits;
    private int numElems;

    private static int[] createBankArray(int n) {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = i;
        }
        return nArray;
    }

    public BandedSampleModel(int n, int n2, int n3, int n4) {
        this(n, n2, n3, n2, BandedSampleModel.createBankArray(n4), new int[n4]);
    }

    public BandedSampleModel(int n, int n2, int n3, int n4, int[] nArray, int[] nArray2) {
        super(n, n2, n3, 1, n4, nArray, nArray2);
    }

    @Override
    public DataBuffer createDataBuffer() {
        int n = this.scanlineStride * this.height;
        return Buffers.createBuffer(this.getDataType(), n, this.numBanks);
    }

    @Override
    public SampleModel createCompatibleSampleModel(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int[] nArray = new int[this.bandOffsets.length];
        int[] nArray2 = new int[this.bandOffsets.length];
        for (n5 = 0; n5 < this.bandOffsets.length; ++n5) {
            nArray2[n5] = n5;
        }
        for (n5 = 0; n5 < this.bandOffsets.length; ++n5) {
            for (n4 = n5 + 1; n4 < this.bandOffsets.length; ++n4) {
                if (this.bankIndices[nArray2[n5]] <= this.bankIndices[nArray2[n4]] && (this.bankIndices[nArray2[n5]] != this.bankIndices[nArray2[n4]] || this.bandOffsets[nArray2[n5]] <= this.bandOffsets[nArray2[n4]])) continue;
                n3 = nArray2[n5];
                nArray2[n5] = nArray2[n4];
                nArray2[n4] = n3;
            }
        }
        n5 = 0;
        n4 = 0;
        for (n3 = 0; n3 < this.bandOffsets.length; ++n3) {
            if (this.bankIndices[nArray2[n3]] != n5) {
                n5 = this.bankIndices[nArray2[n3]];
                n4 = 0;
            }
            nArray[nArray2[n3]] = n4;
            n4 += n * this.scanlineStride;
        }
        return new BandedSampleModel(this.dataType, n, n2, n, this.bankIndices, nArray);
    }

    @Override
    public SampleModel createSubsetSampleModel(int[] nArray) {
        if (nArray.length > this.bankIndices.length) {
            throw new RasterFormatException("BandedSampleModel createSubsetSampleModel too many bands");
        }
        int[] nArray2 = new int[nArray.length];
        int[] nArray3 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            nArray2[i] = this.bandOffsets[n];
            nArray3[i] = this.bankIndices[n];
        }
        return new BandedSampleModel(this.dataType, this.width, this.height, this.scanlineStride, nArray3, nArray2);
    }

    @Override
    public Object getDataElements(int n, int n2, Object object, DataBuffer dataBuffer) {
        if (n < 0 || n2 < 0) {
            throw new ArrayIndexOutOfBoundsException("x and y must not be less than 0.");
        }
        int n3 = this.getSample(n, n2, 0, dataBuffer);
        switch (this.getTransferType()) {
            case 0: {
                byte[] byArray = (byte[])object;
                if (byArray == null) {
                    byArray = new byte[this.numBands];
                }
                for (int i = 0; i < this.numBands; ++i) {
                    byArray[i] = (byte)this.getSample(n, n2, i, dataBuffer);
                }
                return byArray;
            }
            case 1: 
            case 2: {
                short[] sArray = (short[])object;
                if (sArray == null) {
                    sArray = new short[this.numBands];
                }
                for (int i = 0; i < this.numBands; ++i) {
                    sArray[i] = (short)this.getSample(n, n2, i, dataBuffer);
                }
                return sArray;
            }
            case 3: {
                int[] nArray = (int[])object;
                if (nArray == null) {
                    nArray = new int[this.numBands];
                }
                for (int i = 0; i < this.numBands; ++i) {
                    nArray[i] = this.getSample(n, n2, i, dataBuffer);
                }
                return nArray;
            }
            case 4: {
                float[] fArray = (float[])object;
                if (fArray == null) {
                    fArray = new float[this.numBands];
                }
                for (int i = 0; i < this.numBands; ++i) {
                    fArray[i] = this.getSampleFloat(n, n2, i, dataBuffer);
                }
                return fArray;
            }
            case 5: {
                double[] dArray = (double[])object;
                if (dArray == null) {
                    dArray = new double[this.numBands];
                }
                for (int i = 0; i < this.numBands; ++i) {
                    dArray[i] = this.getSample(n, n2, i, dataBuffer);
                }
                return dArray;
            }
        }
        throw new ClassCastException();
    }

    @Override
    public int[] getPixel(int n, int n2, int[] nArray, DataBuffer dataBuffer) {
        if (nArray == null) {
            nArray = new int[this.numBands];
        }
        for (int i = 0; i < this.numBands; ++i) {
            nArray[i] = this.getSample(n, n2, i, dataBuffer);
        }
        return nArray;
    }

    @Override
    public int[] getPixels(int n, int n2, int n3, int n4, int[] nArray, DataBuffer dataBuffer) {
        if (n < 0 || n2 < 0) {
            throw new ArrayIndexOutOfBoundsException("x and y must not be less than 0.");
        }
        if (nArray == null) {
            nArray = new int[n3 * n4 * this.numBands];
        }
        int n5 = 0;
        int n6 = n + n3;
        int n7 = n2 + n4;
        for (int i = n; i < n7; ++i) {
            for (int j = n; j < n6; ++j) {
                for (int k = 0; k < this.numBands; ++k) {
                    int n8 = this.bandOffsets[k] + i * this.scanlineStride + j;
                    nArray[n5++] = dataBuffer.getElem(this.bankIndices[k], n8);
                }
            }
        }
        return nArray;
    }

    @Override
    public int getSample(int n, int n2, int n3, DataBuffer dataBuffer) {
        int n4 = this.bandOffsets[n3] + n2 * this.scanlineStride + n;
        return dataBuffer.getElem(this.bankIndices[n3], n4);
    }

    @Override
    public float getSampleFloat(int n, int n2, int n3, DataBuffer dataBuffer) {
        int n4 = this.bandOffsets[n3] + n2 * this.scanlineStride + n;
        return dataBuffer.getElemFloat(this.bankIndices[n3], n4);
    }

    @Override
    public double getSampleDouble(int n, int n2, int n3, DataBuffer dataBuffer) {
        int n4 = this.bandOffsets[n3] + n2 * this.scanlineStride + n;
        return dataBuffer.getElemDouble(this.bankIndices[n3], n4);
    }

    @Override
    public int[] getSamples(int n, int n2, int n3, int n4, int n5, int[] nArray, DataBuffer dataBuffer) {
        if (n < 0 || n2 < 0) {
            throw new ArrayIndexOutOfBoundsException("x and y must not be less than 0.");
        }
        if (nArray == null) {
            nArray = new int[n3 * n4];
        }
        int n6 = 0;
        int n7 = n + n3;
        int n8 = n2 + n4;
        for (int i = n2; i < n8; ++i) {
            for (int j = n; j < n7; ++j) {
                int n9 = this.bandOffsets[n5] + i * this.scanlineStride + j;
                nArray[n6++] = dataBuffer.getElem(this.bankIndices[n5], n9);
            }
        }
        return nArray;
    }

    @Override
    public void setDataElements(int n, int n2, Object object, DataBuffer dataBuffer) {
        int n3 = this.getTransferType();
        if (this.getTransferType() != dataBuffer.getDataType()) {
            throw new IllegalArgumentException("transfer type (" + this.getTransferType() + "), " + "does not match data " + "buffer type (" + dataBuffer.getDataType() + ").");
        }
        int n4 = n2 * this.scanlineStride + n;
        try {
            switch (n3) {
                case 0: {
                    DataBufferByte dataBufferByte = (DataBufferByte)dataBuffer;
                    byte[] byArray = (byte[])object;
                    for (int i = 0; i < this.numBands; ++i) {
                        dataBufferByte.getData((int)this.bankIndices[i])[n4 + this.bandOffsets[i]] = byArray[i];
                    }
                    return;
                }
                case 2: {
                    DataBufferShort dataBufferShort = (DataBufferShort)dataBuffer;
                    short[] sArray = (short[])object;
                    for (int i = 0; i < this.numBands; ++i) {
                        dataBufferShort.getData((int)this.bankIndices[i])[n4 + this.bandOffsets[i]] = sArray[i];
                    }
                    return;
                }
                case 1: {
                    DataBufferUShort dataBufferUShort = (DataBufferUShort)dataBuffer;
                    short[] sArray = (short[])object;
                    for (int i = 0; i < this.numBands; ++i) {
                        dataBufferUShort.getData((int)this.bankIndices[i])[n4 + this.bandOffsets[i]] = sArray[i];
                    }
                    return;
                }
                case 3: {
                    DataBufferInt dataBufferInt = (DataBufferInt)dataBuffer;
                    int[] nArray = (int[])object;
                    for (int i = 0; i < this.numBands; ++i) {
                        dataBufferInt.getData((int)this.bankIndices[i])[n4 + this.bandOffsets[i]] = nArray[i];
                    }
                    return;
                }
                case 4: {
                    DataBufferFloat dataBufferFloat = (DataBufferFloat)dataBuffer;
                    float[] fArray = (float[])object;
                    for (int i = 0; i < this.numBands; ++i) {
                        dataBufferFloat.getData((int)this.bankIndices[i])[n4 + this.bandOffsets[i]] = fArray[i];
                    }
                    return;
                }
                case 5: {
                    DataBufferDouble dataBufferDouble = (DataBufferDouble)dataBuffer;
                    double[] dArray = (double[])object;
                    for (int i = 0; i < this.numBands; ++i) {
                        dataBufferDouble.getData((int)this.bankIndices[i])[n4 + this.bandOffsets[i]] = dArray[i];
                    }
                    return;
                }
            }
            throw new ClassCastException("Unsupported data type");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            String string = "While writing data elements, x=" + n + ", y=" + n2 + ", width=" + this.width + ", height=" + this.height + ", scanlineStride=" + this.scanlineStride + ", offset=" + n4 + ", data.getSize()=" + dataBuffer.getSize() + ", data.getOffset()=" + dataBuffer.getOffset() + ": " + arrayIndexOutOfBoundsException;
            throw new ArrayIndexOutOfBoundsException(string);
        }
    }

    @Override
    public void setPixel(int n, int n2, int[] nArray, DataBuffer dataBuffer) {
        for (int i = 0; i < this.numBands; ++i) {
            dataBuffer.setElem(this.bankIndices[i], this.bandOffsets[i] + n2 * this.scanlineStride + n, nArray[i]);
        }
    }

    @Override
    public void setPixels(int n, int n2, int n3, int n4, int[] nArray, DataBuffer dataBuffer) {
        int n5 = 0;
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                int n6 = n2 * this.scanlineStride + (n + j);
                for (int k = 0; k < this.numBands; ++k) {
                    dataBuffer.setElem(this.bankIndices[k], this.bandOffsets[k] + n6, nArray[n5++]);
                }
            }
            ++n2;
        }
    }

    @Override
    public void setSample(int n, int n2, int n3, int n4, DataBuffer dataBuffer) {
        dataBuffer.setElem(this.bankIndices[n3], this.bandOffsets[n3] + n2 * this.scanlineStride + n, n4);
    }

    @Override
    public void setSample(int n, int n2, int n3, float f, DataBuffer dataBuffer) {
        dataBuffer.setElemFloat(this.bankIndices[n3], this.bandOffsets[n3] + n2 * this.scanlineStride + n, f);
    }

    @Override
    public void setSample(int n, int n2, int n3, double d, DataBuffer dataBuffer) {
        dataBuffer.setElemDouble(this.bankIndices[n3], this.bandOffsets[n3] + n2 * this.scanlineStride + n, d);
    }

    @Override
    public void setSamples(int n, int n2, int n3, int n4, int n5, int[] nArray, DataBuffer dataBuffer) {
        if (n < 0 || n2 < 0) {
            throw new ArrayIndexOutOfBoundsException("x and y must not be less than 0.");
        }
        int n6 = 0;
        switch (this.getTransferType()) {
            case 0: {
                DataBufferByte dataBufferByte = (DataBufferByte)dataBuffer;
                byte[] byArray = dataBufferByte.getData(this.bankIndices[n5]);
                for (int i = 0; i < n4; ++i) {
                    for (int j = 0; j < n3; ++j) {
                        int n7 = this.bandOffsets[n5] + n2 * this.scanlineStride + (n + j);
                        byArray[n7] = (byte)nArray[n6++];
                    }
                    ++n2;
                }
                return;
            }
            case 2: {
                DataBufferShort dataBufferShort = (DataBufferShort)dataBuffer;
                short[] sArray = dataBufferShort.getData(this.bankIndices[n5]);
                for (int i = 0; i < n4; ++i) {
                    for (int j = 0; j < n3; ++j) {
                        int n8 = this.bandOffsets[n5] + n2 * this.scanlineStride + (n + j);
                        sArray[n8] = (short)nArray[n6++];
                    }
                    ++n2;
                }
                return;
            }
            case 1: {
                DataBufferShort dataBufferShort = (DataBufferShort)dataBuffer;
                short[] sArray = dataBufferShort.getData(this.bankIndices[n5]);
                for (int i = 0; i < n4; ++i) {
                    for (int j = 0; j < n3; ++j) {
                        int n9 = this.bandOffsets[n5] + n2 * this.scanlineStride + (n + j);
                        sArray[n9] = (short)nArray[n6++];
                    }
                    ++n2;
                }
                return;
            }
            case 3: {
                DataBufferInt dataBufferInt = (DataBufferInt)dataBuffer;
                int[] nArray2 = dataBufferInt.getData(this.bankIndices[n5]);
                for (int i = 0; i < n4; ++i) {
                    for (int j = 0; j < n3; ++j) {
                        int n10 = this.bandOffsets[n5] + n2 * this.scanlineStride + (n + j);
                        nArray2[n10] = nArray[n6++];
                    }
                    ++n2;
                }
                return;
            }
            case 4: 
            case 5: {
                break;
            }
            default: {
                throw new ClassCastException("Unsupported data type");
            }
        }
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                int n11 = this.bandOffsets[n5] + n2 * this.scanlineStride + (n + j);
                dataBuffer.setElem(this.bankIndices[n5], n11, nArray[n6++]);
            }
            ++n2;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append("[");
        stringBuffer.append("scanlineStride=").append(this.scanlineStride);
        for (int i = 0; i < this.bitMasks.length; ++i) {
            stringBuffer.append(", mask[").append(i).append("]=0x").append(Integer.toHexString(this.bitMasks[i]));
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

