/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.color;

import gnu.java.awt.color.ColorLookUpTable;
import gnu.java.awt.color.ColorSpaceConverter;
import gnu.java.awt.color.SrgbConverter;
import gnu.java.awt.color.ToneReproductionCurve;
import java.awt.color.ICC_ProfileRGB;
import java.awt.color.ProfileDataException;

public class RgbProfileConverter
implements ColorSpaceConverter {
    private float[][] matrix;
    private float[][] inv_matrix;
    private ToneReproductionCurve rTRC;
    private ToneReproductionCurve gTRC;
    private ToneReproductionCurve bTRC;
    private ColorLookUpTable toPCS = null;
    private ColorLookUpTable fromPCS = null;
    private static float[] D50 = new float[]{0.96422f, 1.0f, 0.82521f};

    public RgbProfileConverter(ICC_ProfileRGB iCC_ProfileRGB) {
        this.matrix = iCC_ProfileRGB.getMatrix();
        try {
            this.rTRC = new ToneReproductionCurve(iCC_ProfileRGB.getGamma(0));
        }
        catch (ProfileDataException profileDataException) {
            this.rTRC = new ToneReproductionCurve(iCC_ProfileRGB.getTRC(0));
        }
        try {
            this.gTRC = new ToneReproductionCurve(iCC_ProfileRGB.getGamma(1));
        }
        catch (ProfileDataException profileDataException) {
            this.gTRC = new ToneReproductionCurve(iCC_ProfileRGB.getTRC(1));
        }
        try {
            this.bTRC = new ToneReproductionCurve(iCC_ProfileRGB.getGamma(2));
        }
        catch (ProfileDataException profileDataException) {
            this.bTRC = new ToneReproductionCurve(iCC_ProfileRGB.getTRC(2));
        }
        try {
            this.toPCS = new ColorLookUpTable(iCC_ProfileRGB, 1093812784);
        }
        catch (Exception exception) {
            this.toPCS = null;
        }
        try {
            this.fromPCS = new ColorLookUpTable(iCC_ProfileRGB, 1110589744);
        }
        catch (Exception exception) {
            this.fromPCS = null;
        }
        if (this.fromPCS == null) {
            this.inv_matrix = this.invertMatrix(this.matrix);
        } else {
            this.inv_matrix = new float[3][3];
            this.inv_matrix[2][2] = 1.0f;
            this.inv_matrix[1][1] = 1.0f;
            this.inv_matrix[0][0] = 1.0f;
        }
    }

    @Override
    public float[] toCIEXYZ(float[] fArray) {
        if (this.toPCS != null) {
            return this.toPCS.lookup(fArray);
        }
        float[] fArray2 = new float[3];
        float[] fArray3 = new float[3];
        fArray2[0] = this.rTRC.lookup(fArray[0]);
        fArray2[1] = this.gTRC.lookup(fArray[1]);
        fArray2[2] = this.bTRC.lookup(fArray[2]);
        fArray3[0] = this.matrix[0][0] * fArray2[0] + this.matrix[0][1] * fArray2[1] + this.matrix[0][2] * fArray2[2];
        fArray3[1] = this.matrix[1][0] * fArray2[0] + this.matrix[1][1] * fArray2[1] + this.matrix[1][2] * fArray2[2];
        fArray3[2] = this.matrix[2][0] * fArray2[0] + this.matrix[2][1] * fArray2[1] + this.matrix[2][2] * fArray2[2];
        return fArray3;
    }

    @Override
    public float[] toRGB(float[] fArray) {
        return SrgbConverter.XYZtoRGB(this.toCIEXYZ(fArray));
    }

    @Override
    public float[] fromCIEXYZ(float[] fArray) {
        if (this.fromPCS != null) {
            return this.fromPCS.lookup(fArray);
        }
        float[] fArray2 = new float[3];
        float[] fArray3 = new float[3];
        fArray2[0] = this.inv_matrix[0][0] * fArray[0] + this.inv_matrix[0][1] * fArray[1] + this.inv_matrix[0][2] * fArray[2];
        fArray2[1] = this.inv_matrix[1][0] * fArray[0] + this.inv_matrix[1][1] * fArray[1] + this.inv_matrix[1][2] * fArray[2];
        fArray2[2] = this.inv_matrix[2][0] * fArray[0] + this.inv_matrix[2][1] * fArray[1] + this.inv_matrix[2][2] * fArray[2];
        fArray3[0] = this.rTRC.reverseLookup(fArray2[0]);
        fArray3[1] = this.gTRC.reverseLookup(fArray2[1]);
        fArray3[2] = this.bTRC.reverseLookup(fArray2[2]);
        return fArray3;
    }

    @Override
    public float[] fromRGB(float[] fArray) {
        return this.fromCIEXYZ(SrgbConverter.RGBtoXYZ(fArray));
    }

    private float[][] invertMatrix(float[][] fArray) {
        float[][] fArray2 = new float[3][3];
        double d = fArray[0][0] * (fArray[1][1] * fArray[2][2] - fArray[2][1] * fArray[1][2]) - fArray[0][1] * (fArray[1][0] * fArray[2][2] - fArray[2][0] * fArray[1][2]) + fArray[0][2] * (fArray[1][0] * fArray[2][1] - fArray[2][0] * fArray[1][1]);
        if (d == 0.0) {
            throw new IllegalArgumentException("Can't invert conversion matrix.");
        }
        float f = (float)(1.0 / d);
        fArray2[0][0] = f * (fArray[1][1] * fArray[2][2] - fArray[1][2] * fArray[2][1]);
        fArray2[0][1] = f * (fArray[0][2] * fArray[2][1] - fArray[0][1] * fArray[2][2]);
        fArray2[0][2] = f * (fArray[0][1] * fArray[1][2] - fArray[0][2] * fArray[1][1]);
        fArray2[1][0] = f * (fArray[1][2] * fArray[2][0] - fArray[1][0] * fArray[2][2]);
        fArray2[1][1] = f * (fArray[0][0] * fArray[2][2] - fArray[0][2] * fArray[2][0]);
        fArray2[1][2] = f * (fArray[0][2] * fArray[1][0] - fArray[0][0] * fArray[1][2]);
        fArray2[2][0] = f * (fArray[1][0] * fArray[2][1] - fArray[1][1] * fArray[2][0]);
        fArray2[2][1] = f * (fArray[0][1] * fArray[2][0] - fArray[0][0] * fArray[2][1]);
        fArray2[2][2] = f * (fArray[0][0] * fArray[1][1] - fArray[0][1] * fArray[1][0]);
        return fArray2;
    }
}

