/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.color;

import java.nio.ByteBuffer;

public class ProfileHeader {
    private static final int icMagicNumber = 1633907568;
    private static final int[] csTypeMap = new int[]{1482250784, 0, 1281450528, 1, 1282766368, 2, 1497588338, 3, 1501067552, 4, 1380401696, 5, 1196573017, 6, 1213421088, 7, 1212961568, 8, 1129142603, 9, 1129142560, 11, 843271250, 12, 860048466, 13, 876825682, 14, 893602898, 15, 910380114, 16, 927157330, 17, 943934546, 18, 960711762, 19, 1094929490, 20, 1111706706, 21, 1128483922, 22, 1145261138, 23, 1162038354, 24, 1178815570, 25};
    public static final int HEADERSIZE = 128;
    private static final int[] classMap = new int[]{1935896178, 0, 1835955314, 1, 1886549106, 2, 1818848875, 3, 1936744803, 4, 1633842036, 5, 1852662636, 6};
    private int size;
    private int cmmId;
    private int majorVersion;
    private int minorVersion;
    private int profileClass;
    private int colorSpace;
    private int profileColorSpace;
    private byte[] timestamp;
    private int platform;
    private int flags;
    private int magic;
    private int manufacturerSig;
    private int modelSig;
    private byte[] attributes;
    private int intent;
    private byte[] illuminant;
    private int creatorSig;

    public ProfileHeader() {
        this.creatorSig = 0;
        this.intent = 0;
        this.manufacturerSig = 1852796517;
        this.modelSig = 1852796517;
        this.magic = 1633907568;
        this.cmmId = 0;
        this.platform = 0;
        this.timestamp = new byte[8];
        this.majorVersion = 2;
        this.minorVersion = 16;
        this.flags = 0;
        this.illuminant = new byte[]{0, 0, -10, -42, 0, 1, 0, 0, 0, 0, -45, 45};
        this.attributes = new byte[8];
        this.profileClass = 1;
    }

    public ProfileHeader(byte[] byArray) {
        ByteBuffer byteBuffer;
        block5: {
            int n;
            block4: {
                int n2;
                byteBuffer = ByteBuffer.wrap(byArray);
                this.size = byteBuffer.getInt(0);
                this.cmmId = byteBuffer.getInt(4);
                this.majorVersion = byArray[8];
                this.minorVersion = byArray[9];
                int n3 = byteBuffer.getInt(12);
                this.profileClass = -1;
                for (n2 = 0; n2 < classMap.length; n2 += 2) {
                    if (classMap[n2] != n3) continue;
                    this.profileClass = classMap[n2 + 1];
                    break;
                }
                n2 = byteBuffer.getInt(16);
                this.colorSpace = -1;
                for (n = 0; n < csTypeMap.length; n += 2) {
                    if (csTypeMap[n] != n2) continue;
                    this.colorSpace = csTypeMap[n + 1];
                    break;
                }
                n = byteBuffer.getInt(20);
                this.profileColorSpace = -1;
                if (this.profileClass == 3) break block4;
                if (n == 1482250784) {
                    this.profileColorSpace = 0;
                }
                if (n != 1281450528) break block5;
                this.profileColorSpace = 1;
                break block5;
            }
            for (int i = 0; i < csTypeMap.length; i += 2) {
                if (csTypeMap[i] != n) continue;
                this.profileColorSpace = csTypeMap[i + 1];
                break;
            }
        }
        this.timestamp = new byte[8];
        System.arraycopy(byArray, 24, this.timestamp, 0, 8);
        this.magic = byteBuffer.getInt(36);
        this.platform = byteBuffer.getInt(40);
        this.flags = byteBuffer.getInt(44);
        this.manufacturerSig = byteBuffer.getInt(48);
        this.modelSig = byteBuffer.getInt(52);
        this.attributes = new byte[8];
        System.arraycopy(byArray, 56, this.attributes, 0, 8);
        this.intent = byteBuffer.getInt(64);
        this.illuminant = new byte[12];
        System.arraycopy(byArray, 68, this.illuminant, 0, 12);
        this.creatorSig = byteBuffer.getInt(80);
    }

    public void verifyHeader(int n) throws IllegalArgumentException {
        if (n != -1 && this.size != n) {
            throw new IllegalArgumentException("Invalid profile length:" + n);
        }
        if (this.majorVersion != 2) {
            throw new IllegalArgumentException("Wrong major version number:" + this.majorVersion);
        }
        if (this.profileClass == -1) {
            throw new IllegalArgumentException("Invalid profile/device class");
        }
        if (this.colorSpace == -1) {
            throw new IllegalArgumentException("Invalid colorspace");
        }
        if (this.profileColorSpace == -1) {
            throw new IllegalArgumentException("Invalid PCS.");
        }
        if (this.magic != 1633907568) {
            throw new IllegalArgumentException("Invalid magic number!");
        }
    }

    public byte[] getData(int n) {
        int n2;
        byte[] byArray = new byte[128];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.putInt(0, n);
        byteBuffer.putInt(4, this.cmmId);
        byteBuffer.putShort(8, (short)(this.majorVersion << 8 | this.minorVersion));
        for (n2 = 1; n2 < classMap.length; n2 += 2) {
            if (this.profileClass != classMap[n2]) continue;
            byteBuffer.putInt(12, classMap[n2 - 1]);
        }
        for (n2 = 1; n2 < csTypeMap.length; n2 += 2) {
            if (csTypeMap[n2] != this.colorSpace) continue;
            byteBuffer.putInt(16, csTypeMap[n2 - 1]);
        }
        for (n2 = 1; n2 < csTypeMap.length; n2 += 2) {
            if (csTypeMap[n2] != this.profileColorSpace) continue;
            byteBuffer.putInt(20, csTypeMap[n2 - 1]);
        }
        System.arraycopy(this.timestamp, 0, byArray, 24, this.timestamp.length);
        byteBuffer.putInt(36, 1633907568);
        byteBuffer.putInt(40, this.platform);
        byteBuffer.putInt(44, this.flags);
        byteBuffer.putInt(48, this.manufacturerSig);
        byteBuffer.putInt(52, this.modelSig);
        System.arraycopy(this.attributes, 0, byArray, 56, this.attributes.length);
        byteBuffer.putInt(64, this.intent);
        System.arraycopy(this.illuminant, 0, byArray, 68, this.illuminant.length);
        byteBuffer.putInt(80, this.creatorSig);
        return byteBuffer.array();
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        this.size = n;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int getProfileClass() {
        return this.profileClass;
    }

    public void setProfileClass(int n) {
        this.profileClass = n;
    }

    public int getColorSpace() {
        return this.colorSpace;
    }

    public int getProfileColorSpace() {
        return this.profileColorSpace;
    }

    public void setColorSpace(int n) {
        this.colorSpace = n;
    }

    public void setProfileColorSpace(int n) {
        this.profileColorSpace = n;
    }
}

