/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.color;

import gnu.java.awt.color.ColorSpaceConverter;

public class LinearRGBConverter
implements ColorSpaceConverter {
    @Override
    public float[] toRGB(float[] fArray) {
        float[] fArray2 = new float[3];
        for (int i = 0; i < 3; ++i) {
            float f = fArray[i];
            if (f < 0.0f) {
                f = 0.0f;
            }
            if (f > 1.0f) {
                f = 1.0f;
            }
            fArray2[i] = f <= 0.00304f ? fArray[0] * 12.92f : 1.055f * (float)Math.exp(0.4166666666666667 * Math.log(f)) - 0.055f;
        }
        return fArray2;
    }

    @Override
    public float[] fromRGB(float[] fArray) {
        float[] fArray2 = new float[3];
        for (int i = 0; i < 3; ++i) {
            float f = fArray[i];
            if (f < 0.0f) {
                f = 0.0f;
            }
            if (f > 1.0f) {
                f = 1.0f;
            }
            fArray2[i] = f <= 0.03928f ? (float)((double)f / 12.92) : (float)Math.exp(2.4 * Math.log(((double)f + 0.055) / 1.055));
        }
        return fArray2;
    }

    @Override
    public float[] fromCIEXYZ(float[] fArray) {
        float[] fArray2 = new float[]{(float)(3.13383065124221 * (double)fArray[0] - 1.61711949411313 * (double)fArray[1] - 0.49071914111101 * (double)fArray[2]), (float)(-0.97847026691142 * (double)fArray[0] + 1.91597856031996 * (double)fArray[1] + 0.03340430640699 * (double)fArray[2]), (float)(0.07203679486279 * (double)fArray[0] - 0.22903073553113 * (double)fArray[1] + 1.40557835776234 * (double)fArray[2])};
        if (fArray2[0] < 0.0f) {
            fArray2[0] = 0.0f;
        }
        if (fArray2[1] < 0.0f) {
            fArray2[1] = 0.0f;
        }
        if (fArray2[2] < 0.0f) {
            fArray2[2] = 0.0f;
        }
        if (fArray2[0] > 1.0f) {
            fArray2[0] = 1.0f;
        }
        if (fArray2[1] > 1.0f) {
            fArray2[1] = 1.0f;
        }
        if (fArray2[2] > 1.0f) {
            fArray2[2] = 1.0f;
        }
        return fArray2;
    }

    @Override
    public float[] toCIEXYZ(float[] fArray) {
        float[] fArray2 = new float[]{(float)(0.4360637502219 * (double)fArray[0] + 0.38514960146481 * (double)fArray[1] + 0.14308641888799 * (double)fArray[2]), (float)(0.22245089403542 * (double)fArray[0] + 0.71692584775182 * (double)fArray[1] + 0.06062451125578 * (double)fArray[2]), (float)(0.01389851860679 * (double)fArray[0] + 0.09707969011198 * (double)fArray[1] + 0.71399604572506 * (double)fArray[2])};
        return fArray2;
    }
}

