#!/usr/bin/perl
#
#	Jday - display a julian date
#
#	Arguments:  when none, display julian date of the system clock

use strict;
use CalDate;	# subroutines: JulDate, CalDate, FormatCalDate

my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst);

($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = gmtime(time);

my %UTInstantNow;
$UTInstantNow{'YEAR'} = $year + 1900;
$UTInstantNow{'MONTH'} = $mon + 1;
$UTInstantNow{'DAY'} = $mday;
$UTInstantNow{'HOUR'} = $hour;
$UTInstantNow{'MINUTE'} = $min;
$UTInstantNow{'SECOND'} = $sec;

my $U=\%UTInstantNow;		# $U is a pointer to the UTInstantNow
$U=\%UTInstantNow;
&JulDate($U);
printf "%.6f\n", $UTInstantNow{'J_DATE'};
