#!/usr/bin/perl
#
#	J2D.pl - convert a julian date to a calendar date
#
#	Arguments:  must have one argument: the julian date to convert

use strict;
use CalDate;	# subroutines: JulDate, CalDate, FormatCalDate

my $version = "1.3";
my $date = "2002/11/11 11:11:11 UTC - JD 2452589.966100";
my $jday_copyright = q(Copyright(C) 1999, 2000, 2001, 2002 - curator@hiram.ws);

sub Version() {
	printf("j2d - version %s - %s\n", $version, $date );
	printf("\t%s\n", $jday_copyright );
}

sub Usage() {
printf("usage: J2D.pl <julian date>\n" );
&Version();
}

my $argc = $#ARGV + 1;

if( 1 != $argc ) {
	&Usage();
	die "ERROR: must supply a julian date\n";
}

if ( $ARGV[0] =~ /^-h.*/ ) {
	&Usage();
	die "\n";
}
if ( $ARGV[0] =~ /^-v.*/ ) {
	&Version();
	die "\n";
}


my %UTInstantNow;
$UTInstantNow{'J_DATE'} = $ARGV[0];

&CalDate(\%UTInstantNow);
my $D=&FormatCalDate(\%UTInstantNow);
printf("%s\n", $D);
