/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.modeler.util;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public final class IntrospectionUtils {
    static final Class[] NO_PARAMS = new Class[0];
    static final Class[] STRING_OBJ_PARAM = new Class[]{class$java$lang$String == null ? (class$java$lang$String = IntrospectionUtils.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Object == null ? (class$java$lang$Object = IntrospectionUtils.class$("java.lang.Object")) : class$java$lang$Object};
    static final Class[] STRING_PARAM = new Class[]{class$java$lang$String == null ? (class$java$lang$String = IntrospectionUtils.class$("java.lang.String")) : class$java$lang$String};
    public static String PATH_SEPARATOR = System.getProperty("path.separator");
    static Hashtable objectMethods = new Hashtable();
    static Object[] emptyArray = new Object[0];
    static final int dbg = 0;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$ClassLoader;

    public static void execute(Object proxy, String method) throws Exception {
        Method executeM = null;
        Class<?> c = proxy.getClass();
        executeM = IntrospectionUtils.findMethod(c, method, NO_PARAMS);
        if (executeM == null) {
            throw new RuntimeException("No method " + method + " in " + proxy.getClass());
        }
        executeM.invoke(proxy, null);
    }

    public static void setAttribute(Object proxy, String n, Object v) throws Exception {
        if (proxy instanceof AttributeHolder) {
            ((AttributeHolder)proxy).setAttribute(n, v);
            return;
        }
        Method executeM = null;
        Class<?> c = proxy.getClass();
        executeM = IntrospectionUtils.findMethod(c, "setAttribute", STRING_OBJ_PARAM);
        if (executeM == null) {
            System.out.println("No setAttribute in " + proxy.getClass());
            return;
        }
        executeM.invoke(proxy, n, v);
    }

    public static Object getAttribute(Object proxy, String n) throws Exception {
        Method executeM = null;
        Class<?> c = proxy.getClass();
        executeM = IntrospectionUtils.findMethod(c, "getAttribute", STRING_PARAM);
        if (executeM == null) {
            System.out.println("No getAttribute in " + proxy.getClass());
            return null;
        }
        return executeM.invoke(proxy, n);
    }

    public static ClassLoader getURLClassLoader(URL[] urls, ClassLoader parent) {
        try {
            Class<?> urlCL = Class.forName("java.net.URLClassLoader");
            Class[] paramT = new Class[]{urls.getClass(), class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = IntrospectionUtils.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader};
            Method m = IntrospectionUtils.findMethod(urlCL, "newInstance", paramT);
            if (m == null) {
                return null;
            }
            ClassLoader cl = (ClassLoader)m.invoke(urlCL, urls, parent);
            return cl;
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static String guessInstall(String installSysProp, String homeSysProp, String jarName) {
        return IntrospectionUtils.guessInstall(installSysProp, homeSysProp, jarName, null);
    }

    public static String guessInstall(String installSysProp, String homeSysProp, String jarName, String classFile) {
        String install = null;
        String home = null;
        if (installSysProp != null) {
            install = System.getProperty(installSysProp);
        }
        if (homeSysProp != null) {
            home = System.getProperty(homeSysProp);
        }
        if (install != null) {
            if (home == null) {
                System.getProperties().put(homeSysProp, install);
            }
            return install;
        }
        String cpath = System.getProperty("java.class.path");
        String pathSep = System.getProperty("path.separator");
        StringTokenizer st = new StringTokenizer(cpath, pathSep);
        while (st.hasMoreTokens()) {
            String path = st.nextToken();
            if (path.endsWith(jarName)) {
                home = path.substring(0, path.length() - jarName.length());
                try {
                    if ("".equals(home)) {
                        home = new File("./").getCanonicalPath();
                    } else if (home.endsWith(File.separator)) {
                        home = home.substring(0, home.length() - 1);
                    }
                    File f = new File(home);
                    String parentDir = f.getParent();
                    if (parentDir == null) {
                        parentDir = home;
                    }
                    File f1 = new File(parentDir);
                    install = f1.getCanonicalPath();
                    if (installSysProp != null) {
                        System.getProperties().put(installSysProp, install);
                    }
                    if (home == null && homeSysProp != null) {
                        System.getProperties().put(homeSysProp, install);
                    }
                    return install;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    continue;
                }
            }
            String fname = path + (path.endsWith("/") ? "" : "/") + classFile;
            if (!new File(fname).exists()) continue;
            try {
                File f = new File(path);
                String parentDir = f.getParent();
                if (parentDir == null) {
                    parentDir = path;
                }
                File f1 = new File(parentDir);
                install = f1.getCanonicalPath();
                if (installSysProp != null) {
                    System.getProperties().put(installSysProp, install);
                }
                if (home == null && homeSysProp != null) {
                    System.getProperties().put(homeSysProp, install);
                }
                return install;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (home != null) {
            System.getProperties().put(installSysProp, home);
            return home;
        }
        return null;
    }

    public static void displayClassPath(String msg, URL[] cp) {
        System.out.println(msg);
        int i = 0;
        while (i < cp.length) {
            System.out.println(cp[i].getFile());
            ++i;
        }
    }

    public static String classPathAdd(URL[] urls, String cp) {
        if (urls == null) {
            return cp;
        }
        int i = 0;
        while (i < urls.length) {
            cp = cp != null ? cp + PATH_SEPARATOR + urls[i].getFile() : urls[i].getFile();
            ++i;
        }
        return cp;
    }

    public static void setProperty(Object o, String name, String value) {
        String setter = "set" + IntrospectionUtils.capitalize(name);
        try {
            Method[] methods = IntrospectionUtils.findMethods(o.getClass());
            Method setPropertyMethod = null;
            int i = 0;
            while (i < methods.length) {
                Class<?>[] paramT = methods[i].getParameterTypes();
                if (setter.equals(methods[i].getName()) && paramT.length == 1 && "java.lang.String".equals(paramT[0].getName())) {
                    methods[i].invoke(o, value);
                    return;
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < methods.length) {
                boolean ok = true;
                if (setter.equals(methods[i2].getName()) && methods[i2].getParameterTypes().length == 1) {
                    Class<?> paramType = methods[i2].getParameterTypes()[0];
                    Object[] params = new Object[1];
                    if ("java.lang.Integer".equals(paramType.getName()) || "int".equals(paramType.getName())) {
                        try {
                            params[0] = new Integer(value);
                        }
                        catch (NumberFormatException ex) {
                            ok = false;
                        }
                    } else if ("java.lang.Boolean".equals(paramType.getName()) || "boolean".equals(paramType.getName())) {
                        params[0] = new Boolean(value);
                    } else if ("java.net.InetAddress".equals(paramType.getName())) {
                        try {
                            params[0] = InetAddress.getByName(value);
                        }
                        catch (UnknownHostException exc) {
                            IntrospectionUtils.d("Unable to resolve host name:" + value);
                            ok = false;
                        }
                    } else if ("java.lang.Object".equals(paramType.getName())) {
                        params[0] = value;
                    } else {
                        IntrospectionUtils.d("Unknown type " + paramType.getName());
                    }
                    if (ok) {
                        methods[i2].invoke(o, params);
                        return;
                    }
                }
                if ("setProperty".equals(methods[i2].getName())) {
                    setPropertyMethod = methods[i2];
                }
                ++i2;
            }
            if (setPropertyMethod != null) {
                Object[] params = new Object[]{name, value};
                setPropertyMethod.invoke(o, params);
            }
        }
        catch (IllegalArgumentException ex2) {
            System.err.println("IAE " + o + " " + name + " " + value);
            ex2.printStackTrace();
        }
        catch (SecurityException ex1) {
        }
        catch (IllegalAccessException iae) {
        }
        catch (InvocationTargetException ie) {}
    }

    public static Object getProperty(Object o, String name) {
        String getter = "get" + IntrospectionUtils.capitalize(name);
        try {
            Method[] methods = IntrospectionUtils.findMethods(o.getClass());
            Method getPropertyMethod = null;
            int i = 0;
            while (i < methods.length) {
                Class<?>[] paramT = methods[i].getParameterTypes();
                if (getter.equals(methods[i].getName()) && paramT.length == 0) {
                    return methods[i].invoke(o, null);
                }
                if ("getProperty".equals(methods[i].getName())) {
                    getPropertyMethod = methods[i];
                }
                if ("getAttribute".equals(methods[i].getName())) {
                    getPropertyMethod = methods[i];
                }
                ++i;
            }
            if (getPropertyMethod != null) {
                Object[] params = new Object[]{name};
                getPropertyMethod.invoke(o, params);
            }
        }
        catch (IllegalArgumentException ex2) {
            System.err.println("IAE " + o + " " + name);
            ex2.printStackTrace();
        }
        catch (SecurityException ex1) {
        }
        catch (IllegalAccessException iae) {
        }
        catch (InvocationTargetException ie) {}
        return null;
    }

    public static void setProperty(Object o, String name) {
        String setter = "set" + IntrospectionUtils.capitalize(name);
        try {
            Method[] methods = IntrospectionUtils.findMethods(o.getClass());
            Object setPropertyMethod = null;
            int i = 0;
            while (i < methods.length) {
                Class<?>[] paramT = methods[i].getParameterTypes();
                if (setter.equals(methods[i].getName()) && paramT.length == 0) {
                    methods[i].invoke(o, new Object[0]);
                    return;
                }
                ++i;
            }
        }
        catch (Exception ex1) {}
    }

    public static String replaceProperties(String value, Object getter) {
        if (getter instanceof Hashtable) {
            return IntrospectionUtils.replaceProperties(value, (Hashtable)getter, null);
        }
        if (getter instanceof PropertySource) {
            PropertySource[] src = new PropertySource[]{(PropertySource)getter};
            return IntrospectionUtils.replaceProperties(value, null, src);
        }
        return value;
    }

    /*
     * WARNING - void declaration
     */
    public static String replaceProperties(String value, Hashtable staticProp, PropertySource[] dynamicProp) {
        int pos;
        StringBuffer sb = new StringBuffer();
        int prev = 0;
        while ((pos = value.indexOf("$", prev)) >= 0) {
            void var5_5;
            if (var5_5 > 0) {
                sb.append(value.substring(prev, (int)var5_5));
            }
            if (var5_5 == value.length() - 1) {
                sb.append('$');
                prev = var5_5 + true;
                continue;
            }
            if (value.charAt((int)(var5_5 + true)) != '{') {
                sb.append(value.charAt((int)(var5_5 + true)));
                prev = var5_5 + 2;
                continue;
            }
            int endName = value.indexOf(125, (int)var5_5);
            if (endName < 0) {
                sb.append(value.substring((int)var5_5));
                prev = value.length();
                continue;
            }
            String n = value.substring((int)(var5_5 + 2), endName);
            String v = null;
            if (staticProp != null) {
                v = (String)staticProp.get(n);
            }
            if (v == null && dynamicProp != null) {
                int i = 0;
                while (i < dynamicProp.length) {
                    v = dynamicProp[i].getProperty(n);
                    if (v != null) break;
                    ++i;
                }
            }
            if (v == null) {
                v = "${" + n + "}";
            }
            sb.append(v);
            prev = endName + 1;
        }
        if (prev < value.length()) {
            sb.append(value.substring(prev));
        }
        return sb.toString();
    }

    public static String capitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    public static String unCapitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    public static void addToClassPath(Vector cpV, String dir) {
        block4: {
            try {
                String[] cpComp = IntrospectionUtils.getFilesByExt(dir, ".jar");
                if (cpComp == null) break block4;
                int jarCount = cpComp.length;
                int i = 0;
                while (i < jarCount) {
                    URL url = IntrospectionUtils.getURL(dir, cpComp[i]);
                    if (url != null) {
                        cpV.addElement(url);
                    }
                    ++i;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void addToolsJar(Vector v) {
        try {
            File f = new File(System.getProperty("java.home") + "/../lib/tools.jar");
            if (!f.exists() && (f = new File(System.getProperty("java.home") + "/lib/tools.jar")).exists()) {
                System.out.println("Detected strange java.home value " + System.getProperty("java.home") + ", it should point to jre");
            }
            URL url = new URL("file", "", f.getAbsolutePath());
            v.addElement(url);
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
        }
    }

    public static String[] getFilesByExt(String ld, String ext) {
        File dir = new File(ld);
        String[] names = null;
        final String lext = ext;
        if (dir.isDirectory()) {
            names = dir.list(new FilenameFilter(){

                public boolean accept(File d, String name) {
                    return name.endsWith(lext);
                }
            });
        }
        return names;
    }

    public static URL getURL(String base, String file) {
        try {
            File baseF = new File(base);
            File f = new File(baseF, file);
            String path = f.getCanonicalPath();
            if (f.isDirectory()) {
                path = path + "/";
            }
            if (!f.exists()) {
                return null;
            }
            return new URL("file", "", path);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static void addJarsFromClassPath(Vector jars, String cp) throws IOException, MalformedURLException {
        String sep = System.getProperty("path.separator");
        if (cp != null) {
            StringTokenizer st = new StringTokenizer(cp, sep);
            while (st.hasMoreTokens()) {
                URL url;
                File f = new File(st.nextToken());
                String path = f.getCanonicalPath();
                if (f.isDirectory()) {
                    path = path + "/";
                }
                if (jars.contains(url = new URL("file", "", path))) continue;
                jars.addElement(url);
            }
        }
    }

    public static URL[] getClassPath(Vector v) {
        URL[] urls = new URL[v.size()];
        int i = 0;
        while (i < v.size()) {
            urls[i] = (URL)v.elementAt(i);
            ++i;
        }
        return urls;
    }

    public static URL[] getClassPath(String dir, String cpath, String cpathProp, boolean addTools) throws IOException, MalformedURLException {
        Vector<URL> jarsV = new Vector<URL>();
        if (dir != null) {
            URL url = IntrospectionUtils.getURL(dir, "classes");
            if (url != null) {
                jarsV.addElement(url);
            }
            IntrospectionUtils.addToClassPath(jarsV, dir);
        }
        if (cpath != null) {
            IntrospectionUtils.addJarsFromClassPath(jarsV, cpath);
        }
        if (cpathProp != null) {
            String cpath1 = System.getProperty(cpathProp);
            IntrospectionUtils.addJarsFromClassPath(jarsV, cpath1);
        }
        if (addTools) {
            IntrospectionUtils.addToolsJar(jarsV);
        }
        return IntrospectionUtils.getClassPath(jarsV);
    }

    public static boolean processArgs(Object proxy, String[] args) throws Exception {
        String[] args0 = null;
        if (null != IntrospectionUtils.findMethod(proxy.getClass(), "getOptions1", new Class[0])) {
            args0 = (String[])IntrospectionUtils.callMethod0(proxy, "getOptions1");
        }
        if (args0 == null) {
            args0 = IntrospectionUtils.findBooleanSetters(proxy.getClass());
        }
        Hashtable h = null;
        if (null != IntrospectionUtils.findMethod(proxy.getClass(), "getOptionAliases", new Class[0])) {
            h = (Hashtable)IntrospectionUtils.callMethod0(proxy, "getOptionAliases");
        }
        return IntrospectionUtils.processArgs(proxy, args, args0, null, h);
    }

    public static boolean processArgs(Object proxy, String[] args, String[] args0, String[] args1, Hashtable aliases) throws Exception {
        int i = 0;
        while (i < args.length) {
            block13: {
                String arg;
                block14: {
                    arg = args[i];
                    if (arg.startsWith("-")) {
                        arg = arg.substring(1);
                    }
                    if (aliases != null && aliases.get(arg) != null) {
                        arg = (String)aliases.get(arg);
                    }
                    if (args0 == null) break block14;
                    boolean set = false;
                    int j = 0;
                    while (j < args0.length) {
                        if (args0[j].equalsIgnoreCase(arg)) {
                            IntrospectionUtils.setProperty(proxy, args0[j], "true");
                            set = true;
                            break;
                        }
                        ++j;
                    }
                    if (set) break block13;
                }
                if (args1 != null) {
                    int j = 0;
                    while (j < args1.length) {
                        if (args1[j].equalsIgnoreCase(arg)) {
                            if (++i >= args.length) {
                                return false;
                            }
                            IntrospectionUtils.setProperty(proxy, arg, args[i]);
                            break;
                        }
                        ++j;
                    }
                } else {
                    if (++i >= args.length) {
                        return false;
                    }
                    IntrospectionUtils.setProperty(proxy, arg, args[i]);
                }
            }
            ++i;
        }
        return true;
    }

    public static String[] findVoidSetters(Class c) {
        Method[] m = IntrospectionUtils.findMethods(c);
        if (m == null) {
            return null;
        }
        Vector<String> v = new Vector<String>();
        int i = 0;
        while (i < m.length) {
            if (m[i].getName().startsWith("set") && m[i].getParameterTypes().length == 0) {
                String arg = m[i].getName().substring(3);
                v.addElement(IntrospectionUtils.unCapitalize(arg));
            }
            ++i;
        }
        String[] s = new String[v.size()];
        int i2 = 0;
        while (i2 < s.length) {
            s[i2] = (String)v.elementAt(i2);
            ++i2;
        }
        return s;
    }

    public static String[] findBooleanSetters(Class c) {
        Method[] m = IntrospectionUtils.findMethods(c);
        if (m == null) {
            return null;
        }
        Vector<String> v = new Vector<String>();
        int i = 0;
        while (i < m.length) {
            if (m[i].getName().startsWith("set") && m[i].getParameterTypes().length == 1 && "boolean".equalsIgnoreCase(m[i].getParameterTypes()[0].getName())) {
                String arg = m[i].getName().substring(3);
                v.addElement(IntrospectionUtils.unCapitalize(arg));
            }
            ++i;
        }
        String[] s = new String[v.size()];
        int i2 = 0;
        while (i2 < s.length) {
            s[i2] = (String)v.elementAt(i2);
            ++i2;
        }
        return s;
    }

    public static Method[] findMethods(Class c) {
        Method[] methods = (Method[])objectMethods.get(c);
        if (methods != null) {
            return methods;
        }
        methods = c.getMethods();
        objectMethods.put(c, methods);
        return methods;
    }

    public static Method findMethod(Class c, String name, Class[] params) {
        Method[] methods = IntrospectionUtils.findMethods(c);
        if (methods == null) {
            return null;
        }
        int i = 0;
        while (i < methods.length) {
            if (methods[i].getName().equals(name)) {
                Class<?>[] methodParams = methods[i].getParameterTypes();
                if (methodParams == null && (params == null || params.length == 0)) {
                    return methods[i];
                }
                if (params == null && (methodParams == null || methodParams.length == 0)) {
                    return methods[i];
                }
                if (params.length == methodParams.length) {
                    boolean found = true;
                    int j = 0;
                    while (j < params.length) {
                        if (params[j] != methodParams[j]) {
                            found = false;
                            break;
                        }
                        ++j;
                    }
                    if (found) {
                        return methods[i];
                    }
                }
            }
            ++i;
        }
        return null;
    }

    public static boolean hasHook(Object obj, String methodN) {
        try {
            Method[] myMethods = IntrospectionUtils.findMethods(obj.getClass());
            int i = 0;
            while (i < myMethods.length) {
                Class<?> declaring;
                Class<?> parentOfDeclaring;
                if (methodN.equals(myMethods[i].getName()) && !"java.lang.Object".equals((parentOfDeclaring = (declaring = myMethods[i].getDeclaringClass()).getSuperclass()).getName())) {
                    return true;
                }
                ++i;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return false;
    }

    public static void callMain(Class c, String[] args) throws Exception {
        Class[] p = new Class[]{args.getClass()};
        Method m = c.getMethod("main", p);
        m.invoke((Object)c, new Object[]{args});
    }

    public static Object callMethod1(Object target, String methodN, Object param1, String typeParam1, ClassLoader cl) throws Exception {
        if (target == null || param1 == null) {
            IntrospectionUtils.d("Assert: Illegal params " + target + " " + param1);
        }
        Class[] params = new Class[]{typeParam1 == null ? param1.getClass() : cl.loadClass(typeParam1)};
        Method m = IntrospectionUtils.findMethod(target.getClass(), methodN, params);
        if (m == null) {
            throw new NoSuchMethodException(target.getClass().getName() + " " + methodN);
        }
        return m.invoke(target, param1);
    }

    public static Object callMethod0(Object target, String methodN) throws Exception {
        if (target == null) {
            IntrospectionUtils.d("Assert: Illegal params " + target);
            return null;
        }
        Class[] params = new Class[]{};
        Method m = IntrospectionUtils.findMethod(target.getClass(), methodN, params);
        if (m == null) {
            throw new NoSuchMethodException(target.getClass().getName() + " " + methodN);
        }
        return m.invoke(target, emptyArray);
    }

    public static Object callMethodN(Object target, String methodN, Object[] params, Class[] typeParams) throws Exception {
        Method m = null;
        m = IntrospectionUtils.findMethod(target.getClass(), methodN, typeParams);
        if (m == null) {
            IntrospectionUtils.d("Can't find method " + methodN + " in " + target + " CLASS " + target.getClass());
            return null;
        }
        Object o = m.invoke(target, params);
        return o;
    }

    static void d(String s) {
        System.out.println("IntrospectionUtils: " + s);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface AttributeHolder {
        public void setAttribute(String var1, Object var2);
    }

    public static interface PropertySource {
        public String getProperty(String var1);
    }
}

