/*
 * Decompiled with CFR 0.152.
 */
package tyrex.tm;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import org.omg.CORBA.Any;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.CoordinatorOperations;
import org.omg.CosTransactions.CoordinatorTie;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.Inactive;
import org.omg.CosTransactions.NotSubtransaction;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.RecoveryCoordinator;
import org.omg.CosTransactions.Resource;
import org.omg.CosTransactions.Status;
import org.omg.CosTransactions.SubtransactionAwareResource;
import org.omg.CosTransactions.SubtransactionsUnavailable;
import org.omg.CosTransactions.Synchronization;
import org.omg.CosTransactions.SynchronizationUnavailable;
import org.omg.CosTransactions.Terminator;
import org.omg.CosTransactions.TerminatorOperations;
import org.omg.CosTransactions.TerminatorTie;
import org.omg.CosTransactions.TransIdentity;
import org.omg.CosTransactions.Unavailable;
import org.omg.CosTransactions._ControlImplBase;
import org.omg.CosTransactions.otid_t;
import tyrex.tm.SubtransactionAwareWrapper;
import tyrex.tm.SynhronizationWrapper;
import tyrex.tm.TransactionImpl;
import tyrex.tm.XidImpl;

public class ControlImpl
extends _ControlImplBase
implements Terminator,
Coordinator,
RecoveryCoordinator {
    private TransactionImpl _tx;
    private TransIdentity[] _parents;
    private PropagationContext _pgContext;
    private ORB _orb;
    private Terminator _terminator;
    private Coordinator _coordinator;

    ControlImpl(TransactionImpl transactionImpl) {
        this._tx = transactionImpl;
        if (transactionImpl.getParent() != null) {
            transactionImpl = transactionImpl.getParent();
            ControlImpl controlImpl = transactionImpl.getControl();
            if (controlImpl._parents == null) {
                this._parents = new TransIdentity[1];
                this._parents[0] = controlImpl.get_identity();
            } else {
                this._parents = new TransIdentity[controlImpl._parents.length + 1];
                System.arraycopy(controlImpl._parents, 0, this._parents, 1, controlImpl._parents.length);
                this._parents[0] = controlImpl.get_identity();
            }
        }
    }

    ControlImpl(TransactionImpl transactionImpl, PropagationContext propagationContext) {
        this._tx = transactionImpl;
        this._parents = new TransIdentity[propagationContext.parents.length + 1];
        System.arraycopy(propagationContext.parents, 0, this._parents, 1, propagationContext.parents.length);
        this._parents[0] = propagationContext.current;
    }

    public void commit(boolean bl) throws HeuristicMixed, HeuristicHazard {
        if (this._parents != null) {
            bl = false;
        }
        try {
            try {
                this._tx.commit();
            }
            catch (IllegalStateException illegalStateException) {
                throw new INVALID_TRANSACTION(illegalStateException.getMessage());
            }
            catch (SystemException systemException) {
                if (bl) {
                    throw new HeuristicHazard();
                }
            }
            catch (RollbackException rollbackException) {
                throw new TRANSACTION_ROLLEDBACK(rollbackException.getMessage());
            }
            catch (HeuristicRollbackException heuristicRollbackException) {
                if (bl) {
                    throw new TRANSACTION_ROLLEDBACK(heuristicRollbackException.getMessage());
                }
            }
            catch (HeuristicMixedException heuristicMixedException) {
                if (bl) {
                    throw new HeuristicMixed();
                }
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
                if (bl) {
                    throw new HeuristicHazard();
                }
                throw new INVALID_TRANSACTION(securityException.toString());
            }
            java.lang.Object var3_6 = null;
            this.deactivate();
        }
        catch (Throwable throwable) {
            java.lang.Object var3_7 = null;
            this.deactivate();
            throw throwable;
        }
    }

    private Coordinator coordinator() {
        if (this._orb == null) {
            return this;
        }
        if (this._coordinator != null) {
            return this._coordinator;
        }
        this._coordinator = new CoordinatorTie((CoordinatorOperations)this);
        this._orb.connect((Object)this._coordinator);
        return this._coordinator;
    }

    public Control create_subtransaction() throws SubtransactionsUnavailable, Inactive {
        if (this._tx.getStatus() != 0 && this._tx.getStatus() != 1) {
            throw new Inactive();
        }
        try {
            TransactionImpl transactionImpl = this._tx.getTransactionDomain().createTransaction(this._tx, null);
            transactionImpl.setORB(this._orb);
            return transactionImpl.getControl();
        }
        catch (SystemException systemException) {
            throw new Inactive();
        }
    }

    private void deactivate() {
        if (this._orb != null) {
            this._orb.disconnect((Object)this);
            this._orb.disconnect((Object)this._coordinator);
            this._orb.disconnect((Object)this._terminator);
        }
    }

    static Status fromJTAStatus(int n) {
        switch (n) {
            case 0: {
                return Status.StatusActive;
            }
            case 1: {
                return Status.StatusMarkedRollback;
            }
            case 8: {
                return Status.StatusCommitting;
            }
            case 3: {
                return Status.StatusCommitted;
            }
            case 9: {
                return Status.StatusRollingBack;
            }
            case 4: {
                return Status.StatusRolledBack;
            }
            case 2: {
                return Status.StatusPrepared;
            }
            case 7: {
                return Status.StatusPreparing;
            }
            case 6: {
                return Status.StatusNoTransaction;
            }
        }
        return Status.StatusUnknown;
    }

    TransactionImpl getTransaction() {
        return this._tx;
    }

    public Coordinator get_coordinator() throws Unavailable {
        int n = this._tx.getStatus();
        if (n == 0 || n == 1) {
            return this.coordinator();
        }
        throw new Unavailable();
    }

    TransIdentity get_identity() {
        XidImpl xidImpl = this._tx.getXid();
        byte[] byArray = xidImpl.getGlobalTransactionId();
        otid_t otid_t2 = new otid_t(xidImpl.getFormatId(), byArray.length, byArray);
        return new TransIdentity(this.coordinator(), this.terminator(), otid_t2);
    }

    public Status get_parent_status() {
        if (this._parents == null) {
            return ControlImpl.fromJTAStatus(this._tx.getStatus());
        }
        return this._parents[0].coord.get_status();
    }

    public Status get_status() {
        return ControlImpl.fromJTAStatus(this._tx.getStatus());
    }

    public Terminator get_terminator() throws Unavailable {
        int n = this._tx.getStatus();
        if (n == 0 || n == 1) {
            return this.terminator();
        }
        throw new Unavailable();
    }

    public Status get_top_level_status() {
        if (this._parents == null) {
            return ControlImpl.fromJTAStatus(this._tx.getStatus());
        }
        return this._parents[this._parents.length - 1].coord.get_status();
    }

    public String get_transaction_name() {
        return this._tx.toString();
    }

    public synchronized PropagationContext get_txcontext() {
        if (this._pgContext != null) {
            return this._pgContext;
        }
        if (this._orb == null) {
            this._pgContext = new PropagationContext(this._tx.getTransactionDomain().getTransactionTimeout(this._tx), this.get_identity(), this._parents != null ? this._parents : new TransIdentity[]{}, null);
        } else {
            Any any = this._orb.create_any();
            this._pgContext = new PropagationContext(this._tx.getTransactionDomain().getTransactionTimeout(this._tx), this.get_identity(), this._parents != null ? this._parents : new TransIdentity[]{}, any);
        }
        return this._pgContext;
    }

    public int hash_top_level_tran() {
        if (this._parents == null) {
            return this._tx.hashCode();
        }
        return this._parents[this._parents.length - 1].coord.hash_transaction();
    }

    public int hash_transaction() {
        return this._tx.hashCode();
    }

    public boolean is_ancestor_transaction(Coordinator coordinator) {
        return coordinator.is_descendant_transaction(this.coordinator());
    }

    public boolean is_descendant_transaction(Coordinator coordinator) {
        if (this._parents == null) {
            return false;
        }
        int n = 0;
        while (n < this._parents.length) {
            if (this._parents[n].coord.is_same_transaction(coordinator)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean is_related_transaction(Coordinator coordinator) {
        if (this._parents == null) {
            return this.is_same_transaction(coordinator);
        }
        int n = 0;
        while (n < this._parents.length) {
            if (this._parents[n].coord.is_ancestor_transaction(coordinator)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean is_same_transaction(Coordinator coordinator) {
        return this.hash_transaction() == coordinator.hash_transaction();
    }

    public boolean is_top_level_transaction() {
        return this._parents == null;
    }

    public boolean is_top_level_transaction(Coordinator coordinator) {
        return this._parents == null;
    }

    public RecoveryCoordinator register_resource(Resource resource) throws Inactive {
        try {
            this._tx.registerResource(resource);
            if (resource instanceof SubtransactionAwareResource) {
                this._tx.registerSynchronization(new SubtransactionAwareWrapper((SubtransactionAwareResource)resource, this));
            }
        }
        catch (RollbackException rollbackException) {
            throw new TRANSACTION_ROLLEDBACK(rollbackException.getMessage());
        }
        catch (IllegalStateException illegalStateException) {
            throw new Inactive();
        }
        catch (SystemException systemException) {
            throw new Inactive();
        }
        return this;
    }

    public void register_subtran_aware(SubtransactionAwareResource subtransactionAwareResource) throws Inactive, NotSubtransaction {
        if (this._parents == null) {
            throw new NotSubtransaction();
        }
        try {
            this._tx.registerSynchronization(new SubtransactionAwareWrapper(subtransactionAwareResource, this));
        }
        catch (RollbackException rollbackException) {
            throw new TRANSACTION_ROLLEDBACK(rollbackException.getMessage());
        }
        catch (IllegalStateException illegalStateException) {
            throw new Inactive();
        }
        catch (SystemException systemException) {
            throw new Inactive();
        }
    }

    public void register_synchronization(Synchronization synchronization) throws Inactive, SynchronizationUnavailable {
        try {
            this._tx.registerSynchronization(new SynhronizationWrapper(synchronization));
        }
        catch (RollbackException rollbackException) {
            throw new TRANSACTION_ROLLEDBACK(rollbackException.getMessage());
        }
        catch (IllegalStateException illegalStateException) {
            throw new Inactive();
        }
        catch (SystemException systemException) {
            throw new Inactive();
        }
    }

    public Status replay_completion(Resource resource) {
        return this.get_status();
    }

    public void rollback() {
        try {
            try {
                this._tx.rollback();
            }
            catch (IllegalStateException illegalStateException) {
                throw new INVALID_TRANSACTION(illegalStateException.getMessage());
            }
            catch (SystemException systemException) {
                throw new INVALID_TRANSACTION(systemException.toString());
            }
            java.lang.Object var2_3 = null;
            this.deactivate();
        }
        catch (Throwable throwable) {
            java.lang.Object var2_4 = null;
            this.deactivate();
            throw throwable;
        }
    }

    public void rollback_only() throws Inactive {
        try {
            this._tx.setRollbackOnly();
        }
        catch (IllegalStateException illegalStateException) {
            throw new Inactive();
        }
        catch (SystemException systemException) {
            throw new Inactive();
        }
    }

    public void setORB(ORB oRB) {
        this._orb = oRB;
    }

    private Terminator terminator() {
        if (this._orb == null) {
            return this;
        }
        if (this._terminator != null) {
            return this._terminator;
        }
        this._terminator = new TerminatorTie((TerminatorOperations)this);
        this._orb.connect((Object)this._terminator);
        return this._terminator;
    }
}

