/*
 * Decompiled with CFR 0.152.
 */
package tyrex.connector;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.Subject;
import tyrex.connector.ConnectionException;
import tyrex.connector.ConnectionFactory;
import tyrex.connector.ConnectionFactoryImpl;
import tyrex.connector.ConnectionManager;
import tyrex.connector.ManagedConnection;
import tyrex.connector.ManagedConnectionFactory;
import tyrex.connector.manager.ConnectionManagerFactory;
import tyrex.util.ArraySet;

public abstract class AbstractManagedConnectionFactory
implements ManagedConnectionFactory,
Serializable {
    protected static final int loginTimeoutChanged = 1;
    protected static final int maxConnectionChanged = 2;
    protected static final int minConnectionChanged = 3;
    protected static final int descriptionChanged = 4;
    protected static final int logWriterChanged = 5;
    private int loginTimeout;
    private int maxConn;
    private int minConn;
    private String description;
    private PrintWriter logWriter;
    private transient ConnectionManager defaultConnectionManager;

    protected AbstractManagedConnectionFactory() {
    }

    protected boolean allowEmptyCredentials(boolean bl) {
        return false;
    }

    protected abstract boolean canAccess(ManagedConnection var1, Subject var2, Set var3, Object var4) throws ConnectionException;

    public final ConnectionFactory createConnectionFactory() throws ConnectionException {
        return this.createConnectionFactory(this.getDefaultConnectionManager());
    }

    public ConnectionFactory createConnectionFactory(ConnectionManager connectionManager) throws ConnectionException {
        return new ConnectionFactoryImpl(this, connectionManager);
    }

    protected ConnectionManager createDefaultConnectionManager() {
        return ConnectionManagerFactory.build(null);
    }

    public final ManagedConnection createManagedConnection(Subject subject, Object object) throws ConnectionException {
        Set set = this.getCredentials(subject, object, true);
        if (!(this.allowEmptyCredentials(true) || set != null && set.size() != 0)) {
            throw new ConnectionException("Cannot find the proper credentials to create the managed connection.");
        }
        try {
            return this.createManagedConnection(subject, set, object);
        }
        catch (Exception exception) {
            if (exception instanceof ConnectionException) {
                throw (ConnectionException)exception;
            }
            throw new ConnectionException(exception);
        }
    }

    protected abstract ManagedConnection createManagedConnection(Subject var1, Set var2, Object var3) throws ConnectionException;

    protected boolean createNewDefaultConnectionManager() {
        return false;
    }

    private void findCredentials(Set set, Object object, boolean bl, Set set2) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!this.isValidCredential(e, object, bl)) continue;
            set2.add(e);
        }
    }

    protected Set getCredentials(Subject subject, Object object, boolean bl) throws ConnectionException {
        ArraySet arraySet = new ArraySet();
        this.findCredentials(subject.getPublicCredentials(), object, false, arraySet);
        if (this.searchPrivateCredentials(subject)) {
            this.findCredentials(subject.getPrivateCredentials(), object, true, arraySet);
        }
        return arraySet;
    }

    private ConnectionManager getDefaultConnectionManager() {
        if (this.createNewDefaultConnectionManager()) {
            return this.createDefaultConnectionManager();
        }
        AbstractManagedConnectionFactory abstractManagedConnectionFactory = this;
        synchronized (abstractManagedConnectionFactory) {
            if (this.defaultConnectionManager == null) {
                this.defaultConnectionManager = this.createDefaultConnectionManager();
            }
        }
        return this.defaultConnectionManager;
    }

    public final String getDescription() {
        return this.description;
    }

    public final PrintWriter getLogWriter() {
        return this.logWriter;
    }

    public final int getLoginTimeout() {
        return this.loginTimeout;
    }

    public final ManagedConnection getManagedConnection(Subject subject, Enumeration enumeration, Object object) throws ConnectionException {
        if (enumeration.hasMoreElements()) {
            Set set = this.getCredentials(subject, object, false);
            if (!(this.allowEmptyCredentials(false) || set != null && set.size() != 0)) {
                throw new ConnectionException("Cannot find the proper credentials to access the managed connection.");
            }
            do {
                ManagedConnection managedConnection;
                if (!this.canAccess(managedConnection = (ManagedConnection)enumeration.nextElement(), subject, set, object)) continue;
                return managedConnection;
            } while (enumeration.hasMoreElements());
        }
        return null;
    }

    public final int getMaxConnection() {
        return this.maxConn;
    }

    public final int getMinConnection() {
        return this.minConn;
    }

    protected abstract boolean isValidCredential(Object var1, Object var2, boolean var3);

    protected void propertyHasChanged(int n) {
    }

    protected boolean searchPrivateCredentials(Subject subject) {
        return true;
    }

    public final void setDescription(String string) {
        this.description = string;
        this.propertyHasChanged(4);
    }

    public final void setLogWriter(PrintWriter printWriter) {
        this.logWriter = printWriter;
        this.propertyHasChanged(5);
    }

    public final void setLoginTimeout(int n) {
        this.loginTimeout = this.loginTimeout;
        this.propertyHasChanged(1);
    }

    public final void setMaxConnection(int n) {
        this.maxConn = n;
        this.propertyHasChanged(2);
    }

    public final void setMinConnection(int n) {
        this.minConn = n;
        this.propertyHasChanged(3);
    }

    public String toString() {
        return String.valueOf(super.toString()) + "[" + (this.description == null ? "" : this.description) + "]";
    }
}

