/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.lang.reflect.Method;
import org.apache.catalina.startup.ClassLoaderFactory;

public final class Bootstrap {
    private static int debug = 0;

    public static void main(String[] args) {
        int i = 0;
        while (i < args.length) {
            if ("-debug".equals(args[i])) {
                debug = 1;
            }
            ++i;
        }
        if (System.getProperty("catalina.base") == null) {
            System.setProperty("catalina.base", Bootstrap.getCatalinaHome());
        }
        ClassLoader commonLoader = null;
        ClassLoader catalinaLoader = null;
        ClassLoader sharedLoader = null;
        try {
            File[] unpacked = new File[1];
            File[] packed = new File[1];
            ClassLoaderFactory.setDebug(debug);
            unpacked[0] = new File(Bootstrap.getCatalinaHome(), "common" + File.separator + "classes");
            packed[0] = new File(Bootstrap.getCatalinaHome(), "common" + File.separator + "lib");
            commonLoader = ClassLoaderFactory.createClassLoader(unpacked, packed, null);
            unpacked[0] = new File(Bootstrap.getCatalinaHome(), "server" + File.separator + "classes");
            packed[0] = new File(Bootstrap.getCatalinaHome(), "server" + File.separator + "lib");
            catalinaLoader = ClassLoaderFactory.createClassLoader(unpacked, packed, commonLoader);
            unpacked[0] = new File(Bootstrap.getCatalinaHome(), "classes");
            packed[0] = new File(Bootstrap.getCatalinaHome(), "lib");
            sharedLoader = ClassLoaderFactory.createClassLoader(unpacked, packed, commonLoader);
        }
        catch (Throwable t) {
            Bootstrap.log("Class loader creation threw exception", t);
            System.exit(1);
        }
        Thread.currentThread().setContextClassLoader(catalinaLoader);
        try {
            if (System.getSecurityManager() != null) {
                String basePackage = "org.apache.catalina.";
                catalinaLoader.loadClass(basePackage + "core.ApplicationContext$PrivilegedGetRequestDispatcher");
                catalinaLoader.loadClass(basePackage + "core.ApplicationContext$PrivilegedGetResource");
                catalinaLoader.loadClass(basePackage + "core.ApplicationContext$PrivilegedGetResourcePaths");
                catalinaLoader.loadClass(basePackage + "core.ApplicationContext$PrivilegedLogMessage");
                catalinaLoader.loadClass(basePackage + "core.ApplicationContext$PrivilegedLogException");
                catalinaLoader.loadClass(basePackage + "core.ApplicationContext$PrivilegedLogThrowable");
                catalinaLoader.loadClass(basePackage + "core.ApplicationDispatcher$PrivilegedForward");
                catalinaLoader.loadClass(basePackage + "core.ApplicationDispatcher$PrivilegedInclude");
                catalinaLoader.loadClass(basePackage + "connector.HttpRequestBase$PrivilegedGetSession");
                catalinaLoader.loadClass(basePackage + "loader.WebappClassLoader$PrivilegedFindResource");
                catalinaLoader.loadClass(basePackage + "session.StandardSession");
                catalinaLoader.loadClass(basePackage + "util.CookieTools");
                catalinaLoader.loadClass(basePackage + "util.URL");
                catalinaLoader.loadClass(basePackage + "util.Enumerator");
                catalinaLoader.loadClass("javax.servlet.http.Cookie");
            }
            if (debug >= 1) {
                Bootstrap.log("Loading startup class");
            }
            Class<?> startupClass = catalinaLoader.loadClass("org.apache.catalina.startup.Catalina");
            Object startupInstance = startupClass.newInstance();
            if (debug >= 1) {
                Bootstrap.log("Setting startup class properties");
            }
            String methodName = "setParentClassLoader";
            Class[] paramTypes = new Class[]{Class.forName("java.lang.ClassLoader")};
            Object[] paramValues = new Object[]{sharedLoader};
            Method method = startupInstance.getClass().getMethod(methodName, paramTypes);
            method.invoke(startupInstance, paramValues);
            if (debug >= 1) {
                Bootstrap.log("Calling startup class process() method");
            }
            methodName = "process";
            paramTypes = new Class[]{args.getClass()};
            paramValues = new Object[]{args};
            method = startupInstance.getClass().getMethod(methodName, paramTypes);
            method.invoke(startupInstance, paramValues);
        }
        catch (Exception e) {
            System.out.println("Exception during startup processing");
            e.printStackTrace(System.out);
            System.exit(2);
        }
    }

    private static String getCatalinaHome() {
        return System.getProperty("catalina.home", System.getProperty("user.dir"));
    }

    private static void log(String message) {
        System.out.print("Bootstrap: ");
        System.out.println(message);
    }

    private static void log(String message, Throwable exception) {
        Bootstrap.log(message);
        exception.printStackTrace(System.out);
    }
}

